#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['ai_django_core',
 'ai_django_core.admin',
 'ai_django_core.admin.model_admins',
 'ai_django_core.admin.views',
 'ai_django_core.drf',
 'ai_django_core.graphql',
 'ai_django_core.graphql.forms',
 'ai_django_core.graphql.schemes',
 'ai_django_core.graphql.tests',
 'ai_django_core.mail',
 'ai_django_core.mail.backends',
 'ai_django_core.mail.services',
 'ai_django_core.middleware',
 'ai_django_core.mixins',
 'ai_django_core.services',
 'ai_django_core.templatetags',
 'ai_django_core.tests',
 'ai_django_core.utils',
 'ai_django_core.view_layer']

package_data = \
{'': ['*'],
 'ai_django_core': ['locale/*',
                    'locale\\de/*',
                    'locale\\de\\LC_MESSAGES/*',
                    'pipeline/*',
                    'pipeline\\services/*']}

install_requires = \
['Django>=2.2.24',
 'bleach>=1.4.3',
 'python-dateutil>=2.5.3',
 'html2text>=2020.1.16']

extras_require = \
{'dev': ['freezegun',
         'pytest-cov',
         'pytest-django',
         'pytest-mock',
         'gevent',
         'sphinx',
         'recommonmark',
         'sphinx-rtd-theme',
         'm2r2'],
 'docs': ['recommonmark', 'sphinx-rtd-theme', 'm2r2'],
 'drf': ['djangorestframework>=3.8.2'],
 'graphql': ['graphene-django>=2.2.0', 'django-graphql-jwt>=0.2.1'],
 'view-layer': ['django-crispy-forms>=1.4.0']}

setup(name='ai-django-core',
      version='5.7.3',
      description='Ambient toolbox - Lots of helper functions and useful widgets',
      author=None,
      author_email='"Ambient Innovation: GmbH" <hello@ambient-innovation.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
