# Generated by Django 3.2.4 on 2021-12-02 17:14
import json

from django.db import migrations


def to_data(value):
    if value == "True":
        return True
    if value == "False":
        return False
    return value


def get_int(value):
    if value:
        try:
            return int(value)
        except Exception:
            pass


def get_settings_dict(settings, keys, mapping):
    result = {}
    for key in keys:
        value = settings.get(key)
        if value:
            result[mapping.get(key) or key] = to_data(value)
    return result


def get_visibility(field, settings, default):
    request = to_data(settings.get(f"cfp_request_{field}"))
    require = to_data(settings.get(f"cfp_require_{field}"))
    if request is None or require is None:
        return default
    if require:
        return "required"
    if request:
        return "optional"
    return "do_not_ask"


def update_custom_domain(apps, schema_editor):
    Event = apps.get_model("event", "Event")
    EventSettings = apps.get_model("event", "Event_SettingsStore")
    CfP = apps.get_model("submission", "CfP")
    for event in Event.objects.all():
        settings = {s.key: s.value for s in EventSettings.objects.filter(object=event)}
        cfp = CfP.objects.filter(event=event).first()
        flow = settings.get("cfp_flow")
        if flow:
            flow = json.loads(flow)
        if flow:
            cfp.settings["flow"] = flow
        cfp.settings.update(
            get_settings_dict(
                settings,
                ["cfp_count_length_in", "cfp_show_deadline"],
                {
                    "cfp_show_deadline": "show_deadline",
                    "cfp_count_length_in": "count_length_in",
                },
            )
        )

        request_require_fields = (
            "abstract",
            "description",
            "availabilities",
            "biography",
            "avatar",
            "notes",
            "do_not_record",
            "image",
            "track",
            "duration",
            "content_locale",
        )
        length_fields = ("title", "abstract", "description", "biography")

        for field in request_require_fields:
            cfp.fields[field]["visibility"] = get_visibility(
                field, settings, default=cfp.fields[field]["visibility"]
            )
        for field in length_fields:
            cfp.fields[field]["min_length"] = get_int(
                settings.get(f"cfp_{field}_min_length")
            )
            cfp.fields[field]["max_length"] = get_int(
                settings.get(f"cfp_{field}_max_length")
            )

        cfp.save()


class Migration(migrations.Migration):

    dependencies = [
        ("submission", "0061_cfp_settings"),
    ]

    operations = [migrations.RunPython(update_custom_domain, migrations.RunPython.noop)]
