# Generated by Django 3.1 on 2020-09-24 08:30

from django.db import migrations, models
import django.db.models.deletion
import i18nfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ("event", "0023_update_featured_visibility"),
        ("submission", "0048_reviewphase_can_see_reviewer_names"),
    ]

    operations = [
        migrations.AlterField(
            model_name="review",
            name="score",
            field=models.DecimalField(decimal_places=2, max_digits=10, null=True),
        ),
        migrations.CreateModel(
            name="ReviewScoreCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("name", i18nfield.fields.I18nCharField()),
                (
                    "weight",
                    models.DecimalField(decimal_places=1, default=1, max_digits=4),
                ),
                ("required", models.BooleanField(default=False)),
                ("active", models.BooleanField(default=True)),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="score_categories",
                        to="event.event",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ReviewScore",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("value", models.DecimalField(decimal_places=1, max_digits=3)),
                ("label", models.CharField(max_length=100, null=True)),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="scores",
                        to="submission.reviewscorecategory",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="review",
            name="scores",
            field=models.ManyToManyField(
                related_name="reviews", to="submission.ReviewScore"
            ),
        ),
    ]
