TEMPLATE = """\
# Code generated by d2a (https://github.com/walkframe/d2a).
# `{{ command }}` at {{ generated_at }}.

{{ blocks.before_importing }}
from importlib import import_module

import sqlalchemy as sa
from sqlalchemy import (
    types as default_types,
    Column,
    ForeignKey,
)
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy.dialects import (
    postgresql as postgresql_types,
    mysql as mysql_types,
    oracle as oracle_types,
)
from django.utils import timezone
from d2a import original_types
try:
    from geoalchemy2 import types as geotypes
except ImportError:
    pass

{{ blocks.after_importing }}

Base = declarative_base()


def GET_DEFAULT(path):
    '''DO NOT DELETE THIS FUNCTION'''

    module_path, model_name, field_name = path.rsplit(".", 2)
    try:
        module = import_module(module_path)
        model = getattr(module, model_name)
    except (ImportError, AttributeError):
        return None

    for field in model._meta.fields:
        if field.name == field_name:
            return field.default


{{ blocks.before_models }}


{% for model in models %}
class {{ model.model_name }}(Base):
    __tablename__ = '{{ model.table_name }}'
    {% for name, args in model.columns.items %}
    {{ name }} = Column({% for arg in args %}
        {{ arg | safe }},{% endfor %}
    ){% endfor %}{% for name, args in model.relationships.items %}
    {{ name }} = relationship({% for arg in args %}
        {{ arg | safe }},{% endfor %}
    ){% endfor %}

{% endfor %}
{{ blocks.after_models }}
"""
