
# `gryannote_pipeline`
<img alt="Static Badge" src="https://img.shields.io/badge/version%20-%200.2.0%20-%20orange">

A component allowing a user to select a pipeline from a drop-down list

## Usage

```python
import gradio as gr
from gryannote_pipeline import PipelineSelector

with gr.Blocks() as demo:
    pipeline_selector = PipelineSelector(show_config=True)

    pipeline_selector.select(
        fn=pipeline_selector.on_select,
        inputs=pipeline_selector,
        outputs=pipeline_selector,
        preprocess=False,
        postprocess=False,
    )
    pipeline_selector.change(
        fn=pipeline_selector.on_change,
        inputs=pipeline_selector,
        outputs=pipeline_selector,
        preprocess=False,
        postprocess=False,
    )

if __name__ == "__main__":
    demo.launch()
```

## Interface

Here's an example of what the component interface looks like

![](https://github.com/clement-pages/gryannote/blob/main/docs/assets/gryannote_pipeline_interface.png?raw=1)

1 - Type your Hugging Face token in the textbox. This is needed the first time you use a specific pipeline. If you don't specify a token, the component will raise an error.
2 - Select a `pyannote` pipeline to apply
3 - If `enable_edition` is set to `True` in the component instantiation, you can edit pipeline's parameters.
4 - Finally, to validate pipeline's parameters modification, click on update button.

### Initialization

<table>
<thead>
<tr>
<th align="left">name</th>
<th align="left" style="width: 25%;">type</th>
<th align="left">default</th>
<th align="left">description</th>
</tr>
</thead>
<tbody>
<tr>
<td align="left"><code>pipelines</code></td>
<td align="left" style="width: 25%;">

```python
pyannote.audio.core.pipeline.Pipeline
    | list[str]
    | dict[str, pyannote.audio.core.pipeline.Pipeline]
    | tuple[str, pyannote.audio.core.pipeline.Pipeline]
    | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>value</code></td>
<td align="left" style="width: 25%;">

```python
str | Callable | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>token</code></td>
<td align="left" style="width: 25%;">

```python
str | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">None</td>
</tr>

<tr>
<td align="left"><code>label</code></td>
<td align="left" style="width: 25%;">

```python
str | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>info</code></td>
<td align="left" style="width: 25%;">

```python
str | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>every</code></td>
<td align="left" style="width: 25%;">

```python
float | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>show_label</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>True</code></td>
<td align="left">bool, optional</td>
</tr>

<tr>
<td align="left"><code>show_token_textbox</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>True</code></td>
<td align="left">bool, optional</td>
</tr>

<tr>
<td align="left"><code>show_config</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>False</code></td>
<td align="left">bool, optional</td>
</tr>

<tr>
<td align="left"><code>enable_edition</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>False</code></td>
<td align="left">bool, optional</td>
</tr>

<tr>
<td align="left"><code>container</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>True</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>scale</code></td>
<td align="left" style="width: 25%;">

```python
int | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>min_width</code></td>
<td align="left" style="width: 25%;">

```python
int
```

</td>
<td align="left"><code>160</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>interactive</code></td>
<td align="left" style="width: 25%;">

```python
bool | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>visible</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>True</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>elem_id</code></td>
<td align="left" style="width: 25%;">

```python
str | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>elem_classes</code></td>
<td align="left" style="width: 25%;">

```python
list[str] | str | None
```

</td>
<td align="left"><code>None</code></td>
<td align="left">optional</td>
</tr>

<tr>
<td align="left"><code>render</code></td>
<td align="left" style="width: 25%;">

```python
bool
```

</td>
<td align="left"><code>True</code></td>
<td align="left">optional</td>
</tr>
</tbody></table>


### Events

| name | description |
|:-----|:------------|
| `change` | Triggered when the value of the PipelineSelector changes either because of user input (e.g. a user types in a textbox) OR because of a function update (e.g. an image receives a value from the output of an event trigger). See `.input()` for a listener that is only triggered by user input. |
| `input` | This listener is triggered when the user changes the value of the PipelineSelector. |
| `select` | Event listener for when the user selects or deselects the PipelineSelector. Uses event data gradio.SelectData to carry `value` referring to the label of the PipelineSelector, and `selected` to refer to state of the PipelineSelector. See EventData documentation on how to use this event data |
| `focus` | This listener is triggered when the PipelineSelector is focused. |
| `blur` | This listener is triggered when the PipelineSelector is unfocused/blurred. |
| `key_up` | This listener is triggered when the user presses a key while the PipelineSelector is focused. |



### User function

The impact on the users predict function varies depending on whether the component is used as an input or output for an event (or both).

- When used as an Input, the component only impacts the input signature of the user function.
- When used as an output, the component only impacts the return signature of the user function.

The code snippet below is accurate in cases where the component is used as both an input and an output.

- **As output:** Is passed, an instantiated pipeline.
- **As input:** Should return, instantiated pipeline.

 ```python
 def predict(
     value: pyannote.audio.core.pipeline.Pipeline
 ) -> pyannote.audio.core.pipeline.Pipeline | None:
     return value
 ```
