"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdktf_1 = require("cdktf");
const _1 = require(".");
const app = new cdktf_1.App();
const stack = new cdktf_1.TerraformStack(app, 'cdktf-eks-demo');
// create the cluster and the default nodegroup
const cluster = new _1.Cluster(stack, 'demo-cluster', {
    version: _1.KubernetesVersion.V1_21,
    scalingConfig: { minCapacity: 1 },
});
// create the optional 2nd nodegroup
cluster.addNodeGroup('NG2', {
    scalingConfig: {
        minCapacity: 1,
        maxCapacity: 10,
        desiredCapacity: 5,
    },
    capacityType: _1.CapacityType.SPOT,
    instanceTypes: ['t3.large', 'c5.large', 'm5.large'],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsaUNBQTRDO0FBQzVDLHdCQUE2RDtBQUU3RCxNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksc0JBQWMsQ0FBQyxHQUFHLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUV4RCwrQ0FBK0M7QUFDL0MsTUFBTSxPQUFPLEdBQUcsSUFBSSxVQUFPLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRTtJQUNqRCxPQUFPLEVBQUUsb0JBQWlCLENBQUMsS0FBSztJQUNoQyxhQUFhLEVBQUUsRUFBRSxXQUFXLEVBQUUsQ0FBQyxFQUFFO0NBQ2xDLENBQUMsQ0FBQztBQUVILG9DQUFvQztBQUNwQyxPQUFPLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRTtJQUMxQixhQUFhLEVBQUU7UUFDYixXQUFXLEVBQUUsQ0FBQztRQUNkLFdBQVcsRUFBRSxFQUFFO1FBQ2YsZUFBZSxFQUFFLENBQUM7S0FDbkI7SUFDRCxZQUFZLEVBQUUsZUFBWSxDQUFDLElBQUk7SUFDL0IsYUFBYSxFQUFFLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUM7Q0FDcEQsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBUZXJyYWZvcm1TdGFjayB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IEt1YmVybmV0ZXNWZXJzaW9uLCBDbHVzdGVyLCBDYXBhY2l0eVR5cGUgfSBmcm9tICcuJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBUZXJyYWZvcm1TdGFjayhhcHAsICdjZGt0Zi1la3MtZGVtbycpO1xuXG4vLyBjcmVhdGUgdGhlIGNsdXN0ZXIgYW5kIHRoZSBkZWZhdWx0IG5vZGVncm91cFxuY29uc3QgY2x1c3RlciA9IG5ldyBDbHVzdGVyKHN0YWNrLCAnZGVtby1jbHVzdGVyJywge1xuICB2ZXJzaW9uOiBLdWJlcm5ldGVzVmVyc2lvbi5WMV8yMSxcbiAgc2NhbGluZ0NvbmZpZzogeyBtaW5DYXBhY2l0eTogMSB9LFxufSk7XG5cbi8vIGNyZWF0ZSB0aGUgb3B0aW9uYWwgMm5kIG5vZGVncm91cFxuY2x1c3Rlci5hZGROb2RlR3JvdXAoJ05HMicsIHtcbiAgc2NhbGluZ0NvbmZpZzoge1xuICAgIG1pbkNhcGFjaXR5OiAxLFxuICAgIG1heENhcGFjaXR5OiAxMCxcbiAgICBkZXNpcmVkQ2FwYWNpdHk6IDUsXG4gIH0sXG4gIGNhcGFjaXR5VHlwZTogQ2FwYWNpdHlUeXBlLlNQT1QsXG4gIGluc3RhbmNlVHlwZXM6IFsndDMubGFyZ2UnLCAnYzUubGFyZ2UnLCAnbTUubGFyZ2UnXSxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==