(self["webpackChunk_datalayer_jupyter_markdown"] = self["webpackChunk_datalayer_jupyter_markdown"] || []).push([["vendors-node_modules_primer_react_lib-esm_index_js"],{

/***/ "./node_modules/@github/combobox-nav/dist/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@github/combobox-nav/dist/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Combobox)
/* harmony export */ });
class Combobox {
    constructor(input, list, { tabInsertsSuggestions, defaultFirstOption } = {}) {
        this.input = input;
        this.list = list;
        this.tabInsertsSuggestions = tabInsertsSuggestions !== null && tabInsertsSuggestions !== void 0 ? tabInsertsSuggestions : true;
        this.defaultFirstOption = defaultFirstOption !== null && defaultFirstOption !== void 0 ? defaultFirstOption : false;
        this.isComposing = false;
        if (!list.id) {
            list.id = `combobox-${Math.random().toString().slice(2, 6)}`;
        }
        this.ctrlBindings = !!navigator.userAgent.match(/Macintosh/);
        this.keyboardEventHandler = event => keyboardBindings(event, this);
        this.compositionEventHandler = event => trackComposition(event, this);
        this.inputHandler = this.clearSelection.bind(this);
        input.setAttribute('role', 'combobox');
        input.setAttribute('aria-controls', list.id);
        input.setAttribute('aria-expanded', 'false');
        input.setAttribute('aria-autocomplete', 'list');
        input.setAttribute('aria-haspopup', 'listbox');
    }
    destroy() {
        this.clearSelection();
        this.stop();
        this.input.removeAttribute('role');
        this.input.removeAttribute('aria-controls');
        this.input.removeAttribute('aria-expanded');
        this.input.removeAttribute('aria-autocomplete');
        this.input.removeAttribute('aria-haspopup');
    }
    start() {
        this.input.setAttribute('aria-expanded', 'true');
        this.input.addEventListener('compositionstart', this.compositionEventHandler);
        this.input.addEventListener('compositionend', this.compositionEventHandler);
        this.input.addEventListener('input', this.inputHandler);
        this.input.addEventListener('keydown', this.keyboardEventHandler);
        this.list.addEventListener('click', commitWithElement);
        this.indicateDefaultOption();
    }
    stop() {
        this.clearSelection();
        this.input.setAttribute('aria-expanded', 'false');
        this.input.removeEventListener('compositionstart', this.compositionEventHandler);
        this.input.removeEventListener('compositionend', this.compositionEventHandler);
        this.input.removeEventListener('input', this.inputHandler);
        this.input.removeEventListener('keydown', this.keyboardEventHandler);
        this.list.removeEventListener('click', commitWithElement);
    }
    indicateDefaultOption() {
        var _a;
        if (this.defaultFirstOption) {
            (_a = Array.from(this.list.querySelectorAll('[role="option"]:not([aria-disabled="true"])'))
                .filter(visible)[0]) === null || _a === void 0 ? void 0 : _a.setAttribute('data-combobox-option-default', 'true');
        }
    }
    navigate(indexDiff = 1) {
        const focusEl = Array.from(this.list.querySelectorAll('[aria-selected="true"]')).filter(visible)[0];
        const els = Array.from(this.list.querySelectorAll('[role="option"]')).filter(visible);
        const focusIndex = els.indexOf(focusEl);
        if ((focusIndex === els.length - 1 && indexDiff === 1) || (focusIndex === 0 && indexDiff === -1)) {
            this.clearSelection();
            this.input.focus();
            return;
        }
        let indexOfItem = indexDiff === 1 ? 0 : els.length - 1;
        if (focusEl && focusIndex >= 0) {
            const newIndex = focusIndex + indexDiff;
            if (newIndex >= 0 && newIndex < els.length)
                indexOfItem = newIndex;
        }
        const target = els[indexOfItem];
        if (!target)
            return;
        for (const el of els) {
            el.removeAttribute('data-combobox-option-default');
            if (target === el) {
                this.input.setAttribute('aria-activedescendant', target.id);
                target.setAttribute('aria-selected', 'true');
                scrollTo(this.list, target);
            }
            else {
                el.removeAttribute('aria-selected');
            }
        }
    }
    clearSelection() {
        this.input.removeAttribute('aria-activedescendant');
        for (const el of this.list.querySelectorAll('[aria-selected="true"]')) {
            el.removeAttribute('aria-selected');
        }
        this.indicateDefaultOption();
    }
}
function keyboardBindings(event, combobox) {
    if (event.shiftKey || event.metaKey || event.altKey)
        return;
    if (!combobox.ctrlBindings && event.ctrlKey)
        return;
    if (combobox.isComposing)
        return;
    switch (event.key) {
        case 'Enter':
            if (commit(combobox.input, combobox.list)) {
                event.preventDefault();
            }
            break;
        case 'Tab':
            if (combobox.tabInsertsSuggestions && commit(combobox.input, combobox.list)) {
                event.preventDefault();
            }
            break;
        case 'Escape':
            combobox.clearSelection();
            break;
        case 'ArrowDown':
            combobox.navigate(1);
            event.preventDefault();
            break;
        case 'ArrowUp':
            combobox.navigate(-1);
            event.preventDefault();
            break;
        case 'n':
            if (combobox.ctrlBindings && event.ctrlKey) {
                combobox.navigate(1);
                event.preventDefault();
            }
            break;
        case 'p':
            if (combobox.ctrlBindings && event.ctrlKey) {
                combobox.navigate(-1);
                event.preventDefault();
            }
            break;
        default:
            if (event.ctrlKey)
                break;
            combobox.clearSelection();
    }
}
function commitWithElement(event) {
    if (!(event.target instanceof Element))
        return;
    const target = event.target.closest('[role="option"]');
    if (!target)
        return;
    if (target.getAttribute('aria-disabled') === 'true')
        return;
    fireCommitEvent(target);
}
function commit(input, list) {
    const target = list.querySelector('[aria-selected="true"], [data-combobox-option-default="true"]');
    if (!target)
        return false;
    if (target.getAttribute('aria-disabled') === 'true')
        return true;
    target.click();
    return true;
}
function fireCommitEvent(target) {
    target.dispatchEvent(new CustomEvent('combobox-commit', { bubbles: true }));
}
function visible(el) {
    return (!el.hidden &&
        !(el instanceof HTMLInputElement && el.type === 'hidden') &&
        (el.offsetWidth > 0 || el.offsetHeight > 0));
}
function trackComposition(event, combobox) {
    combobox.isComposing = event.type === 'compositionstart';
    const list = document.getElementById(combobox.input.getAttribute('aria-controls') || '');
    if (!list)
        return;
    combobox.clearSelection();
}
function scrollTo(container, target) {
    if (!inViewport(container, target)) {
        container.scrollTop = target.offsetTop;
    }
}
function inViewport(container, element) {
    const scrollTop = container.scrollTop;
    const containerBottom = scrollTop + container.clientHeight;
    const top = element.offsetTop;
    const bottom = top + element.clientHeight;
    return top >= scrollTop && bottom <= containerBottom;
}


/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/anchored-position.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/anchored-position.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getAnchoredPosition": () => (/* binding */ getAnchoredPosition)
/* harmony export */ });
const alternateOrders = {
    'outside-top': ['outside-bottom', 'outside-right', 'outside-left', 'outside-bottom'],
    'outside-bottom': ['outside-top', 'outside-right', 'outside-left', 'outside-bottom'],
    'outside-left': ['outside-right', 'outside-bottom', 'outside-top', 'outside-bottom'],
    'outside-right': ['outside-left', 'outside-bottom', 'outside-top', 'outside-bottom']
};
const alternateAlignments = {
    start: ['end', 'center'],
    end: ['start', 'center'],
    center: ['end', 'start']
};
function getAnchoredPosition(floatingElement, anchorElement, settings = {}) {
    const parentElement = getPositionedParent(floatingElement);
    const clippingRect = getClippingRect(parentElement);
    const parentElementStyle = getComputedStyle(parentElement);
    const parentElementRect = parentElement.getBoundingClientRect();
    const [borderTop, borderLeft] = [parentElementStyle.borderTopWidth, parentElementStyle.borderLeftWidth].map(v => parseInt(v, 10) || 0);
    const relativeRect = {
        top: parentElementRect.top + borderTop,
        left: parentElementRect.left + borderLeft
    };
    return pureCalculateAnchoredPosition(clippingRect, relativeRect, floatingElement.getBoundingClientRect(), anchorElement instanceof Element ? anchorElement.getBoundingClientRect() : anchorElement, getDefaultSettings(settings));
}
function getPositionedParent(element) {
    let parentNode = element.parentNode;
    while (parentNode !== null) {
        if (parentNode instanceof HTMLElement && getComputedStyle(parentNode).position !== 'static') {
            return parentNode;
        }
        parentNode = parentNode.parentNode;
    }
    return document.body;
}
function getClippingRect(element) {
    let parentNode = element;
    while (parentNode !== null) {
        if (parentNode === document.body) {
            break;
        }
        const parentNodeStyle = getComputedStyle(parentNode);
        if (parentNodeStyle.overflow !== 'visible') {
            break;
        }
        parentNode = parentNode.parentNode;
    }
    const clippingNode = parentNode === document.body || !(parentNode instanceof HTMLElement) ? document.body : parentNode;
    const elemRect = clippingNode.getBoundingClientRect();
    const elemStyle = getComputedStyle(clippingNode);
    const [borderTop, borderLeft, borderRight, borderBottom] = [
        elemStyle.borderTopWidth,
        elemStyle.borderLeftWidth,
        elemStyle.borderRightWidth,
        elemStyle.borderBottomWidth
    ].map(v => parseInt(v, 10) || 0);
    return {
        top: elemRect.top + borderTop,
        left: elemRect.left + borderLeft,
        width: elemRect.width - borderRight - borderLeft,
        height: Math.max(elemRect.height - borderTop - borderBottom, clippingNode === document.body ? window.innerHeight : -Infinity)
    };
}
const positionDefaults = {
    side: 'outside-bottom',
    align: 'start',
    anchorOffset: 4,
    alignmentOffset: 4,
    allowOutOfBounds: false
};
function getDefaultSettings(settings = {}) {
    var _a, _b, _c, _d, _e;
    const side = (_a = settings.side) !== null && _a !== void 0 ? _a : positionDefaults.side;
    const align = (_b = settings.align) !== null && _b !== void 0 ? _b : positionDefaults.align;
    return {
        side,
        align,
        anchorOffset: (_c = settings.anchorOffset) !== null && _c !== void 0 ? _c : (side === 'inside-center' ? 0 : positionDefaults.anchorOffset),
        alignmentOffset: (_d = settings.alignmentOffset) !== null && _d !== void 0 ? _d : (align !== 'center' && side.startsWith('inside') ? positionDefaults.alignmentOffset : 0),
        allowOutOfBounds: (_e = settings.allowOutOfBounds) !== null && _e !== void 0 ? _e : positionDefaults.allowOutOfBounds
    };
}
function pureCalculateAnchoredPosition(viewportRect, relativePosition, floatingRect, anchorRect, { side, align, allowOutOfBounds, anchorOffset, alignmentOffset }) {
    const relativeViewportRect = {
        top: viewportRect.top - relativePosition.top,
        left: viewportRect.left - relativePosition.left,
        width: viewportRect.width,
        height: viewportRect.height
    };
    let pos = calculatePosition(floatingRect, anchorRect, side, align, anchorOffset, alignmentOffset);
    let anchorSide = side;
    let anchorAlign = align;
    pos.top -= relativePosition.top;
    pos.left -= relativePosition.left;
    if (!allowOutOfBounds) {
        const alternateOrder = alternateOrders[side];
        let positionAttempt = 0;
        if (alternateOrder) {
            let prevSide = side;
            while (positionAttempt < alternateOrder.length &&
                shouldRecalculatePosition(prevSide, pos, relativeViewportRect, floatingRect)) {
                const nextSide = alternateOrder[positionAttempt++];
                prevSide = nextSide;
                pos = calculatePosition(floatingRect, anchorRect, nextSide, align, anchorOffset, alignmentOffset);
                pos.top -= relativePosition.top;
                pos.left -= relativePosition.left;
                anchorSide = nextSide;
            }
        }
        const alternateAlignment = alternateAlignments[align];
        let alignmentAttempt = 0;
        if (alternateAlignment) {
            let prevAlign = align;
            while (alignmentAttempt < alternateAlignment.length &&
                shouldRecalculateAlignment(prevAlign, pos, relativeViewportRect, floatingRect)) {
                const nextAlign = alternateAlignment[alignmentAttempt++];
                prevAlign = nextAlign;
                pos = calculatePosition(floatingRect, anchorRect, anchorSide, nextAlign, anchorOffset, alignmentOffset);
                pos.top -= relativePosition.top;
                pos.left -= relativePosition.left;
                anchorAlign = nextAlign;
            }
        }
        if (pos.top < relativeViewportRect.top) {
            pos.top = relativeViewportRect.top;
        }
        if (pos.left < relativeViewportRect.left) {
            pos.left = relativeViewportRect.left;
        }
        if (pos.left + floatingRect.width > viewportRect.width + relativeViewportRect.left) {
            pos.left = viewportRect.width + relativeViewportRect.left - floatingRect.width;
        }
        if (alternateOrder && positionAttempt < alternateOrder.length) {
            if (pos.top + floatingRect.height > viewportRect.height + relativeViewportRect.top) {
                pos.top = viewportRect.height + relativeViewportRect.top - floatingRect.height;
            }
        }
    }
    return Object.assign(Object.assign({}, pos), { anchorSide, anchorAlign });
}
function calculatePosition(elementDimensions, anchorPosition, side, align, anchorOffset, alignmentOffset) {
    const anchorRight = anchorPosition.left + anchorPosition.width;
    const anchorBottom = anchorPosition.top + anchorPosition.height;
    let top = -1;
    let left = -1;
    if (side === 'outside-top') {
        top = anchorPosition.top - anchorOffset - elementDimensions.height;
    }
    else if (side === 'outside-bottom') {
        top = anchorBottom + anchorOffset;
    }
    else if (side === 'outside-left') {
        left = anchorPosition.left - anchorOffset - elementDimensions.width;
    }
    else if (side === 'outside-right') {
        left = anchorRight + anchorOffset;
    }
    if (side === 'outside-top' || side === 'outside-bottom') {
        if (align === 'start') {
            left = anchorPosition.left + alignmentOffset;
        }
        else if (align === 'center') {
            left = anchorPosition.left - (elementDimensions.width - anchorPosition.width) / 2 + alignmentOffset;
        }
        else {
            left = anchorRight - elementDimensions.width - alignmentOffset;
        }
    }
    if (side === 'outside-left' || side === 'outside-right') {
        if (align === 'start') {
            top = anchorPosition.top + alignmentOffset;
        }
        else if (align === 'center') {
            top = anchorPosition.top - (elementDimensions.height - anchorPosition.height) / 2 + alignmentOffset;
        }
        else {
            top = anchorBottom - elementDimensions.height - alignmentOffset;
        }
    }
    if (side === 'inside-top') {
        top = anchorPosition.top + anchorOffset;
    }
    else if (side === 'inside-bottom') {
        top = anchorBottom - anchorOffset - elementDimensions.height;
    }
    else if (side === 'inside-left') {
        left = anchorPosition.left + anchorOffset;
    }
    else if (side === 'inside-right') {
        left = anchorRight - anchorOffset - elementDimensions.width;
    }
    else if (side === 'inside-center') {
        left = (anchorRight + anchorPosition.left) / 2 - elementDimensions.width / 2 + anchorOffset;
    }
    if (side === 'inside-top' || side === 'inside-bottom') {
        if (align === 'start') {
            left = anchorPosition.left + alignmentOffset;
        }
        else if (align === 'center') {
            left = anchorPosition.left - (elementDimensions.width - anchorPosition.width) / 2 + alignmentOffset;
        }
        else {
            left = anchorRight - elementDimensions.width - alignmentOffset;
        }
    }
    else if (side === 'inside-left' || side === 'inside-right' || side === 'inside-center') {
        if (align === 'start') {
            top = anchorPosition.top + alignmentOffset;
        }
        else if (align === 'center') {
            top = anchorPosition.top - (elementDimensions.height - anchorPosition.height) / 2 + alignmentOffset;
        }
        else {
            top = anchorBottom - elementDimensions.height - alignmentOffset;
        }
    }
    return { top, left };
}
function shouldRecalculatePosition(side, currentPos, containerDimensions, elementDimensions) {
    if (side === 'outside-top' || side === 'outside-bottom') {
        return (currentPos.top < containerDimensions.top ||
            currentPos.top + elementDimensions.height > containerDimensions.height + containerDimensions.top);
    }
    else {
        return (currentPos.left < containerDimensions.left ||
            currentPos.left + elementDimensions.width > containerDimensions.width + containerDimensions.left);
    }
}
function shouldRecalculateAlignment(align, currentPos, containerDimensions, elementDimensions) {
    if (align === 'end') {
        return currentPos.left < containerDimensions.left;
    }
    else if (align === 'start' || align === 'center') {
        return (currentPos.left + elementDimensions.width > containerDimensions.left + containerDimensions.width ||
            currentPos.left < containerDimensions.left);
    }
}


/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/scroll-into-view.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/scroll-into-view.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "scrollIntoView": () => (/* binding */ scrollIntoView)
/* harmony export */ });
function scrollIntoView(child, viewingArea, { direction = 'vertical', startMargin = 0, endMargin = 0, behavior = 'smooth' } = {}) {
    const startSide = direction === 'vertical' ? 'top' : 'left';
    const endSide = direction === 'vertical' ? 'bottom' : 'right';
    const scrollSide = direction === 'vertical' ? 'scrollTop' : 'scrollLeft';
    const { [startSide]: childStart, [endSide]: childEnd } = child.getBoundingClientRect();
    const { [startSide]: viewingAreaStart, [endSide]: viewingAreaEnd } = viewingArea.getBoundingClientRect();
    const isChildStartAboveViewingArea = childStart < viewingAreaStart + startMargin;
    const isChildBottomBelowViewingArea = childEnd > viewingAreaEnd - endMargin;
    if (isChildStartAboveViewingArea) {
        const scrollHeightToChildStart = childStart - viewingAreaStart + viewingArea[scrollSide];
        viewingArea.scrollTo({ behavior, [startSide]: scrollHeightToChildStart - startMargin });
    }
    else if (isChildBottomBelowViewingArea) {
        const scrollHeightToChildBottom = childEnd - viewingAreaEnd + viewingArea[scrollSide];
        viewingArea.scrollTo({ behavior, [startSide]: scrollHeightToChildBottom + endMargin });
    }
}


/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/ActionMenu.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/ActionMenu.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionMenu": () => (/* binding */ ActionMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ActionList_Divider_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ActionList/Divider.js */ "./node_modules/@primer/react/lib-esm/ActionList/Divider.js");
/* harmony import */ var _ActionList_ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ActionList/ActionListContainerContext.js */ "./node_modules/@primer/react/lib-esm/ActionList/ActionListContainerContext.js");
/* harmony import */ var _Button_index_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Button/index.js */ "./node_modules/@primer/react/lib-esm/Button/index.js");
/* harmony import */ var _hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./hooks/useProvidedStateOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _hooks_useMenuKeyboardNavigation_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./hooks/useMenuKeyboardNavigation.js */ "./node_modules/@primer/react/lib-esm/hooks/useMenuKeyboardNavigation.js");
/* harmony import */ var _AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AnchoredOverlay/AnchoredOverlay.js */ "./node_modules/@primer/react/lib-esm/AnchoredOverlay/AnchoredOverlay.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);













function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const MenuContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({
  renderAnchor: null,
  open: false
});
const Menu = ({
  anchorRef: externalAnchorRef,
  open,
  onOpenChange,
  children
}) => {
  const [combinedOpenState, setCombinedOpenState] = (0,_hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_3__.useProvidedStateOrCreate)(open, onOpenChange, false);
  const onOpen = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => setCombinedOpenState(true), [setCombinedOpenState]);
  const onClose = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => setCombinedOpenState(false), [setCombinedOpenState]);
  const anchorRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__.useProvidedRefOrCreate)(externalAnchorRef);
  const anchorId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_5__.useSSRSafeId)();
  let renderAnchor = null;

  // 🚨 Hack for good API!
  // we strip out Anchor from children and pass it to AnchoredOverlay to render
  // with additional props for accessibility
  const contents = react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, child => {
    if (child.type === MenuButton || child.type === Anchor) {
      renderAnchor = anchorProps => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, anchorProps);
      return null;
    }
    return child;
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(MenuContext.Provider, {
    value: {
      anchorRef,
      renderAnchor,
      anchorId,
      open: combinedOpenState,
      onOpen,
      onClose
    }
  }, contents);
};
Menu.displayName = "Menu";
const Anchor = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  children,
  ...anchorProps
}, anchorRef) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(children, {
    ...anchorProps,
    ref: anchorRef
  });
});

/** this component is syntactical sugar 🍭 */

const MenuButton = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  sx: sxProp = {},
  ...props
}, anchorRef) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Anchor, {
    ref: anchorRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Button_index_js__WEBPACK_IMPORTED_MODULE_6__.Button, _extends({
    type: "button",
    trailingIcon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__.TriangleDownIcon,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      // override the margin on caret for optical alignment
      '[data-component=trailingIcon]': {
        marginX: -1
      }
    }, sxProp)
  }, props)));
});
const Overlay = ({
  children,
  align = 'start',
  ...overlayProps
}) => {
  // we typecast anchorRef as required instead of optional
  // because we know that we're setting it in context in Menu
  const {
    anchorRef,
    renderAnchor,
    anchorId,
    open,
    onOpen,
    onClose
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(MenuContext);
  const containerRef = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
  (0,_hooks_useMenuKeyboardNavigation_js__WEBPACK_IMPORTED_MODULE_7__.useMenuKeyboardNavigation)(open, onClose, containerRef, anchorRef);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_8__.AnchoredOverlay, {
    anchorRef: anchorRef,
    renderAnchor: renderAnchor,
    anchorId: anchorId,
    open: open,
    onOpen: onOpen,
    onClose: onClose,
    align: align,
    overlayProps: overlayProps,
    focusZoneSettings: {
      focusOutBehavior: 'wrap'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_9__.ActionListContainerContext.Provider, {
    value: {
      container: 'ActionMenu',
      listRole: 'menu',
      listLabelledBy: anchorId,
      selectionAttribute: 'aria-checked',
      // Should this be here?
      afterSelect: onClose
    }
  }, children)));
};
Overlay.displayName = "Overlay";
Menu.displayName = 'ActionMenu';
const ActionMenu = Object.assign(Menu, {
  Button: MenuButton,
  Anchor,
  Overlay,
  Divider: _ActionList_Divider_js__WEBPACK_IMPORTED_MODULE_10__.Divider
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/AnchoredOverlay/AnchoredOverlay.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/AnchoredOverlay/AnchoredOverlay.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnchoredOverlay": () => (/* binding */ AnchoredOverlay)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Overlay_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Overlay.js */ "./node_modules/@primer/react/lib-esm/Overlay.js");
/* harmony import */ var _hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useFocusTrap.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusTrap.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hooks/useRenderForcingRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRenderForcingRef.js");
/* harmony import */ var _hooks_useAnchoredPosition_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useAnchoredPosition.js */ "./node_modules/@primer/react/lib-esm/hooks/useAnchoredPosition.js");









function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/**
 * An `AnchoredOverlay` provides an anchor that will open a floating overlay positioned relative to the anchor.
 * The overlay can be opened and navigated using keyboard or mouse.
 */
const AnchoredOverlay = ({
  renderAnchor,
  anchorRef: externalAnchorRef,
  anchorId: externalAnchorId,
  children,
  open,
  onOpen,
  onClose,
  height,
  width,
  overlayProps,
  focusTrapSettings,
  focusZoneSettings,
  side,
  align
}) => {
  const anchorRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(externalAnchorRef);
  const [overlayRef, updateOverlayRef] = (0,_hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_2__.useRenderForcingRef)();
  const anchorId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_3__.useSSRSafeId)(externalAnchorId);
  const onClickOutside = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => onClose === null || onClose === void 0 ? void 0 : onClose('click-outside'), [onClose]);
  const onEscape = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => onClose === null || onClose === void 0 ? void 0 : onClose('escape'), [onClose]);
  const onAnchorKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    if (!event.defaultPrevented) {
      if (!open && ['ArrowDown', 'ArrowUp', ' ', 'Enter'].includes(event.key)) {
        onOpen === null || onOpen === void 0 ? void 0 : onOpen('anchor-key-press', event);
        event.preventDefault();
      }
    }
  }, [open, onOpen]);
  const onAnchorClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    if (event.defaultPrevented || event.button !== 0) {
      return;
    }
    if (!open) {
      onOpen === null || onOpen === void 0 ? void 0 : onOpen('anchor-click');
    } else {
      onClose === null || onClose === void 0 ? void 0 : onClose('anchor-click');
    }
  }, [open, onOpen, onClose]);
  const {
    position
  } = (0,_hooks_useAnchoredPosition_js__WEBPACK_IMPORTED_MODULE_4__.useAnchoredPosition)({
    anchorElementRef: anchorRef,
    floatingElementRef: overlayRef,
    side,
    align
  }, [overlayRef.current]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // ensure overlay ref gets cleared when closed, so position can reset between closing/re-opening
    if (!open && overlayRef.current) {
      updateOverlayRef(null);
    }
  }, [open, overlayRef, updateOverlayRef]);
  (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_5__.useFocusZone)({
    containerRef: overlayRef,
    disabled: !open || !position,
    ...focusZoneSettings
  });
  (0,_hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_6__.useFocusTrap)({
    containerRef: overlayRef,
    disabled: !open || !position,
    ...focusTrapSettings
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, renderAnchor && renderAnchor({
    ref: anchorRef,
    id: anchorId,
    'aria-haspopup': 'true',
    'aria-expanded': open ? 'true' : undefined,
    tabIndex: 0,
    onClick: onAnchorClick,
    onKeyDown: onAnchorKeyDown
  }), open ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Overlay_js__WEBPACK_IMPORTED_MODULE_7__["default"], _extends({
    returnFocusRef: anchorRef,
    onClickOutside: onClickOutside,
    ignoreClickRefs: [anchorRef],
    onEscape: onEscape,
    ref: updateOverlayRef,
    role: "none",
    visibility: position ? 'visible' : 'hidden',
    height: height,
    width: width,
    top: (position === null || position === void 0 ? void 0 : position.top) || 0,
    left: (position === null || position === void 0 ? void 0 : position.left) || 0,
    anchorSide: position === null || position === void 0 ? void 0 : position.anchorSide
  }, overlayProps), children) : null);
};
AnchoredOverlay.displayName = 'AnchoredOverlay';
AnchoredOverlay.defaultProps = {
  side: 'outside-bottom',
  align: 'start'
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Autocomplete/Autocomplete.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Autocomplete/Autocomplete.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Autocomplete$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var _AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AutocompleteContext.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js");
/* harmony import */ var _AutocompleteInput_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AutocompleteInput.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteInput.js");
/* harmony import */ var _AutocompleteMenu_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AutocompleteMenu.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteMenu.js");
/* harmony import */ var _AutocompleteOverlay_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AutocompleteOverlay.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteOverlay.js");







const initialState = {
  inputValue: '',
  showMenu: false,
  isMenuDirectlyActivated: false,
  autocompleteSuggestion: '',
  selectedItemLength: 0
};
const reducer = (state, action) => {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case 'inputValue':
      return {
        ...state,
        inputValue: payload
      };
    case 'showMenu':
      return {
        ...state,
        showMenu: payload
      };
    case 'isMenuDirectlyActivated':
      return {
        ...state,
        isMenuDirectlyActivated: payload
      };
    case 'autocompleteSuggestion':
      return {
        ...state,
        autocompleteSuggestion: payload
      };
    case 'selectedItemLength':
      return {
        ...state,
        selectedItemLength: payload
      };
    default:
      return state;
  }
};
const Autocomplete = ({
  children,
  id: idProp
}) => {
  const activeDescendantRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const scrollContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const [state, dispatch] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(reducer, initialState);
  const {
    inputValue,
    showMenu,
    autocompleteSuggestion,
    isMenuDirectlyActivated,
    selectedItemLength
  } = state;
  const setInputValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(value => {
    dispatch({
      type: 'inputValue',
      payload: value
    });
  }, []);
  const setShowMenu = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(value => {
    dispatch({
      type: 'showMenu',
      payload: value
    });
  }, []);
  const setAutocompleteSuggestion = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(value => {
    dispatch({
      type: 'autocompleteSuggestion',
      payload: value
    });
  }, []);
  const setIsMenuDirectlyActivated = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(value => {
    dispatch({
      type: 'isMenuDirectlyActivated',
      payload: value
    });
  }, []);
  const setSelectedItemLength = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(value => {
    dispatch({
      type: 'selectedItemLength',
      payload: value
    });
  }, []);
  const id = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_1__.useSSRSafeId)(idProp);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__.AutocompleteContext.Provider, {
    value: {
      activeDescendantRef,
      autocompleteSuggestion,
      id,
      inputRef,
      inputValue,
      isMenuDirectlyActivated,
      scrollContainerRef,
      selectedItemLength,
      setAutocompleteSuggestion,
      setInputValue,
      setIsMenuDirectlyActivated,
      setShowMenu,
      setSelectedItemLength,
      showMenu
    }
  }, children);
};
Autocomplete.displayName = "Autocomplete";
var Autocomplete$1 = Object.assign(Autocomplete, {
  Context: _AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__.AutocompleteContext,
  Input: _AutocompleteInput_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  Menu: _AutocompleteMenu_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  Overlay: _AutocompleteOverlay_js__WEBPACK_IMPORTED_MODULE_5__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AutocompleteContext": () => (/* binding */ AutocompleteContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const AutocompleteContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteInput.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteInput.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AutocompleteInput$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AutocompleteContext.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js");
/* harmony import */ var _TextInput_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../TextInput.js */ "./node_modules/@primer/react/lib-esm/TextInput.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useSafeTimeout.js */ "./node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const AutocompleteInput = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  as: Component = _TextInput_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  onFocus,
  onBlur,
  onChange,
  onKeyDown,
  onKeyUp,
  onKeyPress,
  value,
  ...props
}, forwardedRef) => {
  const autocompleteContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__.AutocompleteContext);
  if (autocompleteContext === null) {
    throw new Error('AutocompleteContext returned null values');
  }
  const {
    activeDescendantRef,
    autocompleteSuggestion = '',
    id,
    inputRef,
    inputValue = '',
    isMenuDirectlyActivated,
    setInputValue,
    setShowMenu,
    showMenu
  } = autocompleteContext;
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__.useRefObjectAsForwardedRef)(forwardedRef, inputRef);
  const [highlightRemainingText, setHighlightRemainingText] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const {
    safeSetTimeout
  } = (0,_hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const handleInputFocus = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    onFocus && onFocus(event);
    setShowMenu(true);
  }, [onFocus, setShowMenu]);
  const handleInputBlur = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    onBlur && onBlur(event);

    // HACK: wait a tick and check the focused element before hiding the autocomplete menu
    // this prevents the menu from hiding when the user is clicking an option in the Autoselect.Menu,
    // but still hides the menu when the user blurs the input by tabbing out or clicking somewhere else on the page
    safeSetTimeout(() => {
      if (document.activeElement !== inputRef.current) {
        setShowMenu(false);
      }
    }, 0);
  }, [onBlur, setShowMenu, inputRef, safeSetTimeout]);
  const handleInputChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    onChange && onChange(event);
    setInputValue(event.currentTarget.value);
    if (!showMenu) {
      setShowMenu(true);
    }
  }, [onChange, setInputValue, setShowMenu, showMenu]);
  const handleInputKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    var _inputRef$current;
    onKeyDown && onKeyDown(event);
    if (event.key === 'Backspace') {
      setHighlightRemainingText(false);
    }
    if (event.key === 'Escape' && (_inputRef$current = inputRef.current) !== null && _inputRef$current !== void 0 && _inputRef$current.value) {
      setInputValue('');
      inputRef.current.value = '';
    }
  }, [inputRef, setInputValue, setHighlightRemainingText, onKeyDown]);
  const handleInputKeyUp = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    onKeyUp && onKeyUp(event);
    if (event.key === 'Backspace') {
      setHighlightRemainingText(true);
    }
  }, [setHighlightRemainingText, onKeyUp]);
  const onInputKeyPress = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    onKeyPress && onKeyPress(event);
    if (showMenu && event.key === 'Enter' && activeDescendantRef.current) {
      event.preventDefault();
      event.nativeEvent.stopImmediatePropagation();

      // Forward Enter key press to active descendant so that item gets activated
      const activeDescendantEvent = new KeyboardEvent(event.type, event.nativeEvent);
      activeDescendantRef.current.dispatchEvent(activeDescendantEvent);
    }
  }, [activeDescendantRef, showMenu, onKeyPress]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!inputRef.current) {
      return;
    }

    // resets input value to being empty after a selection has been made
    if (!autocompleteSuggestion) {
      inputRef.current.value = inputValue;
    }

    // TODO: fix bug where this function prevents `onChange` from being triggered if the highlighted item text
    //       is the same as what I'm typing
    //       e.g.: typing 'tw' highlights 'two', but when I 'two', the text input change does not get triggered
    if (highlightRemainingText && autocompleteSuggestion && (inputValue || isMenuDirectlyActivated)) {
      inputRef.current.value = autocompleteSuggestion;
      if (autocompleteSuggestion.toLowerCase().indexOf(inputValue.toLowerCase()) === 0) {
        inputRef.current.setSelectionRange(inputValue.length, autocompleteSuggestion.length);
      }
    }

    // calling this useEffect when `highlightRemainingText` changes breaks backspace functionality
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [autocompleteSuggestion, inputValue, inputRef, isMenuDirectlyActivated]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setInputValue(typeof value !== 'undefined' ? value.toString() : '');
  }, [value, setInputValue]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Component, _extends({
    onFocus: handleInputFocus,
    onBlur: handleInputBlur,
    onChange: handleInputChange,
    onKeyDown: handleInputKeyDown,
    onKeyPress: onInputKeyPress,
    onKeyUp: handleInputKeyUp,
    ref: inputRef,
    "aria-controls": `${id}-listbox`,
    "aria-autocomplete": "both",
    role: "combobox",
    "aria-expanded": showMenu,
    "aria-haspopup": "listbox",
    "aria-owns": `${id}-listbox`,
    autoComplete: "off",
    id: id
  }, props));
});
AutocompleteInput.displayName = 'AutocompleteInput';
var AutocompleteInput$1 = AutocompleteInput;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteMenu.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteMenu.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AutocompleteMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/scroll-into-view.js");
/* harmony import */ var _deprecated_ActionList_index_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../deprecated/ActionList/index.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/index.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AutocompleteContext.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../_VisuallyHidden.js */ "./node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");











const getDefaultSortFn = isItemSelectedFn => (itemIdA, itemIdB) => isItemSelectedFn(itemIdA) === isItemSelectedFn(itemIdB) ? 0 : isItemSelectedFn(itemIdA) ? -1 : 1;
const menuScrollMargins = {
  startMargin: 0,
  endMargin: 8
};
function getDefaultItemFilter(filterValue) {
  return function (item, _i) {
    var _item$text;
    return Boolean((_item$text = item.text) === null || _item$text === void 0 ? void 0 : _item$text.toLowerCase().startsWith(filterValue.toLowerCase()));
  };
}
function getdefaultCheckedSelectionChange(setInputValueFn) {
  return function (itemOrItems) {
    const {
      text = ''
    } = Array.isArray(itemOrItems) ? itemOrItems.slice(-1)[0] : itemOrItems;
    setInputValueFn(text);
  };
}
const isItemSelected = (itemId, selectedItemIds) => selectedItemIds.includes(itemId);
function getItemById(itemId, items) {
  return items.find(item => item.id === itemId);
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any

function AutocompleteMenu(props) {
  const autocompleteContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_2__.AutocompleteContext);
  if (autocompleteContext === null) {
    throw new Error('AutocompleteContext returned null values');
  }
  const {
    activeDescendantRef,
    id,
    inputRef,
    inputValue = '',
    scrollContainerRef,
    setAutocompleteSuggestion,
    setShowMenu,
    setInputValue,
    setIsMenuDirectlyActivated,
    setSelectedItemLength,
    showMenu
  } = autocompleteContext;
  const {
    items,
    selectedItemIds,
    sortOnCloseFn,
    emptyStateText,
    addNewItem,
    loading,
    selectionVariant,
    filterFn,
    'aria-labelledby': ariaLabelledBy,
    onOpenChange,
    onSelectedChange,
    customScrollContainerRef
  } = props;
  const listContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const [highlightedItem, setHighlightedItem] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
  const [sortedItemIds, setSortedItemIds] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(items.map(({
    id: itemId
  }) => itemId));
  const generatedUniqueId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_3__.useSSRSafeId)(id);
  const selectableItems = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => items.map(selectableItem => {
    return {
      ...selectableItem,
      role: 'option',
      id: selectableItem.id,
      selected: selectionVariant === 'multiple' ? selectedItemIds.includes(selectableItem.id) : undefined,
      onAction: item => {
        const otherSelectedItemIds = selectedItemIds.filter(selectedItemId => selectedItemId !== item.id);
        const newSelectedItemIds = selectedItemIds.includes(item.id) ? otherSelectedItemIds : [...otherSelectedItemIds, item.id];
        const onSelectedChangeFn = onSelectedChange ? onSelectedChange : getdefaultCheckedSelectionChange(setInputValue);
        onSelectedChangeFn(newSelectedItemIds.map(newSelectedItemId => getItemById(newSelectedItemId, items)));
        if (selectionVariant === 'multiple') {
          setInputValue('');
          setAutocompleteSuggestion('');
        } else {
          var _inputRef$current;
          setShowMenu(false);
          (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.setSelectionRange(inputRef.current.value.length, inputRef.current.value.length);
        }
      }
    };
  }), [items, selectedItemIds, inputRef, onSelectedChange, selectionVariant, setAutocompleteSuggestion, setInputValue, setShowMenu]);
  const itemSortOrderData = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => sortedItemIds.reduce((acc, curr, i) => {
    acc[curr] = i;
    return acc;
  }, {}), [sortedItemIds]);
  const sortedAndFilteredItemsToRender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => selectableItems.filter(filterFn ? filterFn : getDefaultItemFilter(inputValue)).sort((a, b) => itemSortOrderData[a.id] - itemSortOrderData[b.id]), [selectableItems, itemSortOrderData, filterFn, inputValue]);
  const allItemsToRender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => [
  // sorted and filtered selectable items
  ...sortedAndFilteredItemsToRender,
  // menu item used for creating a token from whatever is in the text input
  ...(addNewItem ? [{
    ...addNewItem,
    leadingVisual: () => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__.PlusIcon, null),
    onAction: item => {
      // TODO: make it possible to pass a leadingVisual when using `addNewItem`
      addNewItem.handleAddItem({
        ...item,
        id: item.id || generatedUniqueId,
        leadingVisual: undefined
      });
      if (selectionVariant === 'multiple') {
        setInputValue('');
        setAutocompleteSuggestion('');
      }
    }
  }] : [])], [sortedAndFilteredItemsToRender, addNewItem, setAutocompleteSuggestion, selectionVariant, setInputValue, generatedUniqueId]);
  (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_4__.useFocusZone)({
    containerRef: listContainerRef,
    focusOutBehavior: 'wrap',
    focusableElementFilter: element => {
      return !(element instanceof HTMLInputElement);
    },
    activeDescendantFocus: inputRef,
    onActiveDescendantChanged: (current, _previous, directlyActivated) => {
      activeDescendantRef.current = current || null;
      if (current) {
        const selectedItem = selectableItems.find(item => item.id.toString() === current.getAttribute('data-id'));
        setHighlightedItem(selectedItem);
        setIsMenuDirectlyActivated(directlyActivated);
      }
      if (current && customScrollContainerRef && customScrollContainerRef.current && directlyActivated) {
        (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_5__.scrollIntoView)(current, customScrollContainerRef.current, menuScrollMargins);
      } else if (current && scrollContainerRef.current && directlyActivated) {
        (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_5__.scrollIntoView)(current, scrollContainerRef.current, menuScrollMargins);
      }
    }
  }, [loading]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    var _highlightedItem$text;
    if (highlightedItem !== null && highlightedItem !== void 0 && (_highlightedItem$text = highlightedItem.text) !== null && _highlightedItem$text !== void 0 && _highlightedItem$text.startsWith(inputValue) && !selectedItemIds.includes(highlightedItem.id)) {
      setAutocompleteSuggestion(highlightedItem.text);
    } else {
      setAutocompleteSuggestion('');
    }
  }, [highlightedItem, inputValue, selectedItemIds, setAutocompleteSuggestion]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const itemIdSortResult = [...sortedItemIds].sort(sortOnCloseFn ? sortOnCloseFn : getDefaultSortFn(itemId => isItemSelected(itemId, selectedItemIds)));
    const sortResultMatchesState = itemIdSortResult.length === sortedItemIds.length && itemIdSortResult.every((element, index) => element === sortedItemIds[index]);
    if (showMenu === false && !sortResultMatchesState) {
      setSortedItemIds(itemIdSortResult);
    }
    onOpenChange && onOpenChange(Boolean(showMenu));
  }, [showMenu, onOpenChange, selectedItemIds, sortOnCloseFn, sortedItemIds]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (selectedItemIds.length) {
      setSelectedItemLength(selectedItemIds.length);
    }
  }, [selectedItemIds, setSelectedItemLength]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    isVisible: showMenu
  }, loading ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    p: 3,
    display: "flex",
    justifyContent: "center"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_8__["default"], null)) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    ref: listContainerRef
  }, allItemsToRender.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_deprecated_ActionList_index_js__WEBPACK_IMPORTED_MODULE_9__.ActionList, {
    selectionVariant: "multiple"
    // have to typecast to `ItemProps` because we have an extra property
    // on `items` for Autocomplete: `metadata`
    ,
    items: allItemsToRender,
    role: "listbox",
    id: `${id}-listbox`,
    "aria-labelledby": ariaLabelledBy
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    p: 3
  }, emptyStateText)));
}
AutocompleteMenu.displayName = "AutocompleteMenu";
AutocompleteMenu.defaultProps = {
  emptyStateText: 'No selectable options',
  selectionVariant: 'single'
};
AutocompleteMenu.displayName = 'AutocompleteMenu';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteOverlay.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteOverlay.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AutocompleteOverlay)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Overlay_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Overlay.js */ "./node_modules/@primer/react/lib-esm/Overlay.js");
/* harmony import */ var _AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AutocompleteContext.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/AutocompleteContext.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _hooks_useAnchoredPosition_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hooks/useAnchoredPosition.js */ "./node_modules/@primer/react/lib-esm/hooks/useAnchoredPosition.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
// TODO: consider making 'aria-labelledby' required

function AutocompleteOverlay({
  menuAnchorRef,
  overlayProps: oldOverlayProps,
  children,
  ...newOverlayProps
}) {
  const autocompleteContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AutocompleteContext_js__WEBPACK_IMPORTED_MODULE_1__.AutocompleteContext);
  if (autocompleteContext === null) {
    throw new Error('AutocompleteContext returned null values');
  }
  const overlayProps = {
    ...oldOverlayProps,
    ...newOverlayProps
  };
  const {
    inputRef,
    scrollContainerRef,
    selectedItemLength,
    setShowMenu,
    showMenu = false
  } = autocompleteContext;
  const {
    floatingElementRef,
    position
  } = (0,_hooks_useAnchoredPosition_js__WEBPACK_IMPORTED_MODULE_2__.useAnchoredPosition)({
    side: 'outside-bottom',
    align: 'start',
    anchorElementRef: menuAnchorRef ? menuAnchorRef : inputRef
  }, [showMenu, selectedItemLength]);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__.useRefObjectAsForwardedRef)(scrollContainerRef, floatingElementRef);
  const closeOptionList = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    setShowMenu(false);
  }, [setShowMenu]);
  if (typeof window === 'undefined') {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Overlay_js__WEBPACK_IMPORTED_MODULE_4__["default"], _extends({
    returnFocusRef: inputRef,
    preventFocusOnOpen: true,
    onClickOutside: closeOptionList,
    onEscape: closeOptionList,
    ref: floatingElementRef,
    top: position === null || position === void 0 ? void 0 : position.top,
    left: position === null || position === void 0 ? void 0 : position.left,
    visibility: showMenu ? 'visible' : 'hidden',
    sx: {
      overflow: 'auto'
    }
  }, overlayProps), children);
}
AutocompleteOverlay.displayName = "AutocompleteOverlay";
AutocompleteOverlay.displayName = 'AutocompleteOverlay';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Avatar.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Avatar.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Avatar$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




function getBorderRadius({
  size,
  square
}) {
  if (square) {
    return size && size <= 24 ? '4px' : '6px';
  } else {
    return '50%';
  }
}
const Avatar = styled_components__WEBPACK_IMPORTED_MODULE_0___default().img.attrs(props => ({
  height: props.size,
  width: props.size
})).withConfig({
  displayName: "Avatar",
  componentId: "sc-oifmh0-0"
})(["display:inline-block;overflow:hidden;line-height:", ";vertical-align:middle;border-radius:", ";box-shadow:0 0 0 1px ", ";", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('lineHeights.condensedUltra'), props => getBorderRadius(props), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.avatar.border'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
Avatar.defaultProps = {
  size: 20,
  alt: '',
  square: false
};
var Avatar$1 = Avatar;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/AvatarPair.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/AvatarPair.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AvatarPair$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Avatar_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Avatar.js */ "./node_modules/@primer/react/lib-esm/Avatar.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ChildAvatar = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(_Avatar_js__WEBPACK_IMPORTED_MODULE_2__["default"]).withConfig({
  displayName: "AvatarPair__ChildAvatar",
  componentId: "sc-fw60pa-0"
})(["position:absolute;right:-15%;bottom:-9%;box-shadow:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('shadows.avatar.childShadow'));
const AvatarPair = ({
  children,
  ...rest
}) => {
  const avatars = react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, (child, i) => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child)) {
      return child;
    }
    if (i === 0) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, {
        size: 40
      });
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ChildAvatar, _extends({
      bg: "canvas.default"
    }, child.props, {
      size: 20
    }));
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_4__["default"], _extends({
    position: "relative",
    display: "inline-flex"
  }, rest), avatars);
};
AvatarPair.displayName = "AvatarPair";
// styled() changes this
AvatarPair.displayName = 'AvatarPair';
var AvatarPair$1 = AvatarPair;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/AvatarStack.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/AvatarStack.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AvatarStack$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");







const AvatarStackWrapper = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "AvatarStack__AvatarStackWrapper",
  componentId: "sc-10uzy85-0"
})(["display:flex;position:relative;height:20px;min-width:", ";.pc-AvatarItem{flex-shrink:0;height:20px;width:20px;box-shadow:0 0 0 1px ", ";position:relative;overflow:hidden;transition:margin 0.2s ease-in-out,opacity 0.2s ease-in-out,visibility 0.2s ease-in-out,box-shadow 0.1s ease-in-out;&:first-child{margin-left:0;z-index:10;}&:nth-child(n + 2){margin-left:-11px;z-index:9;}&:nth-child(n + 3){margin-left:-17px;opacity:", "%;z-index:8;}&:nth-child(n + 4){opacity:", "%;z-index:7;}&:nth-child(n + 5){opacity:", "%;z-index:6;}&:nth-child(n + 6){opacity:0;visibility:hidden;}}&.pc-AvatarStack--two{min-width:30px;}&.pc-AvatarStack--three-plus{min-width:38px;}&.pc-AvatarStack--right{justify-content:flex-end;.pc-AvatarItem{margin-left:0 !important;&:first-child{margin-right:0;}&:nth-child(n + 2){margin-right:-11px;}&:nth-child(n + 3){margin-right:-17px;}}.pc-AvatarStackBody{flex-direction:row-reverse;&:hover{.pc-AvatarItem{margin-right:", "!important;margin-left:0 !important;&:first-child{margin-right:0 !important;}}}}}.pc-AvatarStackBody:hover{width:auto;.pc-AvatarItem{margin-left:", ";opacity:100%;visibility:visible;box-shadow:0 0 0 4px ", ";&:first-child{margin-left:0;}}}", ";"], props => props.count === 1 ? '20px' : props.count === 2 ? '30px' : '38px', (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.default'), 100 - 3 * 15, 100 - 4 * 15, 100 - 5 * 15, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.default'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const transformChildren = children => {
  return react__WEBPACK_IMPORTED_MODULE_1___default().Children.map(children, child => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().isValidElement(child)) return child;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().cloneElement(child, {
      ...child.props,
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(child.props.className, 'pc-AvatarItem')
    });
  });
};
const AvatarStack = ({
  children,
  alignRight,
  sx: sxProp
}) => {
  const count = react__WEBPACK_IMPORTED_MODULE_1___default().Children.count(children);
  const wrapperClassNames = classnames__WEBPACK_IMPORTED_MODULE_0___default()({
    'pc-AvatarStack--two': count === 2,
    'pc-AvatarStack--three-plus': count > 2,
    'pc-AvatarStack--right': alignRight
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(AvatarStackWrapper, {
    count: count,
    className: wrapperClassNames,
    sx: sxProp
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    position: "absolute",
    display: "flex",
    width: "38px",
    className: "pc-AvatarStackBody"
  }, transformChildren(children)));
};
AvatarStack.displayName = "AvatarStack";
var AvatarStack$1 = AvatarStack;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/BaseStyles.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/BaseStyles.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BaseStyles)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var focus_visible__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! focus-visible */ "./node_modules/focus-visible/dist/focus-visible.js");
/* harmony import */ var focus_visible__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(focus_visible__WEBPACK_IMPORTED_MODULE_2__);






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const GlobalStyle = (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.createGlobalStyle)(["*{box-sizing:border-box;}body{margin:0;}table{border-collapse:collapse;}input{color-scheme:", ";}[role=\"button\"]:focus:not(:focus-visible):not(.focus-visible),[role=\"tabpanel\"][tabindex=\"0\"]:focus:not(:focus-visible):not(.focus-visible),button:focus:not(:focus-visible):not(.focus-visible),summary:focus:not(:focus-visible):not(.focus-visible),a:focus:not(:focus-visible):not(.focus-visible){outline:none;box-shadow:none;}[tabindex=\"0\"]:focus:not(:focus-visible):not(.focus-visible),details-dialog:focus:not(:focus-visible):not(.focus-visible){outline:none;}"], props => props.colorScheme);
const Base = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "BaseStyles__Base",
  componentId: "sc-nfjs56-0"
})(["", ";", ";"], _constants_js__WEBPACK_IMPORTED_MODULE_3__.TYPOGRAPHY, _constants_js__WEBPACK_IMPORTED_MODULE_3__.COMMON);
function BaseStyles(props) {
  const {
    children,
    ...rest
  } = props;
  const {
    colorScheme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__.useTheme)();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Base, _extends({}, rest, {
    "data-portal-root": true
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GlobalStyle, {
    colorScheme: colorScheme !== null && colorScheme !== void 0 && colorScheme.includes('dark') ? 'dark' : 'light'
  }), children);
}
BaseStyles.displayName = "BaseStyles";
BaseStyles.defaultProps = {
  color: 'fg.default',
  fontFamily: 'normal',
  lineHeight: 'default'
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/BranchName.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/BranchName.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BranchName$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const BranchName = styled_components__WEBPACK_IMPORTED_MODULE_0___default().a.withConfig({
  displayName: "BranchName",
  componentId: "sc-lduqme-0"
})(["display:inline-block;padding:2px 6px;font-size:", ";font-family:", ";color:", ";background-color:", ";border-radius:", ";text-decoration:none;", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontSizes.0'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fonts.mono'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.accent.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var BranchName$1 = BranchName;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Breadcrumbs.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Breadcrumbs.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Breadcrumb": () => (/* binding */ Breadcrumb),
/* harmony export */   "default": () => (/* binding */ Breadcrumbs$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");







const SELECTED_CLASS = 'selected';
const Wrapper = styled_components__WEBPACK_IMPORTED_MODULE_2___default().li.withConfig({
  displayName: "Breadcrumbs__Wrapper",
  componentId: "sc-zwknu7-0"
})(["display:inline-block;white-space:nowrap;list-style:none;&::after{padding-right:0.5em;padding-left:0.5em;color:", ";font-size:", ";content:'/';}&:first-child{margin-left:0;}&:last-child{&::after{content:none;}}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'));
const BreadcrumbsBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().nav.withConfig({
  displayName: "Breadcrumbs__BreadcrumbsBase",
  componentId: "sc-zwknu7-1"
})(["display:flex;justify-content:space-between;", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
function Breadcrumbs({
  className,
  children,
  sx: sxProp
}) {
  const wrappedChildren = react__WEBPACK_IMPORTED_MODULE_1___default().Children.map(children, child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(Wrapper, null, child));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BreadcrumbsBase, {
    className: className,
    "aria-label": "Breadcrumbs",
    sx: sxProp
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "ol",
    my: 0,
    pl: 0
  }, wrappedChildren));
}
Breadcrumbs.displayName = "Breadcrumbs";
const BreadcrumbsItem = styled_components__WEBPACK_IMPORTED_MODULE_2___default().a.attrs(props => ({
  activeClassName: typeof props.to === 'string' ? 'selected' : '',
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(props.selected && SELECTED_CLASS, props.className),
  'aria-current': props.selected ? 'page' : null
})).withConfig({
  displayName: "Breadcrumbs__BreadcrumbsItem",
  componentId: "sc-zwknu7-2"
})(["color:", ";display:inline-block;font-size:", ";text-decoration:none;&:hover{text-decoration:underline;}&.selected{color:", ";pointer-events:none;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
Breadcrumbs.displayName = 'Breadcrumbs';
BreadcrumbsItem.displayName = 'Breadcrumbs.Item';
var Breadcrumbs$1 = Object.assign(Breadcrumbs, {
  Item: BreadcrumbsItem
});

/**
 * @deprecated Use the `Breadcrumbs` component instead (i.e. `<Breadcrumb>` → `<Breadcrumbs>`)
 */
const Breadcrumb = Object.assign(Breadcrumbs, {
  Item: BreadcrumbsItem
});

/**
 * @deprecated Use the `BreadcrumbsProps` type instead
 */




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Button/IconButton.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Button/IconButton.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IconButton": () => (/* binding */ IconButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _types_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./types.js */ "./node_modules/@primer/react/lib-esm/Button/types.js");
/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles.js */ "./node_modules/@primer/react/lib-esm/Button/styles.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const IconButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, forwardedRef) => {
  const {
    variant = 'default',
    size = 'medium',
    sx: sxProp = {},
    icon: Icon,
    ...rest
  } = props;
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
  const sxStyles = deepmerge__WEBPACK_IMPORTED_MODULE_1___default().all([(0,_styles_js__WEBPACK_IMPORTED_MODULE_3__.getBaseStyles)(theme), (0,_styles_js__WEBPACK_IMPORTED_MODULE_3__.getSizeStyles)(size, variant, true), (0,_styles_js__WEBPACK_IMPORTED_MODULE_3__.getVariantStyles)(variant, theme), sxProp]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_types_js__WEBPACK_IMPORTED_MODULE_4__.StyledButton, _extends({
    sx: sxStyles
  }, rest, {
    ref: forwardedRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "span",
    sx: {
      display: 'inline-block'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null)));
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Button/LinkButton.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Button/LinkButton.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LinkButton": () => (/* binding */ LinkButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonBase_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ButtonBase.js */ "./node_modules/@primer/react/lib-esm/Button/ButtonBase.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);





function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LinkButton = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  children,
  as: Component = 'a',
  sx = {},
  ...props
}, forwardedRef) => {
  const style = {
    width: 'fit-content',
    '&:hover:not([disabled])': {
      textDecoration: 'underline'
    },
    // focus must come before :active so that the active box shadow overrides
    '&:focus:not([disabled])': {
      textDecoration: 'underline'
    },
    '&:active:not([disabled])': {
      textDecoration: 'underline'
    }
  };
  const sxStyle = deepmerge__WEBPACK_IMPORTED_MODULE_1___default().all([style, sx]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ButtonBase_js__WEBPACK_IMPORTED_MODULE_2__.ButtonBase, _extends({
    as: Component,
    ref: forwardedRef,
    sx: sxStyle
  }, props), children);
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/ButtonGroup.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/ButtonGroup.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ButtonGroup$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const ButtonGroup = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "ButtonGroup",
  componentId: "sc-tk435v-0"
})(["display:inline-flex;vertical-align:middle;&& > *{position:relative;border-right-width:0;border-radius:0;:first-child{border-top-left-radius:", ";border-bottom-left-radius:", ";margin-right:0;}:not(:first-child){margin-left:0;margin-right:0;}:last-child{border-right-width:1px;border-top-right-radius:", ";border-bottom-right-radius:", ";}:focus,:active,:hover{border-right-width:1px;+ *{border-left-width:0;}}:focus,:active{z-index:1;}}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var ButtonGroup$1 = ButtonGroup;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Caret.js":
/*!*****************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Caret.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Caret)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");




const oppositeEdge = {
  top: 'Bottom',
  right: 'Left',
  bottom: 'Top',
  left: 'Right'
};
const perpendicularEdge = {
  top: 'Left',
  right: 'Top',
  bottom: 'Left',
  left: 'Top'
};
function getEdgeAlign(location) {
  const [edge, align] = location.split('-');
  return [edge, align];
}
function getPosition(edge, align, spacing) {
  const opposite = oppositeEdge[edge].toLowerCase();
  const perp = perpendicularEdge[edge].toLowerCase();
  return {
    [opposite]: '100%',
    [align || perp]: align ? spacing : '50%'
  };
}
const getBg = (0,styled_system__WEBPACK_IMPORTED_MODULE_2__.style)({
  prop: 'bg',
  key: 'colors'
});
const getBorderColor = (0,styled_system__WEBPACK_IMPORTED_MODULE_2__.style)({
  prop: 'borderColor',
  key: 'colors'
});
const getBorderWidth = (0,styled_system__WEBPACK_IMPORTED_MODULE_2__.style)({
  prop: 'borderWidth',
  key: 'borderWidths',
  scale: [0, 1]
});
function Caret(props) {
  var _props$theme;
  const theme = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(styled_components__WEBPACK_IMPORTED_MODULE_1__.ThemeContext);
  const propsWithTheme = {
    ...props,
    theme: (_props$theme = props.theme) !== null && _props$theme !== void 0 ? _props$theme : theme
  };
  const {
    bg
  } = getBg(propsWithTheme);
  const {
    borderColor
  } = getBorderColor(propsWithTheme);
  const {
    borderWidth
  } = getBorderWidth(propsWithTheme);
  const {
    size = 8,
    location = 'bottom'
  } = props;
  const [edge, align] = getEdgeAlign(location);
  const perp = perpendicularEdge[edge];

  // note: these arrays represent points in the form [x, y]
  const a = [-size, 0];
  const b = [0, size];
  const c = [size, 0];

  // spaces are optional in path `d` attribute, and points are
  // represented in the form `x,y` -- which is what the arrays above
  // become when stringified!
  const triangle = `M${a}L${b}L${c}L${a}Z`;
  const line = `M${a}L${b}L${c}`;
  const transform = {
    top: `translate(${[size, size * 2]}) rotate(180)`,
    right: `translate(${[0, size]}) rotate(-90)`,
    bottom: `translate(${[size, 0]})`,
    left: `translate(${[size * 2, size]}) rotate(90)`
  }[edge];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
    width: size * 2,
    height: size * 2,
    style: {
      pointerEvents: 'none',
      position: 'absolute',
      ...getPosition(edge, align, size),
      // if align is set (top|right|bottom|left),
      // then we don't need an offset margin
      [`margin${perp}`]: align ? null : -size
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", {
    transform: transform
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: triangle,
    fill: bg
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: line,
    fill: "none",
    stroke: borderColor,
    strokeWidth: borderWidth
  })));
}
Caret.displayName = "Caret";
Caret.locations = ['top', 'top-left', 'top-right', 'right', 'right-top', 'right-bottom', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-top', 'left-bottom'];
Caret.defaultProps = {
  bg: 'canvas.default',
  borderColor: 'border.default',
  borderWidth: 1
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Checkbox.js":
/*!********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Checkbox.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Checkbox$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/useIsomorphicLayoutEffect.js */ "./node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");
/* harmony import */ var _CheckboxGroupContext_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CheckboxGroupContext.js */ "./node_modules/@primer/react/lib-esm/CheckboxGroupContext.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getGlobalFocusStyles.js */ "./node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StyledCheckbox = styled_components__WEBPACK_IMPORTED_MODULE_0___default().input.withConfig({
  displayName: "Checkbox__StyledCheckbox",
  componentId: "sc-akhawd-0"
})(["cursor:pointer;", " ", ";", ""], props => props.disabled && `cursor: not-allowed;`, (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(0), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);

/**
 * An accessible, native checkbox component
 */
const Checkbox = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  checked,
  indeterminate,
  disabled,
  onChange,
  sx: sxProp,
  required,
  validationStatus,
  value,
  ...rest
}, ref) => {
  const checkboxRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__.useProvidedRefOrCreate)(ref);
  const checkboxGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_CheckboxGroupContext_js__WEBPACK_IMPORTED_MODULE_5__.CheckboxGroupContext);
  const handleOnChange = e => {
    checkboxGroupContext.onChange && checkboxGroupContext.onChange(e);
    onChange && onChange(e);
  };
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkboxRef.current) {
      checkboxRef.current.indeterminate = indeterminate || false;
    }
  }, [indeterminate, checked, checkboxRef]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledCheckbox, _extends({
    type: "checkbox",
    disabled: disabled,
    "aria-disabled": disabled ? 'true' : 'false',
    ref: ref || checkboxRef,
    checked: indeterminate ? false : checked,
    "aria-checked": indeterminate ? 'mixed' : checked ? 'true' : 'false',
    sx: sxProp,
    required: required,
    "aria-required": required ? 'true' : 'false',
    "aria-invalid": validationStatus === 'error' ? 'true' : 'false',
    onChange: handleOnChange,
    value: value,
    name: value
  }, rest));
});
Checkbox.displayName = 'Checkbox';
var Checkbox$1 = Checkbox;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/CheckboxGroup.js":
/*!*************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/CheckboxGroup.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckboxGroupContext": () => (/* reexport safe */ _CheckboxGroupContext_js__WEBPACK_IMPORTED_MODULE_1__.CheckboxGroupContext),
/* harmony export */   "default": () => (/* binding */ CheckboxGroup$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js");
/* harmony import */ var _Checkbox_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Checkbox.js */ "./node_modules/@primer/react/lib-esm/Checkbox.js");
/* harmony import */ var _CheckboxGroupContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CheckboxGroupContext.js */ "./node_modules/@primer/react/lib-esm/CheckboxGroupContext.js");
/* harmony import */ var _FormControl_FormControl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FormControl/FormControl.js */ "./node_modules/@primer/react/lib-esm/FormControl/FormControl.js");
/* harmony import */ var _hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useRenderForcingRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRenderForcingRef.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroup_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js");











function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const CheckboxGroup = ({
  children,
  disabled,
  onChange,
  ...rest
}) => {
  const formControlComponentChildren = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _FormControl_FormControl_js__WEBPACK_IMPORTED_MODULE_2__["default"]).map(formControlComponent => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(formControlComponent) ? formControlComponent.props.children : []).flat();
  const checkedCheckboxes = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(formControlComponentChildren).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _Checkbox_js__WEBPACK_IMPORTED_MODULE_3__["default"]).map(checkbox => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(checkbox) && (checkbox.props.checked || checkbox.props.defaultChecked) && checkbox.props.value).filter(Boolean);
  const [selectedCheckboxValues, setSelectedCheckboxValues] = (0,_hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_4__.useRenderForcingRef)(checkedCheckboxes);
  const updateSelectedCheckboxes = e => {
    const {
      value,
      checked
    } = e.currentTarget;
    if (checked) {
      setSelectedCheckboxValues([...(selectedCheckboxValues.current || []), value]);
      return;
    }
    setSelectedCheckboxValues((selectedCheckboxValues.current || []).filter(selectedValue => selectedValue !== value));
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CheckboxGroupContext_js__WEBPACK_IMPORTED_MODULE_1__.CheckboxGroupContext.Provider, {
    value: {
      disabled,
      onChange: e => {
        if (onChange) {
          updateSelectedCheckboxes(e);
          onChange(selectedCheckboxValues.current || [], e);
        }
      }
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CheckboxOrRadioGroup_CheckboxOrRadioGroup_js__WEBPACK_IMPORTED_MODULE_5__["default"], _extends({
    disabled: disabled
  }, rest), children));
};
CheckboxGroup.displayName = "CheckboxGroup";
var CheckboxGroup$1 = Object.assign(CheckboxGroup, {
  Caption: _CheckboxOrRadioGroup_CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_6__["default"],
  Label: _CheckboxOrRadioGroup_CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_7__["default"],
  Validation: _CheckboxOrRadioGroup_CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_8__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/CheckboxGroupContext.js":
/*!********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/CheckboxGroupContext.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckboxGroupContext": () => (/* binding */ CheckboxGroupContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const CheckboxGroupContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/CircleBadge.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/CircleBadge.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircleBadge$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./StyledOcticon.js */ "./node_modules/@primer/react/lib-esm/StyledOcticon.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _utils_isNumeric_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/isNumeric.js */ "./node_modules/@primer/react/lib-esm/utils/isNumeric.js");






const variantSizes = {
  small: 56,
  medium: 96,
  large: 128
};
const sizeStyles = ({
  size,
  variant = 'medium'
}) => {
  const calc = (0,_utils_isNumeric_js__WEBPACK_IMPORTED_MODULE_1__["default"])(size) ? size : variantSizes[variant];
  return {
    width: calc,
    height: calc
  };
};
const CircleBadge = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "CircleBadge",
  componentId: "sc-1ej09kx-0"
})(["display:", ";align-items:center;justify-content:center;background-color:", ";border-radius:50%;box-shadow:", ";", ";", ";"], props => props.inline ? 'inline-flex' : 'flex', (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.shadow.medium'), sizeStyles, _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const CircleBadgeIcon = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(_StyledOcticon_js__WEBPACK_IMPORTED_MODULE_4__["default"]).withConfig({
  displayName: "CircleBadge__CircleBadgeIcon",
  componentId: "sc-1ej09kx-1"
})(["height:auto;max-width:60%;max-height:55%;"]);
CircleBadge.defaultProps = {
  inline: false
};
CircleBadgeIcon.displayName = 'CircleBadge.Icon';
var CircleBadge$1 = Object.assign(CircleBadge, {
  Icon: CircleBadgeIcon
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/CircleOcticon.js":
/*!*************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/CircleOcticon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircleOcticon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");



function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function CircleOcticon(props) {
  const {
    size,
    as
  } = props;
  const {
    icon: IconComponent,
    bg,
    ...rest
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: as,
    bg: bg,
    overflow: "hidden",
    borderWidth: 0,
    size: size,
    borderRadius: "50%",
    borderStyle: "solid",
    borderColor: "border.default"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({
    display: "flex"
  }, rest, {
    alignItems: "center",
    justifyContent: "center"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(IconComponent, {
    size: size
  })));
}
CircleOcticon.displayName = "CircleOcticon";
CircleOcticon.defaultProps = {
  ..._Box_js__WEBPACK_IMPORTED_MODULE_1__["default"].defaultProps,
  size: 32
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Details.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Details.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Details$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");



const Details = styled_components__WEBPACK_IMPORTED_MODULE_0___default().details.withConfig({
  displayName: "Details",
  componentId: "sc-1qhvasm-0"
})(["& > summary{list-style:none;}& > summary::-webkit-details-marker{display:none;}", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
Details.displayName = 'Details';
var Details$1 = Details;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Dialog.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Dialog.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Dialog$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _deprecated_Button_ButtonClose_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./deprecated/Button/ButtonClose.js */ "./node_modules/@primer/react/lib-esm/deprecated/Button/ButtonClose.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _hooks_useDialog_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./hooks/useDialog.js */ "./node_modules/@primer/react/lib-esm/hooks/useDialog.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");










function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const noop = () => null;
const DialogBase = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Dialog__DialogBase",
  componentId: "sc-13rdxb7-0"
})(["box-shadow:", ";border-radius:", ";position:fixed;top:0;left:50%;transform:translateX(-50%);max-height:80vh;z-index:999;margin:10vh auto;background-color:", ";width:", ";outline:none;@media screen and (max-width:750px){width:100vw;margin:0;border-radius:0;height:100vh;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.shadow.large'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.default'), props => props.narrow ? '320px' : props.wide ? '640px' : '440px', _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const DialogHeaderBase = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(_Box_js__WEBPACK_IMPORTED_MODULE_4__["default"]).withConfig({
  displayName: "Dialog__DialogHeaderBase",
  componentId: "sc-13rdxb7-1"
})(["border-radius:", " ", " 0px 0px;border-bottom:1px solid ", ";display:flex;@media screen and (max-width:750px){border-radius:0px;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.default'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
function DialogHeader({
  theme,
  children,
  backgroundColor = 'gray.1',
  ...rest
}) {
  if (react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).every(ch => typeof ch === 'string')) {
    children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
      theme: theme,
      color: "fg.default",
      fontSize: 1,
      fontWeight: "bold",
      fontFamily: "sans-serif"
    }, children);
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DialogHeaderBase, _extends({
    theme: theme,
    p: 3,
    backgroundColor: backgroundColor
  }, rest), children);
}
DialogHeader.displayName = "DialogHeader";
const Overlay = styled_components__WEBPACK_IMPORTED_MODULE_1___default().span.withConfig({
  displayName: "Dialog__Overlay",
  componentId: "sc-13rdxb7-2"
})(["&:before{position:fixed;top:0;right:0;bottom:0;left:0;display:block;cursor:default;content:' ';background:transparent;z-index:99;background:", ";}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.primer.canvas.backdrop'));
const Dialog = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  children,
  onDismiss = noop,
  isOpen,
  initialFocusRef,
  returnFocusRef,
  ...props
}, forwardedRef) => {
  const overlayRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const modalRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_6__.useRefObjectAsForwardedRef)(forwardedRef, modalRef);
  const closeButtonRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const onCloseClick = () => {
    onDismiss();
    if (returnFocusRef && returnFocusRef.current) {
      returnFocusRef.current.focus();
    }
  };
  const {
    getDialogProps
  } = (0,_hooks_useDialog_js__WEBPACK_IMPORTED_MODULE_7__["default"])({
    modalRef,
    onDismiss: onCloseClick,
    isOpen,
    initialFocusRef,
    closeButtonRef,
    returnFocusRef,
    overlayRef
  });
  return isOpen ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Overlay, {
    ref: overlayRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DialogBase, _extends({
    tabIndex: -1,
    ref: modalRef,
    role: "dialog",
    "aria-modal": "true"
  }, props, getDialogProps()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_deprecated_Button_ButtonClose_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    ref: closeButtonRef,
    onClick: onCloseClick,
    sx: {
      position: 'absolute',
      top: '16px',
      right: '16px'
    }
  }), children)) : null;
});
DialogHeader.defaultProps = {
  backgroundColor: 'canvas.subtle'
};
DialogHeader.propTypes = {
  ..._Box_js__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes
};
DialogHeader.displayName = 'Dialog.Header';
Dialog.displayName = 'Dialog';
var Dialog$1 = Object.assign(Dialog, {
  Header: DialogHeader
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FilterList.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FilterList.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FilterList$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





const FilterListBase = styled_components__WEBPACK_IMPORTED_MODULE_1___default().ul.withConfig({
  displayName: "FilterList__FilterListBase",
  componentId: "sc-14vymk5-0"
})(["list-style-type:none;margin:0;padding:0;", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
const FilterList = ({
  children,
  ...rest
}) => {
  const items = react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, child => {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", null, child);
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FilterListBase, rest, items);
};
FilterList.displayName = "FilterList";
const FilterListItemBase = styled_components__WEBPACK_IMPORTED_MODULE_1___default().a.withConfig({
  displayName: "FilterList__FilterListItemBase",
  componentId: "sc-14vymk5-1"
})(["position:relative;display:block;padding:", ";margin:", ";overflow:hidden;font-size:", ";color:", ";background-color:", "!important;text-decoration:none;text-overflow:ellipsis;white-space:nowrap;cursor:pointer;border-radius:", ";&:hover{text-decoration:none;background-color:", ";}&:active{color:", ";background-color:", ";}.count{float:right;font-weight:", ";}", ";"], props => props.small ? `${(0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1')(props)} 10px` : `${(0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2')(props)} 11px`, props => props.small ? '0 0 2px' : '0 0 5px 0', (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), props => props.selected ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), props => props.selected ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.emphasis') : '', (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.emphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontWeights.bold'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
function FilterListItem({
  children,
  count,
  ...rest
}) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FilterListItemBase, rest, count && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    title: "results",
    className: "count"
  }, count), children);
}
FilterListItem.displayName = "FilterListItem";
FilterListItem.displayName = 'FilterList.Item';
var FilterList$1 = Object.assign(FilterList, {
  Item: FilterListItem
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FilteredActionList/FilteredActionList.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FilteredActionList/FilteredActionList.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilteredActionList": () => (/* binding */ FilteredActionList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var _TextInput_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../TextInput.js */ "./node_modules/@primer/react/lib-esm/TextInput.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _deprecated_ActionList_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../deprecated/ActionList/index.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/index.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useProvidedStateOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _hooks_useScrollFlash_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../hooks/useScrollFlash.js */ "./node_modules/@primer/react/lib-esm/hooks/useScrollFlash.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/scroll-into-view.js");














function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const menuScrollMargins = {
  startMargin: 0,
  endMargin: 8
};
const StyledHeader = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "FilteredActionList__StyledHeader",
  componentId: "sc-1oqgb0s-0"
})(["box-shadow:0 1px 0 ", ";z-index:1;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.default'));
function FilteredActionList({
  loading = false,
  placeholderText,
  filterValue: externalFilterValue,
  onFilterChange,
  items,
  textInputProps,
  inputRef: providedInputRef,
  sx,
  ...listProps
}) {
  const [filterValue, setInternalFilterValue] = (0,_hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_3__.useProvidedStateOrCreate)(externalFilterValue, undefined, '');
  const onInputChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    const value = e.target.value;
    onFilterChange(value, e);
    setInternalFilterValue(value);
  }, [onFilterChange, setInternalFilterValue]);
  const scrollContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const listContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const inputRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_4__.useProvidedRefOrCreate)(providedInputRef);
  const activeDescendantRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const listId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_5__.useSSRSafeId)();
  const onInputKeyPress = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    if (event.key === 'Enter' && activeDescendantRef.current) {
      event.preventDefault();
      event.nativeEvent.stopImmediatePropagation();

      // Forward Enter key press to active descendant so that item gets activated
      const activeDescendantEvent = new KeyboardEvent(event.type, event.nativeEvent);
      activeDescendantRef.current.dispatchEvent(activeDescendantEvent);
    }
  }, [activeDescendantRef]);
  (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__.useFocusZone)({
    containerRef: listContainerRef,
    focusOutBehavior: 'wrap',
    focusableElementFilter: element => {
      return !(element instanceof HTMLInputElement);
    },
    activeDescendantFocus: inputRef,
    onActiveDescendantChanged: (current, previous, directlyActivated) => {
      activeDescendantRef.current = current;
      if (current && scrollContainerRef.current && directlyActivated) {
        (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.scrollIntoView)(current, scrollContainerRef.current, menuScrollMargins);
      }
    }
  }, [
  // List ref isn't set while loading.  Need to re-bind focus zone when it changes
  loading]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // if items changed, we want to instantly move active descendant into view
    if (activeDescendantRef.current && scrollContainerRef.current) {
      (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.scrollIntoView)(activeDescendantRef.current, scrollContainerRef.current, {
        ...menuScrollMargins,
        behavior: 'auto'
      });
    }
  }, [items]);
  (0,_hooks_useScrollFlash_js__WEBPACK_IMPORTED_MODULE_8__["default"])(scrollContainerRef);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_9__["default"], {
    display: "flex",
    flexDirection: "column",
    overflow: "hidden",
    sx: sx
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledHeader, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TextInput_js__WEBPACK_IMPORTED_MODULE_10__["default"], _extends({
    ref: inputRef,
    block: true,
    width: "auto",
    color: "fg.default",
    value: filterValue,
    onChange: onInputChange,
    onKeyPress: onInputKeyPress,
    placeholder: placeholderText,
    "aria-label": placeholderText,
    "aria-controls": listId
  }, textInputProps))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_9__["default"], {
    ref: scrollContainerRef,
    overflow: "auto"
  }, loading ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_9__["default"], {
    width: "100%",
    display: "flex",
    flexDirection: "row",
    justifyContent: "center",
    pt: 6,
    pb: 7
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_11__["default"], null)) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_deprecated_ActionList_index_js__WEBPACK_IMPORTED_MODULE_12__.ActionList, _extends({
    ref: listContainerRef,
    items: items
  }, listProps, {
    role: "listbox",
    id: listId
  }))));
}
FilteredActionList.displayName = "FilteredActionList";
FilteredActionList.displayName = 'FilteredActionList';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FilteredSearch.js":
/*!**************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FilteredSearch.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FilteredSearch$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const FilteredSearch = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "FilteredSearch",
  componentId: "sc-1q2r5fr-0"
})(["display:flex;align-items:stretch;summary,> button{border-radius:0;border-top-left-radius:", ";border-bottom-left-radius:", ";border-right:0;}.TextInput-wrapper{border-radius:0;border-top-right-radius:", ";border-bottom-right-radius:", ";}", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var FilteredSearch$1 = FilteredSearch;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Flash.js":
/*!*****************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Flash.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Flash$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





const variants = (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  variants: {
    default: {
      color: 'fg.default',
      backgroundColor: 'accent.subtle',
      borderColor: 'accent.muted',
      svg: {
        color: 'accent.fg'
      }
    },
    success: {
      color: 'fg.default',
      backgroundColor: 'success.subtle',
      borderColor: 'success.muted',
      svg: {
        color: 'success.fg'
      }
    },
    danger: {
      color: 'fg.default',
      backgroundColor: 'danger.subtle',
      borderColor: 'danger.muted',
      svg: {
        color: 'danger.fg'
      }
    },
    warning: {
      color: 'fg.default',
      backgroundColor: 'attention.subtle',
      borderColor: 'attention.muted',
      svg: {
        color: 'attention.fg'
      }
    }
  }
});
const Flash = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Flash",
  componentId: "sc-1jd8n2z-0"
})(["position:relative;color:", ";padding:", ";border-style:solid;border-width:", ";border-radius:", ";margin-top:", ";p:last-child{margin-bottom:0;}svg{margin-right:", ";}", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.3'), props => props.full ? '1px 0px' : '1px', props => props.full ? '0' : (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), props => props.full ? '-1px' : '0', (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'), variants, _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
Flash.defaultProps = {
  variant: 'default'
};
var Flash$1 = Flash;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/FormControl.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/FormControl.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormControl$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Checkbox_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Checkbox.js */ "./node_modules/@primer/react/lib-esm/Checkbox.js");
/* harmony import */ var _Radio_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Radio.js */ "./node_modules/@primer/react/lib-esm/Radio.js");
/* harmony import */ var _Select_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Select.js */ "./node_modules/@primer/react/lib-esm/Select.js");
/* harmony import */ var _Textarea_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Textarea.js */ "./node_modules/@primer/react/lib-esm/Textarea.js");
/* harmony import */ var _TextInput_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../TextInput.js */ "./node_modules/@primer/react/lib-esm/TextInput.js");
/* harmony import */ var _TextInputWithTokens_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../TextInputWithTokens.js */ "./node_modules/@primer/react/lib-esm/TextInputWithTokens.js");
/* harmony import */ var _FormControlCaption_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./_FormControlCaption.js */ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlCaption.js");
/* harmony import */ var _FormControlLabel_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./_FormControlLabel.js */ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlLabel.js");
/* harmony import */ var _FormControlValidation_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./_FormControlValidation.js */ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlValidation.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/FormControl/slots.js");
/* harmony import */ var _ValidationAnimationContainer_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../_ValidationAnimationContainer.js */ "./node_modules/@primer/react/lib-esm/_ValidationAnimationContainer.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _FormControlLeadingVisual_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./_FormControlLeadingVisual.js */ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlLeadingVisual.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupContext_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../_CheckboxOrRadioGroup/_CheckboxOrRadioGroupContext.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupContext.js");
/* harmony import */ var _drafts_InlineAutocomplete_InlineAutocomplete_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../drafts/InlineAutocomplete/InlineAutocomplete.js */ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/InlineAutocomplete.js");
/* harmony import */ var _Autocomplete_Autocomplete_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Autocomplete/Autocomplete.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/Autocomplete.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");




















const FormControl = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  children,
  disabled: disabledProp,
  layout,
  id: idProp,
  required,
  sx
}, ref) => {
  const expectedInputComponents = [_Autocomplete_Autocomplete_js__WEBPACK_IMPORTED_MODULE_1__["default"], _Checkbox_js__WEBPACK_IMPORTED_MODULE_2__["default"], _Radio_js__WEBPACK_IMPORTED_MODULE_3__["default"], _Select_js__WEBPACK_IMPORTED_MODULE_4__["default"], _TextInput_js__WEBPACK_IMPORTED_MODULE_5__["default"], _TextInputWithTokens_js__WEBPACK_IMPORTED_MODULE_6__["default"], _Textarea_js__WEBPACK_IMPORTED_MODULE_7__["default"], _drafts_InlineAutocomplete_InlineAutocomplete_js__WEBPACK_IMPORTED_MODULE_8__["default"]];
  const choiceGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_CheckboxOrRadioGroup_CheckboxOrRadioGroupContext_js__WEBPACK_IMPORTED_MODULE_9__["default"]);
  const disabled = (choiceGroupContext === null || choiceGroupContext === void 0 ? void 0 : choiceGroupContext.disabled) || disabledProp;
  const id = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_10__.useSSRSafeId)(idProp);
  const validationChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _FormControlValidation_js__WEBPACK_IMPORTED_MODULE_11__["default"] ? child : null);
  const captionChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _FormControlCaption_js__WEBPACK_IMPORTED_MODULE_12__["default"] ? child : null);
  const labelChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _FormControlLabel_js__WEBPACK_IMPORTED_MODULE_13__["default"]);
  const validationMessageId = validationChild && `${id}-validationMessage`;
  const captionId = captionChild && `${id}-caption`;
  const validationStatus = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(validationChild) && validationChild.props.variant;
  const InputComponent = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => expectedInputComponents.some(inputComponent => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === inputComponent));
  const inputProps = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(InputComponent) && InputComponent.props;
  const isChoiceInput = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(InputComponent) && (InputComponent.type === _Checkbox_js__WEBPACK_IMPORTED_MODULE_2__["default"] || InputComponent.type === _Radio_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
  if (InputComponent) {
    if (inputProps !== null && inputProps !== void 0 && inputProps.id) {
      // eslint-disable-next-line no-console
      console.warn(`instead of passing the 'id' prop directly to the input component, it should be passed to the parent component, <FormControl>`);
    }
    if (inputProps !== null && inputProps !== void 0 && inputProps.disabled) {
      // eslint-disable-next-line no-console
      console.warn(`instead of passing the 'disabled' prop directly to the input component, it should be passed to the parent component, <FormControl>`);
    }
    if (inputProps !== null && inputProps !== void 0 && inputProps.required) {
      // eslint-disable-next-line no-console
      console.warn(`instead of passing the 'required' prop directly to the input component, it should be passed to the parent component, <FormControl>`);
    }
  }
  if (!labelChild) {
    // eslint-disable-next-line no-console
    console.error(`The input field with the id ${id} MUST have a FormControl.Label child.\n\nIf you want to hide the label, pass the 'visuallyHidden' prop to the FormControl.Label component.`);
  }
  if (isChoiceInput) {
    if (validationChild) {
      // eslint-disable-next-line no-console
      console.warn('Validation messages are not rendered for an individual checkbox or radio. The validation message should be shown for all options.');
    }
    if (react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => {
      var _child$props;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && ((_child$props = child.props) === null || _child$props === void 0 ? void 0 : _child$props.required);
    })) {
      // eslint-disable-next-line no-console
      console.warn('An individual checkbox or radio cannot be a required field.');
    }
  } else {
    if (react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _FormControlLeadingVisual_js__WEBPACK_IMPORTED_MODULE_14__["default"])) {
      // eslint-disable-next-line no-console
      console.warn('A leading visual is only rendered for a checkbox or radio form control. If you want to render a leading visual inside of your input, check if your input supports a leading visual.');
    }
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_15__.Slots, {
    context: {
      captionId,
      disabled,
      id,
      required,
      validationMessageId
    }
  }, slots => {
    const isLabelHidden = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(slots.Label) && slots.Label.props.visuallyHidden;
    return isChoiceInput || layout === 'horizontal' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_16__["default"], {
      ref: ref,
      display: "flex",
      alignItems: slots.LeadingVisual ? 'center' : undefined,
      sx: sx
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_16__["default"], {
      sx: {
        '> input': {
          marginLeft: 0,
          marginRight: 0
        }
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(InputComponent) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(InputComponent, {
      id,
      disabled,
      ['aria-describedby']: captionId
    }), react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && ![_Checkbox_js__WEBPACK_IMPORTED_MODULE_2__["default"], _Radio_js__WEBPACK_IMPORTED_MODULE_3__["default"]].some(inputComponent => child.type === inputComponent))), slots.LeadingVisual && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_16__["default"], {
      color: disabled ? 'fg.muted' : 'fg.default',
      sx: {
        '> *': {
          minWidth: slots.Caption ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_17__.get)('fontSizes.4') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_17__.get)('fontSizes.2'),
          minHeight: slots.Caption ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_17__.get)('fontSizes.4') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_17__.get)('fontSizes.2'),
          fill: 'currentColor'
        }
      },
      ml: 2
    }, slots.LeadingVisual), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(slots.Label) && !slots.Label.props.visuallyHidden || slots.Caption ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_16__["default"], {
      display: "flex",
      flexDirection: "column",
      ml: 2
    }, slots.Label, slots.Caption) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, slots.Label, slots.Caption)) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_16__["default"], {
      ref: ref,
      display: "flex",
      flexDirection: "column",
      alignItems: "flex-start",
      sx: {
        ...(isLabelHidden ? {
          '> *:not(label) + *': {
            marginTop: 1
          }
        } : {
          '> * + *': {
            marginTop: 1
          }
        }),
        ...sx
      }
    }, slots.Label, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(InputComponent) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(InputComponent, Object.assign({
      id,
      required,
      disabled,
      validationStatus,
      ['aria-describedby']: [validationMessageId, captionId].filter(Boolean).join(' ')
    }, InputComponent.props)), react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && !expectedInputComponents.some(inputComponent => child.type === inputComponent)), validationChild && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ValidationAnimationContainer_js__WEBPACK_IMPORTED_MODULE_18__["default"], {
      show: true
    }, slots.Validation), slots.Caption);
  });
});
FormControl.defaultProps = {
  layout: 'vertical'
};
var FormControl$1 = Object.assign(FormControl, {
  Caption: _FormControlCaption_js__WEBPACK_IMPORTED_MODULE_12__["default"],
  Label: _FormControlLabel_js__WEBPACK_IMPORTED_MODULE_13__["default"],
  LeadingVisual: _FormControlLeadingVisual_js__WEBPACK_IMPORTED_MODULE_14__["default"],
  Validation: _FormControlValidation_js__WEBPACK_IMPORTED_MODULE_11__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlCaption.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/_FormControlCaption.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormControlCaption$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputCaption_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../_InputCaption.js */ "./node_modules/@primer/react/lib-esm/_InputCaption.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/FormControl/slots.js");




const FormControlCaption = ({
  children,
  sx,
  id
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Caption"
}, ({
  captionId,
  disabled
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputCaption_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  id: id || captionId,
  disabled: disabled,
  sx: sx
}, children));
FormControlCaption.displayName = "FormControlCaption";
var FormControlCaption$1 = FormControlCaption;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlLabel.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/_FormControlLabel.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormControlLabel$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputLabel_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../_InputLabel.js */ "./node_modules/@primer/react/lib-esm/_InputLabel.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/FormControl/slots.js");




const FormControlLabel = ({
  children,
  htmlFor,
  id,
  visuallyHidden,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Label"
}, ({
  disabled,
  id: formControlId,
  required
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputLabel_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  htmlFor: htmlFor || formControlId,
  id: id,
  visuallyHidden: visuallyHidden,
  required: required,
  disabled: disabled,
  sx: sx
}, children));
FormControlLabel.displayName = "FormControlLabel";
var FormControlLabel$1 = FormControlLabel;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlLeadingVisual.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/_FormControlLeadingVisual.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormControlLeadingVisual$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/FormControl/slots.js");





const FormControlLeadingVisual = ({
  children,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "LeadingVisual"
}, ({
  disabled,
  captionId
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  color: disabled ? 'fg.muted' : 'fg.default',
  sx: {
    '> *': {
      minWidth: captionId ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.4') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.2'),
      minHeight: captionId ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.4') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.2'),
      fill: 'currentColor'
    },
    ...sx
  },
  ml: 2
}, children));
FormControlLeadingVisual.displayName = "FormControlLeadingVisual";
var FormControlLeadingVisual$1 = FormControlLeadingVisual;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/_FormControlValidation.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/_FormControlValidation.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormControlValidation$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputValidation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../_InputValidation.js */ "./node_modules/@primer/react/lib-esm/_InputValidation.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/FormControl/slots.js");




const FormControlValidation = ({
  children,
  variant,
  sx,
  id
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Validation"
}, ({
  validationMessageId
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputValidation_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  validationStatus: variant,
  id: id || validationMessageId,
  sx: sx
}, children));
FormControlValidation.displayName = "FormControlValidation";
var FormControlValidation$1 = FormControlValidation;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/FormControl/slots.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/FormControl/slots.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Slot": () => (/* binding */ Slot),
/* harmony export */   "Slots": () => (/* binding */ Slots)
/* harmony export */ });
/* harmony import */ var _utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/create-slots.js */ "./node_modules/@primer/react/lib-esm/utils/create-slots.js");


const {
  Slots,
  Slot
} = (0,_utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__["default"])(['Caption', 'Label', 'LeadingVisual', 'Validation']);




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Header.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Header.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const Header = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Header",
  componentId: "sc-11fu6rh-0"
})(["z-index:32;display:flex;padding:", ";font-size:", ";line-height:", ";color:", ";background-color:", ";align-items:center;flex-wrap:nowrap;", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('lineHeights.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.header.text'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.header.bg'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
const HeaderItem = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Header__HeaderItem",
  componentId: "sc-11fu6rh-1"
})(["display:flex;margin-right:", ";align-self:stretch;align-items:center;flex-wrap:nowrap;", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.3'), ({
  full
}) => full && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["flex:auto;"]), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
HeaderItem.displayName = 'Header.Item';
const HeaderLink = styled_components__WEBPACK_IMPORTED_MODULE_0___default().a.attrs(({
  to
}) => {
  const isReactRouter = typeof to === 'string';
  if (isReactRouter) {
    // according to their docs, NavLink supports aria-current:
    // https://reacttraining.com/react-router/web/api/NavLink/aria-current-string
    return {
      'aria-current': 'page'
    };
  } else {
    return {};
  }
}).withConfig({
  displayName: "Header__HeaderLink",
  componentId: "sc-11fu6rh-2"
})(["font-weight:", ";color:", ";white-space:nowrap;cursor:pointer;text-decoration:none;display:flex;align-items:center;&:hover,&:focus{color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.header.logo'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.header.text'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
HeaderLink.displayName = 'Header.Link';
var Header$1 = Object.assign(Header, {
  Link: HeaderLink,
  Item: HeaderItem
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Heading.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Heading.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Heading$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const Heading = styled_components__WEBPACK_IMPORTED_MODULE_0___default().h2.withConfig({
  displayName: "Heading",
  componentId: "sc-1irtotl-0"
})(["font-weight:", ";font-size:", ";margin:0;", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontSizes.5'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var Heading$1 = Heading;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Label.js":
/*!*****************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Label.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Label$1),
/* harmony export */   "variants": () => (/* binding */ variants)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");





const variants = {
  default: {
    borderColor: 'border.default'
  },
  primary: {
    borderColor: 'fg.default'
  },
  secondary: {
    borderColor: 'border.muted',
    color: 'fg.muted'
  },
  accent: {
    borderColor: 'accent.emphasis',
    color: 'accent.fg'
  },
  success: {
    borderColor: 'success.emphasis',
    color: 'success.fg'
  },
  attention: {
    borderColor: 'attention.emphasis',
    color: 'attention.fg'
  },
  severe: {
    borderColor: 'severe.emphasis',
    color: 'severe.fg'
  },
  danger: {
    borderColor: 'danger.emphasis',
    color: 'danger.fg'
  },
  done: {
    borderColor: 'done.emphasis',
    color: 'done.fg'
  },
  sponsors: {
    borderColor: 'sponsors.emphasis',
    color: 'sponsors.fg'
  }
};
const sizes = {
  small: {
    height: '20px',
    padding: '0 7px' // hard-coded to align with Primer ViewComponents and Primer CSS
  },

  large: {
    height: '24px',
    padding: '0 10px' // hard-coded to align with Primer ViewComponents and Primer CSS
  }
};

const Label = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "Label",
  componentId: "sc-6dyj7v-0"
})(["align-items:center;background-color:transparent;border-width:1px;border-radius:999px;border-style:solid;display:inline-flex;font-weight:", ";font-size:", ";line-height:1;white-space:nowrap;", ";", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontSizes.0'), (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  variants
}), (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  prop: 'size',
  variants: sizes
}), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
Label.defaultProps = {
  size: 'small',
  variant: 'default'
};
var Label$1 = Label;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/LabelGroup.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/LabelGroup.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LabelGroup$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const LabelGroup = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "LabelGroup",
  componentId: "sc-1a0k7wh-0"
})(["& *{margin-right:", ";}& *:last-child{margin-right:0;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.1'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var LabelGroup$1 = LabelGroup;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/NavList/NavList.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/NavList/NavList.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NavList": () => (/* binding */ NavList)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ActionList/index.js */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../StyledOcticon.js */ "./node_modules/@primer/react/lib-esm/StyledOcticon.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_3__);










function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// ----------------------------------------------------------------------------
// NavList

const NavBox = styled_components__WEBPACK_IMPORTED_MODULE_2___default().nav.withConfig({
  displayName: "NavList__NavBox",
  componentId: "sc-1c8ygf7-0"
})(_sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const Root = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  children,
  ...props
}, ref) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(NavBox, _extends({}, props, {
    ref: ref
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList, null, children));
});
Root.displayName = 'NavList';

// ----------------------------------------------------------------------------
// NavList.Item

const Item = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  'aria-current': ariaCurrent,
  children,
  sx: sxProp = {},
  ...props
}, ref) => {
  const {
    depth
  } = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(SubNavContext);

  // Get SubNav from children
  const subNav = react__WEBPACK_IMPORTED_MODULE_1___default().Children.toArray(children).find(child => /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(child) && child.type === SubNav);

  // Get children without SubNav
  const childrenWithoutSubNav = react__WEBPACK_IMPORTED_MODULE_1___default().Children.toArray(children).filter(child => /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(child) ? child.type !== SubNav : true);

  // Render ItemWithSubNav if SubNav is present
  if (subNav && /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(subNav) && depth < 1) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ItemWithSubNav, {
      subNav: subNav,
      sx: sxProp
    }, childrenWithoutSubNav);
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.LinkItem, _extends({
    ref: ref,
    "aria-current": ariaCurrent,
    active: Boolean(ariaCurrent) && ariaCurrent !== 'false',
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()({
      paddingLeft: depth > 0 ? 5 : null,
      // Indent sub-items
      fontSize: depth > 0 ? 0 : null,
      // Reduce font size of sub-items
      fontWeight: depth > 0 ? 'normal' : null // Sub-items don't get bolded
    }, sxProp)
  }, props), children);
});
Item.displayName = 'NavList.Item';

// ----------------------------------------------------------------------------
// ItemWithSubNav (internal)

const ItemWithSubNavContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createContext({
  buttonId: '',
  subNavId: '',
  isOpen: false
});

// TODO: ref prop
// TODO: Animate open/close transition
function ItemWithSubNav({
  children,
  subNav,
  sx: sxProp = {}
}) {
  const buttonId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_6__.useSSRSafeId)();
  const subNavId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_6__.useSSRSafeId)();
  const [isOpen, setIsOpen] = react__WEBPACK_IMPORTED_MODULE_1___default().useState(false);
  const subNavRef = react__WEBPACK_IMPORTED_MODULE_1___default().useRef(null);
  const [containsCurrentItem, setContainsCurrentItem] = react__WEBPACK_IMPORTED_MODULE_1___default().useState(false);
  react__WEBPACK_IMPORTED_MODULE_1___default().useLayoutEffect(() => {
    if (subNavRef.current) {
      // Check if SubNav contains current item
      const currentItem = subNavRef.current.querySelector('[aria-current]');
      if (currentItem && currentItem.getAttribute('aria-current') !== 'false') {
        setContainsCurrentItem(true);
        setIsOpen(true);
      }
    }
  }, [subNav]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(ItemWithSubNavContext.Provider, {
    value: {
      buttonId,
      subNavId,
      isOpen
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    as: "li",
    "aria-labelledby": buttonId,
    sx: {
      listStyle: 'none'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.Item, {
    as: "button",
    id: buttonId,
    "aria-expanded": isOpen,
    "aria-controls": subNavId
    // When the subNav is closed, how should we indicated that the subNav contains the current item?
    ,
    active: !isOpen && containsCurrentItem,
    onClick: () => setIsOpen(open => !open),
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()({
      fontWeight: containsCurrentItem ? 'bold' : null // Parent item is bold if any of it's sub-items are current
    }, sxProp)
  }, children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.TrailingVisual, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_StyledOcticon_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.ChevronDownIcon,
    sx: {
      transform: isOpen ? 'rotate(180deg)' : 'rotate(0deg)'
    }
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    ref: subNavRef
  }, subNav)));
}
ItemWithSubNav.displayName = "ItemWithSubNav";
const SubNavContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createContext({
  depth: 0
});

// TODO: ref prop
// NOTE: SubNav must be a direct child of an Item
const SubNav = ({
  children,
  sx: sxProp = {}
}) => {
  const {
    buttonId,
    subNavId,
    isOpen
  } = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(ItemWithSubNavContext);
  const {
    depth
  } = react__WEBPACK_IMPORTED_MODULE_1___default().useContext(SubNavContext);
  if (!buttonId || !subNavId) {
    // eslint-disable-next-line no-console
    console.error('NavList.SubNav must be a child of a NavList.Item');
  }
  if (depth > 0) {
    // eslint-disable-next-line no-console
    console.error('NavList.SubNav only supports one level of nesting');
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(SubNavContext.Provider, {
    value: {
      depth: depth + 1
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    as: "ul",
    id: subNavId,
    "aria-labelledby": buttonId,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()({
      padding: 0,
      margin: 0,
      display: isOpen ? 'block' : 'none'
    }, sxProp)
  }, children));
};
SubNav.displayName = "SubNav";
SubNav.displayName = 'NavList.SubNav';

// ----------------------------------------------------------------------------
// NavList.LeadingVisual

const LeadingVisual = _ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.LeadingVisual;
LeadingVisual.displayName = 'NavList.LeadingVisual';

// ----------------------------------------------------------------------------
// NavList.TrailingVisual

const TrailingVisual = _ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.TrailingVisual;
TrailingVisual.displayName = 'NavList.TrailingVisual';

// ----------------------------------------------------------------------------
// NavList.Divider

const Divider = _ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.Divider;
Divider.displayName = 'NavList.Divider';

// ----------------------------------------------------------------------------
// NavList.Group

const defaultSx = {};
// TODO: ref prop
const Group = ({
  title,
  children,
  sx: sxProp = defaultSx,
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.Divider, {
    sx: {
      '&:first-child': {
        display: 'none'
      }
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_5__.ActionList.Group, _extends({}, props, {
    title: title,
    sx: sxProp
  }), children));
};
Group.displayName = 'NavList.Group';

// ----------------------------------------------------------------------------
// Export

const NavList = Object.assign(Root, {
  Item,
  SubNav,
  LeadingVisual,
  TrailingVisual,
  Divider,
  Group
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Overlay.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Overlay.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Overlay$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/useIsomorphicLayoutEffect.js */ "./node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Portal_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Portal/index.js */ "./node_modules/@primer/react/lib-esm/Portal/index.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _hooks_useOverlay_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./hooks/useOverlay.js */ "./node_modules/@primer/react/lib-esm/hooks/useOverlay.js");










function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const heightMap = {
  xsmall: '192px',
  small: '256px',
  medium: '320px',
  large: '432px',
  xlarge: '600px',
  auto: 'auto',
  initial: 'auto' // Passing 'initial' initially applies 'auto'
};

const widthMap = {
  small: '256px',
  medium: '320px',
  large: '480px',
  xlarge: '640px',
  xxlarge: '960px',
  auto: 'auto'
};
const animationDuration = 200;
function getSlideAnimationStartingVector(anchorSide) {
  if (anchorSide !== null && anchorSide !== void 0 && anchorSide.endsWith('bottom')) {
    return {
      x: 0,
      y: -1
    };
  } else if (anchorSide !== null && anchorSide !== void 0 && anchorSide.endsWith('top')) {
    return {
      x: 0,
      y: 1
    };
  } else if (anchorSide !== null && anchorSide !== void 0 && anchorSide.endsWith('right')) {
    return {
      x: -1,
      y: 0
    };
  } else if (anchorSide !== null && anchorSide !== void 0 && anchorSide.endsWith('left')) {
    return {
      x: 1,
      y: 0
    };
  }
  return {
    x: 0,
    y: 0
  };
}
const StyledOverlay = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Overlay__StyledOverlay",
  componentId: "sc-1mkyld6-0"
})(["background-color:", ";box-shadow:", ";position:absolute;min-width:192px;max-width:640px;height:", ";max-height:", ";width:", ";border-radius:12px;overflow:hidden;animation:overlay-appear ", "ms ", ";@keyframes overlay-appear{0%{opacity:0;}100%{opacity:1;}}visibility:var(--styled-overlay-visibility);:focus{outline:none;}@media (forced-colors:active){outline:solid 1px transparent;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.overlay'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.overlay.shadow'), props => heightMap[props.height || 'auto'], props => props.maxHeight && heightMap[props.maxHeight], props => widthMap[props.width || 'auto'], animationDuration, (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('animation.easeOutCubic'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
/**
 * An `Overlay` is a flexible floating surface, used to display transient content such as menus,
 * selection options, dialogs, and more. Overlays use shadows to express elevation. The `Overlay`
 * component handles all behaviors needed by overlay UIs as well as the common styles that all overlays * should have.
 * @param ignoreClickRefs Optional. An array of ref objects to ignore clicks on in the `onOutsideClick` behavior. This is often used to ignore clicking on the element that toggles the open/closed state for the `Overlay` to prevent the `Overlay` from being toggled twice.
 * @param initialFocusRef Optional. Ref for the element to focus when the `Overlay` is opened. If nothing is provided, the first focusable element in the `Overlay` body is focused.
 * @param returnFocusRef Required. Ref for the element to focus when the `Overlay` is closed.
 * @param onClickOutside  Required. Function to call when clicking outside of the `Overlay`. Typically this function removes the Overlay.
 * @param onEscape Required. Function to call when user presses `Escape`. Typically this function removes the Overlay.
 * @param width Sets the width of the `Overlay`, pick from our set list of widths, or pass `auto` to automatically set the width based on the content of the `Overlay`. `small` corresponds to `256px`, `medium` corresponds to `320px`, `large` corresponds to `480px`, `xlarge` corresponds to `640px`, `xxlarge` corresponds to `960px`.
 * @param height Sets the height of the `Overlay`, pick from our set list of heights, or pass `auto` to automatically set the height based on the content of the `Overlay`, or pass `initial` to set the height based on the initial content of the `Overlay` (i.e. ignoring content changes). `xsmall` corresponds to `192px`, `small` corresponds to `256px`, `medium` corresponds to `320px`, `large` corresponds to `432px`, `xlarge` corresponds to `600px`.
 * @param maxHeight Sets the maximum height of the `Overlay`, pick from our set list of heights. `xsmall` corresponds to `192px`, `small` corresponds to `256px`, `medium` corresponds to `320px`, `large` corresponds to `432px`, `xlarge` corresponds to `600px`.
 * @param anchorSide If provided, the Overlay will slide into position from the side of the anchor with a brief animation
 * @param top Optional. Vertical position of the overlay, relative to its closest positioned ancestor (often its `Portal`).
 * @param left Optional. Horizontal position of the overlay, relative to its closest positioned ancestor (often its `Portal`).
 * @param portalContainerName Optional. The name of the portal container to render the Overlay into.
 */
const Overlay = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  onClickOutside,
  role = 'none',
  initialFocusRef,
  returnFocusRef,
  ignoreClickRefs,
  onEscape,
  visibility = 'visible',
  height,
  top,
  left,
  anchorSide,
  portalContainerName,
  preventFocusOnOpen,
  ...rest
}, forwardedRef) => {
  const overlayRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_4__.useRefObjectAsForwardedRef)(forwardedRef, overlayRef);
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_5__.useTheme)();
  const slideAnimationDistance = parseInt((0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2')(theme).replace('px', ''));
  const slideAnimationEasing = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('animation.easeOutCubic')(theme);
  (0,_hooks_useOverlay_js__WEBPACK_IMPORTED_MODULE_6__.useOverlay)({
    overlayRef,
    returnFocusRef,
    onEscape,
    ignoreClickRefs,
    onClickOutside,
    initialFocusRef,
    preventFocusOnOpen
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    var _overlayRef$current;
    if (height === 'initial' && (_overlayRef$current = overlayRef.current) !== null && _overlayRef$current !== void 0 && _overlayRef$current.clientHeight) {
      overlayRef.current.style.height = `${overlayRef.current.clientHeight}px`;
    }
  }, [height]);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_7__["default"])(() => {
    var _overlayRef$current2;
    const {
      x,
      y
    } = getSlideAnimationStartingVector(anchorSide);
    if (!x && !y || !((_overlayRef$current2 = overlayRef.current) !== null && _overlayRef$current2 !== void 0 && _overlayRef$current2.animate) || visibility === 'hidden') {
      return;
    }

    // JS animation is required because Safari does not allow css animations to start paused and then run
    overlayRef.current.animate({
      transform: [`translate(${slideAnimationDistance * x}px, ${slideAnimationDistance * y}px)`, `translate(0, 0)`]
    }, {
      duration: animationDuration,
      easing: slideAnimationEasing
    });
  }, [anchorSide, slideAnimationDistance, slideAnimationEasing, visibility]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Portal_index_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    containerName: portalContainerName
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledOverlay, _extends({
    height: height,
    role: role
  }, rest, {
    ref: overlayRef,
    style: {
      top: `${top || 0}px`,
      left: `${left || 0}px`,
      '--styled-overlay-visibility': visibility
    }
  })));
});
Overlay.defaultProps = {
  height: 'auto',
  width: 'auto'
};
var Overlay$1 = Overlay;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/PageLayout/PageLayout.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/PageLayout/PageLayout.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PageLayout": () => (/* binding */ PageLayout)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useResponsiveValue.js */ "./node_modules/@primer/react/lib-esm/hooks/useResponsiveValue.js");
/* harmony import */ var _utils_create_slots_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/create-slots.js */ "./node_modules/@primer/react/lib-esm/utils/create-slots.js");
/* harmony import */ var _utils_environment_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/environment.js */ "./node_modules/@primer/react/lib-esm/utils/environment.js");
/* harmony import */ var _useStickyPaneHeight_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./useStickyPaneHeight.js */ "./node_modules/@primer/react/lib-esm/PageLayout/useStickyPaneHeight.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);











const {
  Slots,
  Slot
} = (0,_utils_create_slots_js__WEBPACK_IMPORTED_MODULE_3__["default"])(['Header', 'Footer']);
const REGION_ORDER = {
  header: 0,
  paneStart: 1,
  content: 2,
  paneEnd: 3,
  footer: 4
};
const SPACING_MAP = {
  none: 0,
  condensed: 3,
  normal: [3, null, null, 4]
};
const PageLayoutContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({
  padding: 'normal',
  rowGap: 'normal',
  columnGap: 'normal'
});

// ----------------------------------------------------------------------------
// PageLayout

const containerWidths = {
  full: '100%',
  medium: '768px',
  large: '1012px',
  xlarge: '1280px'
};

// TODO: refs
const Root = ({
  containerWidth = 'xlarge',
  padding = 'normal',
  rowGap = 'normal',
  columnGap = 'normal',
  children,
  sx = {}
}) => {
  const {
    rootRef,
    enableStickyPane,
    disableStickyPane,
    contentTopRef,
    contentBottomRef,
    stickyPaneHeight
  } = (0,_useStickyPaneHeight_js__WEBPACK_IMPORTED_MODULE_4__.useStickyPaneHeight)();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PageLayoutContext.Provider, {
    value: {
      padding,
      rowGap,
      columnGap,
      enableStickyPane,
      disableStickyPane,
      contentTopRef,
      contentBottomRef
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    ref: rootRef,
    style: {
      // @ts-ignore TypeScript doesn't know about CSS custom properties
      '--sticky-pane-height': stickyPaneHeight
    },
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      padding: SPACING_MAP[padding]
    }, sx)
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      maxWidth: containerWidths[containerWidth],
      marginX: 'auto',
      display: 'flex',
      flexWrap: 'wrap'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Slots, null, slots => {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, slots.Header, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sx: {
        display: 'flex',
        flex: '1 1 100%',
        flexWrap: 'wrap',
        maxWidth: '100%'
      }
    }, children), slots.Footer);
  }))));
};
Root.displayName = "Root";
Root.displayName = 'PageLayout';

// ----------------------------------------------------------------------------
// Divider (internal)

const horizontalDividerVariants = {
  none: {
    display: 'none'
  },
  line: {
    display: 'block',
    height: 1,
    backgroundColor: 'border.default'
  },
  filled: {
    display: 'block',
    height: 8,
    backgroundColor: 'canvas.inset',
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    boxShadow: theme => `inset 0 -1px 0 0 ${theme.colors.border.default}, inset 0 1px 0 0 ${theme.colors.border.default}`
  }
};
function negateSpacingValue(value) {
  if (Array.isArray(value)) {
    // Not using recursion to avoid deeply nested arrays
    return value.map(v => v === null ? null : -v);
  }
  return value === null ? null : -value;
}
const HorizontalDivider = ({
  variant = 'none',
  sx = {}
}) => {
  const {
    padding
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(PageLayoutContext);
  const responsiveVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(variant, 'none');
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"]
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  , {
    sx: theme => deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      // Stretch divider to viewport edges on narrow screens
      marginX: negateSpacingValue(SPACING_MAP[padding]),
      ...horizontalDividerVariants[responsiveVariant],
      [`@media screen and (min-width: ${theme.breakpoints[1]})`]: {
        marginX: '0 !important'
      }
    }, sx)
  });
};
HorizontalDivider.displayName = "HorizontalDivider";
const verticalDividerVariants = {
  none: {
    display: 'none'
  },
  line: {
    display: 'block',
    width: 1,
    backgroundColor: 'border.default'
  },
  filled: {
    display: 'block',
    width: 8,
    backgroundColor: 'canvas.inset',
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    boxShadow: theme => `inset -1px 0 0 0 ${theme.colors.border.default}, inset 1px 0 0 0 ${theme.colors.border.default}`
  }
};
const DraggingGlobalStyles = (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.createGlobalStyle)(["body[data-page-layout-dragging=\"true\"]{cursor:col-resize;}body[data-page-layout-dragging=\"true\"] *{user-select:none;}"]);
const VerticalDivider = ({
  variant = 'none',
  draggable = false,
  onDragStart,
  onDrag,
  onDragEnd,
  onDoubleClick,
  sx = {}
}) => {
  const [isDragging, setIsDragging] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(false);
  const responsiveVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(variant, 'none');
  const stableOnDrag = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(onDrag);
  const stableOnDragEnd = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(onDragEnd);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    stableOnDrag.current = onDrag;
  }, [onDrag]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    stableOnDragEnd.current = onDragEnd;
  }, [onDragEnd]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    function handleDrag(event) {
      var _stableOnDrag$current;
      (_stableOnDrag$current = stableOnDrag.current) === null || _stableOnDrag$current === void 0 ? void 0 : _stableOnDrag$current.call(stableOnDrag, event.movementX);
      event.preventDefault();
    }
    function handleDragEnd(event) {
      var _stableOnDragEnd$curr;
      setIsDragging(false);
      (_stableOnDragEnd$curr = stableOnDragEnd.current) === null || _stableOnDragEnd$curr === void 0 ? void 0 : _stableOnDragEnd$curr.call(stableOnDragEnd);
      event.preventDefault();
    }

    // TODO: Support touch events
    if (isDragging) {
      window.addEventListener('mousemove', handleDrag);
      window.addEventListener('mouseup', handleDragEnd);
      document.body.setAttribute('data-page-layout-dragging', 'true');
    } else {
      window.removeEventListener('mousemove', handleDrag);
      window.removeEventListener('mouseup', handleDragEnd);
      document.body.removeAttribute('data-page-layout-dragging');
    }
    return () => {
      window.removeEventListener('mousemove', handleDrag);
      window.removeEventListener('mouseup', handleDragEnd);
      document.body.removeAttribute('data-page-layout-dragging');
    };
  }, [isDragging]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      height: '100%',
      position: 'relative',
      ...verticalDividerVariants[responsiveVariant]
    }, sx)
  }, draggable ?
  /*#__PURE__*/
  // Drag handle
  react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      position: 'absolute',
      inset: '0 -2px',
      cursor: 'col-resize',
      bg: isDragging ? 'accent.fg' : 'transparent',
      transitionDelay: '0.1s',
      '&:hover': {
        bg: isDragging ? 'accent.fg' : 'neutral.muted'
      }
    },
    onMouseDown: () => {
      setIsDragging(true);
      onDragStart === null || onDragStart === void 0 ? void 0 : onDragStart();
    },
    onDoubleClick: onDoubleClick
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DraggingGlobalStyles, null)) : null);
};
VerticalDivider.displayName = "VerticalDivider";
const Header = ({
  'aria-label': label,
  'aria-labelledby': labelledBy,
  padding = 'none',
  divider = 'none',
  dividerWhenNarrow = 'inherit',
  hidden = false,
  children,
  sx = {}
}) => {
  // Combine divider and dividerWhenNarrow for backwards compatibility
  const dividerProp = !(0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.isResponsiveValue)(divider) && dividerWhenNarrow !== 'inherit' ? {
    regular: divider,
    narrow: dividerWhenNarrow
  } : divider;
  const dividerVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(dividerProp, 'none');
  const isHidden = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(hidden, false);
  const {
    rowGap
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(PageLayoutContext);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Slot, {
    name: "Header"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "header",
    "aria-label": label,
    "aria-labelledby": labelledBy,
    hidden: isHidden,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      width: '100%',
      marginBottom: SPACING_MAP[rowGap]
    }, sx)
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      padding: SPACING_MAP[padding]
    }
  }, children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(HorizontalDivider, {
    variant: dividerVariant,
    sx: {
      marginTop: SPACING_MAP[rowGap]
    }
  })));
};
Header.displayName = "Header";
Header.displayName = 'PageLayout.Header';

// ----------------------------------------------------------------------------
// PageLayout.Content

// TODO: Account for pane width when centering content
const contentWidths = {
  full: '100%',
  medium: '768px',
  large: '1012px',
  xlarge: '1280px'
};
const Content = ({
  'aria-label': label,
  'aria-labelledby': labelledBy,
  width = 'full',
  padding = 'none',
  hidden = false,
  children,
  sx = {}
}) => {
  const isHidden = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(hidden, false);
  const {
    contentTopRef,
    contentBottomRef
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(PageLayoutContext);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "main",
    "aria-label": label,
    "aria-labelledby": labelledBy,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      display: isHidden ? 'none' : 'flex',
      flexDirection: 'column',
      order: REGION_ORDER.content,
      // Set flex-basis to 0% to allow flex-grow to control the width of the content region.
      // Without this, the content region could wrap onto a different line
      // than the pane region on wide viewports if its contents are too wide.
      flexBasis: 0,
      flexGrow: 1,
      flexShrink: 1,
      minWidth: 1 // Hack to prevent overflowing content from pushing the pane region to the next line
    }, sx)
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    ref: contentTopRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      width: '100%',
      maxWidth: contentWidths[width],
      marginX: 'auto',
      flexGrow: 1,
      padding: SPACING_MAP[padding]
    }
  }, children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    ref: contentBottomRef
  }));
};
Content.displayName = "Content";
Content.displayName = 'PageLayout.Content';

// ----------------------------------------------------------------------------
// PageLayout.Pane

const panePositions = {
  start: REGION_ORDER.paneStart,
  end: REGION_ORDER.paneEnd
};
const paneWidths = {
  small: ['100%', null, '240px', '256px'],
  medium: ['100%', null, '256px', '296px'],
  large: ['100%', null, '256px', '320px', '336px']
};
const defaultPaneWidth = {
  small: 256,
  medium: 296,
  large: 320
};
const Pane = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  position: responsivePosition = 'end',
  positionWhenNarrow = 'inherit',
  width = 'medium',
  padding = 'none',
  resizable = false,
  widthStorageKey = 'paneWidth',
  divider: responsiveDivider = 'none',
  dividerWhenNarrow = 'inherit',
  sticky = false,
  offsetHeader = 0,
  hidden: responsiveHidden = false,
  children,
  sx = {}
}, forwardRef) => {
  // Combine position and positionWhenNarrow for backwards compatibility
  const positionProp = !(0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.isResponsiveValue)(responsivePosition) && positionWhenNarrow !== 'inherit' ? {
    regular: responsivePosition,
    narrow: positionWhenNarrow
  } : responsivePosition;
  const position = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(positionProp, 'end');

  // Combine divider and dividerWhenNarrow for backwards compatibility
  const dividerProp = !(0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.isResponsiveValue)(responsiveDivider) && dividerWhenNarrow !== 'inherit' ? {
    regular: responsiveDivider,
    narrow: dividerWhenNarrow
  } : responsiveDivider;
  const dividerVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(dividerProp, 'none');
  const isHidden = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(responsiveHidden, false);
  const {
    rowGap,
    columnGap,
    enableStickyPane,
    disableStickyPane
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(PageLayoutContext);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    if (sticky) {
      enableStickyPane === null || enableStickyPane === void 0 ? void 0 : enableStickyPane(offsetHeader);
    } else {
      disableStickyPane === null || disableStickyPane === void 0 ? void 0 : disableStickyPane();
    }
  }, [sticky, enableStickyPane, disableStickyPane, offsetHeader]);
  const [paneWidth, setPaneWidth] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(() => {
    if (!_utils_environment_js__WEBPACK_IMPORTED_MODULE_7__.canUseDOM) {
      return defaultPaneWidth[width];
    }
    let storedWidth;
    try {
      storedWidth = localStorage.getItem(widthStorageKey);
    } catch (error) {
      storedWidth = null;
    }
    return storedWidth && !isNaN(Number(storedWidth)) ? Number(storedWidth) : defaultPaneWidth[width];
  });
  const updatePaneWidth = width => {
    setPaneWidth(width);
    try {
      localStorage.setItem(widthStorageKey, width.toString());
    } catch (error) {
      // Ignore errors
    }
  };
  const paneRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_8__.useRefObjectAsForwardedRef)(forwardRef, paneRef);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"]
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  , {
    sx: theme => deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      // Narrow viewports
      display: isHidden ? 'none' : 'flex',
      order: panePositions[position],
      width: '100%',
      marginX: 0,
      ...(position === 'end' ? {
        flexDirection: 'column',
        marginTop: SPACING_MAP[rowGap]
      } : {
        flexDirection: 'column-reverse',
        marginBottom: SPACING_MAP[rowGap]
      }),
      // Regular and wide viewports
      [`@media screen and (min-width: ${theme.breakpoints[1]})`]: {
        width: 'auto',
        marginY: '0 !important',
        ...(sticky ? {
          position: 'sticky',
          // If offsetHeader has value, it will stick the pane to the position where the sticky top ends
          // else top will be 0 as the default value of offsetHeader
          top: typeof offsetHeader === 'number' ? `${offsetHeader}px` : offsetHeader,
          maxHeight: 'var(--sticky-pane-height)'
        } : {}),
        ...(position === 'end' ? {
          flexDirection: 'row',
          marginLeft: SPACING_MAP[columnGap]
        } : {
          flexDirection: 'row-reverse',
          marginRight: SPACING_MAP[columnGap]
        })
      }
    }, sx)
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(HorizontalDivider, {
    variant: {
      narrow: dividerVariant,
      regular: 'none'
    },
    sx: {
      [position === 'end' ? 'marginBottom' : 'marginTop']: SPACING_MAP[rowGap]
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(VerticalDivider, {
    variant: {
      narrow: 'none',
      // If pane is resizable, always show a vertical divider on regular viewports
      regular: resizable ? 'line' : dividerVariant
    }
    // If pane is resizable, the divider should be draggable
    ,
    draggable: resizable,
    sx: {
      [position === 'end' ? 'marginRight' : 'marginLeft']: SPACING_MAP[columnGap]
    },
    onDrag: delta => {
      // Get the number of pixels the divider was dragged
      const deltaWithDirection = position === 'end' ? -delta : delta;
      updatePaneWidth(paneWidth + deltaWithDirection);
    }
    // Ensure `paneWidth` state and actual pane width are in sync when the drag ends
    ,
    onDragEnd: () => {
      var _paneRef$current;
      const paneRect = (_paneRef$current = paneRef.current) === null || _paneRef$current === void 0 ? void 0 : _paneRef$current.getBoundingClientRect();
      if (!paneRect) return;
      updatePaneWidth(paneRect.width);
    }
    // Reset pane width on double click
    ,
    onDoubleClick: () => updatePaneWidth(defaultPaneWidth[width])
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    ref: paneRef,
    style: {
      // @ts-ignore CSS custom properties are not supported by TypeScript
      '--pane-width': `${paneWidth}px`
    },
    sx: theme => ({
      '--pane-min-width': `256px`,
      '--pane-max-width': `calc(100vw - 511px)`,
      width: resizable ? ['100%', null, 'clamp(var(--pane-min-width), var(--pane-width), var(--pane-max-width))'] : paneWidths[width],
      padding: SPACING_MAP[padding],
      [`@media screen and (min-width: ${theme.breakpoints[1]})`]: {
        overflow: 'auto'
      },
      [`@media screen and (min-width: ${theme.breakpoints[3]})`]: {
        '--pane-max-width': 'calc(100vw - 959px)'
      }
    })
  }, children));
});
Pane.displayName = 'PageLayout.Pane';

// ----------------------------------------------------------------------------
// PageLayout.Footer

const Footer = ({
  'aria-label': label,
  'aria-labelledby': labelledBy,
  padding = 'none',
  divider = 'none',
  dividerWhenNarrow = 'inherit',
  hidden = false,
  children,
  sx = {}
}) => {
  // Combine divider and dividerWhenNarrow for backwards compatibility
  const dividerProp = !(0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.isResponsiveValue)(divider) && dividerWhenNarrow !== 'inherit' ? {
    regular: divider,
    narrow: dividerWhenNarrow
  } : divider;
  const dividerVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(dividerProp, 'none');
  const isHidden = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_6__.useResponsiveValue)(hidden, false);
  const {
    rowGap
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(PageLayoutContext);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Slot, {
    name: "Footer"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "footer",
    "aria-label": label,
    "aria-labelledby": labelledBy,
    hidden: isHidden,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
      order: REGION_ORDER.footer,
      width: '100%',
      marginTop: SPACING_MAP[rowGap]
    }, sx)
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(HorizontalDivider, {
    variant: dividerVariant,
    sx: {
      marginBottom: SPACING_MAP[rowGap]
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      padding: SPACING_MAP[padding]
    }
  }, children)));
};
Footer.displayName = "Footer";
Footer.displayName = 'PageLayout.Footer';

// ----------------------------------------------------------------------------
// Export

const PageLayout = Object.assign(Root, {
  Header,
  Content,
  Pane,
  Footer
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/PageLayout/useStickyPaneHeight.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/PageLayout/useStickyPaneHeight.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useStickyPaneHeight": () => (/* binding */ useStickyPaneHeight)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-intersection-observer */ "./node_modules/react-intersection-observer/react-intersection-observer.modern.mjs");
/* harmony import */ var _utils_environment_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/environment.js */ "./node_modules/@primer/react/lib-esm/utils/environment.js");
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/useIsomorphicLayoutEffect.js */ "./node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");
/* harmony import */ var _utils_scroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/scroll.js */ "./node_modules/@primer/react/lib-esm/utils/scroll.js");






/**
 * Calculates the height of the sticky pane such that it always
 * fits into the viewport even when the header or footer are visible.
 */
function useStickyPaneHeight() {
  const rootRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);

  // Default the height to the viewport height
  const [height, setHeight] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(dvh(100));
  const [offsetHeader, setOffsetHeader] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(0);

  // Create intersection observers to track the top and bottom of the content region
  const [contentTopRef, contentTopInView, contentTopEntry] = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_1__.useInView)();
  const [contentBottomRef, contentBottomInView] = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_1__.useInView)();

  // Calculate the height of the sticky pane based on the position of the
  // top and bottom of the content region
  const calculateHeight = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
    // Uncomment to debug
    // console.log('Recalculating pane height...')

    let calculatedHeight = '';
    const scrollContainer = (0,_utils_scroll_js__WEBPACK_IMPORTED_MODULE_2__.getScrollContainer)(rootRef.current);
    const topRect = contentTopEntry === null || contentTopEntry === void 0 ? void 0 : contentTopEntry.target.getBoundingClientRect();

    // Custom sticky header's height with units
    const offsetHeaderWithUnits = typeof offsetHeader === 'number' ? `${offsetHeader}px` : offsetHeader;
    if (scrollContainer) {
      const scrollRect = scrollContainer.getBoundingClientRect();
      const topOffset = topRect ? Math.max(topRect.top - scrollRect.top, 0) : 0;
      calculatedHeight = `calc(${scrollRect.height}px - (max(${topOffset}px, ${offsetHeaderWithUnits})))`;
    } else {
      const topOffset = topRect ? Math.max(topRect.top, 0) : 0;
      calculatedHeight = `calc(${dvh(100)} - (max(${topOffset}px, ${offsetHeaderWithUnits})))`;
    }
    setHeight(calculatedHeight);
  }, [contentTopEntry, offsetHeader]);

  // We only want to add scroll and resize listeners if the pane is sticky.
  // Since hooks can't be called conditionally, we need to use state to track
  // if the pane is sticky.
  const [isEnabled, setIsEnabled] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(false);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(() => {
    const scrollContainer = (0,_utils_scroll_js__WEBPACK_IMPORTED_MODULE_2__.getScrollContainer)(rootRef.current);
    if (isEnabled && (contentTopInView || contentBottomInView)) {
      calculateHeight();

      // Start listeners if the top or the bottom edge of the content region is visible

      if (scrollContainer) {
        // eslint-disable-next-line github/prefer-observers
        scrollContainer.addEventListener('scroll', calculateHeight);
      } else {
        // eslint-disable-next-line github/prefer-observers
        window.addEventListener('scroll', calculateHeight);
      }

      // eslint-disable-next-line github/prefer-observers
      window.addEventListener('resize', calculateHeight);
    }
    return () => {
      // Stop listeners if neither the top nor the bottom edge of the content region is visible

      if (scrollContainer) {
        scrollContainer.removeEventListener('scroll', calculateHeight);
      } else {
        window.removeEventListener('scroll', calculateHeight);
      }
      window.removeEventListener('resize', calculateHeight);
    };
  }, [isEnabled, contentTopInView, contentBottomInView, calculateHeight]);
  function enableStickyPane(top) {
    setIsEnabled(true);
    setOffsetHeader(top);
  }
  function disableStickyPane() {
    setIsEnabled(false);
  }
  return {
    rootRef,
    enableStickyPane,
    disableStickyPane,
    contentTopRef,
    contentBottomRef,
    stickyPaneHeight: height
  };
}

// TODO: there is currently an issue with dvh on Desktop Safari 15.6, 16.0. To
// work around it, we check to see if the device supports touch along with the
// dvh unit in order to target iPad. When the bug is addressed this check will
// no longer be needed
//
// @see https://bugs.webkit.org/show_bug.cgi?id=242758
const supportsTouchCallout = _utils_environment_js__WEBPACK_IMPORTED_MODULE_4__.canUseDOM ? CSS.supports('-webkit-touch-callout', 'none') : false;
const supportsDVH = _utils_environment_js__WEBPACK_IMPORTED_MODULE_4__.canUseDOM ? CSS.supports('max-height', '100dvh') && supportsTouchCallout : false;

/**
 * Convert the given value to a dvh value, if supported, otherwise it falls back
 * to vh
 */
function dvh(value) {
  if (supportsDVH) {
    return `${value}dvh`;
  }
  return `${value}vh`;
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Pagehead.js":
/*!********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Pagehead.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Pagehead$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");




const Pagehead = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Pagehead",
  componentId: "sc-17d52hr-0"
})(["position:relative;padding-top:", ";padding-bottom:", ";margin-bottom:", ";border-bottom:1px solid ", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.4'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.4'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('space.4'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.border.default'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var Pagehead$1 = Pagehead;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Pagination/Pagination.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Pagination/Pagination.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Pagination)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../_getGlobalFocusStyles.js */ "./node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model.js */ "./node_modules/@primer/react/lib-esm/Pagination/model.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Page = styled_components__WEBPACK_IMPORTED_MODULE_1___default().a.withConfig({
  displayName: "Pagination__Page",
  componentId: "sc-cp45c9-0"
})(["display:inline-block;min-width:32px;padding:5px 10px;font-style:normal;line-height:20px;color:", ";text-align:center;white-space:nowrap;vertical-align:middle;cursor:pointer;user-select:none;text-decoration:none;margin-right:", ";&:last-child{margin-right:0;}border:", " solid transparent;border-radius:", ";transition:border-color 0.2s cubic-bezier(0.3,0,0.5,1);&:hover,&:focus{text-decoration:none;border-color:", ";outline:0;transition-duration:0.1s;}", ";&:active{border-color:", ";}&[rel='prev'],&[rel='next']{color:", ";}&[aria-current],&[aria-current]:hover{color:", ";background-color:", ";border-color:transparent;}&[aria-disabled],&[aria-disabled]:hover{color:", ";cursor:default;border-color:transparent;}@supports (clip-path:polygon(50% 0,100% 50%,50% 100%)){&[rel='prev']::before,&[rel='next']::after{display:inline-block;width:16px;height:16px;vertical-align:text-bottom;content:'';background-color:currentColor;}&[rel='prev']::before{margin-right:", ";clip-path:polygon( 9.8px 12.8px,8.7px 12.8px,4.5px 8.5px,4.5px 7.5px,8.7px 3.2px,9.8px 4.3px,6.1px 8px,9.8px 11.7px,9.8px 12.8px );}&[rel='next']::after{margin-left:", ";clip-path:polygon( 6.2px 3.2px,7.3px 3.2px,11.5px 7.5px,11.5px 8.5px,7.3px 12.8px,6.2px 11.7px,9.9px 8px,6.2px 4.3px,6.2px 3.2px );}}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('borderWidths.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.default'), (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"])(0), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.onEmphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.emphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.primer.fg.disabled'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.1'));
function usePaginationPages({
  theme,
  pageCount,
  currentPage,
  onPageChange,
  hrefBuilder,
  marginPageCount,
  showPages,
  surroundingPageCount
}) {
  const pageChange = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(n => e => onPageChange(e, n), [onPageChange]);
  const model = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => {
    return (0,_model_js__WEBPACK_IMPORTED_MODULE_4__.buildPaginationModel)(pageCount, currentPage, !!showPages, marginPageCount, surroundingPageCount);
  }, [pageCount, currentPage, showPages, marginPageCount, surroundingPageCount]);
  const children = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => {
    return model.map(page => {
      const {
        props,
        key,
        content
      } = (0,_model_js__WEBPACK_IMPORTED_MODULE_4__.buildComponentData)(page, hrefBuilder, pageChange(page.num));
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Page, _extends({}, props, {
        key: key,
        theme: theme
      }), content);
    });
  }, [model, hrefBuilder, pageChange, theme]);
  return children;
}
const PaginationContainer = styled_components__WEBPACK_IMPORTED_MODULE_1___default().nav.withConfig({
  displayName: "Pagination__PaginationContainer",
  componentId: "sc-cp45c9-1"
})(["margin-top:20px;margin-bottom:15px;text-align:center;", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
function Pagination({
  theme,
  pageCount,
  currentPage,
  onPageChange = noop,
  hrefBuilder = defaultHrefBuilder,
  marginPageCount = 1,
  showPages = true,
  surroundingPageCount = 2,
  ...rest
}) {
  const pageElements = usePaginationPages({
    theme,
    pageCount,
    currentPage,
    onPageChange,
    hrefBuilder,
    marginPageCount,
    showPages,
    surroundingPageCount
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PaginationContainer, _extends({
    "aria-label": "Pagination"
  }, rest, {
    theme: theme
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    display: "inline-block",
    theme: theme
  }, pageElements));
}
Pagination.displayName = "Pagination";
function defaultHrefBuilder(pageNum) {
  return `#${pageNum}`;
}
function noop() {}
Pagination.defaultProps = {
  hrefBuilder: defaultHrefBuilder,
  marginPageCount: 1,
  onPageChange: noop,
  showPages: true,
  surroundingPageCount: 2
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Pagination/model.js":
/*!****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Pagination/model.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "buildComponentData": () => (/* binding */ buildComponentData),
/* harmony export */   "buildPaginationModel": () => (/* binding */ buildPaginationModel)
/* harmony export */ });
function buildPaginationModel(pageCount, currentPage, showPages, marginPageCount, surroundingPageCount) {
  const pages = [];
  if (showPages) {
    const pageNums = [];
    const addPage = n => {
      if (n >= 1 && n <= pageCount) {
        pageNums.push(n);
      }
    };

    // Start by defining the window of pages to show around the current page.
    // If the window goes off either edge, shift it until it fits.
    let extentLeft = currentPage - surroundingPageCount;
    let extentRight = currentPage + surroundingPageCount;
    if (extentLeft < 1 && extentRight > pageCount) {
      // Our window is larger than the entire range,
      // so simply display every page.
      extentLeft = 1;
      extentRight = pageCount;
    } else if (extentLeft < 1) {
      while (extentLeft < 1) {
        extentLeft++;
        extentRight++;
      }
    } else if (extentRight > pageCount) {
      while (extentRight > pageCount) {
        extentLeft--;
        extentRight--;
      }
    }

    // Next, include the pages in the margins.
    // If a margin page is already covered in the window,
    // extend the window to the other direction.
    for (let i = 1; i <= marginPageCount; i++) {
      const leftPage = i;
      const rightPage = pageCount - (i - 1);
      if (leftPage >= extentLeft) {
        extentRight++;
      } else {
        addPage(leftPage);
      }
      if (rightPage <= extentRight) {
        extentLeft--;
      } else {
        addPage(rightPage);
      }
    }
    for (let i = extentLeft; i <= extentRight; i++) {
      addPage(i);
    }
    const sorted = pageNums.slice().sort((a, b) => a - b).filter((item, idx, ary) => !idx || item !== ary[idx - 1]);
    for (let idx = 0; idx < sorted.length; idx++) {
      const num = sorted[idx];
      const selected = num === currentPage;
      if (idx === 0) {
        if (num !== 1) {
          // If the first page isn't page one,
          // we need to add a break
          pages.push({
            type: 'BREAK',
            num: 1
          });
        }
        pages.push({
          type: 'NUM',
          num,
          selected
        });
      } else {
        const last = sorted[idx - 1];
        const delta = num - last;
        if (delta === 1) {
          pages.push({
            type: 'NUM',
            num,
            selected
          });
        } else {
          // We skipped some, so add a break
          pages.push({
            type: 'BREAK',
            num: num - 1
          });
          pages.push({
            type: 'NUM',
            num,
            selected
          });
        }
      }
    }
    const lastPage = pages[pages.length - 1];
    if (lastPage.type === 'NUM' && lastPage.num !== pageCount) {
      // The last page we rendered wasn't the actual last page,
      // so we need an additional break
      pages.push({
        type: 'BREAK',
        num: pageCount
      });
    }
  }
  const prev = {
    type: 'PREV',
    num: currentPage - 1,
    disabled: currentPage === 1
  };
  const next = {
    type: 'NEXT',
    num: currentPage + 1,
    disabled: currentPage === pageCount
  };
  return [prev, ...pages, next];
}
function buildComponentData(page, hrefBuilder, onClick) {
  const props = {};
  let content = '';
  let key = '';
  switch (page.type) {
    case 'PREV':
      {
        key = 'page-prev';
        content = 'Previous';
        if (page.disabled) {
          Object.assign(props, {
            as: 'span',
            'aria-disabled': 'true'
          });
        } else {
          Object.assign(props, {
            rel: 'prev',
            href: hrefBuilder(page.num),
            'aria-label': 'Previous Page',
            onClick
          });
        }
        break;
      }
    case 'NEXT':
      {
        key = 'page-next';
        content = 'Next';
        if (page.disabled) {
          Object.assign(props, {
            as: 'span',
            'aria-disabled': 'true'
          });
        } else {
          Object.assign(props, {
            rel: 'next',
            href: hrefBuilder(page.num),
            'aria-label': 'Next Page',
            onClick
          });
        }
        break;
      }
    case 'NUM':
      {
        key = `page-${page.num}`;
        content = String(page.num);
        if (page.selected) {
          Object.assign(props, {
            as: 'em',
            'aria-current': 'page'
          });
        } else {
          Object.assign(props, {
            href: hrefBuilder(page.num),
            'aria-label': `Page ${page.num}`,
            onClick
          });
        }
        break;
      }
    case 'BREAK':
      {
        key = `page-${page.num}-break`;
        content = '…';
        Object.assign(props, {
          as: 'span',
          'aria-disabled': true
        });
      }
  }
  return {
    props,
    key,
    content
  };
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/PointerBox.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/PointerBox.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PointerBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Caret_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Caret.js */ "./node_modules/@primer/react/lib-esm/Caret.js");




function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function PointerBox(props) {
  // don't destructure these, just grab them
  const {
    bg,
    border,
    borderColor,
    theme,
    sx
  } = props;
  const {
    caret,
    children,
    ...boxProps
  } = props;
  const caretProps = {
    bg: bg || (sx === null || sx === void 0 ? void 0 : sx.bg) || (sx === null || sx === void 0 ? void 0 : sx.backgroundColor),
    borderColor: borderColor || (sx === null || sx === void 0 ? void 0 : sx.borderColor),
    borderWidth: border,
    location: caret,
    theme
  };
  const defaultBoxProps = {
    borderWidth: '1px',
    borderStyle: 'solid',
    borderColor: 'border.default',
    borderRadius: 2
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({}, defaultBoxProps, boxProps, {
    sx: {
      ...sx,
      position: 'relative'
    }
  }), children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Caret_js__WEBPACK_IMPORTED_MODULE_2__["default"], caretProps));
}
PointerBox.displayName = "PointerBox";




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Popover.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Popover.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Popover$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





const Popover = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.attrs(({
  className,
  caret
}) => {
  return {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, `caret-pos--${caret}`)
  };
}).withConfig({
  displayName: "Popover",
  componentId: "sc-7jji3e-0"
})(["position:", ";z-index:100;display:", ";", ";"], props => props.relative ? 'relative' : 'absolute', props => props.open ? 'block' : 'none', _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
const PopoverContent = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Popover__PopoverContent",
  componentId: "sc-7jji3e-1"
})(["border:1px solid ", ";border-radius:", ";position:relative;width:232px;margin-right:auto;margin-left:auto;padding:", ";background-color:", ";&::before,&::after{position:absolute;left:50%;display:inline-block;content:'';}&::before{top:-", ";margin-left:-9px;border:", " solid transparent;border-bottom-color:", ";}&::after{top:-14px;margin-left:-", ";border:7px solid transparent;border-bottom-color:", ";}", ".caret-pos--bottom &,", ".caret-pos--bottom-right &,", ".caret-pos--bottom-left &{&::before,&::after{top:auto;border-bottom-color:transparent;}&::before{bottom:-", ";border-top-color:", ";}&::after{bottom:-14px;border-top-color:", ";}}", ".caret-pos--top-right &,", ".caret-pos--bottom-right &{right:-9px;margin-right:0;&::before,&::after{left:auto;margin-left:0;}&::before{right:20px;}&::after{right:21px;}}", ".caret-pos--top-left &,", ".caret-pos--bottom-left &{left:-9px;margin-left:0;&::before,&::after{left:", ";margin-left:0;}&::after{left:calc(", " + 1px);}}", ".caret-pos--right &,", ".caret-pos--right-top &,", ".caret-pos--right-bottom &,", ".caret-pos--left &,", ".caret-pos--left-top &,", ".caret-pos--left-bottom &{&::before,&::after{top:50%;left:auto;margin-left:0;border-bottom-color:transparent;}&::before{margin-top:calc((", " + 1px) * -1);}&::after{margin-top:-", ";}}", ".caret-pos--right &,", ".caret-pos--right-top &,", ".caret-pos--right-bottom &{&::before{right:-", ";border-left-color:", ";}&::after{right:-14px;border-left-color:", ";}}", ".caret-pos--left &,", ".caret-pos--left-top &,", ".caret-pos--left-bottom &{&::before{left:-", ";border-right-color:", ";}&::after{left:-14px;border-right-color:", ";}}", ".caret-pos--right-top &,", ".caret-pos--left-top &{&::before,&::after{top:", ";}}", ".caret-pos--right-bottom &,", ".caret-pos--left-bottom &{&::before,&::after{top:auto;}&::before{bottom:", ";}&::after{bottom:calc(", " + 1px);}}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.4'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), Popover, Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), Popover, Popover, Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.4'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.4'), Popover, Popover, Popover, Popover, Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), Popover, Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), Popover, Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.4'), Popover, Popover, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
Popover.defaultProps = {
  caret: 'top'
};
PopoverContent.displayName = 'Popover.Content';
var Popover$1 = Object.assign(Popover, {
  Content: PopoverContent
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/ProgressBar.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/ProgressBar.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");






const Bar = styled_components__WEBPACK_IMPORTED_MODULE_1___default().span.withConfig({
  displayName: "ProgressBar__Bar",
  componentId: "sc-bfftmc-0"
})(["width:", ";", ";"], props => props.progress ? `${props.progress}%` : 0, _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const sizeMap = {
  small: '5px',
  large: '10px',
  default: '8px'
};
const ProgressContainer = styled_components__WEBPACK_IMPORTED_MODULE_1___default().span.withConfig({
  displayName: "ProgressBar__ProgressContainer",
  componentId: "sc-bfftmc-1"
})(["display:", ";overflow:hidden;background-color:", ";border-radius:", ";height:", ";", " ", ";"], props => props.inline ? 'inline-flex' : 'flex', (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.1'), props => sizeMap[props.barSize || 'default'], styled_system__WEBPACK_IMPORTED_MODULE_2__.width, _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
function ProgressBar({
  progress,
  bg,
  ...rest
}) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ProgressContainer, rest, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Bar, {
    progress: progress,
    sx: {
      bg
    }
  }));
}
ProgressBar.displayName = "ProgressBar";
ProgressBar.defaultProps = {
  bg: 'success.emphasis',
  barSize: 'default'
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Radio.js":
/*!*****************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Radio.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Radio$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _RadioGroup_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./RadioGroup.js */ "./node_modules/@primer/react/lib-esm/RadioGroup.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getGlobalFocusStyles.js */ "./node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StyledRadio = styled_components__WEBPACK_IMPORTED_MODULE_0___default().input.withConfig({
  displayName: "Radio__StyledRadio",
  componentId: "sc-1o8nmd2-0"
})(["cursor:pointer;", " ", ";", ""], props => props.disabled && `cursor: not-allowed;`, (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(0), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);

/**
 * An accessible, native radio component for selecting one option from a list.
 */
const Radio = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  checked,
  disabled,
  name: nameProp,
  onChange,
  sx: sxProp,
  required,
  validationStatus,
  value,
  ...rest
}, ref) => {
  const radioGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_RadioGroup_js__WEBPACK_IMPORTED_MODULE_4__.RadioGroupContext);
  const handleOnChange = e => {
    (radioGroupContext === null || radioGroupContext === void 0 ? void 0 : radioGroupContext.onChange) && radioGroupContext.onChange(e);
    onChange && onChange(e);
  };
  const name = nameProp || (radioGroupContext === null || radioGroupContext === void 0 ? void 0 : radioGroupContext.name);
  if (!name) {
    // eslint-disable-next-line no-console
    console.warn('A radio input must have a `name` attribute. Pass `name` as a prop directly to each Radio, or nest them in a `RadioGroup` component with a `name` prop');
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledRadio, _extends({
    type: "radio",
    value: value,
    name: name,
    ref: ref,
    disabled: disabled,
    "aria-disabled": disabled ? 'true' : 'false',
    checked: checked,
    "aria-checked": checked ? 'true' : 'false',
    required: required,
    "aria-required": required ? 'true' : 'false',
    "aria-invalid": validationStatus === 'error' ? 'true' : 'false',
    sx: sxProp,
    onChange: handleOnChange
  }, rest));
});
Radio.displayName = 'Radio';
var Radio$1 = Radio;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/RadioGroup.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/RadioGroup.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RadioGroupContext": () => (/* binding */ RadioGroupContext),
/* harmony export */   "default": () => (/* binding */ RadioGroup$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js");
/* harmony import */ var _hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hooks/useRenderForcingRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRenderForcingRef.js");
/* harmony import */ var _CheckboxOrRadioGroup_CheckboxOrRadioGroup_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js");







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const RadioGroupContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
const RadioGroup = ({
  children,
  disabled,
  onChange,
  name,
  ...rest
}) => {
  const [selectedRadioValue, setSelectedRadioValue] = (0,_hooks_useRenderForcingRef_js__WEBPACK_IMPORTED_MODULE_1__.useRenderForcingRef)(null);
  const updateSelectedCheckboxes = e => {
    const {
      value,
      checked
    } = e.currentTarget;
    if (checked) {
      setSelectedRadioValue(value);
      return;
    }
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(RadioGroupContext.Provider, {
    value: {
      disabled,
      name,
      onChange: e => {
        if (onChange) {
          updateSelectedCheckboxes(e);
          onChange(selectedRadioValue.current, e);
        }
      }
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CheckboxOrRadioGroup_CheckboxOrRadioGroup_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    disabled: disabled
  }, rest), children));
};
RadioGroup.displayName = "RadioGroup";
var RadioGroup$1 = Object.assign(RadioGroup, {
  Caption: _CheckboxOrRadioGroup_CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  Label: _CheckboxOrRadioGroup_CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  Validation: _CheckboxOrRadioGroup_CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_5__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControl.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControl.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SegmentedControl": () => (/* binding */ SegmentedControl)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SegmentedControlButton_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SegmentedControlButton.js */ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlButton.js");
/* harmony import */ var _SegmentedControlIconButton_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SegmentedControlIconButton.js */ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlIconButton.js");
/* harmony import */ var _ActionList_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ActionList/index.js */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _ActionMenu_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../ActionMenu.js */ "./node_modules/@primer/react/lib-esm/ActionMenu.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../hooks/useResponsiveValue.js */ "./node_modules/@primer/react/lib-esm/hooks/useResponsiveValue.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);











function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
// Needed because passing a ref to `Box` causes a type error
const SegmentedControlList = styled_components__WEBPACK_IMPORTED_MODULE_1___default().ul.withConfig({
  displayName: "SegmentedControl__SegmentedControlList",
  componentId: "sc-1rzig82-0"
})(["", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const getSegmentedControlStyles = props => ({
  backgroundColor: 'segmentedControl.bg',
  borderColor: 'border.default',
  borderRadius: 2,
  borderStyle: 'solid',
  borderWidth: 1,
  display: props.isFullWidth ? 'flex' : 'inline-flex',
  fontSize: props.size === 'small' ? 0 : 1,
  height: props.size === 'small' ? '28px' : '32px',
  // TODO: use primitive `control.{small|medium}.size` when it is available
  margin: 0,
  padding: 0,
  width: props.isFullWidth ? '100%' : undefined
});
const Root = ({
  'aria-label': ariaLabel,
  'aria-labelledby': ariaLabelledby,
  children,
  fullWidth,
  onChange,
  size,
  sx: sxProp = {},
  variant,
  ...rest
}) => {
  const segmentedControlContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__.useTheme)();
  const isUncontrolled = onChange === undefined || react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).some(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.props.defaultSelected !== undefined);
  const responsiveVariant = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_5__.useResponsiveValue)(variant, 'default');
  const isFullWidth = (0,_hooks_useResponsiveValue_js__WEBPACK_IMPORTED_MODULE_5__.useResponsiveValue)(fullWidth, false);
  const selectedSegments = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).map(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.props.selected);
  const hasSelectedButton = selectedSegments.some(isSelected => isSelected);
  const selectedIndexExternal = hasSelectedButton ? selectedSegments.indexOf(true) : 0;
  const [selectedIndexInternalState, setSelectedIndexInternalState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(selectedIndexExternal);
  const selectedIndex = isUncontrolled ? selectedIndexInternalState : selectedIndexExternal;
  const selectedChild = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children)[selectedIndex]) ? react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children)[selectedIndex] : undefined;
  const getChildIcon = childArg => {
    if ( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(childArg) && childArg.type === _SegmentedControlButton_js__WEBPACK_IMPORTED_MODULE_6__["default"] && childArg.props.leadingIcon) {
      return childArg.props.leadingIcon;
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(childArg) ? childArg.props.icon : null;
  };
  const getChildText = childArg => {
    if ( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(childArg) && childArg.type === _SegmentedControlButton_js__WEBPACK_IMPORTED_MODULE_6__["default"]) {
      return childArg.props.children;
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(childArg) ? childArg.props['aria-label'] : null;
  };
  const listSx = deepmerge__WEBPACK_IMPORTED_MODULE_2___default()(getSegmentedControlStyles({
    isFullWidth,
    size
  }), sxProp);
  if (!ariaLabel && !ariaLabelledby) {
    // eslint-disable-next-line no-console
    console.warn('Use the `aria-label` or `aria-labelledby` prop to provide an accessible label for assistive technology');
  }
  return responsiveVariant === 'dropdown' ?
  /*#__PURE__*/
  // Render the 'dropdown' variant of the SegmentedControlButton or SegmentedControlIconButton
  react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionMenu_js__WEBPACK_IMPORTED_MODULE_7__.ActionMenu, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionMenu_js__WEBPACK_IMPORTED_MODULE_7__.ActionMenu.Button, {
    leadingIcon: getChildIcon(selectedChild)
  }, getChildText(selectedChild)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionMenu_js__WEBPACK_IMPORTED_MODULE_7__.ActionMenu.Overlay, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_8__.ActionList, {
    selectionVariant: "single"
  }, react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, (child, index) => {
    const ChildIcon = getChildIcon(child);
    // Not a valid child element - skip rendering
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child)) {
      return null;
    }
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_8__.ActionList.Item, {
      key: `segmented-control-action-btn-${index}`,
      selected: index === selectedIndex,
      onSelect: event => {
        isUncontrolled && setSelectedIndexInternalState(index);
        onChange && onChange(index);
        child.props.onClick && child.props.onClick(event);
      }
    }, ChildIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ChildIcon, null), " ", getChildText(child));
  })))) :
  /*#__PURE__*/
  // Render a segmented control
  react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SegmentedControlList, _extends({
    sx: listSx,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby,
    ref: segmentedControlContainerRef
  }, rest), react__WEBPACK_IMPORTED_MODULE_0___default().Children.map(children, (child, index) => {
    // Not a valid child element - skip rendering child
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child)) {
      return null;
    }
    const sharedChildProps = {
      onClick: onChange ? event => {
        onChange(index);
        isUncontrolled && setSelectedIndexInternalState(index);
        child.props.onClick && child.props.onClick(event);
      } : event => {
        child.props.onClick && child.props.onClick(event);
        isUncontrolled && setSelectedIndexInternalState(index);
      },
      selected: index === selectedIndex,
      sx: {
        '--separator-color': index === selectedIndex || index === selectedIndex - 1 ? 'transparent' : theme === null || theme === void 0 ? void 0 : theme.colors.border.default,
        ...child.props.sx
      }
    };

    // Render the 'hideLabels' variant of the SegmentedControlButton
    if (responsiveVariant === 'hideLabels' && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _SegmentedControlButton_js__WEBPACK_IMPORTED_MODULE_6__["default"]) {
      const {
        'aria-label': childAriaLabel,
        leadingIcon,
        children: childPropsChildren,
        ...restChildProps
      } = child.props;
      const {
        sx: sharedSxProp,
        ...restSharedChildProps
      } = sharedChildProps;
      if (!leadingIcon) {
        // eslint-disable-next-line no-console
        console.warn('A `leadingIcon` prop is required when hiding visible labels');
      } else {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SegmentedControlIconButton_js__WEBPACK_IMPORTED_MODULE_9__["default"], _extends({
          "aria-label": childAriaLabel || childPropsChildren,
          icon: leadingIcon,
          sx: {
            ...sharedSxProp,
            // setting width here avoids having to pass `isFullWidth` directly to child components
            width: !isFullWidth ? '32px' : '100%' // TODO: use primitive `control.medium.size` when it is available instead of '32px'
          }
        }, restSharedChildProps, restChildProps));
      }
    }

    // Render the children as-is and add the shared child props
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, sharedChildProps);
  }));
};
Root.displayName = 'SegmentedControl';
Root.defaultProps = {
  variant: 'default'
};
const SegmentedControl = Object.assign(Root, {
  Button: _SegmentedControlButton_js__WEBPACK_IMPORTED_MODULE_6__["default"],
  IconButton: _SegmentedControlIconButton_js__WEBPACK_IMPORTED_MODULE_9__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlButton.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlButton.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getSegmentedControlStyles.js */ "./node_modules/@primer/react/lib-esm/SegmentedControl/getSegmentedControlStyles.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SegmentedControlButtonStyled = styled_components__WEBPACK_IMPORTED_MODULE_1___default().button.withConfig({
  displayName: "SegmentedControlButton__SegmentedControlButtonStyled",
  componentId: "sc-8lkgxl-0"
})(["", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const SegmentedControlButton = ({
  children,
  leadingIcon: LeadingIcon,
  selected,
  sx: sxProp = {},
  ...rest
}) => {
  const mergedSx = deepmerge__WEBPACK_IMPORTED_MODULE_2___default()((0,_getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__.getSegmentedControlListItemStyles)(), sxProp);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "li",
    sx: mergedSx
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SegmentedControlButtonStyled, _extends({
    "aria-current": selected,
    sx: (0,_getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__.getSegmentedControlButtonStyles)({
      selected,
      children
    })
  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "segmentedControl-content"
  }, LeadingIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    mr: 1
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingIcon, null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "segmentedControl-text"
  }, children))));
};
SegmentedControlButton.displayName = "SegmentedControlButton";
var Button = SegmentedControlButton;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlIconButton.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControlIconButton.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SegmentedControlIconButton": () => (/* binding */ SegmentedControlIconButton),
/* harmony export */   "default": () => (/* binding */ SegmentedControlIconButton$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getSegmentedControlStyles.js */ "./node_modules/@primer/react/lib-esm/SegmentedControl/getSegmentedControlStyles.js");
/* harmony import */ var _Tooltip_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Tooltip.js */ "./node_modules/@primer/react/lib-esm/Tooltip.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SegmentedControlIconButtonStyled = styled_components__WEBPACK_IMPORTED_MODULE_1___default().button.withConfig({
  displayName: "SegmentedControlIconButton__SegmentedControlIconButtonStyled",
  componentId: "sc-oxh6a9-0"
})(["", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);

// TODO: update this component to be accessible when we update the Tooltip component
// - we wouldn't render tooltip content inside a pseudoelement
// - users can pass custom tooltip text in addition to `ariaLabel`
//
// See Slack thread: https://github.slack.com/archives/C02NUUQ9C30/p1656444474509599
//
const SegmentedControlIconButton = ({
  'aria-label': ariaLabel,
  icon: Icon,
  selected,
  sx: sxProp = {},
  ...rest
}) => {
  const mergedSx = deepmerge__WEBPACK_IMPORTED_MODULE_2___default()({
    width: '32px',
    // TODO: use primitive `control.medium.size` when it is available
    ...(0,_getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__.getSegmentedControlListItemStyles)()
  }, sxProp);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "li",
    sx: mergedSx
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    text: ariaLabel
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SegmentedControlIconButtonStyled, _extends({
    "aria-pressed": selected,
    sx: (0,_getSegmentedControlStyles_js__WEBPACK_IMPORTED_MODULE_4__.getSegmentedControlButtonStyles)({
      selected,
      isIconOnly: true
    })
  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "segmentedControl-content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null)))));
};
SegmentedControlIconButton.displayName = "SegmentedControlIconButton";
var SegmentedControlIconButton$1 = SegmentedControlIconButton;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SegmentedControl/getSegmentedControlStyles.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SegmentedControl/getSegmentedControlStyles.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "borderedSegment": () => (/* binding */ borderedSegment),
/* harmony export */   "directChildLayoutAdjustments": () => (/* binding */ directChildLayoutAdjustments),
/* harmony export */   "getSegmentedControlButtonStyles": () => (/* binding */ getSegmentedControlButtonStyles),
/* harmony export */   "getSegmentedControlListItemStyles": () => (/* binding */ getSegmentedControlListItemStyles)
/* harmony export */ });
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");


const directChildLayoutAdjustments = {
  ':first-child': {
    marginLeft: '-1px'
  },
  ':last-child': {
    marginRight: '-1px'
  }
};
const borderedSegment = {
  marginRight: '1px',
  ':after': {
    backgroundColor: 'var(--separator-color)',
    content: '""',
    position: 'absolute',
    right: '-2px',
    top: 2,
    bottom: 2,
    width: '1px'
  }
};
const getSegmentedControlButtonStyles = props => ({
  '--segmented-control-button-inner-padding': '12px',
  // TODO: use primitive `primer.control.medium.paddingInline.normal` when it is available
  '--segmented-control-button-bg-inset': '4px',
  '--segmented-control-outer-radius': (0,_constants_js__WEBPACK_IMPORTED_MODULE_0__.get)('radii.2')(props),
  backgroundColor: 'transparent',
  borderColor: 'transparent',
  borderRadius: 'var(--segmented-control-outer-radius)',
  borderWidth: 0,
  color: 'currentColor',
  cursor: 'pointer',
  fontFamily: 'inherit',
  fontSize: 'inherit',
  fontWeight: props !== null && props !== void 0 && props.selected ? 'bold' : 'normal',
  padding: props !== null && props !== void 0 && props.selected ? 0 : 'var(--segmented-control-button-bg-inset)',
  height: '100%',
  width: '100%',
  '.segmentedControl-content': {
    alignItems: 'center',
    backgroundColor: props !== null && props !== void 0 && props.selected ? 'btn.bg' : 'transparent',
    borderColor: props !== null && props !== void 0 && props.selected ? 'segmentedControl.button.selected.border' : 'transparent',
    borderStyle: 'solid',
    borderWidth: 1,
    borderRadius: props !== null && props !== void 0 && props.selected ? 'var(--segmented-control-outer-radius)' :
    // innerRadius = outerRadius - distance/2
    // https://stackoverflow.com/questions/2932146/math-problem-determine-the-corner-radius-of-an-inner-border-based-on-outer-corn
    'calc(var(--segmented-control-outer-radius) - var(--segmented-control-button-bg-inset) / 2)',
    display: 'flex',
    height: '100%',
    justifyContent: 'center',
    paddingLeft: props !== null && props !== void 0 && props.selected ? 'var(--segmented-control-button-inner-padding)' : 'calc(var(--segmented-control-button-inner-padding) - var(--segmented-control-button-bg-inset))',
    paddingRight: props !== null && props !== void 0 && props.selected ? 'var(--segmented-control-button-inner-padding)' : 'calc(var(--segmented-control-button-inner-padding) - var(--segmented-control-button-bg-inset))'
  },
  svg: {
    fill: 'fg.muted'
  },
  ':hover .segmentedControl-content': {
    backgroundColor: props !== null && props !== void 0 && props.selected ? undefined : 'segmentedControl.button.hover.bg'
  },
  ':active .segmentedControl-content': {
    backgroundColor: props !== null && props !== void 0 && props.selected ? undefined : 'segmentedControl.button.active.bg'
  },
  // fixes an issue where the focus outline shows over the pseudo-element
  ':focus:focus-visible:not(:last-child):after': {
    width: 0
  },
  '.segmentedControl-text': {
    ':after': {
      content: `"${props === null || props === void 0 ? void 0 : props.children}"`,
      display: 'block',
      fontWeight: 'bold',
      height: 0,
      overflow: 'hidden',
      pointerEvents: 'none',
      userSelect: 'none',
      visibility: 'hidden'
    }
  },
  '@media (pointer: coarse)': {
    ':before': {
      content: '""',
      position: 'absolute',
      left: 0,
      right: 0,
      transform: 'translateY(-50%)',
      top: '50%',
      minHeight: '44px'
    }
  }
});
const getSegmentedControlListItemStyles = () => ({
  display: 'block',
  position: 'relative',
  flexGrow: 1,
  marginTop: '-1px',
  marginBottom: '-1px',
  ':not(:last-child)': borderedSegment,
  ...directChildLayoutAdjustments
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Select.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Select.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Select$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_TextInputWrapper.js */ "./node_modules/@primer/react/lib-esm/_TextInputWrapper.js");




function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const arrowRightOffset = '4px';
const StyledSelect = styled_components__WEBPACK_IMPORTED_MODULE_1___default().select.withConfig({
  displayName: "Select__StyledSelect",
  componentId: "sc-li6bhs-0"
})(["appearance:none;border-radius:inherit;border:0;color:currentColor;font-size:inherit;outline:none;width:100%;background-color:inherit;margin-top:1px;margin-left:1px;margin-bottom:1px;&:disabled{background-color:transparent;}@media screen and (forced-colors:active){&:disabled{background-color:-moz-combobox;}}"]);
const ArrowIndicatorSVG = ({
  className
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
  width: "16",
  height: "16",
  fill: "currentColor",
  xmlns: "http://www.w3.org/2000/svg",
  className: className
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
  d: "m4.074 9.427 3.396 3.396a.25.25 0 0 0 .354 0l3.396-3.396A.25.25 0 0 0 11.043 9H4.251a.25.25 0 0 0-.177.427ZM4.074 7.47 7.47 4.073a.25.25 0 0 1 .354 0L11.22 7.47a.25.25 0 0 1-.177.426H4.251a.25.25 0 0 1-.177-.426Z"
}));
ArrowIndicatorSVG.displayName = "ArrowIndicatorSVG";
const ArrowIndicator = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(ArrowIndicatorSVG).withConfig({
  displayName: "Select__ArrowIndicator",
  componentId: "sc-li6bhs-1"
})(["pointer-events:none;position:absolute;right:", ";top:50%;transform:translateY(-50%);"], arrowRightOffset);
const Select = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  block,
  children,
  contrast,
  disabled,
  placeholder,
  size,
  required,
  validationStatus,
  ...rest
}, ref) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  sx: {
    overflow: 'hidden',
    position: 'relative',
    '@media screen and (forced-colors: active)': {
      svg: {
        fill: disabled ? 'GrayText' : 'FieldText'
      }
    }
  },
  block: block,
  contrast: contrast,
  disabled: disabled,
  size: size,
  validationStatus: validationStatus
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledSelect, _extends({
  ref: ref,
  required: required,
  disabled: disabled,
  "aria-invalid": validationStatus === 'error' ? 'true' : 'false',
  "data-hasplaceholder": Boolean(placeholder),
  defaultValue: placeholder !== null && placeholder !== void 0 ? placeholder : undefined
}, rest), placeholder && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
  value: "",
  disabled: required,
  hidden: required
}, placeholder), children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ArrowIndicator, null)));
const Option = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", props);
Option.displayName = "Option";
const OptGroup = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("optgroup", props);
OptGroup.displayName = "OptGroup";
var Select$1 = Object.assign(Select, {
  Option,
  OptGroup
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SelectPanel/SelectPanel.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SelectPanel/SelectPanel.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectPanel": () => (/* binding */ SelectPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hooks/useProvidedStateOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AnchoredOverlay/AnchoredOverlay.js */ "./node_modules/@primer/react/lib-esm/AnchoredOverlay/AnchoredOverlay.js");
/* harmony import */ var _FilteredActionList_FilteredActionList_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../FilteredActionList/FilteredActionList.js */ "./node_modules/@primer/react/lib-esm/FilteredActionList/FilteredActionList.js");
/* harmony import */ var _deprecated_DropdownMenu_DropdownButton_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../deprecated/DropdownMenu/DropdownButton.js */ "./node_modules/@primer/react/lib-esm/deprecated/DropdownMenu/DropdownButton.js");







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function isMultiSelectVariant(selected) {
  return Array.isArray(selected);
}
const focusZoneSettings = {
  // Let FilteredActionList handle focus zone
  disabled: true
};
function SelectPanel({
  open,
  onOpenChange,
  renderAnchor = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_deprecated_DropdownMenu_DropdownButton_js__WEBPACK_IMPORTED_MODULE_1__.DropdownButton, props),
  anchorRef: externalAnchorRef,
  placeholder,
  selected,
  onSelectedChange,
  filterValue: externalFilterValue,
  onFilterChange: externalOnFilterChange,
  items,
  textInputProps,
  overlayProps,
  sx,
  ...listProps
}) {
  const [filterValue, setInternalFilterValue] = (0,_hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_2__.useProvidedStateOrCreate)(externalFilterValue, undefined, '');
  const onFilterChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((value, e) => {
    externalOnFilterChange(value, e);
    setInternalFilterValue(value);
  }, [externalOnFilterChange, setInternalFilterValue]);
  const anchorRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_3__.useProvidedRefOrCreate)(externalAnchorRef);
  const onOpen = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(gesture => onOpenChange(true, gesture), [onOpenChange]);
  const onClose = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(gesture => {
    onOpenChange(false, gesture);
  }, [onOpenChange]);
  const renderMenuAnchor = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    if (renderAnchor === null) {
      return null;
    }
    const selectedItems = Array.isArray(selected) ? selected : [...(selected ? [selected] : [])];
    return props => {
      return renderAnchor({
        ...props,
        children: selectedItems.length ? selectedItems.map(item => item.text).join(', ') : placeholder
      });
    };
  }, [placeholder, renderAnchor, selected]);
  const itemsToRender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return items.map(item => {
      const isItemSelected = isMultiSelectVariant(selected) ? selected.includes(item) : selected === item;
      return {
        ...item,
        role: 'option',
        selected: 'selected' in item && item.selected === undefined ? undefined : isItemSelected,
        onAction: (itemFromAction, event) => {
          var _item$onAction;
          (_item$onAction = item.onAction) === null || _item$onAction === void 0 ? void 0 : _item$onAction.call(item, itemFromAction, event);
          if (event.defaultPrevented) {
            return;
          }
          if (isMultiSelectVariant(selected)) {
            const otherSelectedItems = selected.filter(selectedItem => selectedItem !== item);
            const newSelectedItems = selected.includes(item) ? otherSelectedItems : [...otherSelectedItems, item];
            const multiSelectOnChange = onSelectedChange;
            multiSelectOnChange(newSelectedItems);
            return;
          }

          // single select
          const singleSelectOnChange = onSelectedChange;
          singleSelectOnChange(item === selected ? undefined : item);
          onClose('selection');
        }
      };
    });
  }, [onClose, onSelectedChange, items, selected]);
  const inputRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  const focusTrapSettings = {
    initialFocusRef: inputRef
  };
  const extendedTextInputProps = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return {
      sx: {
        m: 2
      },
      contrast: true,
      ...textInputProps
    };
  }, [textInputProps]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_4__.AnchoredOverlay, {
    renderAnchor: renderMenuAnchor,
    anchorRef: anchorRef,
    open: open,
    onOpen: onOpen,
    onClose: onClose,
    overlayProps: overlayProps,
    focusTrapSettings: focusTrapSettings,
    focusZoneSettings: focusZoneSettings
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FilteredActionList_FilteredActionList_js__WEBPACK_IMPORTED_MODULE_5__.FilteredActionList, _extends({
    filterValue: filterValue,
    onFilterChange: onFilterChange
  }, listProps, {
    role: "listbox",
    "aria-multiselectable": isMultiSelectVariant(selected) ? 'true' : 'false',
    selectionVariant: isMultiSelectVariant(selected) ? 'multiple' : 'single',
    items: itemsToRender,
    textInputProps: extendedTextInputProps,
    inputRef: inputRef
    // inheriting height and maxHeight ensures that the FilteredActionList is never taller
    // than the Overlay (which would break scrolling the items)
    ,
    sx: {
      ...sx,
      height: 'inherit',
      maxHeight: 'inherit'
    }
  })));
}
SelectPanel.displayName = "SelectPanel";
SelectPanel.displayName = 'SelectPanel';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SideNav.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SideNav.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SideNav$1)
/* harmony export */ });
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Link_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link.js */ "./node_modules/@primer/react/lib-esm/Link.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");








function SideNavBase({
  variant,
  className,
  bordered,
  children,
  'aria-label': ariaLabel
}) {
  const variantClassName = variant === 'lightweight' ? 'lightweight' : 'normal';
  const newClassName = classnames__WEBPACK_IMPORTED_MODULE_2___default()(className, `variant-${variantClassName}`);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    borderWidth: bordered ? '1px' : 0,
    borderStyle: "solid",
    borderColor: "border.default",
    borderRadius: 2,
    as: "nav",
    className: newClassName,
    "aria-label": ariaLabel
  }, children);
}
SideNavBase.displayName = "SideNavBase";
const SideNav = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(SideNavBase).withConfig({
  displayName: "SideNav",
  componentId: "sc-11f1jdr-0"
})(["background-color:", ";", " ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.canvas.subtle'), props => props.bordered && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["& > &{border-left:0;border-right:0;border-bottom:0;}"]), _sx_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
// used for variant normal hover, focus pseudo selectors
const CommonAccessibilityVariantNormalStyles = (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["background-color:", ";text-decoration:none;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.neutral.subtle'));

// used for light weight hover, focus pseudo selectors
const CommonAccessibilityVariantLightWeightStyles = (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["color:", ";text-decoration:none;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'));
const SideNavLink = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(_Link_js__WEBPACK_IMPORTED_MODULE_6__["default"]).attrs(props => {
  const isReactRouter = typeof props.to === 'string';
  if (isReactRouter || props.selected) {
    // according to their docs, NavLink supports aria-current:
    // https://reacttraining.com/react-router/web/api/NavLink/aria-current-string
    return {
      'aria-current': 'page'
    };
  } else {
    return {};
  }
}).withConfig({
  displayName: "SideNav__SideNavLink",
  componentId: "sc-11f1jdr-1"
})(["position:relative;display:block;", " width:100%;text-align:left;font-size:", ";& > ", "{border-bottom:none;}", ".variant-normal > &{color:", ";padding:", ";border:0;border-top:", " solid ", ";&:first-child{border-top:0;border-top-right-radius:", ";border-top-left-radius:", ";}&:last-child{border-bottom-right-radius:", ";border-bottom-left-radius:", ";}&::before{position:absolute;top:0;bottom:0;left:0;z-index:1;width:3px;pointer-events:none;content:'';}&:hover{", "}&:focus{", " outline:solid 2px ", ";z-index:1;}&[aria-current='page'],&[aria-selected='true']{background-color:", ";&::before{background-color:", ";}}}", ".variant-lightweight > &{padding:", " 0;color:", ";&:hover{", "}&:focus{", " outline:solid 1px ", ";z-index:1;}&[aria-current='page'],&[aria-selected='true']{color:", ";font-weight:", ";}}", ";"], props => props.variant === 'full' && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["display:flex;align-items:center;justify-content:space-between;"]), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontSizes.1'), SideNav, SideNav, (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('borderWidths.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), CommonAccessibilityVariantNormalStyles, CommonAccessibilityVariantNormalStyles, (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.sidenav.selectedBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.primer.border.active'), SideNav, (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.accent.fg'), CommonAccessibilityVariantLightWeightStyles, CommonAccessibilityVariantLightWeightStyles, (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontWeights.semibold'), _sx_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
SideNav.defaultProps = {
  variant: 'normal'
};
SideNavLink.defaultProps = {
  variant: 'normal'
};
SideNavLink.displayName = 'SideNav.Link';
/** @deprecated Use [NavList](https://primer.style/react/NavList) instead */
var SideNav$1 = Object.assign(SideNav, {
  Link: SideNavLink
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SplitPageLayout/SplitPageLayout.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SplitPageLayout/SplitPageLayout.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Content": () => (/* binding */ Content),
/* harmony export */   "Footer": () => (/* binding */ Footer),
/* harmony export */   "Header": () => (/* binding */ Header),
/* harmony export */   "Pane": () => (/* binding */ Pane),
/* harmony export */   "Root": () => (/* binding */ Root),
/* harmony export */   "SplitPageLayout": () => (/* binding */ SplitPageLayout)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../PageLayout/PageLayout.js */ "./node_modules/@primer/react/lib-esm/PageLayout/PageLayout.js");



function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// ----------------------------------------------------------------------------
// SplitPageLayout

const Root = props => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__.PageLayout, _extends({
    containerWidth: "full",
    padding: "none",
    columnGap: "none",
    rowGap: "none"
  }, props));
};
Root.displayName = "Root";
Root.displayName = 'SplitPageLayout';

// ----------------------------------------------------------------------------
// SplitPageLayout.Header

const Header = ({
  padding = 'normal',
  divider = 'line',
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__.PageLayout.Header, _extends({
    padding: padding,
    divider: divider
  }, props));
};
Header.displayName = "Header";
Header.displayName = 'SplitPageLayout.Header';

// ----------------------------------------------------------------------------
// SplitPageLayout.Content

const Content = ({
  width = 'large',
  padding = 'normal',
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__.PageLayout.Content, _extends({
    width: width,
    padding: padding
  }, props));
};
Content.displayName = "Content";
Content.displayName = 'SplitPageLayout.Content';

// ----------------------------------------------------------------------------
// SplitPageLayout.Pane

const Pane = ({
  position = 'start',
  sticky = true,
  padding = 'normal',
  divider = 'line',
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__.PageLayout.Pane, _extends({
    position: position,
    sticky: sticky,
    padding: padding,
    divider: divider
  }, props));
};
Pane.displayName = "Pane";
Pane.displayName = 'SplitPageLayout.Pane';

// ----------------------------------------------------------------------------
// SplitPageLayout.Footer

const Footer = ({
  padding = 'normal',
  divider = 'line',
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_1__.PageLayout.Footer, _extends({
    padding: padding,
    divider: divider
  }, props));
};
Footer.displayName = "Footer";
Footer.displayName = 'SplitPageLayout.Footer';

// ----------------------------------------------------------------------------
// Export

const SplitPageLayout = Object.assign(Root, {
  Header,
  Content,
  Pane,
  Footer
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/StateLabel.js":
/*!**********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/StateLabel.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StateLabel)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./StyledOcticon.js */ "./node_modules/@primer/react/lib-esm/StyledOcticon.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const octiconMap = {
  issueOpened: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.IssueOpenedIcon,
  pullOpened: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.GitPullRequestIcon,
  issueClosed: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.IssueClosedIcon,
  issueClosedNotPlanned: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.SkipIcon,
  pullClosed: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.GitPullRequestIcon,
  pullMerged: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.GitMergeIcon,
  draft: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.GitPullRequestIcon,
  issueDraft: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.IssueDraftIcon
};
const colorVariants = (0,styled_system__WEBPACK_IMPORTED_MODULE_3__.variant)({
  prop: 'status',
  variants: {
    issueClosed: {
      backgroundColor: 'done.emphasis',
      color: 'fg.onEmphasis'
    },
    issueClosedNotPlanned: {
      backgroundColor: 'neutral.emphasis',
      color: 'fg.onEmphasis'
    },
    pullClosed: {
      backgroundColor: 'danger.emphasis',
      color: 'fg.onEmphasis'
    },
    pullMerged: {
      backgroundColor: 'done.emphasis',
      color: 'fg.onEmphasis'
    },
    issueOpened: {
      backgroundColor: 'success.emphasis',
      color: 'fg.onEmphasis'
    },
    pullOpened: {
      backgroundColor: 'success.emphasis',
      color: 'fg.onEmphasis'
    },
    draft: {
      backgroundColor: 'neutral.emphasis',
      color: 'fg.onEmphasis'
    },
    issueDraft: {
      backgroundColor: 'neutral.emphasis',
      color: 'fg.onEmphasis'
    }
  }
});
const sizeVariants = (0,styled_system__WEBPACK_IMPORTED_MODULE_3__.variant)({
  prop: 'variant',
  variants: {
    small: {
      paddingX: 2,
      paddingY: 1,
      fontSize: 0
    },
    normal: {
      paddingX: '12px',
      paddingY: 2,
      fontSize: 1
    }
  }
});
const StateLabelBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "StateLabel__StateLabelBase",
  componentId: "sc-4oy091-0"
})(["display:inline-flex;align-items:center;font-weight:", ";line-height:16px;color:", ";text-align:center;border-radius:", ";", ";", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.canvas.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.3'), colorVariants, sizeVariants, _sx_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
function StateLabel({
  children,
  status,
  variant: variantProp,
  ...rest
}) {
  const octiconProps = variantProp === 'small' ? {
    width: '1em'
  } : {};
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StateLabelBase, _extends({}, rest, {
    variant: variantProp,
    status: status
  }), status && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_StyledOcticon_js__WEBPACK_IMPORTED_MODULE_6__["default"], _extends({}, octiconProps, {
    icon: octiconMap[status] || _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.QuestionIcon,
    sx: {
      mr: 1
    }
  })), children);
}
StateLabel.displayName = "StateLabel";
StateLabel.defaultProps = {
  variant: 'normal'
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/SubNav.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/SubNav.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SubNav$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ITEM_CLASS = 'SubNav-item';
const SELECTED_CLASS = 'selected';
const SubNavBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().nav.withConfig({
  displayName: "SubNav__SubNavBase",
  componentId: "sc-1gr10ia-0"
})(["display:flex;justify-content:space-between;.SubNav-body{display:flex;margin-bottom:-1px;> *{margin-left:", ";}> *:first-child{margin-left:0;}}.SubNav-actions{align-self:center;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
function SubNav({
  actions,
  className,
  children,
  label,
  ...rest
}) {
  const classes = classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'SubNav');
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(SubNavBase, _extends({
    className: classes,
    "aria-label": label
  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "SubNav-body"
  }, children), actions && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "SubNav-actions"
  }, actions));
}
SubNav.displayName = "SubNav";
const SubNavLinks = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "SubNav__SubNavLinks",
  componentId: "sc-1gr10ia-1"
})(["display:flex;", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const SubNavLink = styled_components__WEBPACK_IMPORTED_MODULE_2___default().a.attrs(props => ({
  activeClassName: typeof props.to === 'string' ? 'selected' : '',
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(ITEM_CLASS, props.selected && SELECTED_CLASS, props.className)
})).withConfig({
  displayName: "SubNav__SubNavLink",
  componentId: "sc-1gr10ia-2"
})(["padding-left:", ";padding-right:", ";font-weight:", ";font-size:", ";line-height:20px;min-height:34px;color:", ";text-align:center;text-decoration:none;border-top:1px solid ", ";border-bottom:1px solid ", ";border-right:1px solid ", ";display:flex;align-items:center;&:first-of-type{border-top-left-radius:", ";border-bottom-left-radius:", ";border-left:1px solid ", ";}&:last-of-type{border-top-right-radius:", ";border-bottom-right-radius:", ";}&:hover,&:focus{text-decoration:none;background-color:", ";transition:background-color 0.2s ease;.SubNav-octicon{color:", ";}}&.selected{color:", ";background-color:", ";border-color:", ";.SubNav-octicon{color:", ";}}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontWeights.semibold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.emphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.emphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
SubNavLink.displayName = 'SubNav.Link';
SubNavLinks.displayName = 'SubNav.Links';
var SubNav$1 = Object.assign(SubNav, {
  Link: SubNavLink,
  Links: SubNavLinks
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/TabNav.js":
/*!******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/TabNav.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TabNav$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_getGlobalFocusStyles.js */ "./node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/focus-zone.js");









function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ITEM_CLASS = 'TabNav-item';
const SELECTED_CLASS = 'selected';
const TabNavBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "TabNav__TabNavBase",
  componentId: "sc-1ab407u-0"
})(["", ""], _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const TabNavTabList = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "TabNav__TabNavTabList",
  componentId: "sc-1ab407u-1"
})(["display:flex;margin-bottom:-1px;overflow:auto;"]);
const TabNavNav = styled_components__WEBPACK_IMPORTED_MODULE_2___default().nav.withConfig({
  displayName: "TabNav__TabNavNav",
  componentId: "sc-1ab407u-2"
})(["margin-top:0;border-bottom:1px solid ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.default'));
function TabNav({
  children,
  'aria-label': ariaLabel,
  ...rest
}) {
  const customContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
  // TODO: revert tracking when `initialFocus` is set. This is a fix when TabNav
  // is nested within another focus zone. This flag is used to indicate when
  // focus has been initially set, this is useful for including the
  // `aria-selected="true"` tab as the first interactive item.
  //
  // When set to `true`, this changes the behavior in `useFocusZone` to use
  // the `'previous'` strategy which allows the tab to participate in nested
  // focus zones without conflict
  const [initialFocus, setInitialFocus] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const customStrategy = react__WEBPACK_IMPORTED_MODULE_1___default().useCallback(() => {
    if (customContainerRef.current) {
      const tabs = Array.from(customContainerRef.current.querySelectorAll('[role=tab][aria-selected=true]'));
      setInitialFocus(true);
      return tabs[0];
    }
  }, [customContainerRef]);
  const {
    containerRef: navRef
  } = (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_5__.useFocusZone)({
    containerRef: customContainerRef,
    bindKeys: _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.FocusKeys.ArrowHorizontal | _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.FocusKeys.HomeAndEnd,
    focusOutBehavior: 'wrap',
    focusInStrategy: initialFocus ? 'previous' : customStrategy,
    focusableElementFilter: element => element.getAttribute('role') === 'tab'
  }, [initialFocus]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TabNavBase, _extends({}, rest, {
    ref: navRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TabNavNav, {
    "aria-label": ariaLabel
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TabNavTabList, {
    role: "tablist"
  }, children)));
}
TabNav.displayName = "TabNav";
const TabNavLink = styled_components__WEBPACK_IMPORTED_MODULE_2___default().a.attrs(props => ({
  activeClassName: typeof props.to === 'string' ? 'selected' : '',
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(ITEM_CLASS, props.selected && SELECTED_CLASS, props.className),
  role: 'tab',
  'aria-selected': !!props.selected,
  tabIndex: -1
})).withConfig({
  displayName: "TabNav__TabNavLink",
  componentId: "sc-1ab407u-3"
})(["padding:8px 12px;font-size:", ";line-height:20px;color:", ";text-decoration:none;background-color:transparent;border:1px solid transparent;border-bottom:0;", ";&:hover,&:focus{color:", ";text-decoration:none;}&.selected{color:", ";border-color:", ";border-top-right-radius:", ";border-top-left-radius:", ";background-color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_7__["default"])('-6px'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.canvas.default'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
TabNavLink.displayName = 'TabNav.Link';
var TabNav$1 = Object.assign(TabNav, {
  Link: TabNavLink
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/TextInput.js":
/*!*********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/TextInput.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextInput$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_TextInputInnerVisualSlot.js */ "./node_modules/@primer/react/lib-esm/_TextInputInnerVisualSlot.js");
/* harmony import */ var _TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_TextInputWrapper.js */ "./node_modules/@primer/react/lib-esm/_TextInputWrapper.js");
/* harmony import */ var _UnstyledTextInput_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_UnstyledTextInput.js */ "./node_modules/@primer/react/lib-esm/_UnstyledTextInput.js");
/* harmony import */ var _TextInputInnerAction_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_TextInputInnerAction.js */ "./node_modules/@primer/react/lib-esm/_TextInputInnerAction.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hooks/useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
// using forwardRef is important so that other components (ex. SelectMenu) can autofocus the input
const TextInput = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  icon: IconComponent,
  leadingVisual: LeadingVisual,
  trailingVisual: TrailingVisual,
  trailingAction,
  block,
  className,
  contrast,
  disabled,
  loading,
  loaderPosition,
  monospace,
  validationStatus,
  sx: sxProp,
  size: sizeProp,
  onFocus,
  onBlur,
  // start deprecated props
  width: widthProp,
  minWidth: minWidthProp,
  maxWidth: maxWidthProp,
  variant: variantProp,
  // end deprecated props
  ...inputProps
}, ref) => {
  const [isInputFocused, setIsInputFocused] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const inputRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_2__.useProvidedRefOrCreate)(ref);
  // this class is necessary to style FilterSearch, plz no touchy!
  const wrapperClasses = classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, 'TextInput-wrapper');
  const showLeadingLoadingIndicator = loading && (loaderPosition === 'leading' || Boolean(LeadingVisual && loaderPosition !== 'trailing'));
  const showTrailingLoadingIndicator = loading && (loaderPosition === 'trailing' || Boolean(loaderPosition === 'auto' && !LeadingVisual));
  const focusInput = () => {
    var _inputRef$current;
    (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.focus();
  };
  const handleInputFocus = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    setIsInputFocused(true);
    onFocus && onFocus(e);
  }, [onFocus]);
  const handleInputBlur = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    setIsInputFocused(false);
    onBlur && onBlur(e);
  }, [onBlur]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    block: block,
    className: wrapperClasses,
    validationStatus: validationStatus,
    contrast: contrast,
    disabled: disabled,
    monospace: monospace,
    sx: sxProp,
    size: sizeProp,
    width: widthProp,
    minWidth: minWidthProp,
    maxWidth: maxWidthProp,
    variant: variantProp,
    hasLeadingVisual: Boolean(LeadingVisual || showLeadingLoadingIndicator),
    hasTrailingVisual: Boolean(TrailingVisual || showTrailingLoadingIndicator),
    hasTrailingAction: Boolean(trailingAction),
    isInputFocused: isInputFocused,
    onClick: focusInput,
    "aria-live": "polite",
    "aria-busy": Boolean(loading)
  }, IconComponent && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(IconComponent, {
    className: "TextInput-icon"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_4__["default"], {
    visualPosition: "leading",
    showLoadingIndicator: showLeadingLoadingIndicator,
    hasLoadingIndicator: typeof loading === 'boolean'
  }, typeof LeadingVisual === 'function' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingVisual, null) : LeadingVisual), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnstyledTextInput_js__WEBPACK_IMPORTED_MODULE_5__["default"], _extends({
    ref: inputRef,
    disabled: disabled,
    onFocus: handleInputFocus,
    onBlur: handleInputBlur
  }, inputProps, {
    "data-component": "input"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_4__["default"], {
    visualPosition: "trailing",
    showLoadingIndicator: showTrailingLoadingIndicator,
    hasLoadingIndicator: typeof loading === 'boolean'
  }, typeof TrailingVisual === 'function' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TrailingVisual, null) : TrailingVisual), trailingAction);
});
TextInput.defaultProps = {
  type: 'text',
  loaderPosition: 'auto'
};
TextInput.displayName = 'TextInput';
var TextInput$1 = Object.assign(TextInput, {
  Action: _TextInputInnerAction_js__WEBPACK_IMPORTED_MODULE_6__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/TextInputWithTokens.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/TextInputWithTokens.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextInputWithTokens$1)
/* harmony export */ });
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/focus-zone.js");
/* harmony import */ var _primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @primer/behaviors/utils */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _styled_system_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/props */ "./node_modules/@styled-system/props/dist/index.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _Token_Token_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Token/Token.js */ "./node_modules/@primer/react/lib-esm/Token/Token.js");
/* harmony import */ var _TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_TextInputInnerVisualSlot.js */ "./node_modules/@primer/react/lib-esm/_TextInputInnerVisualSlot.js");
/* harmony import */ var _TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_TextInputWrapper.js */ "./node_modules/@primer/react/lib-esm/_TextInputWrapper.js");
/* harmony import */ var _UnstyledTextInput_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./_UnstyledTextInput.js */ "./node_modules/@primer/react/lib-esm/_UnstyledTextInput.js");













function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const overflowCountFontSizeMap = {
  small: 0,
  medium: 1,
  large: 1,
  extralarge: 2,
  xlarge: 2 // will eventually replace "extralarge" per this ADR: https://github.com/github/primer/blob/main/adrs/2022-02-09-size-naming-guidelines.md
};

// using forwardRef is important so that other components (ex. Autocomplete) can use the ref
function TextInputWithTokensInnerComponent({
  icon: IconComponent,
  leadingVisual: LeadingVisual,
  trailingVisual: TrailingVisual,
  loading,
  loaderPosition,
  contrast,
  className,
  block,
  disabled,
  sx: sxProp,
  tokens,
  onTokenRemove,
  tokenComponent: TokenComponent,
  preventTokenWrapping,
  size,
  hideTokenRemoveButtons,
  maxHeight,
  width: widthProp,
  minWidth: minWidthProp,
  maxWidth: maxWidthProp,
  validationStatus,
  variant: variantProp,
  // deprecated. use `size` instead
  visibleTokenCount,
  ...rest
}, forwardedRef) {
  const {
    onBlur,
    onFocus,
    onKeyDown,
    ...inputPropsRest
  } = (0,_styled_system_props__WEBPACK_IMPORTED_MODULE_0__.omit)(rest);
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_2__.useRefObjectAsForwardedRef)(forwardedRef, ref);
  const [selectedTokenIndex, setSelectedTokenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)();
  const [tokensAreTruncated, setTokensAreTruncated] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(Boolean(visibleTokenCount));
  const {
    containerRef
  } = (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_3__.useFocusZone)({
    focusOutBehavior: 'wrap',
    bindKeys: _primer_behaviors__WEBPACK_IMPORTED_MODULE_4__.FocusKeys.ArrowHorizontal | _primer_behaviors__WEBPACK_IMPORTED_MODULE_4__.FocusKeys.HomeAndEnd,
    focusableElementFilter: element => {
      return !element.getAttributeNames().includes('aria-hidden');
    },
    getNextFocusable: direction => {
      var _containerRef$current;
      if (!selectedTokenIndex && selectedTokenIndex !== 0) {
        return undefined;
      }
      let nextIndex = selectedTokenIndex + 1; // "+ 1" accounts for the first element: the text input

      if (direction === 'next') {
        nextIndex += 1;
      }
      if (direction === 'previous') {
        nextIndex -= 1;
      }
      if (nextIndex > tokens.length || nextIndex < 1) {
        return ref.current || undefined;
      }
      return (_containerRef$current = containerRef.current) === null || _containerRef$current === void 0 ? void 0 : _containerRef$current.children[nextIndex];
    }
  }, [selectedTokenIndex]);
  const handleTokenRemove = tokenId => {
    onTokenRemove(tokenId);

    // HACK: wait a tick for the token node to be removed from the DOM
    setTimeout(() => {
      var _containerRef$current2, _containerRef$current3;
      const nextElementToFocus = (_containerRef$current2 = containerRef.current) === null || _containerRef$current2 === void 0 ? void 0 : _containerRef$current2.children[selectedTokenIndex || 0];

      // when removing the first token by keying "Backspace" or "Delete",
      // `nextFocusableElement` is the div that wraps the input
      const firstFocusable = nextElementToFocus && (0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_5__.isFocusable)(nextElementToFocus) ? nextElementToFocus : Array.from(((_containerRef$current3 = containerRef.current) === null || _containerRef$current3 === void 0 ? void 0 : _containerRef$current3.children) || []).find(el => (0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_5__.isFocusable)(el));
      if (firstFocusable) {
        firstFocusable.focus();
      } else {
        var _ref$current;
        // if there are no tokens left, focus the input
        (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.focus();
      }
    }, 0);
  };
  const handleTokenFocus = tokenIndex => () => {
    setSelectedTokenIndex(tokenIndex);
  };
  const handleTokenBlur = () => {
    setSelectedTokenIndex(undefined);

    // HACK: wait a tick and check the focused element before hiding truncated tokens
    // this prevents the tokens from hiding when the user is moving focus between tokens,
    // but still hides the tokens when the user blurs the token by tabbing out or clicking somewhere else on the page
    setTimeout(() => {
      var _containerRef$current4;
      if (!((_containerRef$current4 = containerRef.current) !== null && _containerRef$current4 !== void 0 && _containerRef$current4.contains(document.activeElement)) && visibleTokenCount) {
        setTokensAreTruncated(true);
      }
    }, 0);
  };
  const handleTokenKeyUp = event => {
    if (event.key === 'Escape') {
      var _ref$current2;
      (_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.focus();
    }
  };
  const handleInputFocus = event => {
    onFocus && onFocus(event);
    setSelectedTokenIndex(undefined);
    visibleTokenCount && setTokensAreTruncated(false);
  };
  const handleInputBlur = event => {
    onBlur && onBlur(event);

    // HACK: wait a tick and check the focused element before hiding truncated tokens
    // this prevents the tokens from hiding when the user is moving focus from the input to a token,
    // but still hides the tokens when the user blurs the input by tabbing out or clicking somewhere else on the page
    setTimeout(() => {
      var _containerRef$current5;
      if (!((_containerRef$current5 = containerRef.current) !== null && _containerRef$current5 !== void 0 && _containerRef$current5.contains(document.activeElement)) && visibleTokenCount) {
        setTokensAreTruncated(true);
      }
    }, 0);
  };
  const handleInputKeyDown = e => {
    var _ref$current3;
    if (onKeyDown) {
      onKeyDown(e);
    }
    if ((_ref$current3 = ref.current) !== null && _ref$current3 !== void 0 && _ref$current3.value) {
      return;
    }
    const lastToken = tokens[tokens.length - 1];
    if (e.key === 'Backspace' && lastToken) {
      handleTokenRemove(lastToken.id);
      if (ref.current) {
        // TODO: eliminate the first hack by making changes to the Autocomplete component
        //
        // HACKS:
        // 1. Directly setting `ref.current.value` instead of updating state because the autocomplete
        //    highlight behavior doesn't work correctly if we update the value with a setState action in onChange
        // 2. Adding an extra space so that when I backspace, it doesn't delete the last letter
        ref.current.value = `${lastToken.text} `;
      }

      // HACK: for some reason we need to wait a tick for `.select()` to work
      setTimeout(() => {
        var _ref$current4;
        (_ref$current4 = ref.current) === null || _ref$current4 === void 0 ? void 0 : _ref$current4.select();
      }, 0);
    }
  };
  const focusInput = () => {
    var _ref$current5;
    (_ref$current5 = ref.current) === null || _ref$current5 === void 0 ? void 0 : _ref$current5.focus();
  };
  const preventTokenClickPropagation = event => {
    event.stopPropagation();
  };
  const visibleTokens = tokensAreTruncated ? tokens.slice(0, visibleTokenCount) : tokens;
  const inputSizeMap = {
    small: 'small',
    medium: 'small',
    large: 'medium',
    extralarge: 'medium',
    xlarge: 'medium' // will eventually replace "extralarge" per this ADR: https://github.com/github/primer/blob/main/adrs/2022-02-09-size-naming-guidelines.md
  };

  const showLeadingLoadingIndicator = loading && (loaderPosition === 'leading' || Boolean(LeadingVisual && loaderPosition !== 'trailing'));
  const showTrailingLoadingIndicator = loading && (loaderPosition === 'trailing' || loaderPosition === 'auto' && !LeadingVisual);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    block: block,
    className: className,
    contrast: contrast,
    disabled: disabled,
    hasLeadingVisual: Boolean(LeadingVisual || showLeadingLoadingIndicator),
    hasTrailingVisual: Boolean(TrailingVisual || showTrailingLoadingIndicator),
    width: widthProp,
    minWidth: minWidthProp,
    maxWidth: maxWidthProp,
    size: size && inputSizeMap[size],
    validationStatus: validationStatus,
    variant: variantProp // deprecated. use `size` prop instead
    ,
    onClick: focusInput,
    sx: {
      paddingLeft: _TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_6__.textInputHorizPadding,
      py: `calc(${_TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_6__.textInputHorizPadding} / 2)`,
      ...(block ? {
        display: 'flex',
        width: '100%'
      } : {}),
      ...(maxHeight ? {
        maxHeight,
        overflow: 'auto'
      } : {}),
      ...(preventTokenWrapping ? {
        overflow: 'auto'
      } : {}),
      ...sxProp
    }
  }, IconComponent && !LeadingVisual && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(IconComponent, {
    className: "TextInput-icon"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    hasLoadingIndicator: typeof loading === 'boolean',
    visualPosition: "leading",
    showLoadingIndicator: showLeadingLoadingIndicator
  }, typeof LeadingVisual === 'function' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(LeadingVisual, null) : LeadingVisual), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    ref: containerRef,
    display: "flex",
    sx: {
      alignItems: 'center',
      flexWrap: preventTokenWrapping ? 'nowrap' : 'wrap',
      marginLeft: '-0.25rem',
      marginBottom: '-0.25rem',
      flexGrow: 1,
      '> *': {
        flexShrink: 0,
        marginLeft: '0.25rem',
        marginBottom: '0.25rem'
      }
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    sx: {
      order: 1,
      flexGrow: 1
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_UnstyledTextInput_js__WEBPACK_IMPORTED_MODULE_9__["default"], _extends({
    ref: ref,
    disabled: disabled,
    onFocus: handleInputFocus,
    onBlur: handleInputBlur,
    onKeyDown: handleInputKeyDown,
    type: "text",
    sx: {
      height: '100%'
    },
    "aria-invalid": validationStatus === 'error' ? 'true' : 'false'
  }, inputPropsRest))), TokenComponent ? visibleTokens.map(({
    id,
    ...tokenRest
  }, i) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TokenComponent, _extends({
    key: id,
    onFocus: handleTokenFocus(i),
    onBlur: handleTokenBlur,
    onKeyUp: handleTokenKeyUp,
    onClick: preventTokenClickPropagation,
    isSelected: selectedTokenIndex === i,
    onRemove: () => {
      handleTokenRemove(id);
    },
    hideRemoveButton: hideTokenRemoveButtons,
    size: size,
    tabIndex: 0
  }, tokenRest))) : null, tokensAreTruncated && tokens.length - visibleTokens.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_10__["default"], {
    color: "fg.muted",
    fontSize: size && overflowCountFontSizeMap[size]
  }, "+", tokens.length - visibleTokens.length) : null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_TextInputInnerVisualSlot_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    hasLoadingIndicator: typeof loading === 'boolean',
    visualPosition: "trailing",
    showLoadingIndicator: showTrailingLoadingIndicator
  }, typeof TrailingVisual === 'function' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TrailingVisual, null) : TrailingVisual));
}
TextInputWithTokensInnerComponent.displayName = "TextInputWithTokensInnerComponent";
const TextInputWithTokens = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(TextInputWithTokensInnerComponent);
TextInputWithTokens.defaultProps = {
  tokenComponent: _Token_Token_js__WEBPACK_IMPORTED_MODULE_11__["default"],
  size: 'xlarge',
  hideTokenRemoveButtons: false,
  preventTokenWrapping: false,
  loaderPosition: 'auto'
};
TextInputWithTokens.displayName = 'TextInputWithTokens';
var TextInputWithTokens$1 = TextInputWithTokens;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Textarea.js":
/*!********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Textarea.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_TEXTAREA_COLS": () => (/* binding */ DEFAULT_TEXTAREA_COLS),
/* harmony export */   "DEFAULT_TEXTAREA_RESIZE": () => (/* binding */ DEFAULT_TEXTAREA_RESIZE),
/* harmony export */   "DEFAULT_TEXTAREA_ROWS": () => (/* binding */ DEFAULT_TEXTAREA_ROWS),
/* harmony export */   "default": () => (/* binding */ Textarea$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_TextInputWrapper.js */ "./node_modules/@primer/react/lib-esm/_TextInputWrapper.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DEFAULT_TEXTAREA_ROWS = 7;
const DEFAULT_TEXTAREA_COLS = 30;
const DEFAULT_TEXTAREA_RESIZE = 'both';
const StyledTextarea = styled_components__WEBPACK_IMPORTED_MODULE_0___default().textarea.withConfig({
  displayName: "Textarea__StyledTextarea",
  componentId: "sc-wz5skc-0"
})(["border:0;font-size:inherit;font-family:inherit;background-color:transparent;-webkit-appearance:none;color:inherit;width:100%;resize:both;&:focus{outline:0;}", " ", " ", ";"], props => props.resize && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["resize:", ";"], props.resize), props => props.disabled && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["resize:none;"]), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);

/**
 * An accessible, native textarea component that supports validation states.
 * This component accepts all native HTML <textarea> attributes as props.
 */
const Textarea = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(({
  value,
  disabled,
  sx: sxProp,
  required,
  validationStatus,
  rows = DEFAULT_TEXTAREA_ROWS,
  cols = DEFAULT_TEXTAREA_COLS,
  resize = DEFAULT_TEXTAREA_RESIZE,
  block,
  ...rest
}, ref) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_TextInputWrapper_js__WEBPACK_IMPORTED_MODULE_3__.TextInputBaseWrapper, {
    sx: sxProp,
    validationStatus: validationStatus,
    disabled: disabled,
    block: block
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledTextarea, _extends({
    value: value,
    resize: resize,
    required: required,
    "aria-required": required ? 'true' : 'false',
    "aria-invalid": validationStatus === 'error' ? 'true' : 'false',
    ref: ref,
    disabled: disabled,
    rows: rows,
    cols: cols
  }, rest)));
});
Textarea.displayName = 'Textarea';
var Textarea$1 = Textarea;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Timeline.js":
/*!********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Timeline.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Timeline$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");







const Timeline = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Timeline",
  componentId: "sc-1u6eyef-0"
})(["display:flex;flex-direction:column;", " ", ";"], props => props.clipSidebar && (0,styled_components__WEBPACK_IMPORTED_MODULE_2__.css)([".Timeline-Item:first-child{padding-top:0;}.Timeline-Item:last-child{padding-bottom:0;}"]), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const TimelineItem = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.attrs(props => ({
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('Timeline-Item', props.className)
})).withConfig({
  displayName: "Timeline__TimelineItem",
  componentId: "sc-1u6eyef-1"
})(["display:flex;position:relative;padding:", " 0;margin-left:", ";&::before{position:absolute;top:0;bottom:0;left:0;display:block;width:2px;content:'';background-color:", ";}", " ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.muted'), props => props.condensed && (0,styled_components__WEBPACK_IMPORTED_MODULE_2__.css)(["padding-top:", ";padding-bottom:0;&:last-child{padding-bottom:", ";}.TimelineItem-Badge{height:16px;margin-top:", ";margin-bottom:", ";color:", ";background-color:", ";border:0;}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.canvas.default')), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const TimelineBadge = props => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    position: "relative",
    zIndex: 1
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    display: "flex",
    className: "TimelineItem-Badge",
    flexShrink: 0,
    borderRadius: "50%",
    borderWidth: "2px",
    borderStyle: "solid",
    borderColor: "canvas.default",
    overflow: "hidden",
    color: "fg.muted",
    bg: "timeline.badgeBg",
    width: "32px",
    height: "32px",
    mr: 2,
    ml: "-15px",
    alignItems: "center",
    justifyContent: "center",
    sx: props.sx
  }, props.children));
};
TimelineBadge.displayName = "TimelineBadge";
const TimelineBody = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Timeline__TimelineBody",
  componentId: "sc-1u6eyef-2"
})(["min-width:0;max-width:100%;margin-top:", ";color:", ";flex:auto;font-size:", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontSizes.1'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const TimelineBreak = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Timeline__TimelineBreak",
  componentId: "sc-1u6eyef-3"
})(["position:relative z-index:1;height:24px;margin:0;margin-bottom:-", ";margin-left:0;background-color:", ";border:0;border-top:", " solid ", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.canvas.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.default'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
TimelineItem.displayName = 'Timeline.Item';
TimelineBadge.displayName = 'Timeline.Badge';
TimelineBody.displayName = 'Timeline.Body';
TimelineBreak.displayName = 'Timeline.Break';
var Timeline$1 = Object.assign(Timeline, {
  Item: TimelineItem,
  Badge: TimelineBadge,
  Body: TimelineBody,
  Break: TimelineBreak
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/ToggleSwitch.js":
/*!************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/ToggleSwitch.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Switch$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./_VisuallyHidden.js */ "./node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hooks/useProvidedStateOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js");











const TRANSITION_DURATION = '80ms';
const EASE_OUT_QUAD_CURVE = 'cubic-bezier(0.5, 1, 0.89, 1)';
const sizeVariants = (0,styled_system__WEBPACK_IMPORTED_MODULE_2__.variant)({
  prop: 'size',
  variants: {
    small: {
      height: '24px',
      width: '48px'
    }
  }
});
const CircleIcon = ({
  size
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
  width: size === 'small' ? '12' : '16',
  height: size === 'small' ? '12' : '16',
  viewBox: "0 0 16 16",
  fill: "currentColor",
  xmlns: "http://www.w3.org/2000/svg"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
  fillRule: "evenodd",
  d: "M8 12.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9ZM8 14A6 6 0 1 0 8 2a6 6 0 0 0 0 12Z"
}));
CircleIcon.displayName = "CircleIcon";
const LineIcon = ({
  size
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
  width: size === 'small' ? '12' : '16',
  height: size === 'small' ? '12' : '16',
  viewBox: "0 0 16 16",
  fill: "currentColor",
  xmlns: "http://www.w3.org/2000/svg"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
  fillRule: "evenodd",
  d: "M8 2a.75.75 0 0 1 .75.75v11.5a.75.75 0 0 1-1.5 0V2.75A.75.75 0 0 1 8 2Z"
}));
LineIcon.displayName = "LineIcon";
const SwitchButton = styled_components__WEBPACK_IMPORTED_MODULE_1___default().button.withConfig({
  displayName: "ToggleSwitch__SwitchButton",
  componentId: "sc-om7zet-0"
})(["vertical-align:middle;cursor:pointer;user-select:none;appearance:none;text-decoration:none;padding:0;transition-property:background-color,border-color;transition-duration:", ";transition-timing-function:", ";border-radius:", ";border-style:solid;border-width:1px;display:block;height:32px;width:64px;outline-offset:2px;position:relative;overflow:hidden;@media (pointer:coarse){&:before{content:'';position:absolute;left:0;right:0;transform:translateY(-50%);top:50%;min-height:44px;}}@media (prefers-reduced-motion){transition:none;*{transition:none;}}", " ", " ", ""], TRANSITION_DURATION, EASE_OUT_QUAD_CURVE, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), props => {
  if (props.disabled) {
    return (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["background-color:", ";border-color:", ";cursor:not-allowed;transition-property:none;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.subtle'));
  }
  if (props.checked) {
    return (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["background-color:", ";border-color:", ";&:hover,&:focus:focus-visible{background-color:", ";}&:active,&:active:focus-visible{background-color:", ";}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.checked.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.checked.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.checked.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.checked.activeBg'));
  } else {
    return (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["background-color:", ";border-color:", ";&:hover,&:focus:focus-visible{.Toggle-knob{background-color:", ";}}&:active,&:active:focus-visible{.Toggle-knob{background-color:", ";}}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.btn.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.btn.activeBg'));
  }
}, _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"], sizeVariants);
const ToggleKnob = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "ToggleSwitch__ToggleKnob",
  componentId: "sc-om7zet-1"
})(["background-color:", ";border-width:1px;border-style:solid;border-color:", ";border-radius:calc(", " - 1px);box-shadow:", ";width:50%;position:absolute;top:-1px;bottom:-1px;transition-property:transform;transition-duration:", ";transition-timing-function:", ";transform:", ";z-index:1;@media (prefers-reduced-motion){transition:none;}", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.btn.bg'), props => props.disabled ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchTrack.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), props => {
  var _props$theme, _props$theme$shadows, _props$theme2, _props$theme2$shadows;
  return props.disabled ? 'none' : `${(_props$theme = props.theme) === null || _props$theme === void 0 ? void 0 : (_props$theme$shadows = _props$theme.shadows) === null || _props$theme$shadows === void 0 ? void 0 : _props$theme$shadows.shadow.medium}, ${(_props$theme2 = props.theme) === null || _props$theme2 === void 0 ? void 0 : (_props$theme2$shadows = _props$theme2.shadows) === null || _props$theme2$shadows === void 0 ? void 0 : _props$theme2$shadows.btn.insetShadow}`;
}, TRANSITION_DURATION, EASE_OUT_QUAD_CURVE, props => `translateX(${props.checked ? 'calc(100% + 1px)' : '-1px'})`, props => {
  if (props.checked) {
    return (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["background-color:", ";border-color:", ";box-shadow:", ";"], props.disabled ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchKnob.checked.disabledBg') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchKnob.checked.bg'), props.disabled ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchKnob.checked.disabledBg') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.switchKnob.checked.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('shadows.shadow.small'));
  }
});
const hiddenTextStyles = {
  visibility: 'hidden',
  height: 0
};
const Switch = ({
  'aria-labelledby': ariaLabelledby,
  'aria-describedby': ariaDescribedby,
  defaultChecked,
  disabled,
  loading,
  checked,
  onChange,
  onClick,
  size,
  statusLabelPosition,
  sx: sxProp
}) => {
  const isControlled = typeof checked !== 'undefined';
  const [isOn, setIsOn] = (0,_hooks_useProvidedStateOrCreate_js__WEBPACK_IMPORTED_MODULE_5__.useProvidedStateOrCreate)(checked, onChange, Boolean(defaultChecked));
  const acceptsInteraction = !disabled && !loading;
  const handleToggleClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    if (!isControlled) {
      setIsOn(!isOn);
    }
    onClick && onClick(e);
  }, [onClick, isControlled, isOn, setIsOn]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (onChange && isControlled) {
      onChange(Boolean(checked));
    }
  }, [onChange, checked, isControlled]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    display: "inline-flex",
    alignItems: "center",
    flexDirection: statusLabelPosition === 'start' ? 'row' : 'row-reverse',
    sx: sxProp
  }, loading ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    size: "small"
  }) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    color: acceptsInteraction ? 'fg.default' : 'fg.muted',
    fontSize: size === 'small' ? 0 : 1,
    mx: 2,
    "aria-hidden": "true",
    sx: {
      position: 'relative'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    textAlign: "right",
    sx: isOn ? null : hiddenTextStyles
  }, "On"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    textAlign: "right",
    sx: isOn ? hiddenTextStyles : null
  }, "Off")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SwitchButton, {
    onClick: handleToggleClick,
    "aria-labelledby": ariaLabelledby,
    "aria-describedby": ariaDescribedby,
    "aria-checked": isOn,
    "aria-disabled": !acceptsInteraction,
    role: "switch",
    checked: isOn,
    size: size,
    disabled: !acceptsInteraction
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_9__["default"], null, isOn ? 'On' : 'Off'), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    "aria-hidden": "true",
    display: "flex",
    alignItems: "center",
    width: "100%",
    height: "100%",
    overflow: "hidden"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    flexGrow: 1,
    flexShrink: 0,
    flexBasis: "50%",
    color: acceptsInteraction ? 'accent.fg' : 'fg.subtle',
    lineHeight: "0",
    sx: {
      transform: `translateX(${isOn ? '0' : '-100%'})`,
      transitionProperty: 'transform',
      transitionDuration: TRANSITION_DURATION
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LineIcon, {
    size: size
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    flexGrow: 1,
    flexShrink: 0,
    flexBasis: "50%",
    color: acceptsInteraction ? 'fg.default' : 'fg.subtle',
    lineHeight: "0",
    sx: {
      transform: `translateX(${isOn ? '100%' : '0'})`,
      transitionProperty: 'transform',
      transitionDuration: TRANSITION_DURATION
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CircleIcon, {
    size: size
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ToggleKnob, {
    "aria-hidden": "true",
    className: "Toggle-knob",
    disabled: !acceptsInteraction,
    checked: isOn
  })));
};
Switch.displayName = "Switch";
Switch.defaultProps = {
  statusLabelPosition: 'start',
  size: 'medium'
};
var Switch$1 = Switch;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/AvatarToken.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/AvatarToken.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AvatarToken$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TokenBase.js */ "./node_modules/@primer/react/lib-esm/Token/TokenBase.js");
/* harmony import */ var _Token_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Token.js */ "./node_modules/@primer/react/lib-esm/Token/Token.js");
/* harmony import */ var _Avatar_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Avatar.js */ "./node_modules/@primer/react/lib-esm/Avatar.js");







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// TODO: update props to only accept 'large' and 'xlarge' on the next breaking change

const AvatarContainer = styled_components__WEBPACK_IMPORTED_MODULE_1___default().span.withConfig({
  displayName: "AvatarToken__AvatarContainer",
  componentId: "sc-62sih1-0"
})(["--spacing:calc(", " * 2);display:block;height:", ";width:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.1'), props => `calc(${_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.tokenSizes[props.avatarSize]} - var(--spacing))`, props => `calc(${_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.tokenSizes[props.avatarSize]} - var(--spacing))`);
const AvatarToken = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  avatarSrc,
  id,
  size,
  ...rest
}, forwardedRef) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Token_js__WEBPACK_IMPORTED_MODULE_4__["default"], _extends({
    leadingVisual: () => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AvatarContainer, {
      avatarSize: size || _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.defaultTokenSize
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Avatar_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
      src: avatarSrc,
      size: parseInt(_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.tokenSizes[size || _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.defaultTokenSize], 10),
      sx: {
        width: '100%',
        height: '100%'
      }
    })),
    size: size,
    id: id === null || id === void 0 ? void 0 : id.toString(),
    sx: {
      paddingLeft: (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.1')
    }
  }, rest, {
    ref: forwardedRef
  }));
});
AvatarToken.defaultProps = {
  size: _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.defaultTokenSize
};
AvatarToken.displayName = 'AvatarToken';
var AvatarToken$1 = AvatarToken;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/IssueLabelToken.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/IssueLabelToken.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IssueLabelToken$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _TokenBase_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TokenBase.js */ "./node_modules/@primer/react/lib-esm/Token/TokenBase.js");
/* harmony import */ var _RemoveTokenButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_RemoveTokenButton.js */ "./node_modules/@primer/react/lib-esm/Token/_RemoveTokenButton.js");
/* harmony import */ var color2k__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! color2k */ "./node_modules/color2k/dist/index.module.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _TokenTextContainer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_TokenTextContainer.js */ "./node_modules/@primer/react/lib-esm/Token/_TokenTextContainer.js");







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const tokenBorderWidthPx = 1;
const lightModeStyles = {
  '--lightness-threshold': '0.453',
  '--border-threshold': '0.96',
  '--border-alpha': 'max(0, min(calc((var(--perceived-lightness) - var(--border-threshold)) * 100), 1))',
  background: 'rgb(var(--label-r), var(--label-g), var(--label-b))',
  color: 'hsl(0, 0%, calc(var(--lightness-switch) * 100%))',
  borderWidth: tokenBorderWidthPx,
  borderStyle: 'solid',
  borderColor: 'hsla(var(--label-h),calc(var(--label-s) * 1%),calc((var(--label-l) - 25) * 1%),var(--border-alpha))'
};
const darkModeStyles = {
  '--lightness-threshold': '0.6',
  '--background-alpha': '0.18',
  '--border-alpha': '0.3',
  '--lighten-by': 'calc(((var(--lightness-threshold) - var(--perceived-lightness)) * 100) * var(--lightness-switch))',
  borderWidth: tokenBorderWidthPx,
  borderStyle: 'solid',
  background: 'rgba(var(--label-r), var(--label-g), var(--label-b), var(--background-alpha))',
  color: 'hsl(var(--label-h), calc(var(--label-s) * 1%), calc((var(--label-l) + var(--lighten-by)) * 1%))',
  borderColor: 'hsla(var(--label-h), calc(var(--label-s) * 1%),calc((var(--label-l) + var(--lighten-by)) * 1%),var(--border-alpha))'
};
const IssueLabelToken = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, forwardedRef) => {
  const {
    as,
    fillColor = '#999',
    onRemove,
    id,
    isSelected,
    text,
    size,
    hideRemoveButton,
    href,
    onClick,
    ...rest
  } = props;
  const interactiveTokenProps = {
    as,
    href,
    onClick
  };
  const {
    colorScheme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_1__.useTheme)();
  const hasMultipleActionTargets = (0,_TokenBase_js__WEBPACK_IMPORTED_MODULE_2__.isTokenInteractive)(props) && Boolean(onRemove) && !hideRemoveButton;
  const onRemoveClick = e => {
    e.stopPropagation();
    onRemove && onRemove();
  };
  const labelStyles = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    const [r, g, b] = (0,color2k__WEBPACK_IMPORTED_MODULE_3__.parseToRgba)(fillColor);
    const [h, s, l] = (0,color2k__WEBPACK_IMPORTED_MODULE_3__.parseToHsla)(fillColor);

    // label hack taken from https://github.com/github/github/blob/master/app/assets/stylesheets/hacks/hx_primer-labels.scss#L43-L108
    // this logic should eventually live in primer/components. Also worthy of note is that the dotcom hack code will be moving to primer/css soon.
    return {
      '--label-r': String(r),
      '--label-g': String(g),
      '--label-b': String(b),
      '--label-h': String(Math.round(h)),
      '--label-s': String(Math.round(s * 100)),
      '--label-l': String(Math.round(l * 100)),
      '--perceived-lightness': 'calc(((var(--label-r) * 0.2126) + (var(--label-g) * 0.7152) + (var(--label-b) * 0.0722)) / 255)',
      '--lightness-switch': 'max(0, min(calc((var(--perceived-lightness) - var(--lightness-threshold)) * -1000), 1))',
      paddingRight: hideRemoveButton || !onRemove ? undefined : 0,
      position: 'relative',
      ...(colorScheme === 'light' ? lightModeStyles : darkModeStyles),
      ...(isSelected ? {
        background: colorScheme === 'light' ? 'hsl(var(--label-h), calc(var(--label-s) * 1%), calc((var(--label-l) - 5) * 1%))' : darkModeStyles.background,
        ':focus': {
          outline: 'none'
        },
        ':after': {
          content: '""',
          position: 'absolute',
          zIndex: 1,
          top: `-${tokenBorderWidthPx * 2}px`,
          right: `-${tokenBorderWidthPx * 2}px`,
          bottom: `-${tokenBorderWidthPx * 2}px`,
          left: `-${tokenBorderWidthPx * 2}px`,
          display: 'block',
          pointerEvents: 'none',
          boxShadow: `0 0 0 ${tokenBorderWidthPx * 2}px ${colorScheme === 'light' ? 'rgb(var(--label-r), var(--label-g), var(--label-b))' : 'hsl(var(--label-h), calc(var(--label-s) * 1%), calc((var(--label-l) + var(--lighten-by)) * 1%))'}`,
          borderRadius: '999px'
        }
      } : {})
    };
  }, [colorScheme, fillColor, isSelected, hideRemoveButton, onRemove]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TokenBase_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    onRemove: onRemove,
    id: id === null || id === void 0 ? void 0 : id.toString(),
    isSelected: isSelected,
    text: text,
    size: size,
    sx: labelStyles
  }, !hasMultipleActionTargets ? interactiveTokenProps : {}, rest, {
    ref: forwardedRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TokenTextContainer_js__WEBPACK_IMPORTED_MODULE_4__["default"], hasMultipleActionTargets ? interactiveTokenProps : {}, text), !hideRemoveButton && onRemove ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RemoveTokenButton_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    borderOffset: tokenBorderWidthPx,
    onClick: onRemoveClick,
    size: size,
    "aria-hidden": hasMultipleActionTargets ? 'true' : 'false',
    isParentInteractive: (0,_TokenBase_js__WEBPACK_IMPORTED_MODULE_2__.isTokenInteractive)(props),
    sx: hasMultipleActionTargets ? {
      position: 'relative',
      zIndex: '1'
    } : {}
  }) : null);
});
IssueLabelToken.defaultProps = {
  fillColor: '#999',
  size: _TokenBase_js__WEBPACK_IMPORTED_MODULE_2__.defaultTokenSize
};
IssueLabelToken.displayName = 'IssueLabelToken';
var IssueLabelToken$1 = IssueLabelToken;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/Token.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/Token.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Token$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TokenBase.js */ "./node_modules/@primer/react/lib-esm/Token/TokenBase.js");
/* harmony import */ var _RemoveTokenButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_RemoveTokenButton.js */ "./node_modules/@primer/react/lib-esm/Token/_RemoveTokenButton.js");
/* harmony import */ var _TokenTextContainer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_TokenTextContainer.js */ "./node_modules/@primer/react/lib-esm/Token/_TokenTextContainer.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const tokenBorderWidthPx = 1;
const LeadingVisualContainer = ({
  children,
  size
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  sx: {
    flexShrink: 0,
    lineHeight: 0,
    marginRight: size && ['large', 'extralarge', 'xlarge'].includes(size) ? 2 : 1
  }
}, children);
LeadingVisualContainer.displayName = "LeadingVisualContainer";
const Token = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, forwardedRef) => {
  const {
    as,
    onRemove,
    id,
    leadingVisual: LeadingVisual,
    text,
    size,
    hideRemoveButton,
    href,
    onClick,
    sx: sxProp = {},
    ...rest
  } = props;
  const hasMultipleActionTargets = (0,_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.isTokenInteractive)(props) && Boolean(onRemove) && !hideRemoveButton;
  const onRemoveClick = e => {
    e.stopPropagation();
    onRemove && onRemove();
  };
  const interactiveTokenProps = {
    as,
    href,
    onClick
  };
  const sx = deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
    backgroundColor: 'neutral.subtle',
    borderColor: props.isSelected ? 'fg.default' : 'border.subtle',
    borderStyle: 'solid',
    borderWidth: `${tokenBorderWidthPx}px`,
    color: props.isSelected ? 'fg.default' : 'fg.muted',
    maxWidth: '100%',
    paddingRight: !(hideRemoveButton || !onRemove) ? 0 : undefined,
    ...((0,_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.isTokenInteractive)(props) ? {
      '&:hover': {
        backgroundColor: 'neutral.muted',
        boxShadow: 'shadow.medium',
        color: 'fg.default'
      }
    } : {})
  }, sxProp);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__["default"], _extends({
    onRemove: onRemove,
    id: id === null || id === void 0 ? void 0 : id.toString(),
    text: text,
    size: size,
    sx: sx
  }, !hasMultipleActionTargets ? interactiveTokenProps : {}, rest, {
    ref: forwardedRef
  }), LeadingVisual ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingVisualContainer, {
    size: size
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingVisual, null)) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TokenTextContainer_js__WEBPACK_IMPORTED_MODULE_4__["default"], hasMultipleActionTargets ? interactiveTokenProps : {}, text), !hideRemoveButton && onRemove ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RemoveTokenButton_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    borderOffset: tokenBorderWidthPx,
    onClick: onRemoveClick,
    size: size,
    isParentInteractive: (0,_TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.isTokenInteractive)(props),
    "aria-hidden": hasMultipleActionTargets ? 'true' : 'false',
    sx: hasMultipleActionTargets ? {
      position: 'relative',
      zIndex: '1'
    } : {}
  }) : null);
});
Token.displayName = 'Token';
Token.defaultProps = {
  size: _TokenBase_js__WEBPACK_IMPORTED_MODULE_3__.defaultTokenSize
};
var Token$1 = Token;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/TokenBase.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/TokenBase.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TokenBase$1),
/* harmony export */   "defaultTokenSize": () => (/* binding */ defaultTokenSize),
/* harmony export */   "isTokenInteractive": () => (/* binding */ isTokenInteractive),
/* harmony export */   "tokenSizes": () => (/* binding */ tokenSizes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// TODO: remove invalid "extralarge" size name in next breaking change
/** @deprecated 'extralarge' to be removed to align with size naming ADR https://github.com/github/primer/blob/main/adrs/2022-02-09-size-naming-guidelines.md **/

const xlargeSize = '32px';
const tokenSizes = {
  small: '16px',
  medium: '20px',
  large: '24px',
  extralarge: xlargeSize,
  xlarge: xlargeSize
};
const defaultTokenSize = 'medium';
const isTokenInteractive = ({
  as = 'span',
  onClick,
  onFocus,
  tabIndex = -1
}) => Boolean(onFocus || onClick || tabIndex > -1 || ['a', 'button'].includes(as));
const xlargeVariantStyles = {
  fontSize: 1,
  height: tokenSizes.xlarge,
  lineHeight: tokenSizes.xlarge,
  paddingLeft: 3,
  paddingRight: 3,
  paddingTop: 0,
  paddingBottom: 0
};
const variants = (0,styled_system__WEBPACK_IMPORTED_MODULE_2__.variant)({
  prop: 'size',
  variants: {
    small: {
      fontSize: 0,
      height: tokenSizes.small,
      // without setting lineHeight to match height, the "x" appears vertically mis-aligned
      lineHeight: tokenSizes.small,
      paddingLeft: 1,
      paddingRight: 1,
      // need to explicitly set padding top and bottom to "0" to override default `<button>` element styles
      // without setting these, the "x" appears vertically mis-aligned
      paddingTop: 0,
      paddingBottom: 0
    },
    medium: {
      fontSize: 0,
      height: tokenSizes.medium,
      lineHeight: tokenSizes.medium,
      paddingLeft: 2,
      paddingRight: 2,
      paddingTop: 0,
      paddingBottom: 0
    },
    large: {
      fontSize: 0,
      height: tokenSizes.large,
      lineHeight: tokenSizes.large,
      paddingLeft: 2,
      paddingRight: 2,
      paddingTop: 0,
      paddingBottom: 0
    },
    extralarge: xlargeVariantStyles,
    xlarge: xlargeVariantStyles
  }
});
const StyledTokenBase = styled_components__WEBPACK_IMPORTED_MODULE_1___default().span.withConfig({
  displayName: "TokenBase__StyledTokenBase",
  componentId: "sc-1ju9l7y-0"
})(["align-items:center;border-radius:999px;cursor:", ";display:inline-flex;font-weight:", ";font-family:inherit;text-decoration:none;position:relative;white-space:nowrap;", " ", ""], props => isTokenInteractive(props) ? 'pointer' : 'auto', (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontWeights.bold'), variants, _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const TokenBase = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  text,
  onRemove,
  onKeyDown,
  id,
  ...rest
}, forwardedRef) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledTokenBase, _extends({
    onKeyDown: event => {
      onKeyDown && onKeyDown(event);
      if ((event.key === 'Backspace' || event.key === 'Delete') && onRemove) {
        onRemove();
      }
    },
    "aria-label": onRemove ? `${text}, press backspace or delete to remove` : undefined,
    id: id === null || id === void 0 ? void 0 : id.toString()
  }, rest, {
    ref: forwardedRef
  }));
});
TokenBase.defaultProps = {
  as: 'span',
  size: defaultTokenSize
};
var TokenBase$1 = TokenBase;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/_RemoveTokenButton.js":
/*!************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/_RemoveTokenButton.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RemoveTokenButton$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TokenBase.js */ "./node_modules/@primer/react/lib-esm/Token/TokenBase.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const variants = (0,styled_system__WEBPACK_IMPORTED_MODULE_3__.variant)({
  prop: 'size',
  variants: {
    small: {
      height: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.small,
      width: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.small
    },
    medium: {
      height: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.medium,
      width: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.medium
    },
    large: {
      height: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.large,
      width: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.large
    },
    extralarge: {
      height: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.extralarge,
      width: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.extralarge
    },
    // xlarge will eventually replace "extralarge" per this ADR: https://github.com/github/primer/blob/main/adrs/2022-02-09-size-naming-guidelines.md
    xlarge: {
      height: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.xlarge,
      width: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes.xlarge
    }
  }
});
const getTokenButtonIconSize = size => parseInt(_TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.tokenSizes[size || _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.defaultTokenSize], 10) * 0.75;
const StyledTokenButton = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "_RemoveTokenButton__StyledTokenButton",
  componentId: "sc-urhpr1-0"
})(["background-color:transparent;font-family:inherit;color:currentColor;cursor:pointer;display:inline-flex;justify-content:center;align-items:center;user-select:none;appearance:none;text-decoration:none;padding:0;transform:", ";align-self:baseline;border:0;border-radius:999px;", " &:hover,&:focus{background-color:", ";}&:active{background-color:", ";}", " ", ""], props => `translate(${props.borderOffset}px, -${props.borderOffset}px)`, props => {
  switch (props.size) {
    case 'large':
    case 'extralarge':
    case 'xlarge':
      return (0,styled_components__WEBPACK_IMPORTED_MODULE_2__.css)(["margin-left:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_5__.get)('space.2'));
    default:
      return (0,styled_components__WEBPACK_IMPORTED_MODULE_2__.css)(["margin-left:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_5__.get)('space.1'));
  }
}, (0,_constants_js__WEBPACK_IMPORTED_MODULE_5__.get)('colors.neutral.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_5__.get)('colors.neutral.subtle'), variants, _sx_js__WEBPACK_IMPORTED_MODULE_6__["default"]);
const RemoveTokenButton = ({
  'aria-label': ariaLabel,
  isParentInteractive,
  size,
  ...rest
}) => {
  delete rest.children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledTokenButton, _extends({
    as: isParentInteractive ? 'span' : 'button',
    tabIndex: isParentInteractive ? -1 : undefined,
    "aria-label": !isParentInteractive ? 'Remove token' : ariaLabel,
    size: size
  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__.XIcon, {
    size: getTokenButtonIconSize(size)
  }));
};
RemoveTokenButton.displayName = "RemoveTokenButton";
RemoveTokenButton.defaultProps = {
  size: _TokenBase_js__WEBPACK_IMPORTED_MODULE_4__.defaultTokenSize
};
var RemoveTokenButton$1 = RemoveTokenButton;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Token/_TokenTextContainer.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Token/_TokenTextContainer.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TokenTextContainer$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);


const TokenTextContainer = styled_components__WEBPACK_IMPORTED_MODULE_0___default()('span').withConfig({
  displayName: "_TokenTextContainer__TokenTextContainer",
  componentId: "sc-6l9eri-0"
})(["flex-grow:1;min-width:0;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;background:transparent;border:none;color:inherit;font:inherit;margin:0;overflow:visible;padding:0;width:auto;-webkit-font-smoothing:inherit;-moz-osx-font-smoothing:inherit;-webkit-appearance:none;line-height:1;color:currentColor;text-decoration:none;&:is(a,button,[tabIndex='0']){cursor:pointer;&:after{content:'';position:absolute;left:0;top:0;right:0;bottom:0;}}"]);
var TokenTextContainer$1 = TokenTextContainer;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/Tooltip.js":
/*!*******************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/Tooltip.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TooltipBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "Tooltip__TooltipBase",
  componentId: "sc-uha8qm-0"
})(["position:relative;&::before{position:absolute;z-index:1000001;display:none;width:0px;height:0px;color:", ";pointer-events:none;content:'';border:6px solid transparent;opacity:0;}&::after{position:absolute;z-index:1000000;display:none;padding:0.5em 0.75em;font:normal normal 11px/1.5 ", ";-webkit-font-smoothing:subpixel-antialiased;color:", ";text-align:center;text-decoration:none;text-shadow:none;text-transform:none;letter-spacing:normal;word-wrap:break-word;white-space:pre;pointer-events:none;content:attr(aria-label);background:", ";border-radius:", ";opacity:0;}@keyframes tooltip-appear{from{opacity:0;}to{opacity:1;}}&:hover,&:active,&:focus{&::before,&::after{display:inline-block;text-decoration:none;animation-name:tooltip-appear;animation-duration:0.1s;animation-fill-mode:forwards;animation-timing-function:ease-in;animation-delay:0.4s;}}&.tooltipped-no-delay:hover,&.tooltipped-no-delay:active,&.tooltipped-no-delay:focus{&::before,&::after{animation-delay:0s;}}&.tooltipped-multiline:hover,&.tooltipped-multiline:active,&.tooltipped-multiline:focus{&::after{display:table-cell;}}&.tooltipped-s,&.tooltipped-se,&.tooltipped-sw{&::after{top:100%;right:50%;margin-top:6px;}&::before{top:auto;right:50%;bottom:-7px;margin-right:-6px;border-bottom-color:", ";}}&.tooltipped-se{&::after{right:auto;left:50%;margin-left:-", ";}}&.tooltipped-sw::after{margin-right:-", ";}&.tooltipped-n,&.tooltipped-ne,&.tooltipped-nw{&::after{right:50%;bottom:100%;margin-bottom:6px;}&::before{top:-7px;right:50%;bottom:auto;margin-right:-6px;border-top-color:", ";}}&.tooltipped-ne{&::after{right:auto;left:50%;margin-left:-", ";}}&.tooltipped-nw::after{margin-right:-", ";}&.tooltipped-s::after,&.tooltipped-n::after{transform:translateX(50%);}&.tooltipped-w{&::after{right:100%;bottom:50%;margin-right:6px;transform:translateY(50%);}&::before{top:50%;bottom:50%;left:-7px;margin-top:-6px;border-left-color:", ";}}&.tooltipped-e{&::after{bottom:50%;left:100%;margin-left:6px;transform:translateY(50%);}&::before{top:50%;right:-7px;bottom:50%;margin-top:-6px;border-right-color:", ";}}&.tooltipped-multiline{&::after{width:max-content;max-width:250px;word-wrap:break-word;white-space:pre-line;border-collapse:separate;}&.tooltipped-s::after,&.tooltipped-n::after{right:auto;left:50%;transform:translateX(-50%);}&.tooltipped-w::after,&.tooltipped-e::after{right:100%;}}&.tooltipped-align-right-2::after{right:0;margin-right:0;}&.tooltipped-align-right-2::before{right:15px;}&.tooltipped-align-left-2::after{left:0;margin-left:0;}&.tooltipped-align-left-2::before{left:10px;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fonts.normal'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.emphasisPlus'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
function Tooltip({
  direction = 'n',
  children,
  className,
  text,
  noDelay,
  align,
  wrap,
  ...rest
}) {
  const classes = classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, `tooltipped-${direction}`, align && `tooltipped-align-${align}-2`, noDelay && 'tooltipped-no-delay', wrap && 'tooltipped-multiline');
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TooltipBase, _extends({
    role: "tooltip",
    "aria-label": text
  }, rest, {
    className: classes
  }), children);
}
Tooltip.displayName = "Tooltip";
Tooltip.alignments = ['left', 'right'];
Tooltip.directions = ['n', 'ne', 'e', 'se', 's', 'sw', 'w', 'nw'];




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/UnderlineNav.js":
/*!************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/UnderlineNav.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UnderlineNav$1)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_getGlobalFocusStyles.js */ "./node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ITEM_CLASS = 'PRC-UnderlineNav-item';
const SELECTED_CLASS = 'PRC-selected';
const UnderlineNavBase = styled_components__WEBPACK_IMPORTED_MODULE_2___default().nav.withConfig({
  displayName: "UnderlineNav__UnderlineNavBase",
  componentId: "sc-1lhwixe-0"
})(["display:flex;justify-content:space-between;border-bottom:1px solid ", ";&.PRC-UnderlineNav--right{justify-content:flex-end;.PRC-UnderlineNav-item{margin-right:0;margin-left:", ";}.PRC-UnderlineNav-actions{flex:1 1 auto;}}&.PRC-UnderlineNav--full{display:block;}.PRC-UnderlineNav-body{display:flex;margin-bottom:-1px;}.PRC-UnderlineNav-actions{align-self:center;}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
function UnderlineNav({
  actions,
  className,
  align,
  children,
  full,
  label,
  theme,
  ...rest
}) {
  const classes = classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'PRC-UnderlineNav', align && `PRC-UnderlineNav--${align}`, full && 'PRC-UnderlineNav--full');
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(UnderlineNavBase, _extends({
    className: classes,
    "aria-label": label,
    theme: theme
  }, rest), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "PRC-UnderlineNav-body"
  }, children), actions && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("div", {
    className: "PRC-UnderlineNav-actions"
  }, actions));
}
UnderlineNav.displayName = "UnderlineNav";
const UnderlineNavLink = styled_components__WEBPACK_IMPORTED_MODULE_2___default().a.attrs(props => ({
  activeClassName: typeof props.to === 'string' ? 'selected' : '',
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(ITEM_CLASS, props.selected && SELECTED_CLASS, props.className)
})).withConfig({
  displayName: "UnderlineNav__UnderlineNavLink",
  componentId: "sc-1lhwixe-1"
})(["padding:", " ", ";margin-right:", ";font-size:", ";line-height:", ";color:", ";text-align:center;border-bottom:2px solid transparent;text-decoration:none;&:hover,&:focus{color:", ";text-decoration:none;border-bottom-color:", ";transition:border-bottom-color 0.2s ease;.PRC-UnderlineNav-octicon{color:", ";}}&.PRC-selected{color:", ";border-bottom-color:", ";.PRC-UnderlineNav-octicon{color:", ";}}", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('lineHeights.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.neutral.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.primer.border.active'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'), (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_5__["default"])('-8px'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
UnderlineNavLink.displayName = 'UnderlineNav.Link';
var UnderlineNav$1 = Object.assign(UnderlineNav, {
  Link: UnderlineNavLink
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/CheckboxOrRadioGroup.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckboxOrRadioGroup$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _ValidationAnimationContainer_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../_ValidationAnimationContainer.js */ "./node_modules/@primer/react/lib-esm/_ValidationAnimationContainer.js");
/* harmony import */ var _CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_CheckboxOrRadioGroupCaption.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js");
/* harmony import */ var _CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_CheckboxOrRadioGroupLabel.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js");
/* harmony import */ var _CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_CheckboxOrRadioGroupValidation.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _CheckboxOrRadioGroupContext_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./_CheckboxOrRadioGroupContext.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupContext.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../_VisuallyHidden.js */ "./node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");













function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Body = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "CheckboxOrRadioGroup__Body",
  componentId: "sc-1qo75yk-0"
})(["display:flex;flex-direction:column;list-style:none;margin:0;padding:0;> * + *{margin-top:", ";}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'));
const CheckboxOrRadioGroup = ({
  'aria-labelledby': ariaLabelledby,
  children,
  disabled,
  id: idProp,
  required,
  sx
}) => {
  const labelChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
  const validationChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_4__["default"] ? child : null);
  const captionChild = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child) && child.type === _CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_5__["default"] ? child : null);
  const id = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_6__.useSSRSafeId)(idProp);
  const validationMessageId = validationChild && `${id}-validationMessage`;
  const captionId = captionChild && `${id}-caption`;
  if (!labelChild && !ariaLabelledby) {
    // eslint-disable-next-line no-console
    console.warn('A choice group must be labelled using a `CheckboxOrRadioGroup.Label` child, or by passing `aria-labelledby` to the CheckboxOrRadioGroup component.');
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_7__.Slots, {
    context: {
      disabled,
      required,
      captionId,
      validationMessageId
    }
  }, slots => {
    const isLegendVisible = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(labelChild) && !labelChild.props.visuallyHidden;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CheckboxOrRadioGroupContext_js__WEBPACK_IMPORTED_MODULE_8__["default"].Provider, {
      value: {
        disabled
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_9__["default"], _extends({
      border: "none",
      margin: 0,
      mb: validationChild ? 2 : undefined,
      padding: 0
    }, labelChild && {
      as: 'fieldset',
      disabled
    }, {
      sx: sx
    }), labelChild ?
    /*#__PURE__*/
    /*
      Placing the caption text and validation text in the <legend> provides a better user
      experience for more screenreaders.
       Reference: https://blog.tenon.io/accessible-validation-of-checkbox-and-radiobutton-groups/
    */
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_9__["default"], {
      as: "legend",
      mb: isLegendVisible ? 2 : undefined,
      padding: 0
    }, slots.Label, slots.Caption, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(slots.Validation) && slots.Validation.props.children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_10__["default"], null, slots.Validation.props.children)) :
    /*
      If CheckboxOrRadioGroup.Label wasn't passed as a child, we don't render a <legend> 
      but we still want to render a caption
    */
    slots.Caption, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Body, !labelChild && {
      ['aria-labelledby']: ariaLabelledby,
      ['aria-describedby']: [validationMessageId, captionId].filter(Boolean).join(' '),
      as: 'div',
      role: 'group'
    }, react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child)))), validationChild && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ValidationAnimationContainer_js__WEBPACK_IMPORTED_MODULE_11__["default"]
    // If we have CheckboxOrRadioGroup.Label as a child, we render a screenreader-accessible validation message in the <legend>
    , {
      "aria-hidden": Boolean(labelChild),
      show: true
    }, slots.Validation)));
  });
};
CheckboxOrRadioGroup.displayName = "CheckboxOrRadioGroup";
CheckboxOrRadioGroup.defaultProps = {
  disabled: false,
  required: false
};
var CheckboxOrRadioGroup$1 = Object.assign(CheckboxOrRadioGroup, {
  Caption: _CheckboxOrRadioGroupCaption_js__WEBPACK_IMPORTED_MODULE_5__["default"],
  Label: _CheckboxOrRadioGroupLabel_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  Validation: _CheckboxOrRadioGroupValidation_js__WEBPACK_IMPORTED_MODULE_4__["default"]
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupCaption.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckboxOrRadioGroupCaption$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js");




const CheckboxOrRadioGroupCaption = ({
  children,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Caption"
}, ({
  disabled,
  captionId
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  color: disabled ? 'fg.muted' : 'fg.subtle',
  fontSize: 1,
  id: captionId,
  sx: sx
}, children));
CheckboxOrRadioGroupCaption.displayName = "CheckboxOrRadioGroupCaption";
var CheckboxOrRadioGroupCaption$1 = CheckboxOrRadioGroupCaption;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupContext.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupContext.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckboxOrRadioGroupContext$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const CheckboxOrRadioGroupContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
var CheckboxOrRadioGroupContext$1 = CheckboxOrRadioGroupContext;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupLabel.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckboxOrRadioGroupLabel$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../_VisuallyHidden.js */ "./node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js");





const CheckboxOrRadioGroupLabel = ({
  children,
  visuallyHidden,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Label"
}, ({
  required,
  disabled
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  isVisible: !visuallyHidden,
  title: required ? 'required field' : undefined,
  sx: {
    display: 'block',
    color: disabled ? 'fg.muted' : undefined,
    fontSize: 2,
    ...sx
  }
}, required ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  display: "flex",
  as: "span"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  mr: 1
}, children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "*")) : children));
CheckboxOrRadioGroupLabel.displayName = "CheckboxOrRadioGroupLabel";
CheckboxOrRadioGroupLabel.defaultProps = {
  visuallyHidden: false
};
var CheckboxOrRadioGroupLabel$1 = CheckboxOrRadioGroupLabel;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/_CheckboxOrRadioGroupValidation.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckboxOrRadioGroupValidation$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InputValidation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../_InputValidation.js */ "./node_modules/@primer/react/lib-esm/_InputValidation.js");
/* harmony import */ var _slots_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./slots.js */ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js");




const CheckboxOrRadioGroupValidation = ({
  children,
  variant,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_slots_js__WEBPACK_IMPORTED_MODULE_1__.Slot, {
  name: "Validation"
}, ({
  validationMessageId = ''
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputValidation_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  validationStatus: variant,
  id: validationMessageId,
  sx: sx
}, children));
CheckboxOrRadioGroupValidation.displayName = "CheckboxOrRadioGroupValidation";
var CheckboxOrRadioGroupValidation$1 = CheckboxOrRadioGroupValidation;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_CheckboxOrRadioGroup/slots.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Slot": () => (/* binding */ Slot),
/* harmony export */   "Slots": () => (/* binding */ Slots)
/* harmony export */ });
/* harmony import */ var _utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/create-slots.js */ "./node_modules/@primer/react/lib-esm/utils/create-slots.js");


const {
  Slots,
  Slot
} = (0,_utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__["default"])(['Caption', 'Label', 'Validation']);




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_InputCaption.js":
/*!*************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_InputCaption.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputCaption$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");



const InputCaption = ({
  children,
  disabled,
  id,
  sx
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  color: disabled ? 'fg.subtle' : 'fg.muted',
  display: "block",
  fontSize: 0,
  id: id,
  sx: sx
}, children);
InputCaption.displayName = "InputCaption";
var InputCaption$1 = InputCaption;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_InputLabel.js":
/*!***********************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_InputLabel.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputLabel$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_VisuallyHidden.js */ "./node_modules/@primer/react/lib-esm/_VisuallyHidden.js");




const InputLabel = ({
  children,
  disabled,
  htmlFor,
  id,
  required,
  visuallyHidden,
  sx,
  as = 'label'
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
    isVisible: !visuallyHidden,
    as: as /* This assertion is clearly wrong, but it's the only way TS will allow the htmlFor prop to be possibly defined */,

    htmlFor: htmlFor,
    id: id,
    sx: {
      fontWeight: 'bold',
      fontSize: 1,
      display: 'block',
      color: disabled ? 'fg.muted' : 'fg.default',
      cursor: disabled ? 'default' : 'pointer',
      alignSelf: 'flex-start',
      ...sx
    }
  }, required ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    display: "flex",
    as: "span"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    mr: 1
  }, children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    "aria-hidden": "true"
  }, "*")) : children);
};
InputLabel.displayName = "InputLabel";
var InputLabel$1 = InputLabel;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_InputValidation.js":
/*!****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_InputValidation.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputValidation$1)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");





const validationIconMap = {
  success: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.CheckCircleFillIcon,
  error: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.AlertFillIcon,
  warning: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.AlertFillIcon
};
const validationColorMap = {
  success: 'success.fg',
  error: 'danger.fg',
  warning: 'attention.fg'
};
const InputValidation = ({
  children,
  id,
  validationStatus,
  sx
}) => {
  const IconComponent = validationStatus ? validationIconMap[validationStatus] : undefined;
  const fgColor = validationStatus ? validationColorMap[validationStatus] : undefined;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    sx: {
      fontSize: 0,
      fontWeight: 'bold',
      alignItems: 'center',
      color: fgColor,
      display: 'flex',
      a: {
        color: 'currentColor',
        textDecoration: 'underline'
      },
      ...sx
    }
  }, IconComponent && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    as: "span",
    mr: 1,
    sx: {
      display: 'flex'
    },
    "aria-hidden": "true"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(IconComponent, {
    size: 12,
    fill: "currentColor"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("span", {
    id: id
  }, children));
};
InputValidation.displayName = "InputValidation";
var InputValidation$1 = InputValidation;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_TextInputInnerAction.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_TextInputInnerAction.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextInputAction$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Button_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Button/index.js */ "./node_modules/@primer/react/lib-esm/Button/index.js");
/* harmony import */ var _Tooltip_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Tooltip.js */ "./node_modules/@primer/react/lib-esm/Tooltip.js");
/* harmony import */ var _Button_IconButton_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Button/IconButton.js */ "./node_modules/@primer/react/lib-esm/Button/IconButton.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const invisibleButtonStyleOverrides = {
  color: 'fg.default',
  paddingTop: '2px',
  paddingRight: '4px',
  paddingBottom: '2px',
  paddingLeft: '4px',
  position: 'relative',
  '@media (pointer: coarse)': {
    ':after': {
      content: '""',
      position: 'absolute',
      left: 0,
      right: 0,
      transform: 'translateY(-50%)',
      top: '50%',
      minHeight: '44px'
    }
  }
};
const ConditionalTooltip = ({
  'aria-label': ariaLabel,
  children
}) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, ariaLabel ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  "aria-label": ariaLabel,
  sx: {
    /* inline-block is used to ensure the tooltip dimensions don't
       collapse when being used with `grid` or `inline` children */
    display: 'inline-block'
  }
}, children) : children);
const TextInputAction = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  'aria-label': ariaLabel,
  children,
  icon,
  sx: sxProp,
  variant,
  ...rest
}, forwardedRef) => {
  const sx = variant === 'invisible' ? deepmerge__WEBPACK_IMPORTED_MODULE_1___default()(invisibleButtonStyleOverrides, sxProp || {}) : sxProp || {};
  if (icon && !ariaLabel || !children && !ariaLabel) {
    // eslint-disable-next-line no-console
    console.warn('Use the `aria-label` prop to provide an accessible label for assistive technology');
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    as: "span",
    className: "TextInput-action",
    margin: 1
  }, icon && !children ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    "aria-label": ariaLabel
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Button_IconButton_js__WEBPACK_IMPORTED_MODULE_4__.IconButton, _extends({
    variant: variant,
    type: "button",
    icon: icon,
    "aria-label": ariaLabel,
    size: "small",
    sx: sx
  }, rest, {
    ref: forwardedRef
  }))) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ConditionalTooltip, {
    "aria-label": ariaLabel
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Button_index_js__WEBPACK_IMPORTED_MODULE_5__.Button, _extends({
    variant: variant,
    size: "small",
    type: "button",
    sx: sx
  }, rest, {
    ref: forwardedRef
  }), children)));
});
TextInputAction.defaultProps = {
  variant: 'invisible'
};
var TextInputAction$1 = TextInputAction;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_TextInputInnerVisualSlot.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_TextInputInnerVisualSlot.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextInputInnerVisualSlot$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");




const TextInputInnerVisualSlot = ({
  children,
  hasLoadingIndicator,
  showLoadingIndicator,
  visualPosition
}) => {
  if (!children && !hasLoadingIndicator || visualPosition === 'leading' && !children && !showLoadingIndicator) {
    return null;
  }
  if (!hasLoadingIndicator) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      className: "TextInput-icon"
    }, children);
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "TextInput-icon"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
    display: "flex",
    position: "relative"
  }, children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
    sx: {
      visibility: showLoadingIndicator ? 'hidden' : 'visible'
    }
  }, children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    sx: children ? {
      position: 'absolute',
      top: 0,
      height: '100%',
      maxWidth: '100%',
      visibility: showLoadingIndicator ? 'visible' : 'hidden',
      ...(visualPosition === 'leading' ? {
        left: 0
      } : {
        right: 0
      })
    } : {
      visibility: showLoadingIndicator ? 'visible' : 'hidden'
    },
    size: children ? undefined : 'small'
  })));
};
TextInputInnerVisualSlot.displayName = "TextInputInnerVisualSlot";
var TextInputInnerVisualSlot$1 = TextInputInnerVisualSlot;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_TextInputWrapper.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_TextInputWrapper.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextInputBaseWrapper": () => (/* binding */ TextInputBaseWrapper),
/* harmony export */   "default": () => (/* binding */ TextInputWrapper$1),
/* harmony export */   "textInputHorizPadding": () => (/* binding */ textInputHorizPadding)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





const sizeDeprecatedVariants = (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  variants: {
    small: {
      minHeight: '28px',
      px: 2,
      py: '3px',
      fontSize: 0,
      lineHeight: '20px'
    },
    large: {
      px: 2,
      py: '10px',
      fontSize: 3
    }
  }
});
const sizeVariants = (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  prop: 'size',
  variants: {
    small: {
      minHeight: '28px',
      px: 2,
      py: '3px',
      fontSize: 0,
      lineHeight: '20px'
    },
    large: {
      px: 2,
      py: '10px',
      fontSize: 3
    }
  }
});
const textInputBasePadding = '12px';
const textInputHorizPadding = textInputBasePadding;
const renderFocusStyles = (hasTrailingAction, isInputFocused) => {
  if (hasTrailingAction) {
    return isInputFocused && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["border-color:", ";outline:none;box-shadow:inset 0 0 0 1px ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'));
  }
  return (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["&:focus-within{border-color:", ";outline:none;box-shadow:inset 0 0 0 1px ", ";}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'));
};
const TextInputBaseWrapper = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "_TextInputWrapper__TextInputBaseWrapper",
  componentId: "sc-apywy2-0"
})(["font-size:", ";line-height:20px;color:", ";vertical-align:middle;background-color:", ";border:1px solid ", ";border-radius:", ";outline:none;box-shadow:", ";display:inline-flex;align-items:stretch;min-height:32px;input,textarea{cursor:text;}select{cursor:pointer;}&::placeholder{color:", ";}", " > textarea{padding:", ";}", " ", " ", " ", " ", " ", " @media (min-width:", "){font-size:", ";}", " ", " ", " ", " ", " ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.primer.shadow.inset'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.subtle'), props => renderFocusStyles(Boolean(props.hasTrailingAction), Boolean(props.isInputFocused)), textInputBasePadding, props => props.contrast && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["background-color:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.inset')), props => props.disabled && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["color:", ";background-color:", ";border-color:", ";input,textarea,select{cursor:not-allowed;}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.primer.fg.disabled'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.input.disabledBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.default')), props => props.monospace && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["font-family:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fonts.mono')), props => props.validationStatus === 'error' && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["border-color:", ";", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.danger.emphasis'), renderFocusStyles(Boolean(props.hasTrailingAction), Boolean(props.isInputFocused))), props => props.validationStatus === 'success' && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["border-color:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.success.emphasis')), props => props.block && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["width:100%;display:flex;align-self:stretch;"]), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('breakpoints.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontSizes.1'), styled_system__WEBPACK_IMPORTED_MODULE_1__.width, styled_system__WEBPACK_IMPORTED_MODULE_1__.minWidth, styled_system__WEBPACK_IMPORTED_MODULE_1__.maxWidth, sizeDeprecatedVariants, sizeVariants, _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const TextInputWrapper = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(TextInputBaseWrapper).withConfig({
  displayName: "_TextInputWrapper__TextInputWrapper",
  componentId: "sc-apywy2-1"
})(["background-repeat:no-repeat;background-position:right 8px center;& >:not(:last-child){margin-right:", ";}.TextInput-icon,.TextInput-action{align-self:center;color:", ";flex-shrink:0;}", " ", " ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.muted'), props => (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["padding-left:", ";padding-right:", ";> input,> select{padding-left:", ";padding-right:", ";}"], props.hasLeadingVisual ? textInputHorizPadding : 0, props.hasTrailingVisual && !props.hasTrailingAction ? textInputHorizPadding : 0, !props.hasLeadingVisual ? textInputHorizPadding : 0, !props.hasTrailingVisual && !props.hasTrailingAction ? textInputHorizPadding : 0), props => props.validationStatus === 'warning' && (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["border-color:", ";", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.attention.emphasis'), renderFocusStyles(Boolean(props.hasTrailingAction), Boolean(props.isInputFocused))), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
var TextInputWrapper$1 = TextInputWrapper;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_UnstyledTextInput.js":
/*!******************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_UnstyledTextInput.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UnstyledTextInput$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");



const UnstyledTextInput = styled_components__WEBPACK_IMPORTED_MODULE_0___default().input.withConfig({
  displayName: "_UnstyledTextInput__UnstyledTextInput",
  componentId: "sc-31b2um-0"
})(["border:0;font-size:inherit;font-family:inherit;background-color:transparent;-webkit-appearance:none;color:inherit;width:100%;&:focus{outline:0;}", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
var UnstyledTextInput$1 = UnstyledTextInput;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/_ValidationAnimationContainer.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/_ValidationAnimationContainer.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ValidationAnimationContainer$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");




const fadeIn = (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.keyframes)(["0%{opacity:0;transform:translateY(-100%);}100%{opacity:1;transform:translateY(0);}"]);
// using easeOutQuint easing fn https://easings.net/#easeOutQuint
const AnimatedElement = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "_ValidationAnimationContainer__AnimatedElement",
  componentId: "sc-1gpqp3g-0"
})(["animation:", ";"], props => props.show && (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["170ms ", " cubic-bezier(0.44,0.74,0.36,1);"], fadeIn));
const ValidationAnimationContainer = ({
  show,
  children
}) => {
  const [shouldRender, setRender] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(show);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (show) setRender(true);
  }, [show]);
  const onAnimationEnd = () => {
    if (!show) setRender(false);
  };
  return shouldRender ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    height: show ? 'auto' : 0,
    overflow: "hidden"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AnimatedElement, {
    show: show,
    onAnimationEnd: onAnimationEnd
  }, children)) : null;
};
var ValidationAnimationContainer$1 = ValidationAnimationContainer;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Divider.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/Divider.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Divider": () => (/* binding */ Divider),
/* harmony export */   "StyledDivider": () => (/* binding */ StyledDivider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");




const StyledDivider = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Divider__StyledDivider",
  componentId: "sc-1s7tlfq-0"
})(["height:1px;background:", ";margin-top:calc(", " - 1px);margin-bottom:", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'));

/**
 * Visually separates `Item`s or `Group`s in an `ActionList`.
 */
function Divider() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledDivider, null);
}
Divider.displayName = "Divider";
/**
 * `Divider` fulfills the `ItemPropsWithCustomRenderer` contract,
 * so it can be used inline in an `ActionList`’s `items` prop.
 * In other words, `items={[ActionList.Divider]}` is supported as a concise
 * alternative to `items={[{renderItem: () => <ActionList.Divider />}]}`.
 */
Divider.renderItem = Divider;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Group.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/Group.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Group": () => (/* binding */ Group)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _Header_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Header.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Header.js");





/**
 * Contract for props passed to the `Group` component.
 */

const StyledGroup = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Group__StyledGroup",
  componentId: "sc-1s2aw76-0"
})(["", ""], _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);

/**
 * Collects related `Items` in an `ActionList`.
 */
function Group({
  header,
  items,
  ...props
}) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledGroup, props, header && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Header_js__WEBPACK_IMPORTED_MODULE_3__.Header, header), items);
}
Group.displayName = "Group";




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Header.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/Header.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Header": () => (/* binding */ Header),
/* harmony export */   "StyledHeader": () => (/* binding */ StyledHeader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");





function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Contract for props passed to the `Header` component.
 */

const StyledHeader = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Header__StyledHeader",
  componentId: "sc-cjezay-0"
})(["{}padding:6px ", ";font-size:", ";font-weight:", ";color:", ";", " ", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontSizes.0'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.muted'), ({
  variant
}) => variant === 'filled' && (0,styled_components__WEBPACK_IMPORTED_MODULE_1__.css)(["background:", ";margin:", " 0;border-top:1px solid ", ";border-bottom:1px solid ", ";&:first-child{margin-top:0;}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.canvas.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.neutral.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.neutral.muted')), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);

/**
 * Displays the name and description of a `Group`.
 */
function Header({
  variant = 'subtle',
  title,
  auxiliaryText,
  children: _children,
  ...props
}) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledHeader, _extends({
    role: "heading",
    variant: variant
  }, props), title, auxiliaryText && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, auxiliaryText));
}
Header.displayName = "Header";




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Item.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/Item.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Item": () => (/* binding */ Item),
/* harmony export */   "TextContainer": () => (/* binding */ TextContainer)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _Truncate_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Truncate.js */ "./node_modules/@primer/react/lib-esm/Truncate.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Header_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Header.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Header.js");
/* harmony import */ var _Divider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Divider.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Divider.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/focus-zone.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");












function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const getItemVariant = (variant = 'default', disabled) => {
  if (disabled) {
    return {
      color: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.primer.fg.disabled'),
      iconColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.primer.fg.disabled'),
      annotationColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.primer.fg.disabled'),
      hoverCursor: 'default'
    };
  }
  switch (variant) {
    case 'danger':
      return {
        color: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.danger.fg'),
        iconColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.danger.fg'),
        annotationColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'),
        hoverCursor: 'pointer',
        hoverBg: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.actionListItem.danger.hoverBg'),
        focusBg: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.actionListItem.danger.activeBg'),
        hoverText: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.actionListItem.danger.hoverText')
      };
    default:
      return {
        color: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.default'),
        iconColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'),
        annotationColor: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'),
        hoverCursor: 'pointer',
        hoverBg: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.actionListItem.default.hoverBg'),
        focusBg: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.actionListItem.default.activeBg')
      };
  }
};
const DividedContent = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Item__DividedContent",
  componentId: "sc-y6iv6t-0"
})(["display:flex;min-width:0;position:relative;flex-grow:1;"]);
const MainContent = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Item__MainContent",
  componentId: "sc-y6iv6t-1"
})(["align-items:baseline;display:flex;min-width:0;flex-direction:var(--main-content-flex-direction);flex-grow:1;"]);
const StyledItem = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Item__StyledItem",
  componentId: "sc-y6iv6t-2"
})(["padding:6px ", ";display:flex;border-radius:", ";color:", ";transition:background 33.333ms linear;text-decoration:none;@media (hover:hover) and (pointer:fine){:hover{background:var( --item-hover-bg-override,", " );color:", ";cursor:", ";}}:not(:first-of-type):not(", " + &):not(", " + &){margin-top:", ";", "::before{content:' ';display:block;position:absolute;width:100%;top:-7px;border:0 solid ", ";border-top-width:", ";}}&:hover ", "::before,:hover + * ", "::before{border-color:var(--item-hover-divider-border-color-override,transparent) !important;}&:focus ", "::before,:focus + * ", "::before,&[", "] ", "::before,[", "] + & ", "::before{border-color:transparent !important;}&[", "='", "']{background:", ";}&[", "='", "']{background:", ";}&:focus{background:", ";outline:none;}&:active{background:", ";}", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).color, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).hoverBg, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).hoverText, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).hoverCursor, _Divider_js__WEBPACK_IMPORTED_MODULE_4__.StyledDivider, _Header_js__WEBPACK_IMPORTED_MODULE_5__.StyledHeader, ({
  showDivider
}) => showDivider ? `1px` : '0', DividedContent, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.muted'), ({
  showDivider
}) => showDivider ? `1px` : '0', DividedContent, DividedContent, DividedContent, DividedContent, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.isActiveDescendantAttribute, DividedContent, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.isActiveDescendantAttribute, DividedContent, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.isActiveDescendantAttribute, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.activeDescendantActivatedDirectly, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).focusBg, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.isActiveDescendantAttribute, _primer_behaviors__WEBPACK_IMPORTED_MODULE_6__.activeDescendantActivatedIndirectly, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).hoverBg, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).focusBg, ({
  variant,
  item
}) => getItemVariant(variant, item === null || item === void 0 ? void 0 : item.disabled).focusBg, _sx_js__WEBPACK_IMPORTED_MODULE_7__["default"]);
const TextContainer = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "Item__TextContainer",
  componentId: "sc-y6iv6t-3"
})([""]);
const BaseVisualContainer = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "Item__BaseVisualContainer",
  componentId: "sc-y6iv6t-4"
})(["height:20px;width:", ";margin-right:", ";display:flex;justify-content:center;align-items:center;flex-shrink:0;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const ColoredVisualContainer = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(BaseVisualContainer).withConfig({
  displayName: "Item__ColoredVisualContainer",
  componentId: "sc-y6iv6t-5"
})(["svg{fill:", ";font-size:", ";}"], ({
  variant,
  disabled
}) => getItemVariant(variant, disabled).iconColor, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.0'));
const LeadingVisualContainer = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(ColoredVisualContainer).withConfig({
  displayName: "Item__LeadingVisualContainer",
  componentId: "sc-y6iv6t-6"
})(["display:flex;flex-direction:column;justify-content:center;"]);
const TrailingContent = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(ColoredVisualContainer).withConfig({
  displayName: "Item__TrailingContent",
  componentId: "sc-y6iv6t-7"
})(["color:", "};margin-left:", ";margin-right:0;width:auto;div:nth-child(2){margin-left:", ";}"], ({
  variant,
  disabled
}) => getItemVariant(variant, disabled).annotationColor, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const DescriptionContainer = styled_components__WEBPACK_IMPORTED_MODULE_2___default().span.withConfig({
  displayName: "Item__DescriptionContainer",
  componentId: "sc-y6iv6t-8"
})(["color:", ";font-size:", ";line-height:16px;margin-left:var(--description-container-margin-left);min-width:0;flex-grow:1;flex-basis:var(--description-container-flex-basis);"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.0'));
const MultiSelectIcon = styled_components__WEBPACK_IMPORTED_MODULE_2___default().svg.withConfig({
  displayName: "Item__MultiSelectIcon",
  componentId: "sc-y6iv6t-9"
})(["rect{fill:", ";stroke:", ";shape-rendering:auto;}path{fill:", ";boxshadow:", ";opacity:", ";}"], ({
  selected
}) => selected ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.fg') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.default'), ({
  selected
}) => selected ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.fg') : (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.onEmphasis'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('shadow.small'), ({
  selected
}) => selected ? 1 : 0);

/**
 * An actionable or selectable `Item` with an optional icon and description.
 */
const Item = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef((itemProps, ref) => {
  const {
    as: Component,
    text,
    description,
    descriptionVariant = 'inline',
    selected,
    selectionVariant,
    leadingVisual: LeadingVisual,
    trailingIcon: TrailingIcon,
    trailingVisual: TrailingVisual,
    trailingText,
    variant = 'default',
    showDivider,
    disabled,
    onAction,
    onKeyPress,
    children,
    onClick,
    id,
    ...props
  } = itemProps;
  const labelId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_8__.useSSRSafeId)();
  const descriptionId = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_8__.useSSRSafeId)();
  const keyPressHandler = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(event => {
    if (disabled) {
      return;
    }
    onKeyPress === null || onKeyPress === void 0 ? void 0 : onKeyPress(event);
    if (!event.defaultPrevented && [' ', 'Enter'].includes(event.key)) {
      onAction === null || onAction === void 0 ? void 0 : onAction(itemProps, event);
    }
  }, [onAction, disabled, itemProps, onKeyPress]);
  const clickHandler = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(event => {
    if (disabled) {
      return;
    }
    onClick === null || onClick === void 0 ? void 0 : onClick(event);
    if (!event.defaultPrevented) {
      onAction === null || onAction === void 0 ? void 0 : onAction(itemProps, event);
    }
  }, [onAction, disabled, itemProps, onClick]);
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_9__.useTheme)();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledItem, _extends({
    ref: ref,
    as: Component,
    tabIndex: disabled ? undefined : -1,
    variant: variant,
    showDivider: showDivider,
    "aria-selected": selected,
    "aria-labelledby": text ? labelId : undefined,
    "aria-describedby": description ? descriptionId : undefined
  }, props, {
    "data-id": id,
    onKeyPress: keyPressHandler,
    onClick: clickHandler
  }), !!selected === selected && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BaseVisualContainer, null, selectionVariant === 'multiple' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(MultiSelectIcon, {
    selected: selected,
    width: "16",
    height: "16",
    viewBox: "0 0 16 16",
    xmlns: "http://www.w3.org/2000/svg",
    "aria-hidden": "true"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("rect", {
    x: "2",
    y: "2",
    width: "12",
    height: "12",
    rx: "4"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement("path", {
    fillRule: "evenodd",
    strokeWidth: "0",
    d: "M4.03231 8.69862C3.84775 8.20646 4.49385 7.77554 4.95539 7.77554C5.41693 7.77554 6.80154 9.85246 6.80154 9.85246C6.80154 9.85246 10.2631 4.314 10.4938 4.08323C10.7246 3.85246 11.8785 4.08323 11.4169 5.00631C11.0081 5.82388 7.26308 11.4678 7.26308 11.4678C7.26308 11.4678 6.80154 12.1602 6.34 11.4678C5.87846 10.7755 4.21687 9.19077 4.03231 8.69862Z"
  }))) : selected && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.CheckIcon, {
    fill: theme === null || theme === void 0 ? void 0 : theme.colors.fg.default
  })), LeadingVisual && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(LeadingVisualContainer, {
    variant: variant,
    disabled: disabled
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(LeadingVisual, null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(DividedContent, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(MainContent, {
    style: {
      '--main-content-flex-direction': descriptionVariant === 'inline' ? 'row' : 'column'
    }
  }, children, text ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TextContainer, {
    id: labelId
  }, text) : null, description ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(DescriptionContainer, {
    id: descriptionId,
    style: {
      '--description-container-margin-left': descriptionVariant === 'inline' ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2')(theme) : 0,
      '--description-container-flex-basis': descriptionVariant === 'inline' ? 0 : 'auto'
    }
  }, descriptionVariant === 'block' ? description : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_Truncate_js__WEBPACK_IMPORTED_MODULE_10__["default"], {
    title: description,
    inline: true,
    maxWidth: "100%"
  }, description)) : null), TrailingVisual ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TrailingContent, {
    variant: variant,
    disabled: disabled
  }, typeof TrailingVisual === 'function' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TrailingVisual, null) : TrailingVisual) : TrailingIcon || trailingText ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TrailingContent, {
    variant: variant,
    disabled: disabled
  }, trailingText, TrailingIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(TrailingIcon, null)) : null));
});
Item.displayName = 'ActionList.Item';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/List.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/List.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "List": () => (/* binding */ List)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Group_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Group.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Group.js");
/* harmony import */ var _Item_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Item.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Item.js");
/* harmony import */ var _Divider_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Divider.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Divider.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/focus-zone.js");








function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/**
 * Asserts that the given value fulfills the `GroupedListProps` contract.
 * @param props A value which fulfills either the `ListPropsBase` or the `GroupedListProps` contract.
 */
function isGroupedListProps(props) {
  return 'groupMetadata' in props;
}

/**
 * Contract for props passed to the `List` component.
 */

const StyledList = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "List__StyledList",
  componentId: "sc-hkz3q0-0"
})(["font-size:", ";line-height:20px;&[", "],&:focus-within{--item-hover-bg-override:none;--item-hover-divider-border-color-override:", ";}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('fontSizes.1'), _primer_behaviors__WEBPACK_IMPORTED_MODULE_3__.hasActiveDescendantAttribute, (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.border.muted'));

/**
 * Returns `sx` prop values for `List` children matching the given `List` style variation.
 * @param variant `List` style variation.
 */
function useListVariant(variant = 'inset') {
  switch (variant) {
    case 'full':
      return {
        headerStyle: {
          paddingX: (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2')
        },
        itemStyle: {
          borderRadius: 0
        }
      };
    default:
      return {
        firstGroupStyle: {
          marginTop: (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2')
        },
        lastGroupStyle: {
          marginBottom: (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2')
        },
        itemStyle: {
          marginX: (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('space.2')
        }
      };
  }
}

/**
 * Lists `Item`s, either grouped or ungrouped, with a `Divider` between each `Group`.
 */
const List = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef((props, forwardedRef) => {
  // Get `sx` prop values for `List` children matching the given `List` style variation.
  const {
    firstGroupStyle,
    lastGroupStyle,
    headerStyle,
    itemStyle
  } = useListVariant(props.variant);

  /**
   * Render a `Group` using the first of the following renderers that is defined:
   * A `Group`-level or `List`-level custom `Group` renderer, or
   * the default `Group` renderer.
   */
  const renderGroup = groupProps => {
    var _ref;
    const GroupComponent = ((_ref = 'renderGroup' in groupProps && groupProps.renderGroup) !== null && _ref !== void 0 ? _ref : props.renderGroup) || _Group_js__WEBPACK_IMPORTED_MODULE_4__.Group;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GroupComponent, _extends({}, groupProps, {
      key: groupProps.groupId
    }));
  };

  /**
   * Render an `Item` using the first of the following renderers that is defined:
   * An `Item`-level, `Group`-level, or `List`-level custom `Item` renderer,
   * or the default `Item` renderer.
   */
  const renderItem = (itemProps, item, itemIndex) => {
    var _ref2, _ref3, _itemProps$id;
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    const ItemComponent = 'renderItem' in itemProps && itemProps.renderItem || props.renderItem || _Item_js__WEBPACK_IMPORTED_MODULE_5__.Item;
    const key = (_ref2 = (_ref3 = 'key' in itemProps ? itemProps.key : undefined) !== null && _ref3 !== void 0 ? _ref3 : (_itemProps$id = itemProps.id) === null || _itemProps$id === void 0 ? void 0 : _itemProps$id.toString()) !== null && _ref2 !== void 0 ? _ref2 : itemIndex.toString();
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ItemComponent, _extends({
      showDivider: props.showItemDividers,
      selectionVariant: props.selectionVariant
    }, itemProps, {
      key: key,
      sx: {
        ...itemStyle,
        ...itemProps.sx
      },
      item: item
    }));
  };

  /**
   * An array of `Group`s, each with an associated `Header` and with an array of `Item`s belonging to that `Group`.
   */
  let groups = [];

  // Collect rendered `Item`s into `Group`s, avoiding excess iteration over the lists of `items` and `groupMetadata`:
  if (!isGroupedListProps(props)) {
    // When no `groupMetadata`s is provided, collect rendered `Item`s into a single anonymous `Group`.
    groups = [{
      items: props.items.map((item, index) => renderItem(item, item, index)),
      groupId: '0'
    }];
  } else {
    // When `groupMetadata` is provided, collect rendered `Item`s into their associated `Group`s.

    /**
     * A map of group identifiers to `Group`s, each with an associated array of `Item`s belonging to that `Group`.
     */
    const groupMap = props.groupMetadata.reduce((groupAccumulator, groupMetadata) => groupAccumulator.set(groupMetadata.groupId, groupMetadata), new Map());
    for (const itemProps of props.items) {
      var _group$items$length, _group$items, _group$items2;
      // Look up the group associated with the current item.
      const group = groupMap.get(itemProps.groupId);
      const itemIndex = (_group$items$length = group === null || group === void 0 ? void 0 : (_group$items = group.items) === null || _group$items === void 0 ? void 0 : _group$items.length) !== null && _group$items$length !== void 0 ? _group$items$length : 0;

      // Upsert the group to include the current item (rendered).
      groupMap.set(itemProps.groupId, {
        ...group,
        items: [...((_group$items2 = group === null || group === void 0 ? void 0 : group.items) !== null && _group$items2 !== void 0 ? _group$items2 : []), renderItem({
          showDivider: group === null || group === void 0 ? void 0 : group.showItemDividers,
          ...(group && 'renderItem' in group && {
            renderItem: group.renderItem
          }),
          ...itemProps
        }, itemProps, itemIndex)]
      });
    }
    groups = [...groupMap.values()];
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledList, _extends({}, props, {
    ref: forwardedRef
  }), groups.map(({
    header,
    ...groupProps
  }, index) => {
    const hasFilledHeader = (header === null || header === void 0 ? void 0 : header.variant) === 'filled';
    const shouldShowDivider = index > 0 && !hasFilledHeader;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), {
      key: groupProps.groupId
    }, shouldShowDivider ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Divider_js__WEBPACK_IMPORTED_MODULE_6__.Divider, {
      key: `${groupProps.groupId}-divider`
    }) : null, renderGroup({
      sx: {
        ...(index === 0 && firstGroupStyle),
        ...(index === groups.length - 1 && lastGroupStyle),
        ...(index > 0 && !shouldShowDivider && {
          mt: 2
        })
      },
      ...(header && {
        header: {
          ...header,
          sx: {
            ...headerStyle,
            ...header.sx
          }
        }
      }),
      ...groupProps
    }));
  }));
});
List.displayName = 'ActionList';




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/ActionList/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionList": () => (/* binding */ ActionList)
/* harmony export */ });
/* harmony import */ var _List_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./List.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/List.js");
/* harmony import */ var _Group_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Group.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Group.js");
/* harmony import */ var _Item_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Item.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Item.js");
/* harmony import */ var _Divider_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Divider.js */ "./node_modules/@primer/react/lib-esm/deprecated/ActionList/Divider.js");





/**
 * @deprecated Use ActionList with composable API instead. See https://primer.style/react/ActionList for more details.
 */
const ActionList = Object.assign(_List_js__WEBPACK_IMPORTED_MODULE_0__.List, {
  /** Collects related `Items` in an `ActionList`. */
  Group: _Group_js__WEBPACK_IMPORTED_MODULE_1__.Group,
  /** An actionable or selectable `Item` with an optional icon and description. */
  Item: _Item_js__WEBPACK_IMPORTED_MODULE_2__.Item,
  /** Visually separates `Item`s or `Group`s in an `ActionList`. */
  Divider: _Divider_js__WEBPACK_IMPORTED_MODULE_3__.Divider
});




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/Button/ButtonClose.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/Button/ButtonClose.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ButtonClose$1)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StyledButton = styled_components__WEBPACK_IMPORTED_MODULE_2___default().button.withConfig({
  displayName: "ButtonClose__StyledButton",
  componentId: "sc-azdk6r-0"
})(["border:none;padding:0;background:transparent;cursor:pointer;border-radius:", ";color:", ";&:focus{outline:solid 2px ", ";}&:hover{color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.accent.fg'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const ButtonClose = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)((props, ref) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(StyledButton, _extends({
    ref: ref,
    "aria-label": "Close"
  }, props), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.XIcon, null));
});
var ButtonClose$1 = ButtonClose;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/deprecated/DropdownMenu/DropdownButton.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/deprecated/DropdownMenu/DropdownButton.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownButton": () => (/* binding */ DropdownButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?9a67");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button_Button_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button/Button.js */ "./node_modules/@primer/react/lib-esm/deprecated/Button/Button.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../StyledOcticon.js */ "./node_modules/@primer/react/lib-esm/StyledOcticon.js");





function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/**
 * @deprecated Use Button with Octicons instead. See https://primer.style/react/drafts/Button2#appending-an-icon for more details.
 */
const DropdownButton = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  children,
  ...props
}, ref) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Button_Button_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
  ref: ref,
  type: "button"
}, props), children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_StyledOcticon_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__.TriangleDownIcon,
  sx: {
    ml: 1
  }
})));




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/InlineAutocomplete.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/InlineAutocomplete.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InlineAutocomplete$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Portal_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Portal/index.js */ "./node_modules/@primer/react/lib-esm/Portal/index.js");
/* harmony import */ var _utils_character_coordinates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/character-coordinates.js */ "./node_modules/@primer/react/lib-esm/drafts/utils/character-coordinates.js");
/* harmony import */ var _hooks_useSyntheticChange_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useSyntheticChange.js */ "./node_modules/@primer/react/lib-esm/drafts/hooks/useSyntheticChange.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils.js */ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/utils.js");
/* harmony import */ var _AutocompleteSuggestions_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_AutocompleteSuggestions.js */ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/_AutocompleteSuggestions.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");









const getSelectionStart = element => {
  try {
    return element.selectionStart;
  } catch (e) {
    // Safari throws an exception when trying to access selectionStart on date input element
    if (e instanceof TypeError) return null;
    throw e;
  }
};
const noop = () => {
  // don't do anything
};

/**
 * Shows suggestions to complete the current word/phrase the user is actively typing.
 */
const InlineAutocomplete = ({
  triggers,
  suggestions,
  onShowSuggestions,
  onHideSuggestions,
  sx,
  children,
  tabInsertsSuggestions = false,
  // Forward accessibility props so it works with FormControl
  ...forwardProps
}) => {
  var _children$ref, _externalInput$props$, _getSelectionStart;
  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_1__.useRefObjectAsForwardedRef)((_children$ref = children.ref) !== null && _children$ref !== void 0 ? _children$ref : noop, inputRef);
  const externalInput = (0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.requireChildrenToBeInput)(children, inputRef);
  const emitSyntheticChange = (0,_hooks_useSyntheticChange_js__WEBPACK_IMPORTED_MODULE_3__.useSyntheticChange)({
    inputRef,
    fallbackEventHandler: (_externalInput$props$ = externalInput.props.onChange) !== null && _externalInput$props$ !== void 0 ? _externalInput$props$ : noop
  });

  /** Stores the query that caused the current suggestion list to appear. */
  const showEventRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const suggestionsVisible = suggestions !== null && suggestions.length > 0;

  // The suggestions don't usually move while open, so it seems as though this could be
  // optimized by only re-rendering when suggestionsVisible changes. However, the user
  // could move the cursor to a different location using arrow keys and then type a
  // trigger, which would move the suggestions without closing/reopening them.
  const triggerCharCoords = inputRef.current && showEventRef.current && suggestionsVisible ? (0,_utils_character_coordinates_js__WEBPACK_IMPORTED_MODULE_4__.getAbsoluteCharacterCoordinates)(inputRef.current, ((_getSelectionStart = getSelectionStart(inputRef.current)) !== null && _getSelectionStart !== void 0 ? _getSelectionStart : 0) - showEventRef.current.query.length) : {
    top: 0,
    left: 0,
    height: 0
  };
  const suggestionsOffset = {
    top: triggerCharCoords.top + triggerCharCoords.height,
    left: triggerCharCoords.left
  };

  // User can blur while suggestions are visible with shift+tab
  const onBlur = () => {
    onHideSuggestions();
  };

  // Even though the overlay has an Escape listener, it only works when focus is inside
  // the overlay; in this case the textarea is focused
  const onKeyDown = event => {
    if (suggestionsVisible && event.key === 'Escape') {
      onHideSuggestions();
      event.stopPropagation();
    }
  };
  const onChange = event => {
    const selectionStart = getSelectionStart(event.currentTarget);
    if (selectionStart === null) {
      onHideSuggestions();
      return;
    }
    showEventRef.current = (0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.calculateSuggestionsQuery)(triggers, event.currentTarget.value, selectionStart);
    if (showEventRef.current) {
      onShowSuggestions(showEventRef.current);
    } else {
      onHideSuggestions();
    }
  };
  const onCommit = suggestion => {
    var _getSelectionStart2, _trigger$keepTriggerC;
    if (!inputRef.current || !showEventRef.current) return;
    const {
      query,
      trigger
    } = showEventRef.current;
    const currentCaretPosition = (_getSelectionStart2 = getSelectionStart(inputRef.current)) !== null && _getSelectionStart2 !== void 0 ? _getSelectionStart2 : 0;
    const deleteLength = query.length + trigger.triggerChar.length;
    const startIndex = currentCaretPosition - deleteLength;
    const keepTriggerChar = (_trigger$keepTriggerC = trigger.keepTriggerCharOnCommit) !== null && _trigger$keepTriggerC !== void 0 ? _trigger$keepTriggerC : true;
    const maybeTriggerChar = keepTriggerChar ? trigger.triggerChar : '';
    const replacement = `${maybeTriggerChar}${suggestion} `;
    emitSyntheticChange(replacement, [startIndex, startIndex + deleteLength]);
    onHideSuggestions();
  };
  const input = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(externalInput, {
    ...forwardProps,
    onBlur: (0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.augmentHandler)(externalInput.props.onBlur, onBlur),
    onKeyDown: (0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.augmentHandler)(externalInput.props.onKeyDown, onKeyDown),
    onChange: (0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.augmentHandler)(externalInput.props.onChange, onChange),
    ref: inputRef
  });

  /**
   * Even thoughn we apply all the aria attributes, screen readers don't fully support this
   * dynamic use case and so they don't have a native way to indicate to the user when
   * there are suggestions available. So we use some hidden text with aria-live to politely
   * indicate what's available and how to use it.
   *
   * This text should be consistent and the important info should be first, because users
   * will hear it as they type - if they have heard the message before they should be able
   * to recognize it and quickly apply the first suggestion without listening to the rest
   * of the message.
   *
   * When screen reader users navigate using arrow keys, the `aria-activedescendant` will
   * change and will be read out so we don't need to handle that interaction here.
   */
  const suggestionsDescription = !suggestionsVisible ? '' : suggestions === 'loading' ? 'Loading autocomplete suggestions…' :
  // It's important to include both Enter and Tab because we are telling the user that we are hijacking these keys:
  `${suggestions.length} autocomplete ${suggestions.length === 1 ? 'suggestion' : 'suggestions'} available; "${(0,_utils_js__WEBPACK_IMPORTED_MODULE_2__.getSuggestionValue)(suggestions[0])}" is highlighted. Press ${tabInsertsSuggestions ? 'Enter or Tab' : 'Enter'} to insert.`;
  return (
    /*#__PURE__*/
    // Try to get as close as possible to making the container 'invisible' by making it shrink tight to child input
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sx: {
        display: 'inline-block',
        '& > *': {
          width: '100%'
        },
        ...sx,
        position: 'relative'
      }
    }, input, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AutocompleteSuggestions_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
      suggestions: suggestions,
      inputRef: inputRef,
      onCommit: onCommit,
      onClose: onHideSuggestions,
      top: suggestionsOffset.top,
      left: suggestionsOffset.left,
      visible: suggestionsVisible,
      tabInsertsSuggestions: tabInsertsSuggestions
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Portal_index_js__WEBPACK_IMPORTED_MODULE_7__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      "aria-live": "assertive",
      "aria-atomic": true,
      style: {
        clipPath: 'circle(0)',
        position: 'absolute'
      }
    }, suggestionsDescription)))
  );
};
InlineAutocomplete.displayName = "InlineAutocomplete";
var InlineAutocomplete$1 = InlineAutocomplete;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/_AutocompleteSuggestions.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/_AutocompleteSuggestions.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AutocompleteSuggestions$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _ActionList_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../ActionList/index.js */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _hooks_useCombobox_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../hooks/useCombobox.js */ "./node_modules/@primer/react/lib-esm/drafts/hooks/useCombobox.js");
/* harmony import */ var _Overlay_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Overlay.js */ "./node_modules/@primer/react/lib-esm/Overlay.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils.js */ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/utils.js");








const LoadingIndicator = () => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  sx: {
    display: 'flex',
    justifyContent: 'center',
    py: 2
  }
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  size: "small"
}));
LoadingIndicator.displayName = "LoadingIndicator";
const SuggestionListItem = ({
  suggestion
}) => {
  const value = (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.getSuggestionValue)(suggestion);
  const sharedProps = {
    id: value,
    children: value,
    role: 'option',
    sx: {
      '&[aria-selected]': {
        backgroundColor: 'actionListItem.default.activeBg'
      },
      '&[data-combobox-option-default]:not([aria-selected])': {
        backgroundColor: 'actionListItem.default.selectedBg'
      }
    }
  };
  return typeof suggestion === 'string' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_4__.ActionList.Item, sharedProps) : suggestion.render(sharedProps);
};

/**
 * Renders an overlayed list at the given relative coordinates. Handles keyboard navigation
 * and accessibility concerns.
 */
const AutocompleteSuggestions = ({
  suggestions,
  portalName,
  top,
  left,
  onClose,
  onCommit: externalOnCommit,
  inputRef,
  visible,
  tabInsertsSuggestions
}) => {
  // It seems wierd to use state instead of a ref here, but because the list is inside an
  // AnchoredOverlay it is not always mounted - so we want to reinitialize the Combobox when it mounts
  const [list, setList] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const onCommit = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(({
    option
  }) => {
    externalOnCommit((0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.getSuggestionValue)(option));
  }, [externalOnCommit]);

  // Setup keyboard navigation
  (0,_hooks_useCombobox_js__WEBPACK_IMPORTED_MODULE_5__.useCombobox)({
    // Even though the list is visible when loading, we don't want to do keyboard binding in that case
    isOpen: visible && suggestions !== 'loading',
    listElement: list,
    inputElement: inputRef.current,
    onCommit,
    options: Array.isArray(suggestions) ? suggestions : [],
    tabInsertsSuggestions,
    defaultFirstOption: true
  });

  // Conditional rendering appears wrong at first - it means that we are reconstructing the
  // Combobox instance every time the suggestions appear. But this is what we want - otherwise
  // the textarea would always have the `combobox` role, which is incorrect (a textarea should
  // not technically ever be a combobox). We compromise by dynamically applying the combobox
  // role only when suggestions are available.
  return visible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Overlay_js__WEBPACK_IMPORTED_MODULE_6__["default"], {
    onEscape: onClose,
    onClickOutside: onClose,
    returnFocusRef: inputRef,
    preventFocusOnOpen: true,
    portalContainerName: portalName,
    sx: {
      position: 'fixed'
    },
    top,
    left
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_4__.ActionList, {
    ref: setList
  }, suggestions === 'loading' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LoadingIndicator, null) : suggestions === null || suggestions === void 0 ? void 0 : suggestions.map(suggestion => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SuggestionListItem, {
    suggestion: suggestion,
    key: (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.getSuggestionKey)(suggestion)
  })))) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
};
AutocompleteSuggestions.displayName = 'SuggestionList';
var AutocompleteSuggestions$1 = AutocompleteSuggestions;




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/utils.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/InlineAutocomplete/utils.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "augmentHandler": () => (/* binding */ augmentHandler),
/* harmony export */   "calculateSuggestionsQuery": () => (/* binding */ calculateSuggestionsQuery),
/* harmony export */   "getSuggestionKey": () => (/* binding */ getSuggestionKey),
/* harmony export */   "getSuggestionValue": () => (/* binding */ getSuggestionValue),
/* harmony export */   "requireChildrenToBeInput": () => (/* binding */ requireChildrenToBeInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const singleWordTriggerTerminators = new Set([' ', '\n']);
const multiWordTriggerTerminators = new Set(['.', '\n']);
const isWhitespace = char => /\s/.test(char);

/**
 * Calculate whether or not suggestions should be shown based on the given state of the
 * input. If they should be shown, returns the show event.
 */
const calculateSuggestionsQuery = (triggers, text, caretLocation) => {
  // Build backwards from the caret location until the most recent trigger character or terminator
  for (let i = caretLocation - 1, query = '', potentialTriggers = triggers; i >= 0 && potentialTriggers.length > 0; i--) {
    const character = text[i];
    if (singleWordTriggerTerminators.has(character)) potentialTriggers = potentialTriggers.filter(t => t.multiWord);
    if (multiWordTriggerTerminators.has(character)) potentialTriggers = potentialTriggers.filter(t => !t.multiWord);
    for (const trigger of potentialTriggers.filter(t => character === t.triggerChar)) {
      // Trigger chars must always be preceded by whitespace or be the first character in the input,
      // and even a multi-word query cannot start with whitespace
      if ((i === 0 || isWhitespace(text[i - 1])) && !isWhitespace(query[0])) return {
        trigger,
        query
      };
      potentialTriggers = potentialTriggers.filter(t => t !== trigger);
    }
    query = character + query;
  }
  return null;
};
const getSuggestionValue = suggestion => typeof suggestion === 'string' ? suggestion : suggestion.value;
const getSuggestionKey = suggestion => {
  var _suggestion$key;
  return typeof suggestion === 'string' ? suggestion : (_suggestion$key = suggestion.key) !== null && _suggestion$key !== void 0 ? _suggestion$key : suggestion.value;
};

/**
 * Attempts to assert that the child element is of a supported type. This can't be enforced
 * by the type system so it has to be done as a runtime check. This isn't foolproof - a
 * component that forwards a ref to a correct element but does not forward event handlers
 * will not work. But it's the best we can reasonably do.
 */
function requireChildrenToBeInput(child, childRef) {
  react__WEBPACK_IMPORTED_MODULE_0__.Children.only(child); // Assert that the child is lonely
  if (
  // There is no way to know what type the underlying child is until it mounts, so this
  // will always pass on first render before failing on the second render
  childRef.current && !(childRef.current instanceof HTMLInputElement) && !(childRef.current instanceof HTMLTextAreaElement)) {
    throw new TypeError(`AutocompleteTextarea child must be a component that forwards a ref and props to an <input> or <textarea> element.`);
  }
  return child;
}

/**
 * Combine several event handlers into one. The last handler in the list is called first
 * and no further handlers will be called if `event.preventDefault()` is called.
 */
const augmentHandler = (...handlers) => event => {
  for (const handler of [...handlers].reverse()) {
    if (!event.isDefaultPrevented()) handler === null || handler === void 0 ? void 0 : handler(event);
  }
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/hooks/useCombobox.js":
/*!************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/hooks/useCombobox.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useCombobox": () => (/* binding */ useCombobox)
/* harmony export */ });
/* harmony import */ var _github_combobox_nav__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @github/combobox-nav */ "./node_modules/@github/combobox-nav/dist/index.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);




/**
 * Lightweight hook wrapper around the GitHub `Combobox` class from `@github/combobox-nav`.
 * With this hook, keyboard navigation through suggestions is automatically handled and
 * accessibility attributes are added.
 *
 * `useCombobox` will set nearly all necessary attributes by effect, but you **must** set
 * `role="option"` on list items in order for them to be 'seen' by the combobox. Style the
 * currently highlighted option with the `[aria-selected="true"]` selector.
 */
const useCombobox = ({
  isOpen,
  listElement: list,
  inputElement: input,
  onCommit: externalOnCommit,
  options,
  tabInsertsSuggestions = false,
  defaultFirstOption = false
}) => {
  const id = (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_2__.useSSRSafeId)();
  const optionIdPrefix = `combobox-${id}__option`;
  const isOpenRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(isOpen);
  const [comboboxInstance, setComboboxInstance] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  /** Get all option element instances. */
  const getOptionElements = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    var _list$querySelectorAl;
    return [...((_list$querySelectorAl = list === null || list === void 0 ? void 0 : list.querySelectorAll('[role=option]')) !== null && _list$querySelectorAl !== void 0 ? _list$querySelectorAl : [])];
  }, [list]);
  const onCommit = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(e => {
    const nativeEvent = e;
    const indexAttr = nativeEvent.target.getAttribute('data-combobox-list-index');
    const index = indexAttr !== null ? parseInt(indexAttr, 10) : NaN;
    const option = options[index];
    if (option) externalOnCommit({
      nativeEvent,
      option
    });
  }, [options, externalOnCommit]);

  // Prevent focus leaving the input when clicking an item
  const onOptionMouseDown = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(e => e.preventDefault(), []);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function initializeComboboxInstance() {
    if (input && list) {
      if (!list.getAttribute('role')) list.setAttribute('role', 'listbox');
      const cb = new _github_combobox_nav__WEBPACK_IMPORTED_MODULE_0__["default"](input, list, {
        tabInsertsSuggestions,
        defaultFirstOption
      });
      if (isOpenRef.current) cb.start();

      // By using state instead of a ref here, we trigger the toggleKeyboardEventHandling
      // effect. Otherwise we'd have to depend on isOpen in this effect to start the instance
      // if it's initially open
      setComboboxInstance(cb);
      return () => {
        cb.destroy();
        setComboboxInstance(null);
      };
    }
  }, [input, list, tabInsertsSuggestions, defaultFirstOption]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function toggleKeyboardEventHandling() {
    const wasOpen = isOpenRef.current;
    isOpenRef.current = isOpen;
    if (isOpen === wasOpen || !comboboxInstance) return;
    if (isOpen) {
      comboboxInstance.start();
    } else {
      comboboxInstance.stop();
    }
  }, [isOpen, comboboxInstance]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function bindCommitEvent() {
    list === null || list === void 0 ? void 0 : list.addEventListener('combobox-commit', onCommit);
    return () => list === null || list === void 0 ? void 0 : list.removeEventListener('combobox-commit', onCommit);
  }, [onCommit, list]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect)(() => {
    const optionElements = getOptionElements();
    // Ensure each option has a unique ID (required by the Combobox class), but respect user provided IDs
    for (const [i, option] of optionElements.entries()) {
      if (!option.id || option.id.startsWith(optionIdPrefix)) option.id = `${optionIdPrefix}-${i}`;
      option.setAttribute('data-combobox-list-index', i.toString());
      option.addEventListener('mousedown', onOptionMouseDown);
      // the combobox class has a bug where it resets the default on navigate, but not on clearSelection
      option.removeAttribute('data-combobox-option-default');
    }
    comboboxInstance === null || comboboxInstance === void 0 ? void 0 : comboboxInstance.clearSelection();
    return () => {
      for (const option of optionElements) option.removeEventListener('mousedown', onOptionMouseDown);
    };
  }, [getOptionElements, optionIdPrefix, options, comboboxInstance, onOptionMouseDown]);
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/hooks/useSyntheticChange.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/hooks/useSyntheticChange.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useSyntheticChange": () => (/* binding */ useSyntheticChange)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const calculateNewCaretPosition = (originalCaretPosition, replaceRange, insertLength) => {
  const deleteLength = replaceRange[1] - replaceRange[0];
  const lengthDifference = insertLength - deleteLength;

  // If caret is before the replacement, position is unaffected. If it is at/in the replacement
  // section, move it to the end (as though the user had selected text and typed
  // the replacement). If it is after the replacement, move it by the length difference.
  return originalCaretPosition < replaceRange[0] ? originalCaretPosition : originalCaretPosition < replaceRange[1] ? replaceRange[0] + insertLength : originalCaretPosition + lengthDifference;
};

/**
 * Builds a fake `React.ChangeEvent` from a dispatched `InputEvent` instance.
 * This is only used as a fallback in cases where browsers don't support `execCommand`.
 */
const SyntheticChangeEvent = (dispatchedEvent, target) => ({
  // Spreading the event is particularly imperfect. Functions called on the `SyntheticEvent`
  // will have the wrong `this` binding and shallow object properties may fall out of sync.
  // We consider this acceptable since this is only the fallback behavior, but it's not ideal by any means.
  ...dispatchedEvent,
  nativeEvent: dispatchedEvent,
  target,
  // `currentTarget` is the element that the event listener is attached to. The event
  // doesn't know this, so `event.currentTarget` is `null`.
  currentTarget: target,
  preventDefault: () => dispatchedEvent.preventDefault(),
  isDefaultPrevented: () => dispatchedEvent.defaultPrevented,
  // This event doesn't bubble anyway so there's no need for the consumer to try to
  // stop propagation
  isPropagationStopped: () => false,
  // "As of v17, e.persist() doesn’t do anything because the SyntheticEvent is no
  // longer pooled" -  https://reactjs.org/docs/events.html#overview
  persist: () => (
    /* noop */
  {})
});
/**
 * Returns a function that will synthetically change the input, attempting to maintain caret
 * position and undo history as though the user had typed using a keyboard.
 *
 * Will first attempt to use the non-standard browser `execCommmand` API to simulate a typing
 * action. Failing this (ie, in test environments or certain browsers), the fallback handler
 * will be called with a fake constructed `ChangeEvent` that looks like a real event.
 */
const useSyntheticChange = ({
  inputRef,
  fallbackEventHandler
}) => (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((insertValue, replaceRange_, newSelection_) => {
  var _input$selectionStart, _input$selectionEnd, _input$selectionStart2;
  const input = inputRef.current;
  if (!input) return;
  input.focus(); // the input must be focused to execute execCommand

  const replaceRange = replaceRange_ !== null && replaceRange_ !== void 0 ? replaceRange_ : [(_input$selectionStart = input.selectionStart) !== null && _input$selectionStart !== void 0 ? _input$selectionStart : input.value.length, (_input$selectionEnd = input.selectionEnd) !== null && _input$selectionEnd !== void 0 ? _input$selectionEnd : input.value.length];
  const newSelectionStart = newSelection_ === undefined ? calculateNewCaretPosition((_input$selectionStart2 = input.selectionStart) !== null && _input$selectionStart2 !== void 0 ? _input$selectionStart2 : input.value.length, replaceRange, insertValue.length) : Array.isArray(newSelection_) ? newSelection_[0] : newSelection_;
  const newSelectionEnd = Array.isArray(newSelection_) ? newSelection_[1] : newSelectionStart;

  // execCommmand simulates the user actually typing the value into the input. This preserves the undo history,
  // but it's a deprecated API and there's no alternative. It also doesn't work in test environments
  let execCommandResult = false;
  try {
    // expand selection to the whole range and replace it with the new value
    input.setSelectionRange(replaceRange[0], replaceRange[1]);
    execCommandResult = insertValue === '' ? document.execCommand('delete', false) : document.execCommand('insertText', false, insertValue);
    input.setSelectionRange(newSelectionStart, newSelectionEnd);
  } catch (e) {
    execCommandResult = false;
  }

  // If the execCommand method failed, call onChange instead - will nuke the undo history :(
  if (!execCommandResult) {
    const newValue = input.value.slice(0, replaceRange[0]) + insertValue + input.value.slice(replaceRange[1]);

    // When building the event we could also define the inputType and data, but that would
    // be complex for the consumer to maintain. For now that's not functionality that is
    // strictly necessary.
    // React SyntheticChangeEvents are actually built around 'input' events, not 'change' events
    const event = new InputEvent('input', {
      bubbles: false
    });
    inputRef.current.value = newValue;
    inputRef.current.setSelectionRange(newSelectionStart, newSelectionEnd);

    // Even though we call onChange manually, we must dispatch the event so the browser can
    // set its `target` and fully create it
    inputRef.current.dispatchEvent(event);

    // Surprisingly, dispatching the event does not cause React to call handlers, even
    // though it looks almost exactly like a normal 'input' event. Maybe it's because the
    // event is not trusted? So we have to build and dispatch the `SyntheticEvent` ourselves.
    // This is not perfect but it gets pretty close.
    fallbackEventHandler(SyntheticChangeEvent(event, inputRef.current));
  }
}, [inputRef, fallbackEventHandler]);




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/drafts/utils/character-coordinates.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/drafts/utils/character-coordinates.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getAbsoluteCharacterCoordinates": () => (/* binding */ getAbsoluteCharacterCoordinates),
/* harmony export */   "getCharacterCoordinates": () => (/* binding */ getCharacterCoordinates),
/* harmony export */   "getScrollAdjustedCharacterCoordinates": () => (/* binding */ getScrollAdjustedCharacterCoordinates)
/* harmony export */ });
// Note that some browsers, such as Firefox, do not concatenate properties
// into their shorthand (e.g. padding-top, padding-bottom etc. -> padding),
// so we have to list every single property explicitly.
const propertiesToCopy = ['direction',
// RTL support
'boxSizing', 'width',
// on Chrome and IE, exclude the scrollbar, so the mirror div wraps exactly as the textarea does
'height', 'overflowX', 'overflowY',
// copy the scrollbar for IE

'borderTopWidth', 'borderRightWidth', 'borderBottomWidth', 'borderLeftWidth', 'borderStyle', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft',
// https://developer.mozilla.org/en-US/docs/Web/CSS/font
'fontStyle', 'fontVariant', 'fontWeight', 'fontStretch', 'fontSize', 'fontSizeAdjust', 'lineHeight', 'fontFamily', 'textAlign', 'textTransform', 'textIndent', 'textDecoration',
// might not make a difference, but better be safe

'letterSpacing', 'wordSpacing', 'tabSize', 'MozTabSize' // prefixed version for Firefox <= 52
];

/**
 * Obtain the coordinates (px) of the bottom left of a character in an input, relative to the
 * top-left corner of the interior of the input (not adjusted for scroll).
 *
 * Adapted from https://github.com/koddsson/textarea-caret-position, which was itself
 * forked from https://github.com/component/textarea-caret-position.
 *
 * @param element The target input element.
 * @param index The index of the character to calculate.
 */
function getCharacterCoordinates(element, index) {
  const isFirefox = ('mozInnerScreenX' in window);

  // The mirror div will replicate the textarea's style
  const div = document.createElement('div');
  div.id = 'input-textarea-caret-position-mirror-div';
  document.body.appendChild(div);
  const style = div.style;
  const computed = window.getComputedStyle(element);

  // Lineheight is either a number or the string 'normal'. In that case, fall back to a
  // rough guess of 1.2 based on MDN: "Desktop browsers use a default value of roughly 1.2".
  const lineHeight = isNaN(parseInt(computed.lineHeight)) ? parseInt(computed.fontSize) * 1.2 : parseInt(computed.lineHeight);
  const isInput = element instanceof HTMLInputElement;

  // Default wrapping styles
  style.whiteSpace = isInput ? 'nowrap' : 'pre-wrap';
  style.wordWrap = isInput ? '' : 'break-word';

  // Position off-screen
  style.position = 'absolute'; // required to return coordinates properly

  // Transfer the element's properties to the div
  for (const prop of propertiesToCopy) {
    if (isInput && prop === 'lineHeight') {
      // Special case for <input>s because text is rendered centered and line height may be != height
      if (computed.boxSizing === 'border-box') {
        const height = parseInt(computed.height);
        const outerHeight = parseInt(computed.paddingTop) + parseInt(computed.paddingBottom) + parseInt(computed.borderTopWidth) + parseInt(computed.borderBottomWidth);
        const targetHeight = outerHeight + lineHeight;
        if (height > targetHeight) {
          style.lineHeight = `${height - outerHeight}px`;
        } else if (height === targetHeight) {
          style.lineHeight = computed.lineHeight;
        } else {
          style.lineHeight = '0';
        }
      } else {
        style.lineHeight = computed.height;
      }
    } else if (!isInput && prop === 'width' && computed.boxSizing === 'border-box') {
      // With box-sizing: border-box we need to offset the size slightly inwards.  This small difference can compound
      // greatly in long textareas with lots of wrapping, leading to very innacurate results if not accounted for.
      // Firefox will return computed styles in floats, like `0.9px`, while chromium might return `1px` for the same element.
      // Either way we use `parseFloat` to turn `0.9px` into `0.9` and `1px` into `1`
      const totalBorderWidth = parseFloat(computed.borderLeftWidth) + parseFloat(computed.borderRightWidth);
      // When a vertical scrollbar is present it shrinks the content. We need to account for this by using clientWidth
      // instead of width in everything but Firefox. When we do that we also have to account for the border width.
      const width = isFirefox ? parseFloat(computed.width) - totalBorderWidth : element.clientWidth + totalBorderWidth;
      style.width = `${width}px`;
    } else {
      style[prop] = computed[prop];
    }
  }
  if (isFirefox) {
    // Firefox lies about the overflow property for textareas: https://bugzilla.mozilla.org/show_bug.cgi?id=984275
    if (element.scrollHeight > parseInt(computed.height)) style.overflowY = 'scroll';
  } else {
    style.overflow = 'hidden'; // for Chrome to not render a scrollbar; IE keeps overflowY = 'scroll'
  }

  div.textContent = element.value.substring(0, index);

  // The second special handling for input type="text" vs textarea:
  // spaces need to be replaced with non-breaking spaces - http://stackoverflow.com/a/13402035/1269037
  if (isInput) div.textContent = div.textContent.replace(/\s/g, '\u00a0');
  const span = document.createElement('span');
  // Wrapping must be replicated *exactly*, including when a long word gets
  // onto the next line, with whitespace at the end of the line before (#7).
  // The  *only* reliable way to do that is to copy the *entire* rest of the
  // textarea's content into the <span> created at the caret position.
  // For inputs, '.' is enough because there is no wrapping.
  span.textContent = isInput ? '.' : element.value.substring(index) || '.'; // because a completely empty faux span doesn't render at all
  div.appendChild(span);
  const coordinates = {
    top: span.offsetTop + parseInt(computed.borderTopWidth),
    left: span.offsetLeft + parseInt(computed.borderLeftWidth),
    height: lineHeight
  };
  document.body.removeChild(div);
  return coordinates;
}

/**
 * Obtain the coordinates (px) of the bottom left of a character in an input, relative to the
 * top-left corner of the input element (adjusted for scroll). This includes horizontal
 * scroll in single-line inputs.
 * @param input The target input element.
 * @param index The index of the character to calculate for.
 */
const getScrollAdjustedCharacterCoordinates = (input, index) => {
  const {
    height,
    top,
    left
  } = getCharacterCoordinates(input, index);
  return {
    height,
    top: top - input.scrollTop,
    left: left - input.scrollLeft
  };
};

/**
 * Obtain the coordinates (px) of the bottom left of a character in an input, relative to the
 * top-left corner of the document. Since this is relative to the document, it is also adjusted
 * for the input's scroll.
 * @param input The target input element.
 * @param index The index of the character to calculate for.
 */
const getAbsoluteCharacterCoordinates = (input, index) => {
  const {
    top: relativeTop,
    left: relativeLeft,
    height
  } = getScrollAdjustedCharacterCoordinates(input, index);
  const {
    top: viewportOffsetTop,
    left: viewportOffsetLeft
  } = input.getBoundingClientRect();
  return {
    height,
    top: viewportOffsetTop + relativeTop,
    left: viewportOffsetLeft + relativeLeft
  };
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useAnchoredPosition.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useAnchoredPosition.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useAnchoredPosition": () => (/* binding */ useAnchoredPosition)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/behaviors */ "./node_modules/@primer/behaviors/dist/esm/anchored-position.js");
/* harmony import */ var _useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _useResizeObserver_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./useResizeObserver.js */ "./node_modules/@primer/react/lib-esm/hooks/useResizeObserver.js");
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/useIsomorphicLayoutEffect.js */ "./node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");






/**
 * Calculates the top and left values for an absolutely-positioned floating element
 * to be anchored to some anchor element. Returns refs for the floating element
 * and the anchor element, along with the position.
 * @param settings Settings for calculating the anchored position.
 * @param dependencies Dependencies to determine when to re-calculate the position.
 * @returns An object of {top: number, left: number} to absolutely-position the
 * floating element.
 */
function useAnchoredPosition(settings, dependencies = []) {
  const floatingElementRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(settings === null || settings === void 0 ? void 0 : settings.floatingElementRef);
  const anchorElementRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(settings === null || settings === void 0 ? void 0 : settings.anchorElementRef);
  const [position, setPosition] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(undefined);
  const updatePosition = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
    if (floatingElementRef.current instanceof Element && anchorElementRef.current instanceof Element) {
      setPosition((0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_2__.getAnchoredPosition)(floatingElementRef.current, anchorElementRef.current, settings));
    } else {
      setPosition(undefined);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [floatingElementRef, anchorElementRef, ...dependencies]);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(updatePosition, [updatePosition]);
  (0,_useResizeObserver_js__WEBPACK_IMPORTED_MODULE_4__.useResizeObserver)(updatePosition);
  return {
    floatingElementRef,
    anchorElementRef,
    position
  };
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useDetails.js":
/*!****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useDetails.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDetails)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


function useDetails({
  ref,
  closeOnOutsideClick,
  defaultOpen,
  onClickOutside
}) {
  const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultOpen);
  const backupRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const customRef = ref !== null && ref !== void 0 ? ref : backupRef;
  const onClickOutsideInternal = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    const {
      current
    } = customRef;
    const eventTarget = event.target;
    const closest = eventTarget.closest('details');
    if (closest !== current) {
      onClickOutside && onClickOutside(event);
      if (!event.defaultPrevented) {
        setOpen(false);
      }
    }
  }, [customRef, setOpen, onClickOutside]);

  // handles the overlay behavior - closing the menu when clicking outside of it
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (open && closeOnOutsideClick) {
      document.addEventListener('click', onClickOutsideInternal);
      return () => {
        document.removeEventListener('click', onClickOutsideInternal);
      };
    }
  }, [open, closeOnOutsideClick, onClickOutsideInternal]);
  const handleToggle = e => {
    if (!e.defaultPrevented) {
      const eventTarget = e.target;
      setOpen(eventTarget.open);
    }
  };
  const getDetailsProps = () => {
    return {
      onToggle: handleToggle,
      open,
      ref: customRef
    };
  };
  return {
    open,
    setOpen,
    getDetailsProps
  };
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useDialog.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useDialog.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDialog)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const noop = () => null;
function visible(el) {
  return !el.hidden && (!el.type || el.type !== 'hidden') && (el.offsetWidth > 0 || el.offsetHeight > 0);
}
function focusable(el) {
  const inputEl = el;
  return inputEl.tabIndex >= 0 && !inputEl.disabled && visible(inputEl);
}
function useDialog({
  modalRef,
  overlayRef,
  isOpen,
  onDismiss = noop,
  initialFocusRef,
  closeButtonRef
}) {
  const onClickOutside = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    if (modalRef.current && overlayRef.current && !modalRef.current.contains(e.target) && overlayRef.current.contains(e.target)) {
      onDismiss();
    }
  }, [onDismiss, modalRef, overlayRef]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isOpen) {
      document.addEventListener('click', onClickOutside);
      return () => {
        document.removeEventListener('click', onClickOutside);
      };
    }
  }, [isOpen, onClickOutside]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isOpen) {
      if (initialFocusRef && initialFocusRef.current) {
        initialFocusRef.current.focus();
      } else if (closeButtonRef && closeButtonRef.current) {
        closeButtonRef.current.focus();
      }
    }
  }, [isOpen, initialFocusRef, closeButtonRef]);
  const getFocusableItem = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((e, movement) => {
    if (modalRef.current) {
      const items = Array.from(modalRef.current.querySelectorAll('*')).filter(focusable);
      if (items.length === 0) return;
      e.preventDefault();
      const focusedElement = document.activeElement;
      if (!focusedElement) {
        return;
      }
      const index = items.indexOf(focusedElement);
      const offsetIndex = index + movement;
      const fallbackIndex = movement === 1 ? 0 : items.length - 1;
      const focusableItem = items[offsetIndex] || items[fallbackIndex];
      return focusableItem;
    }
  }, [modalRef]);
  const handleTab = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(e => {
    const movement = e.shiftKey ? -1 : 1;
    const focusableItem = getFocusableItem(e, movement);
    if (!focusableItem) {
      return;
    }
    focusableItem.focus();
  }, [getFocusableItem]);
  const onKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    switch (event.key) {
      case 'Tab':
        handleTab(event);
        break;
      case 'Escape':
        onDismiss();
        event.stopPropagation();
        break;
    }
  }, [handleTab, onDismiss]);
  const getDialogProps = () => {
    return {
      onKeyDown
    };
  };
  return {
    getDialogProps
  };
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useMedia.js":
/*!**************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useMedia.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MatchMedia": () => (/* binding */ MatchMedia),
/* harmony export */   "useMedia": () => (/* binding */ useMedia)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_environment_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/environment.js */ "./node_modules/@primer/react/lib-esm/utils/environment.js");



/**
 * `useMedia` will use the given `mediaQueryString` with `matchMedia` to
 * determine if the document matches the media query string.
 *
 * If `MatchMedia` is used as an ancestor, `useMedia` will instead use the
 * value of the media query string, if available
 *
 * @example
 * function Example() {
 *   const coarsePointer = useMedia('(pointer: coarse)');
 *   // ...
 * }
 */
function useMedia(mediaQueryString, defaultState) {
  const features = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(MatchMediaContext);
  const [matches, setMatches] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(() => {
    if (features[mediaQueryString] !== undefined) {
      return features[mediaQueryString];
    }

    // Prevent a React hydration mismatch when a default value is provided by not defaulting to window.matchMedia(query).matches.
    if (defaultState !== undefined) {
      return defaultState;
    }
    if (_utils_environment_js__WEBPACK_IMPORTED_MODULE_1__.canUseDOM) {
      return window.matchMedia(mediaQueryString).matches;
    }

    // A default value has not been provided, and you are rendering on the server, warn of a possible hydration mismatch when defaulting to false.
    if (true) {
      // eslint-disable-next-line no-console
      console.warn('`useMedia` When server side rendering, defaultState should be defined to prevent a hydration mismatches.');
    }
    return false;
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (features[mediaQueryString] !== undefined) {
      setMatches(features[mediaQueryString]);
    }
  }, [features, mediaQueryString]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // If `mediaQueryString` is present in features through `context` defer to
    // the value present instead of checking with matchMedia
    if (features[mediaQueryString] !== undefined) {
      return;
    }
    function listener(event) {
      setMatches(event.matches);
    }
    const mediaQueryList = window.matchMedia(mediaQueryString);

    // Support fallback to `addListener` for broader browser support
    // @ts-ignore this is not present in Safari <14
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    if (mediaQueryList.addEventListener) {
      mediaQueryList.addEventListener('change', listener);
    } else {
      mediaQueryList.addListener(listener);
    }

    // Make sure the media query list is in sync with the matches state
    setMatches(mediaQueryList.matches);
    return () => {
      // @ts-ignore this is not present in Safari <14
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      if (mediaQueryList.addEventListener) {
        mediaQueryList.removeEventListener('change', listener);
      } else {
        mediaQueryList.removeListener(listener);
      }
    };
  }, [features, mediaQueryString]);
  return matches;
}
// Used to keep track of overrides to specific media query features, this should
// be used for development and demo purposes to emulate specific features if
// unavailable through devtools
const MatchMediaContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
const defaultFeatures = {};

/**
 * Use `MatchMedia` to emulate media conditions by passing in feature
 * queries to the `features` prop. If a component uses `useMedia` with the
 * feature passed in to `MatchMedia` it will force its value to match what is
 * provided to `MatchMedia`
 *
 * This should be used for development and documentation only in situations
 * where devtools cannot emulate this feature
 *
 * @example
 * <MatchMedia features={{ "(pointer: coarse)": true}}>
 *   <Children />
 * </MatchMedia>
 */
function MatchMedia({
  children,
  features = defaultFeatures
}) {
  const value = useShallowObject(features);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(MatchMediaContext.Provider, {
    value: value
  }, children);
}
MatchMedia.displayName = "MatchMedia";
/**
 * Utility hook to provide a stable identity for a "simple" object which
 * contains only primitive values. This provides a `useMemo`-esque signature
 * without dealing with shallow equality checks in the dependency array.
 *
 * Note (perf): this hook iterates through keys and values of the object if the
 * shallow equality check is false each time the hook is called
 */
function useShallowObject(object) {
  const [value, setValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(object);
  if (value !== object) {
    const match = Object.keys(object).every(key => {
      return object[key] === value[key];
    });
    if (!match) {
      setValue(object);
    }
  }
  return value;
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useMenuInitialFocus.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useMenuInitialFocus.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useMenuInitialFocus": () => (/* binding */ useMenuInitialFocus)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/behaviors/utils */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");



const useMenuInitialFocus = (open, containerRef, anchorRef) => {
  /**
   * We need to pick the first element to focus based on how the menu was opened,
   * however, we need to wait for the menu to be open to set focus.
   * This is why we use set openingKey in state and have 2 effects
   */
  const [openingGesture, setOpeningGesture] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(undefined);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function inferOpeningKey() {
    const anchorElement = anchorRef.current;
    const clickHandler = event => {
      // event.detail === 0 means onClick was fired by Enter/Space key
      // https://developer.mozilla.org/en-US/docs/Web/API/UIEvent/detail
      if (event.detail !== 0) setOpeningGesture('mouse-click');
    };
    const keydownHandler = event => {
      if (['Space', 'Enter', 'ArrowDown', 'ArrowUp'].includes(event.code)) {
        setOpeningGesture(event.code);
      }
    };
    anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.addEventListener('click', clickHandler);
    anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.addEventListener('keydown', keydownHandler);
    return () => {
      anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.removeEventListener('click', clickHandler);
      anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.removeEventListener('keydown', keydownHandler);
    };
  }, [anchorRef]);

  /**
   * Pick the first element to focus based on the key used to open the Menu
   * Click: anchor
   * ArrowDown | Space | Enter: first element
   * ArrowUp: last element
   */
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function moveFocusOnOpen() {
    if (!open || !containerRef.current) return; // wait till the menu is open

    const iterable = (0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_1__.iterateFocusableElements)(containerRef.current);
    if (openingGesture === 'mouse-click') {
      if (anchorRef.current) anchorRef.current.focus();else throw new Error('For focus management, please attach anchorRef');
    } else if (openingGesture && ['ArrowDown', 'Space', 'Enter'].includes(openingGesture)) {
      const firstElement = iterable.next().value;
      /** We push imperative focus to the next tick to prevent React's batching */
      setTimeout(() => firstElement === null || firstElement === void 0 ? void 0 : firstElement.focus());
    } else if ('ArrowUp' === openingGesture) {
      const elements = [...iterable];
      const lastElement = elements[elements.length - 1];
      setTimeout(() => lastElement.focus());
    } else {
      /** if the menu was not opened with the anchor, we default to the first element
       *  for example: with keyboard shortcut (see stories/fixtures)
       */
      const firstElement = iterable.next().value;
      setTimeout(() => firstElement === null || firstElement === void 0 ? void 0 : firstElement.focus());
    }
  },
  // we don't want containerRef in dependencies
  // because re-renders to containerRef while it's open should not fire initialMenuFocus
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [open, openingGesture, anchorRef]);
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useMenuKeyboardNavigation.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useMenuKeyboardNavigation.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useMenuKeyboardNavigation": () => (/* binding */ useMenuKeyboardNavigation)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/behaviors/utils */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _useMenuInitialFocus_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useMenuInitialFocus.js */ "./node_modules/@primer/react/lib-esm/hooks/useMenuInitialFocus.js");
/* harmony import */ var _useMnemonics_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useMnemonics.js */ "./node_modules/@primer/react/lib-esm/hooks/useMnemonics.js");





/**
 * Keyboard navigation is a mix of 4 hooks
 * 1. useMenuInitialFocus
 * 2. useTypeaheadFocus
 * 3. useCloseMenuOnTab
 * 4. useMoveFocusToMenuItem
 */
const useMenuKeyboardNavigation = (open, onClose, containerRef, anchorRef) => {
  (0,_useMenuInitialFocus_js__WEBPACK_IMPORTED_MODULE_1__.useMenuInitialFocus)(open, containerRef, anchorRef);
  (0,_useMnemonics_js__WEBPACK_IMPORTED_MODULE_2__.useMnemonics)(open, containerRef);
  useCloseMenuOnTab(open, onClose, containerRef, anchorRef);
  useMoveFocusToMenuItem(open, containerRef, anchorRef);
};

/**
 * When Tab or Shift+Tab is pressed, the menu should close
 * and the focus should naturally move to the next item
 */
const useCloseMenuOnTab = (open, onClose, containerRef, anchorRef) => {
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    const container = containerRef.current;
    const anchor = anchorRef.current;
    const handler = event => {
      if (open && event.key === 'Tab') onClose === null || onClose === void 0 ? void 0 : onClose('tab');
    };
    container === null || container === void 0 ? void 0 : container.addEventListener('keydown', handler);
    anchor === null || anchor === void 0 ? void 0 : anchor.addEventListener('keydown', handler);
    return () => {
      container === null || container === void 0 ? void 0 : container.removeEventListener('keydown', handler);
      anchor === null || anchor === void 0 ? void 0 : anchor.removeEventListener('keydown', handler);
    };
  }, [open, onClose, containerRef, anchorRef]);
};

/**
 * When Arrow Keys are pressed and the focus is on the anchor,
 * focus should move to a menu item
 */
const useMoveFocusToMenuItem = (open, containerRef, anchorRef) => {
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    const container = containerRef.current;
    const anchor = anchorRef.current;
    const handler = event => {
      if (!open || !container) return;
      const iterable = (0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(container);
      if (event.key === 'ArrowDown') {
        // TODO: does commenting this out break anything?
        // event.preventDefault() // prevent scroll event
        const firstElement = iterable.next().value;
        /** We push imperative focus to the next tick to prevent React's batching */
        setTimeout(() => firstElement === null || firstElement === void 0 ? void 0 : firstElement.focus());
      } else if (event.key === 'ArrowUp') {
        // TODO: does commenting this out break anything?
        // event.preventDefault() // prevent scroll event
        const elements = [...iterable];
        const lastElement = elements[elements.length - 1];
        setTimeout(() => lastElement.focus());
      }
    };
    anchor === null || anchor === void 0 ? void 0 : anchor.addEventListener('keydown', handler);
    return () => anchor === null || anchor === void 0 ? void 0 : anchor.addEventListener('keydown', handler);
  }, [open, containerRef, anchorRef]);
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useMnemonics.js":
/*!******************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useMnemonics.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useMnemonics": () => (/* binding */ useMnemonics)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/behaviors/utils */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");




/*
 * A mnemonic indicates to the user which key to press (single)
 * to activate a command or navigate to a component
 * typically appearing in a menu title, menu item, or the text of a button.
 */

const useMnemonics = (open, providedRef) => {
  const containerRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(providedRef);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function addAriaKeyshortcuts() {
    if (!open || !containerRef.current) return;
    const container = containerRef.current;
    const focusableItems = [...(0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_2__.iterateFocusableElements)(container)];
    focusableItems.map(item => {
      var _item$textContent;
      // if item already has aria-keyshortcuts defined by user, skip
      if (item.getAttribute('aria-keyshortcuts')) return;
      const firstLetter = (_item$textContent = item.textContent) === null || _item$textContent === void 0 ? void 0 : _item$textContent.toLowerCase()[0];
      if (firstLetter) item.setAttribute('aria-keyshortcuts', firstLetter);
    });
  }, [open, containerRef]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function handleKeyDown() {
    if (!open || !containerRef.current) return;
    const container = containerRef.current;
    const handler = event => {
      var _elementToFocus;
      // skip if a TextInput has focus
      const activeElement = document.activeElement;
      if (activeElement.tagName === 'INPUT' || activeElement.tagName === 'TEXTAREA') return;

      // skip if used with modifier to preserve shortcuts like ⌘ + F
      const hasModifier = event.ctrlKey || event.altKey || event.metaKey;
      if (hasModifier) return;

      // skip if it's not a alphabet key
      if (!isAlphabetKey(event)) return;

      // if this is a typeahead event, don't propagate outside of menu
      event.stopPropagation();
      const query = event.key.toLowerCase();
      let elementToFocus;
      const focusableItems = [...(0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_2__.iterateFocusableElements)(container)];
      const itemsMatchingKey = focusableItems.filter(item => {
        var _item$getAttribute;
        const keyshortcuts = (_item$getAttribute = item.getAttribute('aria-keyshortcuts')) === null || _item$getAttribute === void 0 ? void 0 : _item$getAttribute.split(' ').map(shortcut => shortcut.toLowerCase());
        return keyshortcuts && keyshortcuts.includes(query);
      });
      const currentActiveIndex = itemsMatchingKey.indexOf(activeElement);

      // If the last element is already selected, cycle through the list
      if (currentActiveIndex === itemsMatchingKey.length - 1) {
        elementToFocus = itemsMatchingKey[0];
      } else {
        elementToFocus = itemsMatchingKey.find((item, index) => {
          return index > currentActiveIndex;
        });
      }
      (_elementToFocus = elementToFocus) === null || _elementToFocus === void 0 ? void 0 : _elementToFocus.focus();
    };
    container.addEventListener('keydown', handler);
    return () => container.removeEventListener('keydown', handler);
  }, [open, containerRef]);
  const isAlphabetKey = event => {
    return event.key.length === 1 && /[a-z\d]/i.test(event.key);
  };
  return {
    containerRef
  };
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useOpenAndCloseFocus.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useOpenAndCloseFocus.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useOpenAndCloseFocus": () => (/* binding */ useOpenAndCloseFocus)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/behaviors/utils */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");



function useOpenAndCloseFocus({
  initialFocusRef,
  returnFocusRef,
  containerRef,
  preventFocusOnOpen
}) {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (preventFocusOnOpen) {
      return;
    }
    const returnRef = returnFocusRef.current;
    if (initialFocusRef && initialFocusRef.current) {
      initialFocusRef.current.focus();
    } else if (containerRef.current) {
      const firstItem = (0,_primer_behaviors_utils__WEBPACK_IMPORTED_MODULE_1__.iterateFocusableElements)(containerRef.current).next().value;
      firstItem === null || firstItem === void 0 ? void 0 : firstItem.focus();
    }
    return function () {
      returnRef === null || returnRef === void 0 ? void 0 : returnRef.focus();
    };
  }, [initialFocusRef, returnFocusRef, containerRef, preventFocusOnOpen]);
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useOverlay.js":
/*!****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useOverlay.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useOverlay": () => (/* binding */ useOverlay)
/* harmony export */ });
/* harmony import */ var _useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useOnOutsideClick.js */ "./node_modules/@primer/react/lib-esm/hooks/useOnOutsideClick.js");
/* harmony import */ var _useOpenAndCloseFocus_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useOpenAndCloseFocus.js */ "./node_modules/@primer/react/lib-esm/hooks/useOpenAndCloseFocus.js");
/* harmony import */ var _useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./useOnEscapePress.js */ "./node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js");
/* harmony import */ var _useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useProvidedRefOrCreate.js */ "./node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");





const useOverlay = ({
  overlayRef: _overlayRef,
  returnFocusRef,
  initialFocusRef,
  onEscape,
  ignoreClickRefs,
  onClickOutside,
  preventFocusOnOpen
}) => {
  const overlayRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_0__.useProvidedRefOrCreate)(_overlayRef);
  (0,_useOpenAndCloseFocus_js__WEBPACK_IMPORTED_MODULE_1__.useOpenAndCloseFocus)({
    containerRef: overlayRef,
    returnFocusRef,
    initialFocusRef,
    preventFocusOnOpen
  });
  (0,_useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_2__.useOnOutsideClick)({
    containerRef: overlayRef,
    ignoreClickRefs,
    onClickOutside
  });

  // We only want one overlay to close at a time
  const preventeddefaultCheckedEscape = event => {
    onEscape(event);
    event.preventDefault();
  };
  (0,_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_3__.useOnEscapePress)(preventeddefaultCheckedEscape);
  return {
    ref: overlayRef
  };
};




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useProvidedStateOrCreate.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useProvidedStateOrCreate": () => (/* binding */ useProvidedStateOrCreate)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * There are some situations where we want to give users the option to control state externally with their own state handlers
 * or default to using internal state handlers. Because of the 'rules-of-hooks', we cannot conditionally make a call to `React.useState`
 * only in the situations where the state is not provided as a prop.
 * This hook aims to encapsulate that logic, so the consumer doesn't need to be concerned with violating `rules-of-hooks`.
 * @param externalState The state to use - if undefined, will use the state from a call to React.useState
 * @param setExternalState The setState to use - if undefined, will use the setState from a call to React.useState
 * @param defaultState The defaultState to use, if using internal state.
 */
function useProvidedStateOrCreate(externalState, setExternalState, defaultState) {
  const [internalState, setInternalState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultState);
  const state = externalState !== null && externalState !== void 0 ? externalState : internalState;
  const setState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(s => {
    setInternalState(s);
    if (setExternalState) setExternalState(s);
  }, [setExternalState]);
  return [state, setState];
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useRenderForcingRef.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useRenderForcingRef.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useRenderForcingRef": () => (/* binding */ useRenderForcingRef)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * There are certain situations where a ref might be set after the current render cycle for a
 * component has finished.  e.g. a forward ref from a conditionally rendered child component.
 * In these situations, we need to force a re-render, which is done here by the useState hook.
 * @type TRef The type of the RefObject which should be created.
 */
function useRenderForcingRef(value) {
  const [refCurrent, setRefCurrent] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value || null);
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  ref.current = refCurrent;
  const setRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(newRef => {
    ref.current = newRef;
    setRefCurrent(newRef);
  }, [ref]);
  return [ref, setRef];
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useResponsiveValue.js":
/*!************************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useResponsiveValue.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isResponsiveValue": () => (/* binding */ isResponsiveValue),
/* harmony export */   "useResponsiveValue": () => (/* binding */ useResponsiveValue),
/* harmony export */   "viewportRanges": () => (/* binding */ viewportRanges)
/* harmony export */ });
/* harmony import */ var _useMedia_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useMedia.js */ "./node_modules/@primer/react/lib-esm/hooks/useMedia.js");


// This file contains utilities for working with responsive values.

// The viewport range values from @primer/primtives don't work in Chrome
// because they use `em` units inside `calc()` (e.g., calc(48em - 0.02px)).
// As a temporary workaround, we're hardcoding the viewport ranges in `px` units.
// TODO: Use viewport range tokens from @primer/primitives
const viewportRanges = {
  narrow: '(max-width: calc(768px - 0.02px))',
  // < 768px
  regular: '(min-width: 768px)',
  // >= 768px
  wide: '(min-width: 1400px)' // >= 1400px
};

/**
 * Checks if the value is a responsive value.
 * In other words, is it an object with viewport range keys?
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isResponsiveValue(value) {
  return typeof value === 'object' && Object.keys(value).some(key => ['narrow', 'regular', 'wide'].includes(key));
}

/**
 * Resolves responsive values based on the current viewport width.
 * For example, if the current viewport width is narrow (less than 768px), the value of `{regular: 'foo', narrow: 'bar'}` will resolve to `'bar'`.
 *
 * @example
 * const value = useResponsiveValue({regular: 'foo', narrow: 'bar'})
 * console.log(value) // 'bar'
 */
// TODO: Improve SRR support
function useResponsiveValue(value, fallback) {
  // Check viewport size
  // TODO: What is the performance cost of creating media query listeners in this hook?
  const isNarrowViewport = (0,_useMedia_js__WEBPACK_IMPORTED_MODULE_0__.useMedia)(viewportRanges.narrow, false);
  const isRegularViewport = (0,_useMedia_js__WEBPACK_IMPORTED_MODULE_0__.useMedia)(viewportRanges.regular, false);
  const isWideViewport = (0,_useMedia_js__WEBPACK_IMPORTED_MODULE_0__.useMedia)(viewportRanges.wide, false);
  if (isResponsiveValue(value)) {
    // If we've reached this line, we know that value is a responsive value
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const responsiveValue = value;
    if (isNarrowViewport && 'narrow' in responsiveValue) {
      return responsiveValue.narrow;
    } else if (isWideViewport && 'wide' in responsiveValue) {
      return responsiveValue.wide;
    } else if (isRegularViewport && 'regular' in responsiveValue) {
      return responsiveValue.regular;
    } else {
      return fallback;
    }
  } else {
    // If we've reached this line, we know that value is not a responsive value
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return value;
  }
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/hooks/useScrollFlash.js":
/*!********************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/hooks/useScrollFlash.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useScrollFlash)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * This hook will flash the scrollbars for a ref of a container that has scrollable overflow
 * @param scrollContainerRef The ref of the scrollable content
 */
function useScrollFlash(scrollContainerRef) {
  // https://adxlv.computer/projects/flash-scrollers/
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const scrollContainer = scrollContainerRef.current;
    if (!scrollContainer) {
      return;
    }
    const currentScroll = scrollContainer.scrollTop;
    const maxScroll = scrollContainer.scrollHeight;
    const altScroll = currentScroll < Math.min(1, maxScroll) ? currentScroll + 1 : currentScroll - 1;
    scrollContainer.scrollTop = altScroll;
    scrollContainer.scrollTop = currentScroll;
  }, [scrollContainerRef]);
}




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "themeGet": () => (/* reexport safe */ _constants_js__WEBPACK_IMPORTED_MODULE_0__.get),
/* harmony export */   "BaseStyles": () => (/* reexport safe */ _BaseStyles_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "ThemeProvider": () => (/* reexport safe */ _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "useColorSchemeVar": () => (/* reexport safe */ _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__.useColorSchemeVar),
/* harmony export */   "useTheme": () => (/* reexport safe */ _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__.useTheme),
/* harmony export */   "Box": () => (/* reexport safe */ _Box_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "Button": () => (/* reexport safe */ _Button_index_js__WEBPACK_IMPORTED_MODULE_4__.Button),
/* harmony export */   "useDetails": () => (/* reexport safe */ _hooks_useDetails_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "useSafeTimeout": () => (/* reexport safe */ _hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "useOnOutsideClick": () => (/* reexport safe */ _hooks_useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_7__.useOnOutsideClick),
/* harmony export */   "useOpenAndCloseFocus": () => (/* reexport safe */ _hooks_useOpenAndCloseFocus_js__WEBPACK_IMPORTED_MODULE_8__.useOpenAndCloseFocus),
/* harmony export */   "useOnEscapePress": () => (/* reexport safe */ _hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_9__.useOnEscapePress),
/* harmony export */   "useOverlay": () => (/* reexport safe */ _hooks_useOverlay_js__WEBPACK_IMPORTED_MODULE_10__.useOverlay),
/* harmony export */   "ConfirmationDialog": () => (/* reexport safe */ _Dialog_ConfirmationDialog_js__WEBPACK_IMPORTED_MODULE_11__.ConfirmationDialog),
/* harmony export */   "useConfirm": () => (/* reexport safe */ _Dialog_ConfirmationDialog_js__WEBPACK_IMPORTED_MODULE_11__.useConfirm),
/* harmony export */   "useFocusTrap": () => (/* reexport safe */ _hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_12__.useFocusTrap),
/* harmony export */   "useFocusZone": () => (/* reexport safe */ _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_13__.useFocusZone),
/* harmony export */   "useRefObjectAsForwardedRef": () => (/* reexport safe */ _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_14__.useRefObjectAsForwardedRef),
/* harmony export */   "Radio": () => (/* reexport safe */ _Radio_js__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "ActionList": () => (/* reexport safe */ _ActionList_index_js__WEBPACK_IMPORTED_MODULE_16__.ActionList),
/* harmony export */   "ActionMenu": () => (/* reexport safe */ _ActionMenu_js__WEBPACK_IMPORTED_MODULE_17__.ActionMenu),
/* harmony export */   "Avatar": () => (/* reexport safe */ _Avatar_js__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   "AvatarPair": () => (/* reexport safe */ _AvatarPair_js__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   "AvatarStack": () => (/* reexport safe */ _AvatarStack_js__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   "BranchName": () => (/* reexport safe */ _BranchName_js__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   "Breadcrumb": () => (/* reexport safe */ _Breadcrumbs_js__WEBPACK_IMPORTED_MODULE_22__.Breadcrumb),
/* harmony export */   "Breadcrumbs": () => (/* reexport safe */ _Breadcrumbs_js__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   "ButtonGroup": () => (/* reexport safe */ _ButtonGroup_js__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   "Caret": () => (/* reexport safe */ _Caret_js__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   "CircleOcticon": () => (/* reexport safe */ _CircleOcticon_js__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   "CheckboxGroup": () => (/* reexport safe */ _CheckboxGroup_js__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   "CircleBadge": () => (/* reexport safe */ _CircleBadge_js__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   "CounterLabel": () => (/* reexport safe */ _CounterLabel_js__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   "Details": () => (/* reexport safe */ _Details_js__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   "Dialog": () => (/* reexport safe */ _Dialog_js__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   "FilteredSearch": () => (/* reexport safe */ _FilteredSearch_js__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   "FilterList": () => (/* reexport safe */ _FilterList_js__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   "Flash": () => (/* reexport safe */ _Flash_js__WEBPACK_IMPORTED_MODULE_33__["default"]),
/* harmony export */   "Header": () => (/* reexport safe */ _Header_js__WEBPACK_IMPORTED_MODULE_34__["default"]),
/* harmony export */   "Heading": () => (/* reexport safe */ _Heading_js__WEBPACK_IMPORTED_MODULE_35__["default"]),
/* harmony export */   "Label": () => (/* reexport safe */ _Label_js__WEBPACK_IMPORTED_MODULE_36__["default"]),
/* harmony export */   "LabelGroup": () => (/* reexport safe */ _LabelGroup_js__WEBPACK_IMPORTED_MODULE_37__["default"]),
/* harmony export */   "Link": () => (/* reexport safe */ _Link_js__WEBPACK_IMPORTED_MODULE_38__["default"]),
/* harmony export */   "Overlay": () => (/* reexport safe */ _Overlay_js__WEBPACK_IMPORTED_MODULE_39__["default"]),
/* harmony export */   "Pagehead": () => (/* reexport safe */ _Pagehead_js__WEBPACK_IMPORTED_MODULE_40__["default"]),
/* harmony export */   "Pagination": () => (/* reexport safe */ _Pagination_Pagination_js__WEBPACK_IMPORTED_MODULE_41__["default"]),
/* harmony export */   "PointerBox": () => (/* reexport safe */ _PointerBox_js__WEBPACK_IMPORTED_MODULE_42__["default"]),
/* harmony export */   "Popover": () => (/* reexport safe */ _Popover_js__WEBPACK_IMPORTED_MODULE_43__["default"]),
/* harmony export */   "Portal": () => (/* reexport safe */ _Portal_index_js__WEBPACK_IMPORTED_MODULE_44__["default"]),
/* harmony export */   "ProgressBar": () => (/* reexport safe */ _ProgressBar_js__WEBPACK_IMPORTED_MODULE_45__["default"]),
/* harmony export */   "RadioGroup": () => (/* reexport safe */ _RadioGroup_js__WEBPACK_IMPORTED_MODULE_46__["default"]),
/* harmony export */   "Select": () => (/* reexport safe */ _Select_js__WEBPACK_IMPORTED_MODULE_47__["default"]),
/* harmony export */   "SideNav": () => (/* reexport safe */ _SideNav_js__WEBPACK_IMPORTED_MODULE_48__["default"]),
/* harmony export */   "Spinner": () => (/* reexport safe */ _Spinner_js__WEBPACK_IMPORTED_MODULE_49__["default"]),
/* harmony export */   "StateLabel": () => (/* reexport safe */ _StateLabel_js__WEBPACK_IMPORTED_MODULE_50__["default"]),
/* harmony export */   "StyledOcticon": () => (/* reexport safe */ _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_51__["default"]),
/* harmony export */   "SubNav": () => (/* reexport safe */ _SubNav_js__WEBPACK_IMPORTED_MODULE_52__["default"]),
/* harmony export */   "ToggleSwitch": () => (/* reexport safe */ _ToggleSwitch_js__WEBPACK_IMPORTED_MODULE_53__["default"]),
/* harmony export */   "TabNav": () => (/* reexport safe */ _TabNav_js__WEBPACK_IMPORTED_MODULE_54__["default"]),
/* harmony export */   "TextInput": () => (/* reexport safe */ _TextInput_js__WEBPACK_IMPORTED_MODULE_55__["default"]),
/* harmony export */   "TextInputWithTokens": () => (/* reexport safe */ _TextInputWithTokens_js__WEBPACK_IMPORTED_MODULE_56__["default"]),
/* harmony export */   "Text": () => (/* reexport safe */ _Text_js__WEBPACK_IMPORTED_MODULE_57__["default"]),
/* harmony export */   "Timeline": () => (/* reexport safe */ _Timeline_js__WEBPACK_IMPORTED_MODULE_58__["default"]),
/* harmony export */   "Tooltip": () => (/* reexport safe */ _Tooltip_js__WEBPACK_IMPORTED_MODULE_59__["default"]),
/* harmony export */   "Truncate": () => (/* reexport safe */ _Truncate_js__WEBPACK_IMPORTED_MODULE_60__["default"]),
/* harmony export */   "UnderlineNav": () => (/* reexport safe */ _UnderlineNav_js__WEBPACK_IMPORTED_MODULE_61__["default"]),
/* harmony export */   "Checkbox": () => (/* reexport safe */ _Checkbox_js__WEBPACK_IMPORTED_MODULE_62__["default"]),
/* harmony export */   "Textarea": () => (/* reexport safe */ _Textarea_js__WEBPACK_IMPORTED_MODULE_63__["default"]),
/* harmony export */   "sx": () => (/* reexport safe */ _sx_js__WEBPACK_IMPORTED_MODULE_64__["default"]),
/* harmony export */   "theme": () => (/* reexport safe */ _theme_preval_js__WEBPACK_IMPORTED_MODULE_65__["default"]),
/* harmony export */   "PageLayout": () => (/* reexport safe */ _PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_66__.PageLayout),
/* harmony export */   "SplitPageLayout": () => (/* reexport safe */ _SplitPageLayout_SplitPageLayout_js__WEBPACK_IMPORTED_MODULE_67__.SplitPageLayout),
/* harmony export */   "AnchoredOverlay": () => (/* reexport safe */ _AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_68__.AnchoredOverlay),
/* harmony export */   "Autocomplete": () => (/* reexport safe */ _Autocomplete_Autocomplete_js__WEBPACK_IMPORTED_MODULE_69__["default"]),
/* harmony export */   "FormControl": () => (/* reexport safe */ _FormControl_FormControl_js__WEBPACK_IMPORTED_MODULE_70__["default"]),
/* harmony export */   "NavList": () => (/* reexport safe */ _NavList_NavList_js__WEBPACK_IMPORTED_MODULE_71__.NavList),
/* harmony export */   "registerPortalRoot": () => (/* reexport safe */ _Portal_Portal_js__WEBPACK_IMPORTED_MODULE_72__.registerPortalRoot),
/* harmony export */   "SegmentedControl": () => (/* reexport safe */ _SegmentedControl_SegmentedControl_js__WEBPACK_IMPORTED_MODULE_73__.SegmentedControl),
/* harmony export */   "SelectPanel": () => (/* reexport safe */ _SelectPanel_SelectPanel_js__WEBPACK_IMPORTED_MODULE_74__.SelectPanel),
/* harmony export */   "Token": () => (/* reexport safe */ _Token_Token_js__WEBPACK_IMPORTED_MODULE_75__["default"]),
/* harmony export */   "IssueLabelToken": () => (/* reexport safe */ _Token_IssueLabelToken_js__WEBPACK_IMPORTED_MODULE_76__["default"]),
/* harmony export */   "AvatarToken": () => (/* reexport safe */ _Token_AvatarToken_js__WEBPACK_IMPORTED_MODULE_77__["default"]),
/* harmony export */   "SSRProvider": () => (/* reexport safe */ _react_aria_ssr__WEBPACK_IMPORTED_MODULE_78__.SSRProvider),
/* harmony export */   "useSSRSafeId": () => (/* reexport safe */ _react_aria_ssr__WEBPACK_IMPORTED_MODULE_78__.useSSRSafeId),
/* harmony export */   "merge": () => (/* reexport default from dynamic */ deepmerge__WEBPACK_IMPORTED_MODULE_79___default.a),
/* harmony export */   "IconButton": () => (/* reexport safe */ _Button_IconButton_js__WEBPACK_IMPORTED_MODULE_80__.IconButton),
/* harmony export */   "LinkButton": () => (/* reexport safe */ _Button_LinkButton_js__WEBPACK_IMPORTED_MODULE_81__.LinkButton)
/* harmony export */ });
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.js */ "./node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _BaseStyles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BaseStyles.js */ "./node_modules/@primer/react/lib-esm/BaseStyles.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ThemeProvider.js */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Box.js */ "./node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Button_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Button/index.js */ "./node_modules/@primer/react/lib-esm/Button/index.js");
/* harmony import */ var _hooks_useDetails_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hooks/useDetails.js */ "./node_modules/@primer/react/lib-esm/hooks/useDetails.js");
/* harmony import */ var _hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./hooks/useSafeTimeout.js */ "./node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js");
/* harmony import */ var _hooks_useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./hooks/useOnOutsideClick.js */ "./node_modules/@primer/react/lib-esm/hooks/useOnOutsideClick.js");
/* harmony import */ var _hooks_useOpenAndCloseFocus_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./hooks/useOpenAndCloseFocus.js */ "./node_modules/@primer/react/lib-esm/hooks/useOpenAndCloseFocus.js");
/* harmony import */ var _hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./hooks/useOnEscapePress.js */ "./node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js");
/* harmony import */ var _hooks_useOverlay_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./hooks/useOverlay.js */ "./node_modules/@primer/react/lib-esm/hooks/useOverlay.js");
/* harmony import */ var _Dialog_ConfirmationDialog_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Dialog/ConfirmationDialog.js */ "./node_modules/@primer/react/lib-esm/Dialog/ConfirmationDialog.js");
/* harmony import */ var _hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./hooks/useFocusTrap.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusTrap.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./hooks/useFocusZone.js */ "./node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./hooks/useRefObjectAsForwardedRef.js */ "./node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _Radio_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Radio.js */ "./node_modules/@primer/react/lib-esm/Radio.js");
/* harmony import */ var _ActionList_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./ActionList/index.js */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _ActionMenu_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./ActionMenu.js */ "./node_modules/@primer/react/lib-esm/ActionMenu.js");
/* harmony import */ var _Avatar_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Avatar.js */ "./node_modules/@primer/react/lib-esm/Avatar.js");
/* harmony import */ var _AvatarPair_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./AvatarPair.js */ "./node_modules/@primer/react/lib-esm/AvatarPair.js");
/* harmony import */ var _AvatarStack_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./AvatarStack.js */ "./node_modules/@primer/react/lib-esm/AvatarStack.js");
/* harmony import */ var _BranchName_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./BranchName.js */ "./node_modules/@primer/react/lib-esm/BranchName.js");
/* harmony import */ var _Breadcrumbs_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Breadcrumbs.js */ "./node_modules/@primer/react/lib-esm/Breadcrumbs.js");
/* harmony import */ var _ButtonGroup_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./ButtonGroup.js */ "./node_modules/@primer/react/lib-esm/ButtonGroup.js");
/* harmony import */ var _Caret_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./Caret.js */ "./node_modules/@primer/react/lib-esm/Caret.js");
/* harmony import */ var _CircleOcticon_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./CircleOcticon.js */ "./node_modules/@primer/react/lib-esm/CircleOcticon.js");
/* harmony import */ var _CheckboxGroup_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./CheckboxGroup.js */ "./node_modules/@primer/react/lib-esm/CheckboxGroup.js");
/* harmony import */ var _CircleBadge_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./CircleBadge.js */ "./node_modules/@primer/react/lib-esm/CircleBadge.js");
/* harmony import */ var _CounterLabel_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./CounterLabel.js */ "./node_modules/@primer/react/lib-esm/CounterLabel.js");
/* harmony import */ var _Details_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Details.js */ "./node_modules/@primer/react/lib-esm/Details.js");
/* harmony import */ var _Dialog_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Dialog.js */ "./node_modules/@primer/react/lib-esm/Dialog.js");
/* harmony import */ var _FilteredSearch_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./FilteredSearch.js */ "./node_modules/@primer/react/lib-esm/FilteredSearch.js");
/* harmony import */ var _FilterList_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./FilterList.js */ "./node_modules/@primer/react/lib-esm/FilterList.js");
/* harmony import */ var _Flash_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Flash.js */ "./node_modules/@primer/react/lib-esm/Flash.js");
/* harmony import */ var _Header_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Header.js */ "./node_modules/@primer/react/lib-esm/Header.js");
/* harmony import */ var _Heading_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./Heading.js */ "./node_modules/@primer/react/lib-esm/Heading.js");
/* harmony import */ var _Label_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Label.js */ "./node_modules/@primer/react/lib-esm/Label.js");
/* harmony import */ var _LabelGroup_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./LabelGroup.js */ "./node_modules/@primer/react/lib-esm/LabelGroup.js");
/* harmony import */ var _Link_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./Link.js */ "./node_modules/@primer/react/lib-esm/Link.js");
/* harmony import */ var _Overlay_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./Overlay.js */ "./node_modules/@primer/react/lib-esm/Overlay.js");
/* harmony import */ var _Pagehead_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./Pagehead.js */ "./node_modules/@primer/react/lib-esm/Pagehead.js");
/* harmony import */ var _Pagination_Pagination_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./Pagination/Pagination.js */ "./node_modules/@primer/react/lib-esm/Pagination/Pagination.js");
/* harmony import */ var _PointerBox_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./PointerBox.js */ "./node_modules/@primer/react/lib-esm/PointerBox.js");
/* harmony import */ var _Popover_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./Popover.js */ "./node_modules/@primer/react/lib-esm/Popover.js");
/* harmony import */ var _Portal_index_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./Portal/index.js */ "./node_modules/@primer/react/lib-esm/Portal/index.js");
/* harmony import */ var _ProgressBar_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./ProgressBar.js */ "./node_modules/@primer/react/lib-esm/ProgressBar.js");
/* harmony import */ var _RadioGroup_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./RadioGroup.js */ "./node_modules/@primer/react/lib-esm/RadioGroup.js");
/* harmony import */ var _Select_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./Select.js */ "./node_modules/@primer/react/lib-esm/Select.js");
/* harmony import */ var _SideNav_js__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./SideNav.js */ "./node_modules/@primer/react/lib-esm/SideNav.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./Spinner.js */ "./node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _StateLabel_js__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./StateLabel.js */ "./node_modules/@primer/react/lib-esm/StateLabel.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./StyledOcticon.js */ "./node_modules/@primer/react/lib-esm/StyledOcticon.js");
/* harmony import */ var _SubNav_js__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./SubNav.js */ "./node_modules/@primer/react/lib-esm/SubNav.js");
/* harmony import */ var _ToggleSwitch_js__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./ToggleSwitch.js */ "./node_modules/@primer/react/lib-esm/ToggleSwitch.js");
/* harmony import */ var _TabNav_js__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./TabNav.js */ "./node_modules/@primer/react/lib-esm/TabNav.js");
/* harmony import */ var _TextInput_js__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./TextInput.js */ "./node_modules/@primer/react/lib-esm/TextInput.js");
/* harmony import */ var _TextInputWithTokens_js__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./TextInputWithTokens.js */ "./node_modules/@primer/react/lib-esm/TextInputWithTokens.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./Text.js */ "./node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _Timeline_js__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./Timeline.js */ "./node_modules/@primer/react/lib-esm/Timeline.js");
/* harmony import */ var _Tooltip_js__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./Tooltip.js */ "./node_modules/@primer/react/lib-esm/Tooltip.js");
/* harmony import */ var _Truncate_js__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./Truncate.js */ "./node_modules/@primer/react/lib-esm/Truncate.js");
/* harmony import */ var _UnderlineNav_js__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./UnderlineNav.js */ "./node_modules/@primer/react/lib-esm/UnderlineNav.js");
/* harmony import */ var _Checkbox_js__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./Checkbox.js */ "./node_modules/@primer/react/lib-esm/Checkbox.js");
/* harmony import */ var _Textarea_js__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./Textarea.js */ "./node_modules/@primer/react/lib-esm/Textarea.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./sx.js */ "./node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _theme_preval_js__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./theme-preval.js */ "./node_modules/@primer/react/lib-esm/theme-preval.js");
/* harmony import */ var _PageLayout_PageLayout_js__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./PageLayout/PageLayout.js */ "./node_modules/@primer/react/lib-esm/PageLayout/PageLayout.js");
/* harmony import */ var _SplitPageLayout_SplitPageLayout_js__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./SplitPageLayout/SplitPageLayout.js */ "./node_modules/@primer/react/lib-esm/SplitPageLayout/SplitPageLayout.js");
/* harmony import */ var _AnchoredOverlay_AnchoredOverlay_js__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./AnchoredOverlay/AnchoredOverlay.js */ "./node_modules/@primer/react/lib-esm/AnchoredOverlay/AnchoredOverlay.js");
/* harmony import */ var _Autocomplete_Autocomplete_js__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./Autocomplete/Autocomplete.js */ "./node_modules/@primer/react/lib-esm/Autocomplete/Autocomplete.js");
/* harmony import */ var _FormControl_FormControl_js__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./FormControl/FormControl.js */ "./node_modules/@primer/react/lib-esm/FormControl/FormControl.js");
/* harmony import */ var _NavList_NavList_js__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./NavList/NavList.js */ "./node_modules/@primer/react/lib-esm/NavList/NavList.js");
/* harmony import */ var _Portal_Portal_js__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./Portal/Portal.js */ "./node_modules/@primer/react/lib-esm/Portal/Portal.js");
/* harmony import */ var _SegmentedControl_SegmentedControl_js__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./SegmentedControl/SegmentedControl.js */ "./node_modules/@primer/react/lib-esm/SegmentedControl/SegmentedControl.js");
/* harmony import */ var _SelectPanel_SelectPanel_js__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./SelectPanel/SelectPanel.js */ "./node_modules/@primer/react/lib-esm/SelectPanel/SelectPanel.js");
/* harmony import */ var _Token_Token_js__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./Token/Token.js */ "./node_modules/@primer/react/lib-esm/Token/Token.js");
/* harmony import */ var _Token_IssueLabelToken_js__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./Token/IssueLabelToken.js */ "./node_modules/@primer/react/lib-esm/Token/IssueLabelToken.js");
/* harmony import */ var _Token_AvatarToken_js__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./Token/AvatarToken.js */ "./node_modules/@primer/react/lib-esm/Token/AvatarToken.js");
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! @react-aria/ssr */ "./node_modules/@react-aria/ssr/dist/module.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_79___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_79__);
/* harmony import */ var _Button_IconButton_js__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./Button/IconButton.js */ "./node_modules/@primer/react/lib-esm/Button/IconButton.js");
/* harmony import */ var _Button_LinkButton_js__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./Button/LinkButton.js */ "./node_modules/@primer/react/lib-esm/Button/LinkButton.js");




















































































/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/utils/environment.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/utils/environment.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "canUseDOM": () => (/* binding */ canUseDOM)
/* harmony export */ });
/**
 * Indicate whether current execution environment can access the DOM.
 *
 * @see https://github.com/facebook/fbjs/blob/4d1751311d3f67af2dcce2e40df8512a23c7b9c6/packages/fbjs/src/core/ExecutionEnvironment.js#L12
 */
const canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);




/***/ }),

/***/ "./node_modules/@primer/react/lib-esm/utils/isNumeric.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/react/lib-esm/utils/isNumeric.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isNumeric)
/* harmony export */ });
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isNumeric(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}




/***/ }),

/***/ "./node_modules/@styled-system/props/dist/index.esm.js":
/*!*************************************************************!*\
  !*** ./node_modules/@styled-system/props/dist/index.esm.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "omit": () => (/* binding */ omit),
/* harmony export */   "pick": () => (/* binding */ pick)
/* harmony export */ });
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-system */ "./node_modules/styled-system/dist/index.esm.js");

var all = (0,styled_system__WEBPACK_IMPORTED_MODULE_0__.compose)(styled_system__WEBPACK_IMPORTED_MODULE_0__.space, styled_system__WEBPACK_IMPORTED_MODULE_0__.typography, styled_system__WEBPACK_IMPORTED_MODULE_0__.color, styled_system__WEBPACK_IMPORTED_MODULE_0__.layout, styled_system__WEBPACK_IMPORTED_MODULE_0__.flexbox, styled_system__WEBPACK_IMPORTED_MODULE_0__.border, styled_system__WEBPACK_IMPORTED_MODULE_0__.background, styled_system__WEBPACK_IMPORTED_MODULE_0__.position, styled_system__WEBPACK_IMPORTED_MODULE_0__.grid, styled_system__WEBPACK_IMPORTED_MODULE_0__.shadow, styled_system__WEBPACK_IMPORTED_MODULE_0__.buttonStyle, styled_system__WEBPACK_IMPORTED_MODULE_0__.textStyle, styled_system__WEBPACK_IMPORTED_MODULE_0__.colorStyle);
var regex = new RegExp("^(" + all.propNames.join('|') + ")$");
var omit = function omit(props) {
  var next = {};

  for (var key in props) {
    if (regex.test(key)) continue;
    next[key] = props[key];
  }

  return next;
};
var pick = function pick(props) {
  var next = {};

  for (var key in props) {
    if (!regex.test(key)) continue;
    next[key] = props[key];
  }

  return next;
};


/***/ }),

/***/ "./node_modules/color2k/dist/index.module.js":
/*!***************************************************!*\
  !*** ./node_modules/color2k/dist/index.module.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColorError": () => (/* binding */ n),
/* harmony export */   "adjustHue": () => (/* binding */ h),
/* harmony export */   "darken": () => (/* binding */ d),
/* harmony export */   "desaturate": () => (/* binding */ g),
/* harmony export */   "getContrast": () => (/* binding */ x),
/* harmony export */   "getLuminance": () => (/* binding */ w),
/* harmony export */   "getScale": () => (/* binding */ b),
/* harmony export */   "guard": () => (/* binding */ t),
/* harmony export */   "hasBadContrast": () => (/* binding */ j),
/* harmony export */   "hsla": () => (/* binding */ z),
/* harmony export */   "lighten": () => (/* binding */ $),
/* harmony export */   "mix": () => (/* binding */ y),
/* harmony export */   "opacify": () => (/* binding */ q),
/* harmony export */   "parseToHsla": () => (/* binding */ p),
/* harmony export */   "parseToRgba": () => (/* binding */ r),
/* harmony export */   "readableColor": () => (/* binding */ M),
/* harmony export */   "readableColorIsBlack": () => (/* binding */ F),
/* harmony export */   "rgba": () => (/* binding */ m),
/* harmony export */   "saturate": () => (/* binding */ A),
/* harmony export */   "toHex": () => (/* binding */ I),
/* harmony export */   "toHsla": () => (/* binding */ C),
/* harmony export */   "toRgba": () => (/* binding */ E),
/* harmony export */   "transparentize": () => (/* binding */ v)
/* harmony export */ });
function t(t,n,r){return Math.min(Math.max(t,r),n)}class n extends Error{constructor(t){super(`Failed to parse color: "${t}"`)}}function r(r){if("string"!=typeof r)throw new n(r);if("transparent"===r.trim().toLowerCase())return[0,0,0,0];let e=r.trim();e=u.test(r)?function(t){const r=t.toLowerCase().trim(),e=o[function(t){let n=5381,r=t.length;for(;r;)n=33*n^t.charCodeAt(--r);return(n>>>0)%2341}(r)];if(!e)throw new n(t);return`#${e}`}(r):r;const f=s.exec(e);if(f){const t=Array.from(f).slice(1);return[...t.slice(0,3).map(t=>parseInt(_(t,2),16)),parseInt(_(t[3]||"f",2),16)/255]}const p=i.exec(e);if(p){const t=Array.from(p).slice(1);return[...t.slice(0,3).map(t=>parseInt(t,16)),parseInt(t[3]||"ff",16)/255]}const z=a.exec(e);if(z){const t=Array.from(z).slice(1);return[...t.slice(0,3).map(t=>parseInt(t,10)),parseFloat(t[3]||"1")]}const h=c.exec(e);if(h){const[e,o,_,s]=Array.from(h).slice(1).map(parseFloat);if(t(0,100,o)!==o)throw new n(r);if(t(0,100,_)!==_)throw new n(r);return[...l(e,o,_),s||1]}throw new n(r)}const e=t=>parseInt(t.replace(/_/g,""),36),o="1q29ehhb 1n09sgk7 1kl1ekf_ _yl4zsno 16z9eiv3 1p29lhp8 _bd9zg04 17u0____ _iw9zhe5 _to73___ _r45e31e _7l6g016 _jh8ouiv _zn3qba8 1jy4zshs 11u87k0u 1ro9yvyo 1aj3xael 1gz9zjz0 _3w8l4xo 1bf1ekf_ _ke3v___ _4rrkb__ 13j776yz _646mbhl _nrjr4__ _le6mbhl 1n37ehkb _m75f91n _qj3bzfz 1939yygw 11i5z6x8 _1k5f8xs 1509441m 15t5lwgf _ae2th1n _tg1ugcv 1lp1ugcv 16e14up_ _h55rw7n _ny9yavn _7a11xb_ 1ih442g9 _pv442g9 1mv16xof 14e6y7tu 1oo9zkds 17d1cisi _4v9y70f _y98m8kc 1019pq0v 12o9zda8 _348j4f4 1et50i2o _8epa8__ _ts6senj 1o350i2o 1mi9eiuo 1259yrp0 1ln80gnw _632xcoy 1cn9zldc _f29edu4 1n490c8q _9f9ziet 1b94vk74 _m49zkct 1kz6s73a 1eu9dtog _q58s1rz 1dy9sjiq __u89jo3 _aj5nkwg _ld89jo3 13h9z6wx _qa9z2ii _l119xgq _bs5arju 1hj4nwk9 1qt4nwk9 1ge6wau6 14j9zlcw 11p1edc_ _ms1zcxe _439shk6 _jt9y70f _754zsow 1la40eju _oq5p___ _x279qkz 1fa5r3rv _yd2d9ip _424tcku _8y1di2_ _zi2uabw _yy7rn9h 12yz980_ __39ljp6 1b59zg0x _n39zfzp 1fy9zest _b33k___ _hp9wq92 1il50hz4 _io472ub _lj9z3eo 19z9ykg0 _8t8iu3a 12b9bl4a 1ak5yw0o _896v4ku _tb8k8lv _s59zi6t _c09ze0p 1lg80oqn 1id9z8wb _238nba5 1kq6wgdi _154zssg _tn3zk49 _da9y6tc 1sg7cv4f _r12jvtt 1gq5fmkz 1cs9rvci _lp9jn1c _xw1tdnb 13f9zje6 16f6973h _vo7ir40 _bt5arjf _rc45e4t _hr4e100 10v4e100 _hc9zke2 _w91egv_ _sj2r1kk 13c87yx8 _vqpds__ _ni8ggk8 _tj9yqfb 1ia2j4r4 _7x9b10u 1fc9ld4j 1eq9zldr _5j9lhpx _ez9zl6o _md61fzm".split(" ").reduce((t,n)=>{const r=e(n.substring(0,3)),o=e(n.substring(3)).toString(16);let _="";for(let t=0;t<6-o.length;t++)_+="0";return t[r]=`${_}${o}`,t},{}),_=(t,n)=>Array.from(Array(n)).map(()=>t).join(""),s=new RegExp(`^#${_("([a-f0-9])",3)}([a-f0-9])?$`,"i"),i=new RegExp(`^#${_("([a-f0-9]{2})",3)}([a-f0-9]{2})?$`,"i"),a=new RegExp(`^rgba?\\(\\s*(\\d+)\\s*${_(",\\s*(\\d+)\\s*",2)}(?:,\\s*([\\d.]+))?\\s*\\)$`,"i"),c=/^hsla?\(\s*([\d.]+)\s*,\s*([\d.]+)%\s*,\s*([\d.]+)%(?:\s*,\s*([\d.]+))?\s*\)$/i,u=/^[a-z]+$/i,f=t=>Math.round(255*t),l=(t,n,r)=>{let e=r/100;if(0===n)return[e,e,e].map(f);const o=(t%360+360)%360/60,_=(1-Math.abs(2*e-1))*(n/100),s=_*(1-Math.abs(o%2-1));let i=0,a=0,c=0;o>=0&&o<1?(i=_,a=s):o>=1&&o<2?(i=s,a=_):o>=2&&o<3?(a=_,c=s):o>=3&&o<4?(a=s,c=_):o>=4&&o<5?(i=s,c=_):o>=5&&o<6&&(i=_,c=s);const u=e-_/2;return[i+u,a+u,c+u].map(f)};function p(t){const[n,e,o,_]=r(t).map((t,n)=>3===n?t:t/255),s=Math.max(n,e,o),i=Math.min(n,e,o),a=(s+i)/2;if(s===i)return[0,0,a,_];const c=s-i;return[60*(n===s?(e-o)/c+(e<o?6:0):e===s?(o-n)/c+2:(n-e)/c+4),a>.5?c/(2-s-i):c/(s+i),a,_]}function z(n,r,e,o){return`hsla(${(n%360).toFixed()}, ${t(0,100,100*r).toFixed()}%, ${t(0,100,100*e).toFixed()}%, ${parseFloat(t(0,1,o).toFixed(3))})`}function h(t,n){const[r,e,o,_]=p(t);return z(r+n,e,o,_)}function d(t,n){const[r,e,o,_]=p(t);return z(r,e,o-n,_)}function g(t,n){const[r,e,o,_]=p(t);return z(r,e-n,o,_)}function w(t){if("transparent"===t)return 0;function n(t){const n=t/255;return n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4)}const[e,o,_]=r(t);return.2126*n(e)+.7152*n(o)+.0722*n(_)}function x(t,n){const r=w(t),e=w(n);return r>e?(r+.05)/(e+.05):(e+.05)/(r+.05)}function m(n,r,e,o){return`rgba(${t(0,255,n).toFixed()}, ${t(0,255,r).toFixed()}, ${t(0,255,e).toFixed()}, ${parseFloat(t(0,1,o).toFixed(3))})`}function y(t,n,e){const o=(t,n)=>3===n?t:t/255,[_,s,i,a]=r(t).map(o),[c,u,f,l]=r(n).map(o),p=l-a,z=2*e-1,h=((z*p==-1?z:z+p/(1+z*p))+1)/2,d=1-h;return m(255*(_*d+c*h),255*(s*d+u*h),255*(i*d+f*h),l*e+a*(1-e))}function b(){var n=[].slice.call(arguments);return r=>{const e=n.length-1,o=t(0,e,Math.floor(r*e)),_=t(0,e,Math.ceil(r*e)),s=1/e;return y(n[o],n[_],(r-s*o)/s)}}const k={decorative:1.5,readable:3,aa:4.5,aaa:7};function j(t,n="aa"){return x(t,"#fff")<k[n]}function $(t,n){return d(t,-n)}function v(t,n){const[e,o,_,s]=r(t);return m(e,o,_,s-n)}function q(t,n){return v(t,-n)}function F(t){return w(t)>.179}function M(t){return F(t)?"#000":"#fff"}function A(t,n){return g(t,-n)}function I(n){const[e,o,_,s]=r(n);let i=n=>{const r=t(0,255,n).toString(16);return 1===r.length?`0${r}`:r};return`#${i(e)}${i(o)}${i(_)}${s<1?i(Math.round(255*s)):""}`}function E(t){return m(...r(t))}function C(t){return z(...p(t))}
//# sourceMappingURL=index.module.js.map


/***/ }),

/***/ "./node_modules/focus-visible/dist/focus-visible.js":
/*!**********************************************************!*\
  !*** ./node_modules/focus-visible/dist/focus-visible.js ***!
  \**********************************************************/
/***/ (function() {

(function (global, factory) {
   true ? factory() :
  0;
}(this, (function () { 'use strict';

  /**
   * Applies the :focus-visible polyfill at the given scope.
   * A scope in this case is either the top-level Document or a Shadow Root.
   *
   * @param {(Document|ShadowRoot)} scope
   * @see https://github.com/WICG/focus-visible
   */
  function applyFocusVisiblePolyfill(scope) {
    var hadKeyboardEvent = true;
    var hadFocusVisibleRecently = false;
    var hadFocusVisibleRecentlyTimeout = null;

    var inputTypesAllowlist = {
      text: true,
      search: true,
      url: true,
      tel: true,
      email: true,
      password: true,
      number: true,
      date: true,
      month: true,
      week: true,
      time: true,
      datetime: true,
      'datetime-local': true
    };

    /**
     * Helper function for legacy browsers and iframes which sometimes focus
     * elements like document, body, and non-interactive SVG.
     * @param {Element} el
     */
    function isValidFocusTarget(el) {
      if (
        el &&
        el !== document &&
        el.nodeName !== 'HTML' &&
        el.nodeName !== 'BODY' &&
        'classList' in el &&
        'contains' in el.classList
      ) {
        return true;
      }
      return false;
    }

    /**
     * Computes whether the given element should automatically trigger the
     * `focus-visible` class being added, i.e. whether it should always match
     * `:focus-visible` when focused.
     * @param {Element} el
     * @return {boolean}
     */
    function focusTriggersKeyboardModality(el) {
      var type = el.type;
      var tagName = el.tagName;

      if (tagName === 'INPUT' && inputTypesAllowlist[type] && !el.readOnly) {
        return true;
      }

      if (tagName === 'TEXTAREA' && !el.readOnly) {
        return true;
      }

      if (el.isContentEditable) {
        return true;
      }

      return false;
    }

    /**
     * Add the `focus-visible` class to the given element if it was not added by
     * the author.
     * @param {Element} el
     */
    function addFocusVisibleClass(el) {
      if (el.classList.contains('focus-visible')) {
        return;
      }
      el.classList.add('focus-visible');
      el.setAttribute('data-focus-visible-added', '');
    }

    /**
     * Remove the `focus-visible` class from the given element if it was not
     * originally added by the author.
     * @param {Element} el
     */
    function removeFocusVisibleClass(el) {
      if (!el.hasAttribute('data-focus-visible-added')) {
        return;
      }
      el.classList.remove('focus-visible');
      el.removeAttribute('data-focus-visible-added');
    }

    /**
     * If the most recent user interaction was via the keyboard;
     * and the key press did not include a meta, alt/option, or control key;
     * then the modality is keyboard. Otherwise, the modality is not keyboard.
     * Apply `focus-visible` to any current active element and keep track
     * of our keyboard modality state with `hadKeyboardEvent`.
     * @param {KeyboardEvent} e
     */
    function onKeyDown(e) {
      if (e.metaKey || e.altKey || e.ctrlKey) {
        return;
      }

      if (isValidFocusTarget(scope.activeElement)) {
        addFocusVisibleClass(scope.activeElement);
      }

      hadKeyboardEvent = true;
    }

    /**
     * If at any point a user clicks with a pointing device, ensure that we change
     * the modality away from keyboard.
     * This avoids the situation where a user presses a key on an already focused
     * element, and then clicks on a different element, focusing it with a
     * pointing device, while we still think we're in keyboard modality.
     * @param {Event} e
     */
    function onPointerDown(e) {
      hadKeyboardEvent = false;
    }

    /**
     * On `focus`, add the `focus-visible` class to the target if:
     * - the target received focus as a result of keyboard navigation, or
     * - the event target is an element that will likely require interaction
     *   via the keyboard (e.g. a text box)
     * @param {Event} e
     */
    function onFocus(e) {
      // Prevent IE from focusing the document or HTML element.
      if (!isValidFocusTarget(e.target)) {
        return;
      }

      if (hadKeyboardEvent || focusTriggersKeyboardModality(e.target)) {
        addFocusVisibleClass(e.target);
      }
    }

    /**
     * On `blur`, remove the `focus-visible` class from the target.
     * @param {Event} e
     */
    function onBlur(e) {
      if (!isValidFocusTarget(e.target)) {
        return;
      }

      if (
        e.target.classList.contains('focus-visible') ||
        e.target.hasAttribute('data-focus-visible-added')
      ) {
        // To detect a tab/window switch, we look for a blur event followed
        // rapidly by a visibility change.
        // If we don't see a visibility change within 100ms, it's probably a
        // regular focus change.
        hadFocusVisibleRecently = true;
        window.clearTimeout(hadFocusVisibleRecentlyTimeout);
        hadFocusVisibleRecentlyTimeout = window.setTimeout(function() {
          hadFocusVisibleRecently = false;
        }, 100);
        removeFocusVisibleClass(e.target);
      }
    }

    /**
     * If the user changes tabs, keep track of whether or not the previously
     * focused element had .focus-visible.
     * @param {Event} e
     */
    function onVisibilityChange(e) {
      if (document.visibilityState === 'hidden') {
        // If the tab becomes active again, the browser will handle calling focus
        // on the element (Safari actually calls it twice).
        // If this tab change caused a blur on an element with focus-visible,
        // re-apply the class when the user switches back to the tab.
        if (hadFocusVisibleRecently) {
          hadKeyboardEvent = true;
        }
        addInitialPointerMoveListeners();
      }
    }

    /**
     * Add a group of listeners to detect usage of any pointing devices.
     * These listeners will be added when the polyfill first loads, and anytime
     * the window is blurred, so that they are active when the window regains
     * focus.
     */
    function addInitialPointerMoveListeners() {
      document.addEventListener('mousemove', onInitialPointerMove);
      document.addEventListener('mousedown', onInitialPointerMove);
      document.addEventListener('mouseup', onInitialPointerMove);
      document.addEventListener('pointermove', onInitialPointerMove);
      document.addEventListener('pointerdown', onInitialPointerMove);
      document.addEventListener('pointerup', onInitialPointerMove);
      document.addEventListener('touchmove', onInitialPointerMove);
      document.addEventListener('touchstart', onInitialPointerMove);
      document.addEventListener('touchend', onInitialPointerMove);
    }

    function removeInitialPointerMoveListeners() {
      document.removeEventListener('mousemove', onInitialPointerMove);
      document.removeEventListener('mousedown', onInitialPointerMove);
      document.removeEventListener('mouseup', onInitialPointerMove);
      document.removeEventListener('pointermove', onInitialPointerMove);
      document.removeEventListener('pointerdown', onInitialPointerMove);
      document.removeEventListener('pointerup', onInitialPointerMove);
      document.removeEventListener('touchmove', onInitialPointerMove);
      document.removeEventListener('touchstart', onInitialPointerMove);
      document.removeEventListener('touchend', onInitialPointerMove);
    }

    /**
     * When the polfyill first loads, assume the user is in keyboard modality.
     * If any event is received from a pointing device (e.g. mouse, pointer,
     * touch), turn off keyboard modality.
     * This accounts for situations where focus enters the page from the URL bar.
     * @param {Event} e
     */
    function onInitialPointerMove(e) {
      // Work around a Safari quirk that fires a mousemove on <html> whenever the
      // window blurs, even if you're tabbing out of the page. ¯\_(ツ)_/¯
      if (e.target.nodeName && e.target.nodeName.toLowerCase() === 'html') {
        return;
      }

      hadKeyboardEvent = false;
      removeInitialPointerMoveListeners();
    }

    // For some kinds of state, we are interested in changes at the global scope
    // only. For example, global pointer input, global key presses and global
    // visibility change should affect the state at every scope:
    document.addEventListener('keydown', onKeyDown, true);
    document.addEventListener('mousedown', onPointerDown, true);
    document.addEventListener('pointerdown', onPointerDown, true);
    document.addEventListener('touchstart', onPointerDown, true);
    document.addEventListener('visibilitychange', onVisibilityChange, true);

    addInitialPointerMoveListeners();

    // For focus and blur, we specifically care about state changes in the local
    // scope. This is because focus / blur events that originate from within a
    // shadow root are not re-dispatched from the host element if it was already
    // the active element in its own scope:
    scope.addEventListener('focus', onFocus, true);
    scope.addEventListener('blur', onBlur, true);

    // We detect that a node is a ShadowRoot by ensuring that it is a
    // DocumentFragment and also has a host property. This check covers native
    // implementation and polyfill implementation transparently. If we only cared
    // about the native implementation, we could just check if the scope was
    // an instance of a ShadowRoot.
    if (scope.nodeType === Node.DOCUMENT_FRAGMENT_NODE && scope.host) {
      // Since a ShadowRoot is a special kind of DocumentFragment, it does not
      // have a root element to add a class to. So, we add this attribute to the
      // host element instead:
      scope.host.setAttribute('data-js-focus-visible', '');
    } else if (scope.nodeType === Node.DOCUMENT_NODE) {
      document.documentElement.classList.add('js-focus-visible');
      document.documentElement.setAttribute('data-js-focus-visible', '');
    }
  }

  // It is important to wrap all references to global window and document in
  // these checks to support server-side rendering use cases
  // @see https://github.com/WICG/focus-visible/issues/199
  if (typeof window !== 'undefined' && typeof document !== 'undefined') {
    // Make the polyfill helper globally available. This can be used as a signal
    // to interested libraries that wish to coordinate with the polyfill for e.g.,
    // applying the polyfill to a shadow root:
    window.applyFocusVisiblePolyfill = applyFocusVisiblePolyfill;

    // Notify interested libraries of the polyfill's presence, in case the
    // polyfill was loaded lazily:
    var event;

    try {
      event = new CustomEvent('focus-visible-polyfill-ready');
    } catch (error) {
      // IE11 does not support using CustomEvent as a constructor directly:
      event = document.createEvent('CustomEvent');
      event.initCustomEvent('focus-visible-polyfill-ready', false, false, {});
    }

    window.dispatchEvent(event);
  }

  if (typeof document !== 'undefined') {
    // Apply the polyfill to the global document, so that no JavaScript
    // coordination is required to use the polyfill in the top-level document:
    applyFocusVisiblePolyfill(document);
  }

})));


/***/ }),

/***/ "./node_modules/react-intersection-observer/react-intersection-observer.modern.mjs":
/*!*****************************************************************************************!*\
  !*** ./node_modules/react-intersection-observer/react-intersection-observer.modern.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InView": () => (/* binding */ InView),
/* harmony export */   "defaultFallbackInView": () => (/* binding */ defaultFallbackInView),
/* harmony export */   "observe": () => (/* binding */ observe),
/* harmony export */   "useInView": () => (/* binding */ useInView)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

const observerMap = new Map();
const RootIds = new WeakMap();
let rootId = 0;
let unsupportedValue = undefined;
/**
 * What should be the default behavior if the IntersectionObserver is unsupported?
 * Ideally the polyfill has been loaded, you can have the following happen:
 * - `undefined`: Throw an error
 * - `true` or `false`: Set the `inView` value to this regardless of intersection state
 * **/

function defaultFallbackInView(inView) {
  unsupportedValue = inView;
}
/**
 * Generate a unique ID for the root element
 * @param root
 */

function getRootId(root) {
  if (!root) return '0';
  if (RootIds.has(root)) return RootIds.get(root);
  rootId += 1;
  RootIds.set(root, rootId.toString());
  return RootIds.get(root);
}
/**
 * Convert the options to a string Id, based on the values.
 * Ensures we can reuse the same observer when observing elements with the same options.
 * @param options
 */


function optionsToId(options) {
  return Object.keys(options).sort().filter(key => options[key] !== undefined).map(key => {
    return `${key}_${key === 'root' ? getRootId(options.root) : options[key]}`;
  }).toString();
}

function createObserver(options) {
  // Create a unique ID for this observer instance, based on the root, root margin and threshold.
  let id = optionsToId(options);
  let instance = observerMap.get(id);

  if (!instance) {
    // Create a map of elements this observer is going to observe. Each element has a list of callbacks that should be triggered, once it comes into view.
    const elements = new Map();
    let thresholds;
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        var _elements$get;

        // While it would be nice if you could just look at isIntersecting to determine if the component is inside the viewport, browsers can't agree on how to use it.
        // -Firefox ignores `threshold` when considering `isIntersecting`, so it will never be false again if `threshold` is > 0
        const inView = entry.isIntersecting && thresholds.some(threshold => entry.intersectionRatio >= threshold); // @ts-ignore support IntersectionObserver v2

        if (options.trackVisibility && typeof entry.isVisible === 'undefined') {
          // The browser doesn't support Intersection Observer v2, falling back to v1 behavior.
          // @ts-ignore
          entry.isVisible = inView;
        }

        (_elements$get = elements.get(entry.target)) == null ? void 0 : _elements$get.forEach(callback => {
          callback(inView, entry);
        });
      });
    }, options); // Ensure we have a valid thresholds array. If not, use the threshold from the options

    thresholds = observer.thresholds || (Array.isArray(options.threshold) ? options.threshold : [options.threshold || 0]);
    instance = {
      id,
      observer,
      elements
    };
    observerMap.set(id, instance);
  }

  return instance;
}
/**
 * @param element - DOM Element to observe
 * @param callback - Callback function to trigger when intersection status changes
 * @param options - Intersection Observer options
 * @param fallbackInView - Fallback inView value.
 * @return Function - Cleanup function that should be triggered to unregister the observer
 */


function observe(element, callback, options = {}, fallbackInView = unsupportedValue) {
  if (typeof window.IntersectionObserver === 'undefined' && fallbackInView !== undefined) {
    const bounds = element.getBoundingClientRect();
    callback(fallbackInView, {
      isIntersecting: fallbackInView,
      target: element,
      intersectionRatio: typeof options.threshold === 'number' ? options.threshold : 0,
      time: 0,
      boundingClientRect: bounds,
      intersectionRect: bounds,
      rootBounds: bounds
    });
    return () => {// Nothing to cleanup
    };
  } // An observer with the same options can be reused, so lets use this fact


  const {
    id,
    observer,
    elements
  } = createObserver(options); // Register the callback listener for this element

  let callbacks = elements.get(element) || [];

  if (!elements.has(element)) {
    elements.set(element, callbacks);
  }

  callbacks.push(callback);
  observer.observe(element);
  return function unobserve() {
    // Remove the callback from the callback list
    callbacks.splice(callbacks.indexOf(callback), 1);

    if (callbacks.length === 0) {
      // No more callback exists for element, so destroy it
      elements.delete(element);
      observer.unobserve(element);
    }

    if (elements.size === 0) {
      // No more elements are being observer by this instance, so destroy it
      observer.disconnect();
      observerMap.delete(id);
    }
  };
}

const _excluded = ["children", "as", "triggerOnce", "threshold", "root", "rootMargin", "onChange", "skip", "trackVisibility", "delay", "initialInView", "fallbackInView"];

function isPlainChildren(props) {
  return typeof props.children !== 'function';
}
/**
 ## Render props

 To use the `<InView>` component, you pass it a function. It will be called
 whenever the state changes, with the new value of `inView`. In addition to the
 `inView` prop, children also receive a `ref` that should be set on the
 containing DOM element. This is the element that the IntersectionObserver will
 monitor.

 If you need it, you can also access the
 [`IntersectionObserverEntry`](https://developer.mozilla.org/en-US/docs/Web/API/IntersectionObserverEntry)
 on `entry`, giving you access to all the details about the current intersection
 state.

 ```jsx
 import { InView } from 'react-intersection-observer';

 const Component = () => (
 <InView>
 {({ inView, ref, entry }) => (
      <div ref={ref}>
        <h2>{`Header inside viewport ${inView}.`}</h2>
      </div>
    )}
 </InView>
 );

 export default Component;
 ```

 ## Plain children

 You can pass any element to the `<InView />`, and it will handle creating the
 wrapping DOM element. Add a handler to the `onChange` method, and control the
 state in your own component. Any extra props you add to `<InView>` will be
 passed to the HTML element, allowing you set the `className`, `style`, etc.

 ```jsx
 import { InView } from 'react-intersection-observer';

 const Component = () => (
 <InView as="div" onChange={(inView, entry) => console.log('Inview:', inView)}>
 <h2>Plain children are always rendered. Use onChange to monitor state.</h2>
 </InView>
 );

 export default Component;
 ```
 */


class InView extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.node = null;
    this._unobserveCb = null;

    this.handleNode = node => {
      if (this.node) {
        // Clear the old observer, before we start observing a new element
        this.unobserve();

        if (!node && !this.props.triggerOnce && !this.props.skip) {
          // Reset the state if we get a new node, and we aren't ignoring updates
          this.setState({
            inView: !!this.props.initialInView,
            entry: undefined
          });
        }
      }

      this.node = node ? node : null;
      this.observeNode();
    };

    this.handleChange = (inView, entry) => {
      if (inView && this.props.triggerOnce) {
        // If `triggerOnce` is true, we should stop observing the element.
        this.unobserve();
      }

      if (!isPlainChildren(this.props)) {
        // Store the current State, so we can pass it to the children in the next render update
        // There's no reason to update the state for plain children, since it's not used in the rendering.
        this.setState({
          inView,
          entry
        });
      }

      if (this.props.onChange) {
        // If the user is actively listening for onChange, always trigger it
        this.props.onChange(inView, entry);
      }
    };

    this.state = {
      inView: !!props.initialInView,
      entry: undefined
    };
  }

  componentDidUpdate(prevProps) {
    // If a IntersectionObserver option changed, reinit the observer
    if (prevProps.rootMargin !== this.props.rootMargin || prevProps.root !== this.props.root || prevProps.threshold !== this.props.threshold || prevProps.skip !== this.props.skip || prevProps.trackVisibility !== this.props.trackVisibility || prevProps.delay !== this.props.delay) {
      this.unobserve();
      this.observeNode();
    }
  }

  componentWillUnmount() {
    this.unobserve();
    this.node = null;
  }

  observeNode() {
    if (!this.node || this.props.skip) return;
    const {
      threshold,
      root,
      rootMargin,
      trackVisibility,
      delay,
      fallbackInView
    } = this.props;
    this._unobserveCb = observe(this.node, this.handleChange, {
      threshold,
      root,
      rootMargin,
      // @ts-ignore
      trackVisibility,
      // @ts-ignore
      delay
    }, fallbackInView);
  }

  unobserve() {
    if (this._unobserveCb) {
      this._unobserveCb();

      this._unobserveCb = null;
    }
  }

  render() {
    if (!isPlainChildren(this.props)) {
      const {
        inView,
        entry
      } = this.state;
      return this.props.children({
        inView,
        entry,
        ref: this.handleNode
      });
    }

    const _this$props = this.props,
          {
      children,
      as
    } = _this$props,
          props = _objectWithoutPropertiesLoose(_this$props, _excluded);

    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(as || 'div', _extends({
      ref: this.handleNode
    }, props), children);
  }

}

/**
 * React Hooks make it easy to monitor the `inView` state of your components. Call
 * the `useInView` hook with the (optional) [options](#options) you need. It will
 * return an array containing a `ref`, the `inView` status and the current
 * [`entry`](https://developer.mozilla.org/en-US/docs/Web/API/IntersectionObserverEntry).
 * Assign the `ref` to the DOM element you want to monitor, and the hook will
 * report the status.
 *
 * @example
 * ```jsx
 * import React from 'react';
 * import { useInView } from 'react-intersection-observer';
 *
 * const Component = () => {
 *   const { ref, inView, entry } = useInView({
 *       threshold: 0,
 *   });
 *
 *   return (
 *     <div ref={ref}>
 *       <h2>{`Header inside viewport ${inView}.`}</h2>
 *     </div>
 *   );
 * };
 * ```
 */

function useInView({
  threshold,
  delay,
  trackVisibility,
  rootMargin,
  root,
  triggerOnce,
  skip,
  initialInView,
  fallbackInView,
  onChange
} = {}) {
  var _state$entry;

  const [ref, setRef] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  const callback = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const [state, setState] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    inView: !!initialInView,
    entry: undefined
  }); // Store the onChange callback in a `ref`, so we can access the latest instance
  // inside the `useEffect`, but without triggering a rerender.

  callback.current = onChange;
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    // Ensure we have node ref, and that we shouldn't skip observing
    if (skip || !ref) return;
    let unobserve;
    unobserve = observe(ref, (inView, entry) => {
      setState({
        inView,
        entry
      });
      if (callback.current) callback.current(inView, entry);

      if (entry.isIntersecting && triggerOnce && unobserve) {
        // If it should only trigger once, unobserve the element after it's inView
        unobserve();
        unobserve = undefined;
      }
    }, {
      root,
      rootMargin,
      threshold,
      // @ts-ignore
      trackVisibility,
      // @ts-ignore
      delay
    }, fallbackInView);
    return () => {
      if (unobserve) {
        unobserve();
      }
    };
  }, // We break the rule here, because we aren't including the actual `threshold` variable
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [// If the threshold is an array, convert it to a string, so it won't change between renders.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  Array.isArray(threshold) ? threshold.toString() : threshold, ref, root, rootMargin, triggerOnce, skip, trackVisibility, fallbackInView, delay]);
  const entryTarget = (_state$entry = state.entry) == null ? void 0 : _state$entry.target;
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!ref && entryTarget && !triggerOnce && !skip) {
      // If we don't have a node ref, then reset the state (unless the hook is set to only `triggerOnce` or `skip`)
      // This ensures we correctly reflect the current state - If you aren't observing anything, then nothing is inView
      setState({
        inView: !!initialInView,
        entry: undefined
      });
    }
  }, [ref, entryTarget, triggerOnce, skip, initialInView]);
  const result = [setRef, state.inView, state.entry]; // Support object destructuring, by adding the specific values.

  result.ref = result[0];
  result.inView = result[1];
  result.entry = result[2];
  return result;
}


//# sourceMappingURL=react-intersection-observer.modern.mjs.map


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_primer_react_lib-esm_index_js.7d5c1140bdfcd8769e0d.js.map