# generated by datamodel-codegen:
#   filename:  aiapi.yaml
#   timestamp: 2024-12-26T16:55:15+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, confloat, conint, constr


class StatusResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    ready: bool
    reason: Optional[str] = None


class ImpactBigQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    requestId: str = Field(
        ..., description="Unique identifier for the request", examples=["124ab1c"]
    )
    caller: str = Field(
        ...,
        description="Full resource name of the BigQuery job",
        examples=[
            "//bigquery.googleapis.com/projects/myproject/jobs/myproject:US.bquxjob_5b4c112c_17961fafeaf"
        ],
    )
    sessionUser: str = Field(
        ...,
        description="Email of the user executing the BigQuery query",
        examples=["user@company.com"],
    )
    userDefinedContext: Optional[Dict[str, Any]] = Field(
        None, description="User-defined context from BigQuery"
    )
    calls: List[List[Union[str, int]]]


class ImpactBigQueryResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    replies: List[str] = Field(
        ..., description="Array of impact metric results", max_length=1000, min_length=0
    )
    errorMessage: Optional[str] = None


class ImpactBigQueryError(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    errorMessage: str = Field(
        ...,
        description="Error message for BigQuery",
        examples=["Invalid request format: missing required field 'calls'"],
    )


class ImpactMetrics(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    usage_energy_wh: float = Field(..., examples=[0.13])
    usage_emissions_gco2e: float = Field(..., examples=[0.81])
    usage_water_ml: float = Field(..., examples=[1.32])
    embodied_emissions_gco2e: float = Field(..., examples=[0.81])
    embodied_water_ml: float = Field(..., examples=[1.32])


class PredictionStep(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    description: str
    duration_ms: float
    inferences: int


class Details(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    reason: Optional[str] = None
    field: Optional[str] = None


class Error(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    code: Optional[str] = None
    message: str
    details: Optional[Details] = None


class GPU(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    name: Optional[str] = Field(None, examples=["NVIDIA A100 40GB"])
    id: Optional[str] = Field(None, examples=["a100_40gb"])
    max_power_w: Optional[float] = Field(None, examples=[700])
    embodied_emissions_kgco2e: Optional[float] = Field(None, examples=[282.1])
    embodied_water_mlh2o: Optional[float] = Field(None, examples=[181.1])
    performance_ratio_to_h200: Optional[float] = Field(None, examples=[1.5])


class ManagedServiceProvider(Enum):
    aws_bedrock = "aws-bedrock"
    azure_ml = "azure-ml"
    google_vertex = "google-vertex"
    ibm_watson = "ibm-watson"
    hugging_face = "hugging-face"


class Image(RootModel[constr(pattern=r"^\d{1,4}x\d{1,4}$")]):
    root: constr(pattern=r"^\d{1,4}x\d{1,4}$") = Field(..., examples=["1024x1024"])


class CloudProvider(Enum):
    aws = "aws"
    azure = "azure"
    gcp = "gcp"
    oracle = "oracle"
    ibm = "ibm"


class Task(Enum):
    """
    Common types of AI/ML models and their primary functions:
    - Text-based models for natural language processing
    - Vision models for image analysis and generation
    - Audio models for speech and sound processing
    - Multimodal models that combine different types of inputs/outputs
    - Specialized models for specific use cases

    """

    text_generation = "text-generation"
    chat = "chat"
    text_embedding = "text-embedding"
    text_classification = "text-classification"
    sentiment_analysis = "sentiment-analysis"
    named_entity_recognition = "named-entity-recognition"
    question_answering = "question-answering"
    summarization = "summarization"
    translation = "translation"
    image_classification = "image-classification"
    object_detection = "object-detection"
    image_segmentation = "image-segmentation"
    image_generation = "image-generation"
    image_to_text = "image-to-text"
    text_to_image = "text-to-image"
    style_transfer = "style-transfer"
    face_detection = "face-detection"
    facial_recognition = "facial-recognition"
    speech_to_text = "speech-to-text"
    text_to_speech = "text-to-speech"
    speaker_identification = "speaker-identification"
    audio_classification = "audio-classification"
    music_generation = "music-generation"
    multimodal_embedding = "multimodal-embedding"
    multimodal_generation = "multimodal-generation"
    visual_question_answering = "visual-question-answering"
    recommendation_system = "recommendation-system"
    reinforcement_learning = "reinforcement-learning"
    anomaly_detection = "anomaly-detection"
    time_series_forecasting = "time-series-forecasting"
    clustering = "clustering"


class Family(Enum):
    """
    Core AI model families from various organizations:
    - Commercial models from major AI companies
    - Open source model families
    - Research/academic model families
    - Models may appear in multiple categories if they have both commercial and open source variants

    """

    claude = "claude"
    gpt = "gpt"
    dall_e = "dall-e"
    whisper = "whisper"
    gemini = "gemini"
    palm = "palm"
    bert = "bert"
    t5 = "t5"
    llama = "llama"
    opt = "opt"
    galactica = "galactica"
    phi = "phi"
    stable_diffusion = "stable-diffusion"
    stable_lm = "stable-lm"
    mistral = "mistral"
    mixtral = "mixtral"
    command = "command"
    embed = "embed"
    falcon = "falcon"
    mpt = "mpt"
    pythia = "pythia"
    dolly = "dolly"
    bloom = "bloom"
    roberta = "roberta"
    gpt_neo = "gpt-neo"
    gpt_j = "gpt-j"


class DataType(Enum):
    fp8 = "fp8"
    fp8_e4m3 = "fp8-e4m3"
    fp8_e5m2 = "fp8-e5m2"
    fp16 = "fp16"
    tf32 = "tf32"
    fp32 = "fp32"
    fp64 = "fp64"
    bfloat8 = "bfloat8"
    bfloat16 = "bfloat16"
    bf16 = "bf16"
    int4 = "int4"
    int8 = "int8"
    int16 = "int16"
    int32 = "int32"
    int64 = "int64"
    uint4 = "uint4"
    uint8 = "uint8"
    uint16 = "uint16"
    uint32 = "uint32"
    uint64 = "uint64"


class CountryCode(RootModel[constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2)]):
    root: constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2) = Field(
        ...,
        description="Two-letter country code as defined by ISO 3166-1 alpha-2",
        examples=["US"],
    )


class RegionCode(RootModel[constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2)]):
    root: constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2) = Field(
        ...,
        description="Two-letter region code as defined by ISO 3166-1 alpha-2",
        examples=["NY"],
    )


class GPUResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    gpus: List[GPU] = Field(..., max_length=100)


class ImpactLogRow(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    start_time_utc: Optional[datetime] = Field(
        None,
        description="The start time of the inference",
        examples=["2024-10-01T00:00:00Z"],
    )
    request_duration_ms: Optional[float] = Field(
        None,
        description="The time the request took (as measured by client or proxy)",
        examples=[283],
    )
    processing_duration_ms: Optional[float] = Field(
        None,
        description="The time taken in processing the request (as measured at execution)",
        examples=[238],
    )
    integration_source: Optional[str] = Field(
        None,
        description="The integration used to source the data",
        examples=["litellm"],
    )
    client_id: Optional[str] = Field(
        None, description="The client to attribute this call to"
    )
    project_id: Optional[str] = Field(
        None, description="The project to attribute this call to"
    )
    application_id: Optional[str] = Field(
        None, description="The application to attribute this call to"
    )
    session_id: Optional[str] = Field(
        None, description="The ID of the session (multiple requests)"
    )
    request_id: Optional[str] = Field(
        None, description="The unique identifier of this request"
    )
    environment: Optional[str] = Field(
        None,
        description="Environment (prod/production indicates production)",
        examples=["staging"],
    )
    model_id: Optional[str] = Field(
        None, description="The ID of the model requested", examples=["llama_31_8b"]
    )
    model_id_used: Optional[str] = Field(
        None,
        description="The ID of the model that did the inference",
        examples=["llama_31_8b_0125"],
    )
    model_name: Optional[str] = Field(
        None, description="The name of the model", examples=["LLaMa v3.1 8B"]
    )
    model_family: Optional[str] = Field(
        None, description="The family of the model", examples=["llama"]
    )
    model_hugging_face_path: Optional[str] = Field(
        None,
        description="The Hugging Face path of the model",
        examples=["meta/llama31_8b"],
    )
    cloud_id: Optional[str] = Field(
        None, description="The ID of the cloud", examples=["aws"]
    )
    cloud_region: Optional[str] = Field(
        None, description="The region of cloud hosting", examples=["us-central1"]
    )
    cloud_instance_id: Optional[str] = Field(
        None, description="The instance type in the cloud", examples=["xl-4g-8a100"]
    )
    managed_service_id: Optional[str] = Field(
        None,
        description="The ID of a managed service provider",
        examples=["aws-bedrock"],
    )
    node_id: Optional[str] = Field(
        None, description="The ID of a proprietary node", examples=["h200-2024-build"]
    )
    node_country: Optional[
        constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2)
    ] = Field(
        None, description="The country where the servers are hosted", examples=["US"]
    )
    node_region: Optional[constr(pattern=r"^[A-Z]{2}$", min_length=2, max_length=2)] = (
        Field(
            None, description="The region where the servers are hosted", examples=["CA"]
        )
    )
    task: Optional[Task] = Field(
        None, description="The task the AI is performing", examples=["text-generation"]
    )
    input_tokens: Optional[conint(ge=0, le=100000000)] = Field(
        None, description="the number of input tokens", examples=[1033]
    )
    output_tokens: Optional[conint(ge=0, le=100000000)] = Field(
        None, description="the number of output tokens", examples=[2300]
    )
    input_audio_seconds: Optional[conint(ge=0, le=100000)] = Field(
        None, description="the duration of audio input in seconds", examples=[60]
    )
    output_audio_seconds: Optional[conint(ge=0, le=100000)] = Field(
        None, description="the duration of audio output in seconds", examples=[60]
    )
    input_images: Optional[str] = Field(
        None,
        description="a comma delimited list of image sizes",
        examples=["512x512,1024x1024"],
    )
    input_steps: Optional[conint(ge=1, le=10000)] = Field(
        None, description="the number of steps in the model", examples=[50]
    )
    output_images: Optional[str] = Field(
        None,
        description="a comma delimited list of output sizes",
        examples=["512x512,1024x1024"],
    )
    output_video_frames: Optional[conint(ge=0, le=100000000)] = Field(
        None,
        description="the number of video frames (frame rate x duration)",
        examples=[60],
    )
    output_video_resolution: Optional[int] = Field(
        None,
        description="the resolution of the video in number of lines (for instance, 1080 for 1080p)",
        examples=[1080],
    )
    request_cost: Optional[float] = Field(None, description="the cost of this request")
    currency: Optional[str] = Field(None, description="the currency for cost data")


class Model(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    id: Optional[str] = Field(None, examples=["gpt-4-turbo"])
    name: Optional[str] = Field(None, examples=["GPT-4 Turbo"])
    family: Optional[str] = Field(None, examples=["gpt"])
    hugging_face_path: Optional[str] = Field(None, examples=["EleutherAI/gpt-neo-2.7B"])
    benchmark_model_id: Optional[str] = Field(None, examples=["GPTJ-6B"])
    total_params_billions: Optional[float] = Field(None, examples=[175])
    number_of_experts: Optional[int] = Field(None, examples=[7])
    params_per_expert_billions: Optional[float] = Field(None, examples=[8])
    tensor_parallelism: Optional[int] = Field(None, examples=[1])
    datatype: Optional[DataType] = Field(None, examples=["fp8"])
    task: Optional[Task] = Field(None, examples=["text-generation"])
    training_usage_energy_kwh: Optional[float] = Field(None, examples=[1013.1])
    training_usage_emissions_kgco2e: Optional[float] = Field(None, examples=[1013.1])
    training_usage_water_l: Optional[float] = Field(None, examples=[1013.1])
    training_embodied_emissions_kgco2e: Optional[float] = Field(
        None, examples=[11013.1]
    )
    training_embodied_water_l: Optional[float] = Field(None, examples=[11013.1])
    estimated_use_life_days: Optional[float] = Field(None, examples=[1013.1])
    estimated_requests_per_day: Optional[float] = Field(None, examples=[1013.1])
    fine_tuned_from_model_id: Optional[str] = Field(None, examples=["llama_31_8b"])


class GridMix(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    country: CountryCode
    region: Optional[RegionCode] = None
    gco2e_per_kwh: confloat(ge=0.0, le=2000.0) = Field(..., examples=[475])


class Node(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    id: Optional[str] = Field(None, examples=["base-node-xl"])
    cloud_id: Optional[str] = Field(None, examples=["aws"])
    cloud_instance_id: Optional[str] = Field(None, examples=["a2-highgpu-1g"])
    managed_service_id: Optional[str] = Field(None, examples=["aws-bedrock"])
    gpu_id: Optional[str] = Field(None, examples=["a100_40gb"])
    gpu: Optional[GPU] = None
    gpu_count: Optional[conint(ge=0, le=10000)] = Field(None, examples=[8])
    cpu_count: Optional[conint(ge=1, le=10000)] = Field(None, examples=[2])
    idle_power_w_ex_gpu: Optional[confloat(ge=0.0, le=10000.0)] = Field(
        None, examples=[100]
    )
    average_utilization_rate: Optional[confloat(ge=0.0, le=1.0)] = Field(
        None, examples=[0.8]
    )
    embodied_emissions_kgco2e_ex_gpu: Optional[confloat(ge=0.0, le=100000.0)] = Field(
        None, examples=[2500]
    )
    embodied_water_l_ex_gpu: Optional[confloat(ge=0.0, le=100000.0)] = Field(
        None, examples=[2500]
    )
    use_life_years: Optional[confloat(ge=1.0, le=30.0)] = Field(None, examples=[5])


class ModelResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    models: List[Model] = Field(..., max_length=100)


class NodeResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    nodes: List[Node] = Field(..., max_length=100)


class ImpactLogRequest(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    rows: List[ImpactLogRow] = Field(..., max_length=1000)


class ImpactRow(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    utc_datetime: Optional[datetime] = Field(
        None,
        description="The start time of the request in UTC",
        examples=["2022-01-01T00:00:00Z"],
    )
    model: Model
    cloud_region: Optional[str] = Field(
        None, description="The region of cloud hosting", examples=["us-central1"]
    )
    node: Optional[Node] = None
    country: Optional[CountryCode] = None
    region: Optional[RegionCode] = None
    task: Optional[Task] = Field(None, examples=["text-generation"])
    input_tokens: Optional[conint(ge=0, le=100000000)] = Field(
        None, description="the number of input (or prompt) tokens", examples=[128]
    )
    input_audio_seconds: Optional[conint(ge=0, le=100000)] = Field(
        None, description="the duration of audio input in seconds", examples=[60]
    )
    output_audio_seconds: Optional[conint(ge=0, le=100000)] = Field(
        None, description="the duration of audio output in seconds", examples=[60]
    )
    output_tokens: Optional[conint(ge=0, le=100000000)] = Field(
        None, description="the number of output (or completion) tokens", examples=[128]
    )
    input_images: Optional[List[Image]] = Field(None, max_length=100)
    input_steps: Optional[conint(ge=1, le=10000)] = Field(
        None, description="the number of steps to use in the model", examples=[50]
    )
    output_images: Optional[List[Image]] = Field(
        None, description="a list of output image sizes", max_length=100
    )
    output_video_frames: Optional[conint(ge=0, le=100000000)] = Field(
        None,
        description="the number of video frames (frame rate x duration)",
        examples=[60],
    )
    output_video_resolution: Optional[int] = Field(
        None,
        description="the resolution of the video in number of lines (for instance, 1080 for 1080p)",
        examples=[1080],
    )
    request_duration_ms: Optional[float] = Field(
        None,
        description="The time the request took (as measured by client or proxy)",
        examples=[283],
    )
    managed_service_id: Optional[str] = Field(
        None,
        description="The ID of a managed service provider",
        examples=["aws-bedrock"],
    )
    model_used: Optional[Model] = None


class DebugInfo(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    model: Optional[Model] = None
    hardware_node: Optional[Node] = None
    grid_mix: Optional[GridMix] = None
    steps: Optional[List[PredictionStep]] = Field(None, max_length=100)


class ImpactRequest(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    rows: List[ImpactRow] = Field(..., max_length=1000)


class ModeledRow(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    inference_impact: Optional[ImpactMetrics] = None
    training_impact: Optional[ImpactMetrics] = None
    fine_tuning_impact: Optional[ImpactMetrics] = None
    total_impact: ImpactMetrics
    debug: Optional[DebugInfo] = None
    error: Optional[Error] = None


class ImpactResponse(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    rows: List[ModeledRow] = Field(..., max_length=1000)
    total_energy_wh: Optional[float] = Field(None, examples=[0.13])
    total_gco2e: Optional[float] = Field(None, examples=[0.81])
    total_mlh2o: Optional[float] = Field(None, examples=[1.32])
    has_errors: bool = Field(..., examples=[False])
