# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['recollwebui']

package_data = \
{'': ['*'], 'recollwebui': ['static/*', 'views/*']}

install_requires = \
['waitress>=2.1.2,<3.0.0']

entry_points = \
{'console_scripts': ['recollwebui = recollwebui.standalone:main']}

setup_kwargs = {
    'name': 'recollwebui',
    'version': '0.1.2',
    'description': 'Web interface for recoll desktop search',
    'long_description': '============\nRecoll WebUI\n============\n\nThis (https://framagit.org/medoc92/recollwebui) is an updated clone of\nKoniu\'s original version on GitHub (https://github.com/koniu/recoll-webui),\nwhich has not been updated lately, and is now slightly obsolete.\n\nAs compared to the original, this version has an additional dependancy when\nrunning the webui-standalone.py server (i.e. not with apache): it uses the\npython3-waitress module which must be installed. This makes\nwebui-standalone quite suitable for moderate multiaccess loads with no\nauthentication needs.\n\nAn updated version of the original doc follows.\n\n\n**Recoll WebUI** is a Python-based web interface for the **Recoll** text search\ntool for Unix/Linux.\n\n.. image:: http://i.imgur.com/n8qTnBg.png\n\n* WebUI homepage: https://framagit.org/medoc92/recollwebui\n* Recoll homepage: http://www.lesbonscomptes.com/recoll\n* Original WebUI homepage: https://github.com/koniu/recoll-webui\n\nRequirements\n============\n\nAll you need to use the WebUI is:\n\n* Python 3.\n* The Python waitress package. You can remove this dependance and run with\n  the internal bottle server by editing webui-standalone.py\n* Recoll 1.20+ and the Recoll Python3 extension (e.g. the python3-recoll package on Debian-derived\n  systems).\n* A WEB browser\n\nInstallation and Usage on MS-Windows\n====================================\n\nWe have a `separate Web page <https://www.lesbonscomptes.com/recoll/faqsandhowtos/webui-on-windows.html>`_ for this.\n\nInstallation and Usage on Linux\n===============================\n\n**Recoll WebUI** can be used as a standalone application or through a web server via\nWSGI/CGI. Regardless of the mode of operation you need Recoll to be configured on your system as the\nWebUI only provides a front-end for searching and does not handle index configuration etc.\n\nRun standalone\n--------------\n\nRun ``webui-standalone.py`` and connect to ``http://localhost:8080``.\n\nThere\'s some optional command-line arguments available::\n\n    -h, --help            show this help message and exit\n    -a ADDR, --addr ADDR  address to bind to [127.0.0.1]\n    -p PORT, --port PORT  port to listen on [8080]\n    -c CONFDIR, --config CONFDIR Recoll configuration directory to use\n\nThe standalone application can be configured to run automatically using systemd. See the file\n`README-systemd.rst <README-systemd.rst>`_.\n\nEnvironment variables:\n\n- `RECOLL_CONFDIR` the recoll configuration directory. This is overriden by a -c option.\n- `RECOLL_EXTRACONFDIRS` a space-separated list of external indexes to query in addition to the main\n  one.\n\n\nRun as WSGI/CGI\n---------------\n\nSee the following link for a complete run-through:\n\nhttps://www.lesbonscomptes.com/recoll/pages/recoll-webui-install-wsgi.html\n\nExample WSGI/Apache2 config, assuming that the code is in /var/recoll-webui-master::\n\n        WSGIDaemonProcess recoll user=recoll group=recoll threads=5 display-name=%{GROUP} python-path=/var/recoll-webui-master\n        WSGIScriptAlias /recoll /var/recoll-webui-master/webui-wsgi.py\n        <Directory /var/recoll-webui-master>\n                WSGIProcessGroup recoll\n                Order allow,deny\n                allow from all\n        </Directory>\n\nRemarks:\n\n* Without "python-path=" you might see errors that it can\'t import webui \n* Run the WSGIDaemonProcess run under the username (user=xyz) of the user\n  that you want to have exposed via web.\n\n\nUser configuration defaults\n---------------------------\n\nNew on 2022-06-15.\n\nThere are a number of parameters with initial defaults which the user can change through a Web\ninterface page (by clicking the `Settings` button), and which are persisted in a cookie.\n\nSome of the initial defaults may not be appropriate for your configuration. For example the default\ndepth of 2 for building the directory selection tree may be too much on a big data set (and cause\ninitialisation errors).\n\nThe initial defaults can be changed by setting values in the main recoll configuration file\n($RECOLL_CONFDIR/recoll.conf):\n\n- webui_context (30) the size of the abstract snippets in words.\n- webui_maxchars (500) total maximum size for the abstract shown with each result.\n- webui_stem (1) queries will use stemming (or not).\n- webui_timefmt ("%c") format of the time display.\n- webui_dirdepth (2) depth of the directory selection tree. Beware if your data set has many\n  directories.\n- webui_maxresults (0) limit the number of results (0 means no limit).\n- webui_perpage (25) number of results per page.\n- webui_csvfields ("filename title author size time mtype url") fields extracted in CSV or JSON dumps.\n- webui_title_link ("download") action performed if you click the result title (or \'open\',\n  \'preview\').\n\nThe following are not changeable from the user interface:\n\n- webui_nojsoncsv (0) If set, disable downloading results as JSON or CSV.\n- webui_maxperpage (0) If set to non-zero, limits the maximum value of results per page settable\n  through the UI.\n- webui_nosettings (0) do not show settings options to users.\n- webui_defaultsort ("Relevancy") default sort field.\n\n\nRunning the indexer\n-------------------\n\nExample user Crontab entry to have the indexer at least once a day::\n\n        22 5    * * *   /usr/bin/recollindex\n\n\n\nIssues\n======\n\nCan\'t open files when Recoll WebUI is running on a server\n---------------------------------------------------------\nBy default links to files in the result list correspond to the file\'s\nphysical location on the server. If you have access to the file tree\nvia a local mountpoint or eg. ftp/http you can provide replacement\nURLs in the WebUI settings. If in doubt, ask your network administrator.\n\nOpening files via local links\n-----------------------------\nFor security reasons modern browsers prevent linking to local content from\n\'remote\' pages. As a result URLs starting with file:// will not, by default,\nbe opened when linked from anything else than pages in file:// or when\naccessed directly from the address bar. Here\'s ways of working around it:\n\nFirefox\n~~~~~~~\n1. Insert contents of ``examples/firefox-user.js`` into\n   ``~/.mozilla/firefox/<profile>/user.js``\n2. Restart Firefox\n\nChrom{e,ium}\n~~~~~~~~~~~~\nInstall *LocalLinks* extension:\n\n* http://code.google.com/p/locallinks/\n* https://chrome.google.com/webstore/detail/locallinks/jllpkdkcdjndhggodimiphkghogcpida\n\nOpera\n~~~~~\n1. Copy ``examples/opera-open.sh`` into your PATH (eg. ``/usr/local/bin``)\n2. Go to ``Tools > Preferences > Advanced > Programs > Add``\n3. In ``Protocol`` field enter ``local-file``\n4. Select ``Open with other application`` and enter ``opera-open.sh``\n5. In WebUI settings replace all ``file://`` with ``local-file://``\n',
    'author': 'Jean-Francois Dockes',
    'author_email': 'jf@dockes.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://framagit.org/medoc92/recollwebui',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
