/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.io.DataInputStream;
import ibis.ipl.ReadMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class StoreArrayInputStream
extends DataInputStream {
    private int boolean_count = 0;
    private boolean[] boolean_store = new boolean[0];
    private int byte_count = 0;
    private byte[] byte_store = new byte[0];
    private int short_count = 0;
    private short[] short_store = new short[0];
    private int char_count = 0;
    private char[] char_store = new char[0];
    private int int_count = 0;
    private int[] int_store = new int[0];
    private int long_count = 0;
    private long[] long_store = new long[0];
    private int float_count = 0;
    private float[] float_store = new float[0];
    private int double_count = 0;
    private double[] double_store = new double[0];
    private int[] indices = new int[8];
    private int count = 0;
    private int read = 0;

    public int bufferSize() {
        return -1;
    }

    public void reset(ReadMessage m) throws IOException {
        this.boolean_count = 0;
        this.byte_count = 0;
        this.short_count = 0;
        this.char_count = 0;
        this.int_count = 0;
        this.long_count = 0;
        this.float_count = 0;
        this.double_count = 0;
        m.readArray(this.indices);
        this.count = this.indices[0];
        this.count += this.indices[1];
        this.count += 2 * this.indices[2];
        this.count += 2 * this.indices[3];
        this.count += 4 * this.indices[4];
        this.count += 8 * this.indices[5];
        this.count += 4 * this.indices[6];
        this.count += 8 * this.indices[7];
        if (this.indices[0] > 0) {
            if (this.boolean_store.length < this.indices[0]) {
                this.boolean_store = new boolean[this.indices[0]];
            }
            m.readArray(this.boolean_store, 0, this.indices[0]);
        }
        if (this.indices[1] > 0) {
            if (this.byte_store.length < this.indices[1]) {
                this.byte_store = new byte[this.indices[1]];
            }
            m.readArray(this.byte_store, 0, this.indices[1]);
        }
        if (this.indices[2] > 0) {
            if (this.short_store.length < this.indices[2]) {
                this.short_store = new short[this.indices[2]];
            }
            m.readArray(this.short_store, 0, this.indices[2]);
        }
        if (this.indices[3] > 0) {
            if (this.char_store.length < this.indices[3]) {
                this.char_store = new char[this.indices[3]];
            }
            m.readArray(this.char_store, 0, this.indices[3]);
        }
        if (this.indices[4] > 0) {
            if (this.int_store.length < this.indices[4]) {
                this.int_store = new int[this.indices[4]];
            }
            m.readArray(this.int_store, 0, this.indices[4]);
        }
        if (this.indices[5] > 0) {
            if (this.long_store.length < this.indices[5]) {
                this.long_store = new long[this.indices[5]];
            }
            m.readArray(this.long_store, 0, this.indices[5]);
        }
        if (this.indices[6] > 0) {
            if (this.float_store.length < this.indices[6]) {
                this.float_store = new float[this.indices[6]];
            }
            m.readArray(this.float_store, 0, this.indices[6]);
        }
        if (this.indices[7] > 0) {
            if (this.double_store.length < this.indices[7]) {
                this.double_store = new double[this.indices[7]];
            }
            m.readArray(this.double_store, 0, this.indices[7]);
        }
    }

    public byte readByte() {
        ++this.read;
        --this.count;
        return this.byte_store[this.byte_count++];
    }

    public boolean readBoolean() {
        ++this.read;
        --this.count;
        return this.boolean_store[this.boolean_count++];
    }

    public char readChar() {
        this.read += 2;
        this.count -= 2;
        return this.char_store[this.char_count++];
    }

    public short readShort() {
        this.read += 2;
        this.count -= 2;
        return this.short_store[this.short_count++];
    }

    public int readInt() {
        this.read += 4;
        this.count -= 4;
        return this.int_store[this.int_count++];
    }

    public long readLong() {
        this.read += 8;
        this.count -= 8;
        return this.long_store[this.long_count++];
    }

    public float readFloat() {
        this.read += 4;
        this.count -= 4;
        return this.float_store[this.float_count++];
    }

    public double readDouble() {
        this.read += 8;
        this.count -= 8;
        return this.double_store[this.double_count++];
    }

    public void readArray(boolean[] a, int off, int len) {
        this.read += len;
        this.count -= len;
        System.arraycopy(this.boolean_store, this.boolean_count, a, off, len);
        this.boolean_count += len;
    }

    public void readArray(byte[] a, int off, int len) {
        this.read += len;
        this.count -= len;
        System.arraycopy(this.byte_store, this.byte_count, a, off, len);
        this.byte_count += len;
    }

    public void readArray(short[] a, int off, int len) {
        this.read += 2 * len;
        this.count -= 2 * len;
        System.arraycopy(this.short_store, this.short_count, a, off, len);
        this.short_count += len;
    }

    public void readArray(char[] a, int off, int len) {
        this.read += 2 * len;
        this.count -= 2 * len;
        System.arraycopy(this.char_store, this.char_count, a, off, len);
        this.char_count += len;
    }

    public void readArray(int[] a, int off, int len) {
        this.read += 4 * len;
        this.count -= 4 * len;
        System.arraycopy(this.int_store, this.int_count, a, off, len);
        this.int_count += len;
    }

    public void readArray(long[] a, int off, int len) {
        this.read += 8 * len;
        this.count -= 8 * len;
        System.arraycopy(this.long_store, this.long_count, a, off, len);
        this.long_count += len;
    }

    public void readArray(float[] a, int off, int len) {
        this.read += 4 * len;
        this.count -= 4 * len;
        System.arraycopy(this.float_store, this.float_count, a, off, len);
        this.float_count += len;
    }

    public void readArray(double[] a, int off, int len) {
        this.read += 8 * len;
        this.count -= 8 * len;
        System.arraycopy(this.double_store, this.double_count, a, off, len);
        this.double_count += len;
    }

    public int read() {
        if (this.byte_store.length <= this.byte_count) {
            return -1;
        }
        ++this.read;
        --this.count;
        return this.byte_store[this.byte_count++] & 0xFF;
    }

    public int read(byte[] b) {
        if (this.byte_count >= this.byte_store.length) {
            return -1;
        }
        if (this.byte_count + b.length > this.byte_store.length) {
            System.arraycopy(this.byte_store, this.byte_count, b, 0, this.byte_store.length - this.byte_count);
            int rval = this.byte_store.length - this.byte_count;
            this.byte_count = this.byte_store.length;
            this.read += rval;
            this.count -= rval;
            return rval;
        }
        this.readArray(b, 0, b.length);
        this.read += b.length;
        this.count -= b.length;
        return b.length;
    }

    public int read(byte[] b, int off, int len) {
        if (this.byte_count >= this.byte_store.length) {
            return -1;
        }
        if (this.byte_count + len > this.byte_store.length) {
            System.arraycopy(this.byte_store, this.byte_count, b, off, this.byte_store.length - this.byte_count);
            int rval = this.byte_store.length - this.byte_count;
            this.byte_count = this.byte_store.length;
            this.read += rval;
            this.count -= rval;
            return rval;
        }
        this.readArray(b, off, len);
        this.read += len;
        this.count -= len;
        return len;
    }

    public long bytesRead() {
        return this.read;
    }

    public void resetBytesRead() {
        this.read = 0;
    }

    public int available() throws IOException {
        return this.count;
    }

    public void close() throws IOException {
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        int len = value.limit() - value.position();
        this.read += len;
        this.count -= len;
        value.put(this.byte_store, this.byte_count, len);
        this.byte_count += len;
    }
}

