/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.util.messagecombining.CombiningReadMessage;
import ibis.ipl.util.messagecombining.StoreArrayInputStream;
import ibis.util.TypedProperties;
import java.io.IOException;

public class MessageSplitter {
    private ReceivePort rp;
    private StoreArrayInputStream storeIn;
    private SendPortIdentifier origin;
    private CombiningReadMessage rm;
    private boolean rmInUse = false;
    private long count = 0L;

    public MessageSplitter(TypedProperties prop, ReceivePort rp) {
        this.rp = rp;
        String ser = prop.getProperty("ibis.serialization");
        if (ser == null) {
            ser = "sun";
        }
        this.storeIn = new StoreArrayInputStream();
        this.rm = new CombiningReadMessage(this, this.storeIn, ser);
    }

    public synchronized void setMessageToSplit(ReadMessage m) throws IOException {
        while (this.rmInUse || this.storeIn.available() > 0) {
            try {
                System.out.println("Waiting " + this.storeIn.available() + " " + this.rmInUse);
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.storeIn.reset(m);
        this.origin = m.origin();
        this.rm.clear();
    }

    public synchronized ReadMessage receive() throws IOException {
        while (this.rmInUse) {
            try {
                System.out.println("Waiting " + this.rmInUse);
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.storeIn.available() == 0) {
            return null;
        }
        this.rmInUse = true;
        this.count = this.storeIn.bytesRead();
        return this.rm;
    }

    protected synchronized long messageIsFinished() {
        this.rmInUse = false;
        this.notifyAll();
        return this.storeIn.bytesRead() - this.count;
    }

    protected ReceivePort getReceivePort() {
        return this.rp;
    }

    protected SendPortIdentifier origin() {
        return this.origin;
    }
}

