/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.io.DataInputStream;
import ibis.io.SerializationFactory;
import ibis.io.SerializationInput;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.util.messagecombining.MessageSplitter;
import ibis.ipl.util.messagecombining.StoreArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class CombiningReadMessage
implements ReadMessage {
    private SerializationInput in;
    private StoreArrayInputStream storeIn;
    private MessageSplitter rp;
    private String ser;

    protected CombiningReadMessage(MessageSplitter rp, StoreArrayInputStream storeIn, String ser) {
        this.storeIn = storeIn;
        this.rp = rp;
        this.ser = ser;
    }

    protected void clear() throws IOException {
        if (this.in == null) {
            this.in = SerializationFactory.createSerializationInput((String)this.ser, (DataInputStream)this.storeIn);
        }
        this.in.clear();
    }

    public long finish() throws IOException {
        return this.rp.messageIsFinished();
    }

    public void finish(IOException arg0) {
    }

    public long bytesRead() throws IOException {
        throw new IOException("Bytes Read not supported");
    }

    public ReceivePort localPort() {
        return this.rp.getReceivePort();
    }

    public long sequenceNumber() {
        return 0L;
    }

    public SendPortIdentifier origin() {
        return this.rp.origin();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readString() throws IOException {
        return this.in.readString();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.in.readObject();
    }

    public void readArray(boolean[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(byte[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(char[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(short[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(int[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(long[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(float[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(double[] arg0) throws IOException {
        this.in.readArray(arg0);
    }

    public void readArray(Object[] arg0) throws IOException, ClassNotFoundException {
        this.in.readArray(arg0);
    }

    public void readArray(boolean[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(byte[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(char[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(short[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(int[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(long[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(float[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(double[] arg0, int arg1, int arg2) throws IOException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public void readArray(Object[] arg0, int arg1, int arg2) throws IOException, ClassNotFoundException {
        this.in.readArray(arg0, arg1, arg2);
    }

    public int remaining() throws IOException {
        return -1;
    }

    public int size() throws IOException {
        return -1;
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        this.in.readByteBuffer(value);
    }
}

