/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.SendPort;
import ibis.ipl.impl.SendPortConnectionInfo;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NioAccumulatorConnection
extends SendPortConnectionInfo {
    static final int MAX_SEND_BUFFERS = 32;
    private static Logger logger = LoggerFactory.getLogger(NioAccumulatorConnection.class);
    GatheringByteChannel channel;
    SendBuffer[] pendingBuffers = new SendBuffer[32];
    int bufferPosition = 0;
    int bufferLimit = 0;
    SelectionKey key;

    NioAccumulatorConnection(NioSendPort port, GatheringByteChannel channel, ReceivePortIdentifier peer) {
        super((SendPort)port, peer);
        this.channel = channel;
    }

    boolean full() {
        return (this.bufferLimit + 1) % 32 == this.bufferPosition;
    }

    boolean empty() {
        return this.bufferLimit == this.bufferPosition;
    }

    boolean addToSendList(SendBuffer buffer) {
        if (this.full()) {
            return false;
        }
        this.pendingBuffers[this.bufferLimit] = buffer;
        if (logger.isDebugEnabled()) {
            logger.debug("adding new buffer to send list at position " + this.bufferLimit);
        }
        this.bufferLimit = (this.bufferLimit + 1) % 32;
        return true;
    }

    boolean send() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("sending");
        }
        while (!this.empty()) {
            long count = this.channel.write(this.pendingBuffers[this.bufferPosition].byteBuffers);
            if (logger.isDebugEnabled()) {
                logger.debug("send " + count + " bytes");
            }
            if (this.pendingBuffers[this.bufferPosition].hasRemaining()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("buffer has some bytes remaining");
                }
                return false;
            }
            SendBuffer.recycle(this.pendingBuffers[this.bufferPosition]);
            this.bufferPosition = (this.bufferPosition + 1) % 32;
            if (!logger.isDebugEnabled()) continue;
            logger.debug("completely send buffer, trying next one too");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done sending");
        }
        return true;
    }

    public void closeConnection() {
        try {
            this.channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

