/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.NioAccumulator;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockingChannelNioAccumulator
extends NioAccumulator {
    private static Logger logger = LoggerFactory.getLogger(BlockingChannelNioAccumulator.class);

    public BlockingChannelNioAccumulator(NioSendPort port) {
        super(port);
    }

    @Override
    NioAccumulatorConnection newConnection(GatheringByteChannel channel, ReceivePortIdentifier peer) throws IOException {
        logger.debug("registering new connection");
        if (this.nrOfConnections != 0) {
            logger.warn("" + (this.nrOfConnections + 1) + " connections from a blocking send port");
        }
        SelectableChannel sChannel = (SelectableChannel)((Object)channel);
        sChannel.configureBlocking(true);
        NioAccumulatorConnection result = new NioAccumulatorConnection(this.port, channel, peer);
        logger.debug("registered new connection");
        return result;
    }

    @Override
    boolean doSend(SendBuffer buffer) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("sending a buffer");
        }
        buffer.mark();
        for (int i = 0; i < this.nrOfConnections; ++i) {
            NioAccumulatorConnection connection = this.connections[i];
            try {
                buffer.reset();
                while (buffer.hasRemaining()) {
                    logger.debug("Write...");
                    connection.channel.write(buffer.byteBuffers);
                }
                continue;
            }
            catch (IOException e) {
                logger.debug("lost connection", (Throwable)e);
                this.port.lostConnection(connection.target, e);
                --this.nrOfConnections;
                this.connections[i] = this.connections[this.nrOfConnections];
                this.connections[this.nrOfConnections] = null;
                --i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done sending a buffer");
        }
        return true;
    }

    @Override
    void doFlush() throws IOException {
    }
}

