/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ASMClassInfo;
import ibis.compile.ASMRepository;
import ibis.compile.ByteCodeWrapper;
import ibis.compile.ClassInfo;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ASMWrapper
implements ByteCodeWrapper {
    private HashMap<String, ASMClassInfo> javaClasses = new HashMap();

    public ASMWrapper(List<String> args) {
    }

    @Override
    public ClassInfo getInfo(Object cl) {
        ClassNode n = (ClassNode)cl;
        String name = n.name.replaceAll("/", ".");
        ASMClassInfo e = this.javaClasses.get(name);
        if (e == null) {
            e = new ASMClassInfo(n);
            this.javaClasses.put(name, e);
        }
        e.setClassObject(n);
        return e;
    }

    @Override
    public ClassInfo parseClassFile(String fileName) throws IOException {
        return this.parseInputStream(new BufferedInputStream(new FileInputStream(fileName)), fileName);
    }

    @Override
    public ClassInfo parseInputStream(InputStream in, String fileName) throws IOException {
        ClassNode n = new ClassNode(262144);
        ClassReader r = new ClassReader(in);
        r.accept((ClassVisitor)n, 0);
        ASMRepository.addClass(n);
        return new ASMClassInfo(n);
    }
}

