/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.io.IOException;
import java.io.OutputStream;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcessFactory;
import nl.esciencecenter.xenon.adaptors.schedulers.Process;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.filesystems.PathAlreadyExistsException;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.Streams;
import nl.esciencecenter.xenon.utils.LocalFileSystemUtils;
import nl.esciencecenter.xenon.utils.StreamForwarder;

class BatchProcess
implements Process {
    private static final long TERMINATION_DELAY = 1000L;
    private final InteractiveProcess process;
    private StreamForwarder stdinForwarder;
    private StreamForwarder stdoutForwarder;
    private StreamForwarder stderrForwarder;

    public BatchProcess(FileSystem filesystem, Path workingDirectory, JobDescription description, String jobIdentifier, InteractiveProcessFactory factory, long startupTimeout) throws XenonException, IOException {
        Path workdir = this.processPath(workingDirectory, description.getWorkingDirectory());
        if (!filesystem.exists(workdir)) {
            throw new IOException("Working directory " + workdir + " does not exist!");
        }
        Path stdin = null;
        if (description.getStdin() != null && !filesystem.exists(stdin = this.processPath(workdir, description.getStdin()))) {
            throw new IOException("Stdin cannot be redirected from " + stdin + " (file does not exist!)");
        }
        OutputStream out = this.createOutputStream(filesystem, workdir, description.getStdout());
        OutputStream err = this.createOutputStream(filesystem, workdir, description.getStderr());
        this.process = factory.createInteractiveProcess(description, jobIdentifier, startupTimeout);
        Streams streams = this.process.getStreams();
        this.stdoutForwarder = new StreamForwarder(streams.getStdout(), out);
        this.stderrForwarder = new StreamForwarder(streams.getStderr(), err);
        if (stdin == null) {
            this.stdinForwarder = null;
            streams.getStdin().close();
        } else {
            this.stdinForwarder = new StreamForwarder(filesystem.readFromFile(stdin), streams.getStdin());
        }
    }

    private Path processPath(Path root, String path) {
        Path result = path == null ? root : (LocalFileSystemUtils.startWithRoot(path) ? new Path(path) : root.resolve(path));
        return result;
    }

    private OutputStream createOutputStream(FileSystem filesystem, Path workdir, String filename) throws XenonException {
        if (filename == null) {
            return null;
        }
        Path file = this.processPath(workdir, filename);
        if (filesystem.exists(file)) {
            throw new PathAlreadyExistsException(filesystem.getAdaptorName(), "File already exists: " + file);
        }
        return filesystem.writeToFile(file);
    }

    private synchronized void closeStreams() {
        if (this.stdinForwarder != null) {
            this.stdinForwarder.terminate(1000L);
            this.stdinForwarder = null;
        }
        if (this.stdoutForwarder != null) {
            this.stdoutForwarder.terminate(1000L);
            this.stdoutForwarder = null;
        }
        if (this.stderrForwarder != null) {
            this.stderrForwarder.terminate(1000L);
            this.stderrForwarder = null;
        }
    }

    @Override
    public boolean isDone() {
        if (this.process.isDone()) {
            this.closeStreams();
            return true;
        }
        return false;
    }

    @Override
    public int getExitStatus() {
        return this.process.getExitStatus();
    }

    @Override
    public void destroy() {
        this.process.destroy();
        this.closeStreams();
    }
}

