/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sbbi.upnp.jmx.HttpGetRequest;
import net.sbbi.upnp.jmx.HttpPostRequest;
import net.sbbi.upnp.jmx.HttpRequest;
import net.sbbi.upnp.jmx.HttpRequestHandler;
import net.sbbi.upnp.jmx.HttpSubscriptionRequest;
import net.sbbi.upnp.jmx.UPNPMBeanDevice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPMBeanDevicesRequestsHandler
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)UPNPMBeanDevicesRequestsHandler.class);
    private static final int MAX_HTTP_WORKERS = 10;
    private static final Map instances = new HashMap();
    private Set handledDevices = new HashSet();
    private Set httpWorkers = new HashSet();
    private ServerSocket srv;
    private boolean isRunning = false;
    private InetSocketAddress bindAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UPNPMBeanDevicesRequestsHandler getInstance(InetSocketAddress bindAddress) {
        String key = bindAddress.toString();
        Map map = instances;
        synchronized (map) {
            UPNPMBeanDevicesRequestsHandler handler = (UPNPMBeanDevicesRequestsHandler)instances.get(key);
            if (handler == null) {
                handler = new UPNPMBeanDevicesRequestsHandler(bindAddress);
                instances.put(key, handler);
            }
            return handler;
        }
    }

    private UPNPMBeanDevicesRequestsHandler(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUPNPMBeanDevice(UPNPMBeanDevice rootDevice) {
        Set set = this.handledDevices;
        synchronized (set) {
            Iterator i = this.handledDevices.iterator();
            while (i.hasNext()) {
                UPNPMBeanDevice registred = (UPNPMBeanDevice)i.next();
                if (!registred.getDeviceType().equals(rootDevice.getDeviceType()) || !registred.getUuid().equals(rootDevice.getUuid())) continue;
                throw new RuntimeException("An UPNPMBeanDevice object of type " + rootDevice.getDeviceType() + " with uuid " + rootDevice.getUuid() + " is already registred within this class, use a different UPNPMBeanDevice internalId");
            }
            if (this.handledDevices.size() == 0) {
                Thread runner = new Thread((Runnable)this, "UPNPMBeanDevicesRequestsHandler " + this.bindAddress.toString());
                runner.setDaemon(true);
                runner.start();
            }
            this.handledDevices.add(rootDevice);
            i = rootDevice.getUPNPMBeanChildrens().iterator();
            while (i.hasNext()) {
                this.handledDevices.add(i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUPNPMBeanDevice(UPNPMBeanDevice rootDevice) {
        Set set = this.handledDevices;
        synchronized (set) {
            if (this.handledDevices.contains(rootDevice)) {
                this.handledDevices.remove(rootDevice);
                Iterator i = rootDevice.getUPNPMBeanChildrens().iterator();
                while (i.hasNext()) {
                    this.handledDevices.remove(i.next());
                }
                if (this.handledDevices.size() == 0) {
                    try {
                        this.isRunning = false;
                        this.srv.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWorkerThreadEnd(HttpWorker worker) {
        Set set = this.httpWorkers;
        synchronized (set) {
            this.httpWorkers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.srv = new ServerSocket(this.bindAddress.getPort(), 0, this.bindAddress.getAddress());
        }
        catch (IOException ex) {
            log.error((Object)"Error during server socket creation, thread cannot start", (Throwable)ex);
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Socket skt = this.srv.accept();
                skt.setSoTimeout(30000);
                HttpWorker worker = new HttpWorker(skt, log, this.handledDevices, this);
                while (this.httpWorkers.size() >= 10) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
                Thread workerThread = new Thread((Runnable)worker, "UPNPMBeanDevicesRequestsHandler Http Worker " + this.httpWorkers.size());
                workerThread.start();
                Set set = this.httpWorkers;
                synchronized (set) {
                    this.httpWorkers.add(worker);
                }
            }
            catch (IOException ex) {
                if (!this.isRunning) continue;
                log.error((Object)"Error during client socket creation", (Throwable)ex);
            }
        }
    }

    private class HttpWorker
    implements Runnable {
        private Socket client;
        private Log logger;
        private Set devices;
        private UPNPMBeanDevicesRequestsHandler handler;

        public HttpWorker(Socket client, Log log, Set handledDevices, UPNPMBeanDevicesRequestsHandler handler) {
            this.client = client;
            this.logger = log;
            this.devices = handledDevices;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HttpRequest httpReq;
                byte[] buffer = new byte[256];
                InputStream in = this.client.getInputStream();
                StringBuffer request = new StringBuffer();
                int readen = 0;
                String firstReadenData = null;
                while (readen != -1) {
                    readen = in.read(buffer);
                    String data = new String(buffer, 0, readen);
                    if (firstReadenData == null) {
                        firstReadenData = data.toUpperCase();
                    }
                    request.append(data);
                    String rawRequest = request.toString();
                    if (rawRequest.endsWith("\r\n\r\n") && firstReadenData.startsWith("GET")) {
                        readen = -1;
                        continue;
                    }
                    if (rawRequest.indexOf("</s:Envelope>") == -1) continue;
                    readen = -1;
                }
                OutputStream out = this.client.getOutputStream();
                String req = request.toString().trim();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received message:\n" + req));
                }
                String toWrite = null;
                if (req.length() > 0 && (httpReq = new HttpRequest(req)).getHttpCommand() != null && httpReq.getHttpCommandArg() != null && httpReq.getHttpCommandArg().trim().length() > 0) {
                    String cmd = httpReq.getHttpCommand();
                    HttpRequestHandler handler = null;
                    if (cmd.equals("GET")) {
                        handler = HttpGetRequest.getInstance();
                    } else if (cmd.equals("POST")) {
                        handler = HttpPostRequest.getInstance();
                    } else if (cmd.equals("SUBSCRIBE")) {
                        handler = HttpSubscriptionRequest.getInstance();
                    } else if (cmd.equals("UNSUBSCRIBE")) {
                        handler = HttpSubscriptionRequest.getInstance();
                    }
                    if (handler != null) {
                        toWrite = handler.service(this.devices, httpReq);
                    }
                }
                if (toWrite == null) {
                    String content = "<html><head><title>Not found</title></head><body>The requested ressource cannot be found</body></html>";
                    StringBuffer rtr = new StringBuffer();
                    rtr.append("HTTP/1.1 404 Not Found\r\n");
                    rtr.append("CONTENT-LENGTH: ").append(content.length()).append("\r\n");
                    rtr.append("CONTENT-TYPE: text/html\r\n\r\n");
                    rtr.append(content);
                    toWrite = rtr.toString();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending response :\n" + toWrite));
                }
                out.write(toWrite.getBytes());
                out.flush();
                out.close();
                in.close();
                this.client.close();
            }
            catch (IOException ex) {
                this.logger.error((Object)"IO Exception occured during client serving", (Throwable)ex);
            }
            catch (Throwable t) {
                this.logger.error((Object)"Unexpected Exception occured during client serving", t);
            }
            finally {
                this.handler.notifyWorkerThreadEnd(this);
            }
        }
    }
}

