/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.device;

import de.pleumann.antenna.device.Util;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseProps {
    protected static final String CAPABILITY = "capability";
    protected static final String GROUPS = "groups";
    protected static final String FEATURES = "features";
    protected static final String IDENTIFIER = "identifier";
    protected static final String IMEI_KEY = "IMEI_KEY";
    protected Set m_features = new TreeSet();
    protected Set m_soundFormats = new TreeSet();
    protected Set m_videoFormats;
    protected Set m_javaPackage = new TreeSet();
    protected Set m_bugs;
    protected Properties m_capabilities;

    public BaseProps(Element dev) {
        this.m_videoFormats = new TreeSet();
        this.m_bugs = new TreeSet();
        this.m_capabilities = new Properties();
        NodeList props = dev.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node item = props.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            String tagName = e.getTagName();
            if (FEATURES.equals(tagName)) {
                this.parseGroup(e, this.m_features);
                continue;
            }
            if (!CAPABILITY.equals(tagName)) continue;
            String name = e.getAttribute("name");
            String value = e.getAttribute("value");
            this.m_capabilities.setProperty(name.trim(), value.trim());
        }
    }

    protected void parseGroup(Element e, Set outputSet) {
        String text = Util.getText(e);
        StringTokenizer tok = new StringTokenizer(text, ", ");
        while (tok.hasMoreElements()) {
            String item = tok.nextToken();
            outputSet.add(item.toLowerCase().trim());
        }
    }
}

