/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v1;

import antenna.preprocessor.PreprocessorException;

class BooleanTokenizer {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_ID = 1;
    public static final int TYPE_LPAR = 2;
    public static final int TYPE_RPAR = 3;
    public static final int TYPE_AND = 4;
    public static final int TYPE_OR = 5;
    public static final int TYPE_XOR = 6;
    public static final int TYPE_NOT = 7;
    private String sourceText;
    private int sourcePos;
    private int tokenType;
    private int tokenPos;

    public BooleanTokenizer(String expr) {
        this.sourceText = expr + " ";
        this.sourcePos = 0;
        this.tokenType = -1;
        this.tokenPos = 0;
    }

    private void skipBlanks() {
        char c;
        while (this.sourcePos < this.sourceText.length() && ((c = this.sourceText.charAt(this.sourcePos)) == ' ' || c == '\t')) {
            ++this.sourcePos;
        }
    }

    public int nextToken() throws PreprocessorException {
        this.skipBlanks();
        this.tokenPos = this.sourcePos;
        if (this.sourcePos >= this.sourceText.length()) {
            this.tokenType = 0;
            return this.tokenType;
        }
        char c = this.sourceText.charAt(this.sourcePos);
        if (Character.isJavaIdentifierStart(c)) {
            this.tokenType = 1;
            ++this.sourcePos;
            while (this.isIdentifierPart(this.sourceText.charAt(this.sourcePos))) {
                ++this.sourcePos;
            }
        } else if (c == '(') {
            this.tokenType = 2;
            ++this.sourcePos;
        } else if (c == ')') {
            this.tokenType = 3;
            ++this.sourcePos;
        } else if (c == '&') {
            this.tokenType = 4;
            ++this.sourcePos;
            if (this.sourceText.charAt(this.sourcePos) == '&') {
                ++this.sourcePos;
            }
        } else if (c == '|') {
            this.tokenType = 5;
            ++this.sourcePos;
            if (this.sourceText.charAt(this.sourcePos) == '|') {
                ++this.sourcePos;
            }
        } else if (c == '^') {
            this.tokenType = 6;
            ++this.sourcePos;
        } else if (c == '!') {
            this.tokenType = 7;
            ++this.sourcePos;
        } else {
            throw new PreprocessorException("Syntax Error");
        }
        return this.tokenType;
    }

    private boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '\\' || c == '/';
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public String getTokenText() {
        if (this.tokenType == 0) {
            return "";
        }
        return this.sourceText.substring(this.tokenPos, this.sourcePos);
    }
}

