/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.tcp;

import ibis.io.BufferedArrayInputStream;
import ibis.io.BufferedArrayOutputStream;
import ibis.ipl.AlreadyConnectedException;
import ibis.ipl.CapabilitySet;
import ibis.ipl.ConnectionRefusedException;
import ibis.ipl.ConnectionTimedOutException;
import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisStarter;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortMismatchException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.SendPort;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.tcp.IbisServerSocket;
import ibis.ipl.impl.tcp.IbisSocket;
import ibis.ipl.impl.tcp.IbisSocketAddress;
import ibis.ipl.impl.tcp.IbisSocketFactory;
import ibis.ipl.impl.tcp.TcpProtocol;
import ibis.ipl.impl.tcp.TcpReceivePort;
import ibis.ipl.impl.tcp.TcpSendPort;
import ibis.util.ThreadPool;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpIbis
extends Ibis
implements Runnable,
TcpProtocol {
    static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.tcp.TcpIbis");
    private IbisSocketFactory factory;
    private IbisServerSocket systemServer;
    private IbisSocketAddress myAddress;
    private boolean quiting = false;
    private HashMap<ibis.ipl.IbisIdentifier, IbisSocketAddress> addresses = new HashMap();

    public TcpIbis(RegistryEventHandler registryEventHandler, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] types, Properties userProperties, IbisStarter starter) throws IbisCreationFailedException {
        super(registryEventHandler, capabilities, credentials, applicationTag, types, userProperties, starter);
        this.properties.checkProperties("ibis.ipl.impl.tcp.", new String[0], null, true);
        this.factory.setIdent(this.ident);
        ThreadPool.createNew((Runnable)this, (String)"TcpIbis Accept Thread");
    }

    protected byte[] getData() throws IOException {
        this.factory = new IbisSocketFactory(this.properties);
        this.systemServer = this.factory.createServerSocket(0, 50, true, null);
        this.myAddress = this.systemServer.getLocalSocketAddress();
        if (logger.isInfoEnabled()) {
            logger.info("--> TcpIbis: address = " + this.myAddress);
        }
        return this.myAddress.toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IbisSocket connect(TcpSendPort sp, ibis.ipl.impl.ReceivePortIdentifier rip, int timeout, boolean fillTimeout) throws IOException {
        IbisSocketAddress idAddr;
        IbisIdentifier id = (IbisIdentifier)rip.ibisIdentifier();
        String name = rip.name();
        HashMap<ibis.ipl.IbisIdentifier, IbisSocketAddress> hashMap = this.addresses;
        synchronized (hashMap) {
            idAddr = this.addresses.get(id);
            if (idAddr == null) {
                idAddr = new IbisSocketAddress(id.getImplementationData());
                this.addresses.put((ibis.ipl.IbisIdentifier)id, idAddr);
            }
        }
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("--> Creating socket for connection to " + name + " at " + idAddr);
        }
        PortType sendPortType = sp.getPortType();
        while (true) {
            FilterOutputStream out = null;
            IbisSocket s = null;
            int result = -1;
            try {
                s = this.factory.createClientSocket(idAddr, timeout, fillTimeout, sp.managementProperties());
                s.setTcpNoDelay(true);
                out = new DataOutputStream((OutputStream)new BufferedArrayOutputStream(s.getOutputStream()));
                ((DataOutputStream)out).writeUTF(name);
                sp.getIdent().writeTo((DataOutput)((Object)out));
                sendPortType.writeTo((DataOutput)((Object)out));
                ((DataOutputStream)out).flush();
                result = s.getInputStream().read();
                switch (result) {
                    case 0: {
                        IbisSocket ibisSocket = s;
                        return ibisSocket;
                    }
                    case 3: {
                        throw new AlreadyConnectedException("Already connected", (ReceivePortIdentifier)rip);
                    }
                    case 4: {
                        DataInputStream in = new DataInputStream(s.getInputStream());
                        PortType rtp = new PortType((DataInput)in);
                        CapabilitySet s1 = rtp.unmatchedCapabilities((CapabilitySet)sendPortType);
                        CapabilitySet s2 = sendPortType.unmatchedCapabilities((CapabilitySet)rtp);
                        String message = "";
                        if (s1.size() != 0) {
                            message = message + "\nUnmatched receiveport capabilities: " + s1.toString() + ".";
                        }
                        if (s2.size() != 0) {
                            message = message + "\nUnmatched sendport capabilities: " + s2.toString() + ".";
                        }
                        throw new PortMismatchException("Cannot connect ports of different port types." + message, (ReceivePortIdentifier)rip);
                    }
                    case 1: {
                        throw new ConnectionRefusedException("Receiver denied connection", (ReceivePortIdentifier)rip);
                    }
                    case 6: {
                        throw new ConnectionRefusedException("Receiver already has a connection and neither ManyToOne not ManyToMany is set", (ReceivePortIdentifier)rip);
                    }
                    case 2: 
                    case 5: {
                        if (timeout > 0 && System.currentTimeMillis() > startTime + (long)timeout) {
                            throw new ConnectionTimedOutException("Could not connect", (ReceivePortIdentifier)rip);
                        }
                        break;
                    }
                    case -1: {
                        throw new IOException("Encountered EOF in TcpIbis.connect");
                    }
                    default: {
                        throw new IOException("Illegal opcode in TcpIbis.connect");
                    }
                }
            }
            catch (SocketTimeoutException e) {
                throw new ConnectionTimedOutException("Could not connect", (ReceivePortIdentifier)rip);
            }
            finally {
                if (result != 0) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable e) {}
                    try {
                        s.close();
                    }
                    catch (Throwable e) {}
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    protected void quit() {
        try {
            this.quiting = true;
            this.factory.createClientSocket(this.myAddress, 0, false, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionRequest(IbisSocket s) throws IOException {
        int result;
        if (logger.isDebugEnabled()) {
            logger.debug("--> TcpIbis got connection request from " + s);
        }
        BufferedArrayInputStream bais = new BufferedArrayInputStream(s.getInputStream());
        DataInputStream in = new DataInputStream((InputStream)bais);
        OutputStream out = s.getOutputStream();
        String name = in.readUTF();
        SendPortIdentifier send = new SendPortIdentifier((DataInput)in);
        PortType sp = new PortType((DataInput)in);
        TcpReceivePort rp = (TcpReceivePort)this.findReceivePort(name);
        if (rp == null) {
            result = 5;
        } else {
            TcpReceivePort tcpReceivePort = rp;
            synchronized (tcpReceivePort) {
                result = rp.connectionAllowed(send, sp);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--> S RP = " + name + ": " + ReceivePort.getString((int)result));
        }
        out.write(result);
        if (result == 4) {
            DataOutputStream dout = new DataOutputStream(out);
            rp.getPortType().writeTo((DataOutput)dout);
            dout.flush();
        }
        out.flush();
        if (result == 0) {
            rp.connect(send, s, bais);
            if (logger.isDebugEnabled()) {
                logger.debug("--> S connect done ");
            }
        } else {
            out.close();
            in.close();
            s.close();
        }
    }

    @Override
    public void run() {
        boolean stop = false;
        while (!stop) {
            IbisSocket s = null;
            if (logger.isDebugEnabled()) {
                logger.debug("--> TcpIbis doing new accept()");
            }
            try {
                s = this.systemServer.accept();
                s.setTcpNoDelay(true);
            }
            catch (Throwable e) {
                logger.error("TcpIbis:run: got fatal exception in accept! ", e);
                this.cleanup();
                throw new Error("Fatal: TcpIbis could not do an accept", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("--> TcpIbis through new accept()");
            }
            try {
                if (this.quiting) {
                    s.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("--> it is a quit: RETURN");
                    }
                    this.cleanup();
                    return;
                }
                stop = true;
                try {
                    Thread.currentThread().setName("Connection Handler");
                }
                catch (Exception e) {
                    // empty catch block
                }
                ThreadPool.createNew((Runnable)this, (String)"TcpIbis Accept Thread");
                this.handleConnectionRequest(s);
            }
            catch (Throwable e) {
                try {
                    s.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                logger.error("EEK: TcpIbis:run: got exception (closing this socket only: ", e);
            }
        }
    }

    private void cleanup() {
        try {
            this.systemServer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SendPort doCreateSendPort(PortType tp, String nm, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        return new TcpSendPort(this, tp, nm, cU, props);
    }

    protected ReceivePort doCreateReceivePort(PortType tp, String nm, MessageUpcall u, ReceivePortConnectUpcall cU, Properties props) throws IOException {
        return new TcpReceivePort(this, tp, nm, u, cU, props);
    }
}

