/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.Location;
import java.util.Arrays;
import java.util.Comparator;

public class IbisSorter
implements Comparator<IbisIdentifier> {
    private static final IbisSorter sorter = new IbisSorter("unknown", null);
    private final String preferredCluster;
    private final String preferredName;

    private IbisSorter(String preferredCluster, String preferredName) {
        this.preferredCluster = preferredCluster;
        this.preferredName = preferredName;
    }

    public static void sort(IbisIdentifier[] ids) {
        IbisSorter.sort(ids, 0, ids.length);
    }

    public static void sort(IbisIdentifier local, IbisIdentifier[] ids) {
        IbisSorter.sort(local, ids, 0, ids.length);
    }

    public static void sort(IbisIdentifier[] ids, int from, int to) {
        Arrays.sort(ids, from, to, sorter);
    }

    public static void sort(IbisIdentifier local, IbisIdentifier[] ids, int from, int to) {
        IbisIdentifier[] tmp = new IbisIdentifier[to - from + 1];
        tmp[0] = local;
        System.arraycopy(ids, from, tmp, 1, to - from);
        Arrays.sort(tmp, sorter);
        int index = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (!tmp[i].equals(local)) continue;
            index = i;
            break;
        }
        System.arraycopy(tmp, index + 1, ids, from, tmp.length - (index + 1));
        System.arraycopy(tmp, 0, ids, from + tmp.length - index - 1, index);
    }

    private static int firstDifference(String s1, String s2) {
        if (s1.length() > s2.length()) {
            String tmp = s1;
            s1 = s2;
            s2 = tmp;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return s1.length();
    }

    @Override
    public int compare(IbisIdentifier id1, IbisIdentifier id2) {
        Location cluster2;
        Location cluster1 = id1.location().getParent();
        if (cluster1.equals(cluster2 = id2.location().getParent())) {
            int d2;
            if (this.preferredName == null) {
                return id1.location().toString().compareTo(id2.location().toString());
            }
            int d1 = IbisSorter.firstDifference(this.preferredName, id1.location().toString());
            if (d1 == (d2 = IbisSorter.firstDifference(this.preferredName, id2.location().toString()))) {
                return id1.location().toString().compareTo(id2.location().toString());
            }
            if (d1 <= d2) {
                return 1;
            }
            return -1;
        }
        if (cluster1.equals(this.preferredCluster)) {
            return -1;
        }
        if (cluster2.equals(this.preferredCluster)) {
            return 1;
        }
        return cluster1.compareTo((Object)cluster2);
    }
}

