/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.io;

import ibis.io.Conversion;
import ibis.io.DataInputStream;
import ibis.ipl.impl.stacking.lrmc.io.LrmcInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class BufferedArrayInputStream
extends DataInputStream {
    private static final int SIZEOF_BOOLEAN = 1;
    private static final int SIZEOF_CHAR = 2;
    private static final int SIZEOF_SHORT = 2;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final int SIZEOF_FLOAT = 4;
    private static final int SIZEOF_DOUBLE = 8;
    private static boolean DEBUG = false;
    private static final int BUF_SIZE = 8192;
    private LrmcInputStream in;
    private byte[] buffer = new byte[8192];
    private int index;
    private int buffered_bytes;
    private long bytes = 0L;
    private Conversion conversion;

    public BufferedArrayInputStream(LrmcInputStream in) {
        this.in = in;
        this.conversion = Conversion.loadConversion((boolean)false);
    }

    public int bufferSize() {
        return 8192;
    }

    public void setInputStream(LrmcInputStream in) {
        this.in = in;
    }

    public LrmcInputStream getInputStream() {
        return this.in;
    }

    public long bytesRead() {
        return this.bytes - (long)this.buffered_bytes;
    }

    public void resetBytesRead() {
        this.bytes = this.buffered_bytes;
    }

    private static final int min(int a, int b) {
        return a > b ? b : a;
    }

    public final int read() throws IOException {
        try {
            byte b = this.readByte();
            return b & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    private final void fillBuffer(int len) throws IOException {
        if (this.buffered_bytes >= len) {
            return;
        }
        if (this.buffered_bytes == 0) {
            this.index = 0;
        } else if (this.index + this.buffered_bytes > 8192 - len) {
            System.arraycopy(this.buffer, this.index, this.buffer, 0, this.buffered_bytes);
            this.index = 0;
        }
        while (this.buffered_bytes < len) {
            int n = this.in.read(this.buffer, this.index + this.buffered_bytes, 8192 - (this.index + this.buffered_bytes));
            if (n < 0) {
                throw new EOFException("EOF encountered");
            }
            this.bytes += (long)n;
            this.buffered_bytes += n;
        }
    }

    public final int available() throws IOException {
        return this.buffered_bytes;
    }

    public void readArray(boolean[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 1;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 1;
            this.conversion.byte2boolean(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 1;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2boolean(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public void readArray(byte[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(byte[" + off + " ... " + (off + len) + "])");
        }
        if (this.buffered_bytes >= len) {
            System.arraycopy(this.buffer, this.index, a, off, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            int n;
            if (this.buffered_bytes != 0) {
                System.arraycopy(this.buffer, this.index, a, off, this.buffered_bytes);
            }
            int rd = this.buffered_bytes;
            this.index = 0;
            do {
                if ((n = this.in.read(a, off + rd, len - rd)) < 0) {
                    throw new EOFException("EOF encountered");
                }
                this.bytes += (long)n;
            } while ((rd += n) < len);
            this.buffered_bytes = 0;
        }
    }

    public void readArray(short[] a, int off, int len) throws IOException {
        int i;
        int to_convert = len * 2;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 2;
            this.conversion.byte2short(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 2;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2short(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
        if (DEBUG) {
            System.err.print("readArray(short[");
            for (i = 0; i < len; ++i) {
                System.err.print(a[off + i] + ",");
            }
            System.err.println("]");
            System.err.flush();
        }
    }

    public void readArray(char[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(char[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 2;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 2;
            this.conversion.byte2char(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 2;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2char(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public void readArray(int[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(int[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 4;
            this.conversion.byte2int(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 4;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2int(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public void readArray(long[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(long[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 8;
            this.conversion.byte2long(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 8;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2long(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public void readArray(float[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(float[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 4;
            this.conversion.byte2float(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 4;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2float(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public void readArray(double[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("readArray(double[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 8;
            this.conversion.byte2double(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 8;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(8192, to_convert));
        }
        this.conversion.byte2double(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    public byte readByte() throws IOException {
        this.fillBuffer(1);
        --this.buffered_bytes;
        return this.buffer[this.index++];
    }

    public boolean readBoolean() throws IOException {
        this.fillBuffer(1);
        --this.buffered_bytes;
        return this.conversion.byte2boolean(this.buffer[this.index++]);
    }

    public char readChar() throws IOException {
        this.fillBuffer(2);
        char v = this.conversion.byte2char(this.buffer, this.index);
        this.index += 2;
        this.buffered_bytes -= 2;
        return v;
    }

    public short readShort() throws IOException {
        this.fillBuffer(2);
        short v = this.conversion.byte2short(this.buffer, this.index);
        this.index += 2;
        this.buffered_bytes -= 2;
        return v;
    }

    public int readInt() throws IOException {
        this.fillBuffer(4);
        int v = this.conversion.byte2int(this.buffer, this.index);
        this.index += 4;
        this.buffered_bytes -= 4;
        return v;
    }

    public long readLong() throws IOException {
        this.fillBuffer(8);
        long v = this.conversion.byte2long(this.buffer, this.index);
        this.index += 8;
        this.buffered_bytes -= 8;
        return v;
    }

    public float readFloat() throws IOException {
        this.fillBuffer(4);
        float v = this.conversion.byte2float(this.buffer, this.index);
        this.index += 4;
        this.buffered_bytes -= 4;
        return v;
    }

    public double readDouble() throws IOException {
        this.fillBuffer(8);
        double v = this.conversion.byte2double(this.buffer, this.index);
        this.index += 8;
        this.buffered_bytes -= 8;
        return v;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] a, int off, int len) throws IOException {
        if (DEBUG) {
            System.err.println("read(byte[" + off + " ... " + (off + len) + "])");
        }
        if (this.buffered_bytes >= len) {
            System.arraycopy(this.buffer, this.index, a, off, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            if (this.buffered_bytes != 0) {
                System.arraycopy(this.buffer, this.index, a, off, this.buffered_bytes);
            }
            int rd = this.buffered_bytes;
            this.index = 0;
            do {
                int n;
                if ((n = this.in.read(a, off + rd, len - rd)) < 0) {
                    len = rd;
                    continue;
                }
                rd += n;
                this.bytes += (long)n;
            } while (rd < len);
            this.buffered_bytes = 0;
        }
        return len;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        int len = value.limit() - value.position();
        if (this.buffered_bytes >= len) {
            value.put(this.buffer, this.index, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            if (this.buffered_bytes != 0) {
                value.put(this.buffer, this.index, this.buffered_bytes);
                len -= this.buffered_bytes;
                this.buffered_bytes = 0;
            }
            this.index = 0;
            if (value.hasArray()) {
                this.in.read(value.array(), value.arrayOffset(), len);
                value.position(value.limit());
                this.bytes += (long)len;
            } else {
                int toread;
                do {
                    toread = Math.min(len, 8192);
                    this.fillBuffer(toread);
                    toread = len < this.buffered_bytes ? len : this.buffered_bytes;
                    value.put(this.buffer, this.index, toread);
                    this.index += toread;
                    this.buffered_bytes -= toread;
                } while ((len -= toread) > 0);
            }
        }
    }
}

