/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.io.SerializationOutput;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcSendPort;
import ibis.ipl.impl.stacking.lrmc.Multicaster;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LrmcWriteMessage
implements WriteMessage {
    boolean isFinished = false;
    Multicaster om;
    long count = 0L;
    SerializationOutput out;
    LrmcSendPort port;
    IbisIdentifier[] destinations;

    public LrmcWriteMessage(LrmcSendPort port, Multicaster om, IbisIdentifier[] dests) throws IOException {
        this.om = om;
        this.out = om.sout;
        this.port = port;
        this.destinations = dests;
        om.initializeSend(dests);
    }

    private final void checkNotFinished() throws IOException {
        if (this.isFinished) {
            throw new IOException("Operating on a message that was already finished");
        }
    }

    public SendPort localPort() {
        return this.port;
    }

    public int send() throws IOException {
        this.checkNotFinished();
        return 0;
    }

    public void reset() throws IOException {
        this.out.reset();
    }

    public void sync(int ticket) throws IOException {
        this.checkNotFinished();
        this.out.flush();
    }

    public void flush() throws IOException {
        this.checkNotFinished();
        this.out.flush();
    }

    public void writeBoolean(boolean value) throws IOException {
        this.checkNotFinished();
        this.out.writeBoolean(value);
    }

    public void writeByte(byte value) throws IOException {
        this.checkNotFinished();
        this.out.writeByte(value);
    }

    public void writeChar(char value) throws IOException {
        this.checkNotFinished();
        this.out.writeChar(value);
    }

    public void writeShort(short value) throws IOException {
        this.checkNotFinished();
        this.out.writeShort(value);
    }

    public void writeInt(int value) throws IOException {
        this.checkNotFinished();
        this.out.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.checkNotFinished();
        this.out.writeLong(value);
    }

    public void writeFloat(float value) throws IOException {
        this.checkNotFinished();
        this.out.writeFloat(value);
    }

    public void writeDouble(double value) throws IOException {
        this.checkNotFinished();
        this.out.writeDouble(value);
    }

    public void writeString(String value) throws IOException {
        this.checkNotFinished();
        this.out.writeString(value);
    }

    public void writeObject(Object value) throws IOException {
        this.checkNotFinished();
        this.out.writeObject(value);
    }

    public void writeArray(boolean[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(byte[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(char[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(short[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(int[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(long[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(float[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(double[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(Object[] value) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value);
    }

    public void writeArray(boolean[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(byte[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(char[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(short[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(int[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(long[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(float[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(double[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
    }

    public void writeArray(Object[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.out.writeArray(value, offset, size);
        this.checkNotFinished();
    }

    public long bytesWritten() {
        long cnt = this.om.bout.bytesWritten();
        long retval = cnt - this.count;
        this.count = cnt;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish() throws IOException {
        try {
            if (!this.isFinished) {
                long retval = this.om.finalizeSend();
                this.isFinished = true;
                long l = retval;
                return l;
            }
            throw new IOException("Already finished");
        }
        finally {
            LrmcSendPort lrmcSendPort = this.port;
            synchronized (lrmcSendPort) {
                this.port.message = null;
                this.port.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(IOException exception) {
        try {
            if (!this.isFinished) {
                this.om.finalizeSend();
            }
        }
        catch (Throwable throwable) {
            LrmcSendPort lrmcSendPort = this.port;
            synchronized (lrmcSendPort) {
                this.isFinished = true;
                this.port.message = null;
                this.port.notifyAll();
            }
        }
        finally {
            LrmcSendPort lrmcSendPort = this.port;
            synchronized (lrmcSendPort) {
                this.isFinished = true;
                this.port.message = null;
                this.port.notifyAll();
            }
        }
    }

    public int capacity() throws IOException {
        return this.om.bout.bufferSize();
    }

    public int remaining() throws IOException {
        return (int)((long)this.om.bout.bufferSize() - this.om.bout.bytesWritten());
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        this.checkNotFinished();
        this.out.writeByteBuffer(value);
    }
}

