/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.IbisConfigurationException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.LrmcReadMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcReceivePortIdentifier;
import ibis.ipl.impl.stacking.lrmc.Multicaster;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LrmcReceivePort
implements ReceivePort,
Runnable {
    private final LrmcReceivePortIdentifier identifier;
    private final MessageUpcall upcall;
    private final Multicaster om;
    private LrmcReadMessage message = null;
    private boolean closed = false;
    private boolean messageIsAvailable = false;
    private boolean upcallsEnabled = false;

    public LrmcReceivePort(Multicaster om, LrmcIbis ibis, MessageUpcall upcall, Properties properties) throws IOException {
        this.om = om;
        this.identifier = new LrmcReceivePortIdentifier(ibis.identifier(), om.name);
        this.upcall = upcall;
        if (upcall != null && !om.portType.hasCapability("receive.autoupcalls")) {
            throw new IbisConfigurationException("no connection upcalls requested for this port type");
        }
        ThreadPool.createNew((Runnable)this, (String)"ReceivePort");
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.om.removeReceivePort();
        this.notifyAll();
    }

    public void close(long timeoutMillis) throws IOException {
        this.close();
    }

    public SendPortIdentifier[] connectedTo() {
        throw new IbisConfigurationException("connection downcalls not supported");
    }

    public void disableConnections() {
    }

    public synchronized void disableMessageUpcalls() {
        this.upcallsEnabled = false;
    }

    public void enableConnections() {
    }

    public synchronized void enableMessageUpcalls() {
        this.upcallsEnabled = true;
        this.notifyAll();
    }

    public PortType getPortType() {
        return this.om.portType;
    }

    public ReceivePortIdentifier identifier() {
        return this.identifier;
    }

    public SendPortIdentifier[] lostConnections() {
        throw new IbisConfigurationException("connection downcalls not supported");
    }

    public String name() {
        return this.identifier.name;
    }

    public SendPortIdentifier[] newConnections() {
        throw new IbisConfigurationException("connection downcalls not supported");
    }

    public synchronized ReadMessage poll() throws IOException {
        if (this.closed) {
            throw new IOException("port is closed");
        }
        if (this.messageIsAvailable) {
            this.messageIsAvailable = false;
            return this.message;
        }
        return null;
    }

    public ReadMessage receive() throws IOException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMessage receive(long timeout) throws IOException {
        if (this.upcall != null) {
            throw new IbisConfigurationException("Configured Receiveport for upcalls, downcall not allowed");
        }
        boolean hasTimeout = false;
        if (timeout < 0L) {
            throw new IOException("timeout must be a non-negative number");
        }
        if (timeout > 0L && !this.om.portType.hasCapability("receive.timeout")) {
            throw new IbisConfigurationException("This port is not configured for receive() with timeout");
        }
        LrmcReceivePort lrmcReceivePort = this;
        synchronized (lrmcReceivePort) {
            while (!this.messageIsAvailable) {
                if (this.closed) {
                    throw new IOException("port is closed");
                }
                if (timeout > 0L) {
                    hasTimeout = true;
                    long tm = System.currentTimeMillis();
                    try {
                        this.wait(timeout);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    long tm1 = System.currentTimeMillis();
                    timeout -= tm1 - tm;
                    continue;
                }
                if (hasTimeout) {
                    throw new ReceiveTimedOutException();
                }
                try {
                    this.wait();
                }
                catch (Throwable e) {}
            }
            this.messageIsAvailable = false;
            return this.message;
        }
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCReceivePort");
    }

    public Map<String, String> managementProperties() {
        return new HashMap<String, String>();
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCReceivePort");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCReceivePort");
    }

    synchronized void doFinish() {
        this.message = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpcall(LrmcReadMessage msg) {
        LrmcReceivePort lrmcReceivePort = this;
        synchronized (lrmcReceivePort) {
            while (!this.upcallsEnabled) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {}
            }
        }
        try {
            msg.setInUpcall(true);
            this.upcall.upcall((ReadMessage)msg);
        }
        catch (IOException e) {
            if (!msg.isFinished) {
                msg.finish(e);
                boolean e2 = false;
                return e2;
            }
        }
        catch (ClassNotFoundException e) {
            if (!msg.isFinished) {
                IOException ioex = new IOException("Got ClassNotFoundException: " + e.getMessage());
                ioex.initCause(e);
                msg.finish(ioex);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            System.exit(1);
        }
        finally {
            msg.setInUpcall(false);
        }
        if (!msg.isFinished) {
            try {
                msg.finish();
            }
            catch (IOException e) {
                msg.finish(e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LrmcReadMessage m;
        do {
            if (this.closed) {
                return;
            }
            m = this.om.receive();
            if (m == null) {
                return;
            }
            LrmcReceivePort lrmcReceivePort = this;
            synchronized (lrmcReceivePort) {
                while (this.message != null) {
                    try {
                        this.wait();
                    }
                    catch (Throwable throwable) {}
                }
                this.messageIsAvailable = true;
                this.message = m;
                if (this.upcall == null) {
                    this.notifyAll();
                }
            }
        } while (this.upcall == null || !this.doUpcall(m));
    }
}

