/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class CapabilitySet {
    private transient byte[] codedForm;
    private final HashSet<String> capabilities = new HashSet();

    public CapabilitySet() {
        this.codedForm = this.computeCodedForm();
    }

    public CapabilitySet(String ... values) {
        for (String value : values) {
            this.capabilities.add(value.toLowerCase());
        }
        this.codedForm = this.computeCodedForm();
    }

    public CapabilitySet(CapabilitySet capabilitySet) {
        this.capabilities.addAll(capabilitySet.capabilities);
        this.codedForm = capabilitySet.codedForm;
    }

    protected CapabilitySet(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = properties.getProperty(name);
            if (value == null || !value.equals("1") && !value.equals("on") && !value.equals("") && !value.equals("true") && !value.equals("yes")) continue;
            this.capabilities.add(name.toLowerCase());
        }
        this.codedForm = this.computeCodedForm();
    }

    public CapabilitySet(byte[] codedForm) throws IOException {
        this(codedForm, 0, codedForm.length);
    }

    public CapabilitySet(byte[] codedForm, int offset, int length) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(codedForm, offset, length)));
    }

    public CapabilitySet(DataInput dis) throws IOException {
        this.doRead(dis);
        this.codedForm = this.computeCodedForm();
    }

    public byte[] toBytes() {
        return (byte[])this.codedForm.clone();
    }

    private byte[] computeCodedForm() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.doWrite(dos);
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.codedForm);
    }

    public boolean hasCapability(String capability) {
        return this.capabilities.contains(capability.toLowerCase());
    }

    public boolean matchCapabilities(CapabilitySet capabilitySet) {
        for (String capability : this.capabilities) {
            if (capabilitySet.hasCapability(capability)) continue;
            return false;
        }
        return true;
    }

    public CapabilitySet getCapabilitiesWithPrefix(String prefix) {
        CapabilitySet result = new CapabilitySet();
        for (String capability : this.capabilities) {
            if (!capability.startsWith(prefix)) continue;
            result.capabilities.add(capability);
        }
        result.codedForm = this.computeCodedForm();
        return result;
    }

    public CapabilitySet unmatchedCapabilities(CapabilitySet capabilitySet) {
        CapabilitySet result = new CapabilitySet();
        for (String capability : this.capabilities) {
            if (capabilitySet.hasCapability(capability)) continue;
            result.capabilities.add(capability);
        }
        result.codedForm = this.computeCodedForm();
        return result;
    }

    public int size() {
        return this.capabilities.size();
    }

    public static CapabilitySet load(String name) throws IOException {
        InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(name);
        if (in == null) {
            throw new IOException("Could not open " + name);
        }
        return CapabilitySet.load(in);
    }

    public static CapabilitySet load(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        input.close();
        return new CapabilitySet(properties);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CapabilitySet)) {
            return false;
        }
        CapabilitySet capabilitySet = (CapabilitySet)other;
        return this.capabilities.equals(capabilitySet.capabilities);
    }

    public int hashCode() {
        return this.capabilities.hashCode();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        this.doWrite(output);
    }

    private void doWrite(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.capabilities.size());
        for (String capability : this.capabilities) {
            dataOutput.writeUTF(capability);
        }
    }

    private void readObject(ObjectInputStream input) throws IOException {
        this.doRead(input);
    }

    private void doRead(DataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.capabilities.add(dataInput.readUTF());
        }
        this.codedForm = this.computeCodedForm();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String append = "";
        for (String capability : this.capabilities) {
            result.append(append);
            result.append(capability);
            append = " ";
        }
        return result.toString();
    }

    public String[] getCapabilities() {
        int size = this.capabilities.size();
        String[] result = new String[size];
        int i = 0;
        Iterator<String> i$ = this.capabilities.iterator();
        while (i$.hasNext()) {
            String capability;
            result[i] = capability = i$.next();
            ++i;
        }
        return result;
    }
}

