/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.IbisConfigurationException;
import ibis.util.TypedProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class MultiClassLoader
extends URLClassLoader {
    public MultiClassLoader(String ibisName, TypedProperties userProperties) throws IbisConfigurationException, IOException {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        String[] jarFiles = userProperties.getStringList("ibis.multi.jars." + ibisName);
        if (jarFiles == null || jarFiles.length == 0) {
            throw new IbisConfigurationException("Implementation jar files not specified in property: ibis.multi.jars." + ibisName);
        }
        for (String jarFile : jarFiles) {
            File implJarFile = new File(jarFile);
            if (!implJarFile.exists()) {
                throw new IbisConfigurationException("Implementation jar file: " + jarFile + " does not exist.");
            }
            super.addURL(implJarFile.toURI().toURL());
        }
    }
}

