/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.throughput.mtnio;

import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import test.virtual.throughput.mtnio.DataSink;

class Receiver
extends Thread {
    private final DataSink d;
    private final VirtualSocket s;
    private final SocketChannel channel;
    private final ByteBuffer buffer;
    private final ByteBuffer opcode;
    private final int size;

    Receiver(DataSink d, VirtualSocket s, DataOutputStream out, DataInputStream in, int size) {
        this.d = d;
        this.s = s;
        this.size = size;
        this.channel = s.getChannel();
        this.buffer = ByteBuffer.allocateDirect(size);
        this.buffer.clear();
        this.opcode = ByteBuffer.allocateDirect(4);
        this.opcode.clear();
    }

    private int readOpcode() {
        int block = 0;
        try {
            int tmp;
            for (int read = 0; read < 4; read += tmp) {
                tmp = this.channel.read(this.opcode);
                if (tmp != -1) continue;
                throw new EOFException("Socket closed while reading opcode");
            }
            this.opcode.flip();
            block = this.opcode.getInt();
            this.opcode.clear();
        }
        catch (Exception e) {
            throw new Error("Failed to read opcode! " + e);
        }
        return block;
    }

    private boolean receiveData() {
        int block = -2;
        try {
            do {
                int tmp;
                if ((block = this.readOpcode()) < 0) continue;
                for (int read = 0; read < this.size; read += tmp) {
                    tmp = this.channel.read(this.buffer);
                    if (tmp != -1) continue;
                    throw new EOFException("Socket closed while reading opcode");
                }
                this.buffer.clear();
            } while (block >= 0);
        }
        catch (Exception e) {
            throw new Error("Failed to read data!", e);
        }
        this.d.done();
        return block == -2;
    }

    @Override
    public void run() {
        boolean stop = false;
        while (!stop) {
            stop = this.receiveData();
        }
        VirtualSocketFactory.close(this.s, this.channel);
    }
}

