/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private static final AttributeKey BUFFER = new AttributeKey(CumulativeProtocolDecoder.class, "buffer");
    private boolean transportMetadataFragmentation = true;

    protected CumulativeProtocolDecoder() {
    }

    @Override
    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (this.transportMetadataFragmentation && !session.getTransportMetadata().hasFragmentation()) {
            while (in.hasRemaining() && this.doDecode(session, in, out)) {
            }
            return;
        }
        boolean usingSessionBuffer = true;
        IoBuffer buf2 = (IoBuffer)session.getAttribute(BUFFER);
        if (buf2 != null) {
            boolean appended = false;
            if (buf2.isAutoExpand()) {
                try {
                    buf2.put(in);
                    appended = true;
                }
                catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
                    // empty catch block
                }
            }
            if (appended) {
                buf2.flip();
            } else {
                buf2.flip();
                IoBuffer newBuf = IoBuffer.allocate(buf2.remaining() + in.remaining()).setAutoExpand(true);
                newBuf.order(buf2.order());
                newBuf.put(buf2);
                newBuf.put(in);
                newBuf.flip();
                buf2 = newBuf;
                session.setAttribute(BUFFER, buf2);
            }
        } else {
            buf2 = in;
            usingSessionBuffer = false;
        }
        do {
            int oldPos = buf2.position();
            boolean decoded = this.doDecode(session, buf2, out);
            if (!decoded) break;
            if (buf2.position() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf2.hasRemaining());
        if (buf2.hasRemaining()) {
            if (usingSessionBuffer && buf2.isAutoExpand()) {
                buf2.compact();
            } else {
                this.storeRemainingInSession(buf2, session);
            }
        } else if (usingSessionBuffer) {
            this.removeSessionBuffer(session);
        }
    }

    protected abstract boolean doDecode(IoSession var1, IoBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    @Override
    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        session.removeAttribute(BUFFER);
    }

    private void storeRemainingInSession(IoBuffer buf2, IoSession session) {
        IoBuffer remainingBuf = IoBuffer.allocate(buf2.capacity()).setAutoExpand(true);
        remainingBuf.order(buf2.order());
        remainingBuf.put(buf2);
        session.setAttribute(BUFFER, remainingBuf);
    }

    public void setTransportMetadataFragmentation(boolean transportMetadataFragmentation) {
        this.transportMetadataFragmentation = transportMetadataFragmentation;
    }
}

