/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.samples;

import java.util.Iterator;
import java.util.List;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.UPNPService;

public class IGDAccessSample {
    public static void main(String[] args) {
        block12: {
            try {
                UPNPRootDevice[] rootDevices = Discovery.discover(1500, "urn:schemas-upnp-org:device:InternetGatewayDevice:1");
                if (rootDevices == null) break block12;
                UPNPRootDevice rootDevice = rootDevices[0];
                System.out.println("Plugged to device " + rootDevice.getDeviceType() + ", manufactured by " + rootDevice.getManufacturer() + " model " + rootDevice.getModelName());
                List devices = rootDevice.getChildDevices();
                if (devices != null) {
                    devices.add(rootDevice);
                    Iterator i = devices.iterator();
                    while (i.hasNext()) {
                        List deviceServices;
                        UPNPDevice device = (UPNPDevice)i.next();
                        System.out.println();
                        System.out.println("type " + device.getDeviceType());
                        if (device.getDirectParent() != null) {
                            System.out.println("parent type " + device.getDirectParent().getDeviceType());
                        }
                        if ((deviceServices = device.getServices()) == null) continue;
                        Iterator iSrv = deviceServices.iterator();
                        while (iSrv.hasNext()) {
                            UPNPService srv = (UPNPService)iSrv.next();
                            System.out.println("  service " + srv.getServiceType() + " at " + srv.getSCPDURL());
                            Iterator itrActions = srv.getAvailableActionsName();
                            while (itrActions.hasNext()) {
                                System.out.println("\t" + itrActions.next());
                            }
                        }
                    }
                }
                List rootChildDevices = rootDevice.getChildDevices();
                System.out.println("Child devices available : " + rootChildDevices);
                UPNPDevice wanConnDevice = rootDevice.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
                if (wanConnDevice == null) break block12;
                System.out.println("Found required device " + wanConnDevice.getDeviceType());
                UPNPService wanIPSrv = wanConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
                if (wanIPSrv == null) break block12;
                System.out.println("Service " + wanIPSrv.getServiceType() + " found\n");
                if (wanIPSrv.getUPNPServiceAction("GetExternalIPAddress") == null) break block12;
                UPNPMessageFactory wanIPMsgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
                ActionMessage externalIPAdrMsg = wanIPMsgFactory.getMessage("GetExternalIPAddress");
                List params = externalIPAdrMsg.getInputParameterNames();
                System.out.println("Action required input params:");
                System.out.println(params);
                params = externalIPAdrMsg.getOutputParameterNames();
                System.out.println("Action returned values:");
                System.out.println(params);
                try {
                    ActionResponse response = externalIPAdrMsg.service();
                    System.out.println("Message response values:");
                    for (int i = 0; i < params.size(); ++i) {
                        String param = (String)params.get(i);
                        System.out.println(param + "=" + response.getOutActionArgumentValue(param));
                    }
                }
                catch (UPNPResponseException uPNPResponseException) {
                    // empty catch block
                }
                System.out.println("Validity time remaining=" + rootDevice.getValidityTime());
                System.out.println("Query PortMappingDescription state variable");
                try {
                    System.out.println("Response=" + wanIPSrv.getUPNPServiceStateVariable("PortMappingDescription").getValue());
                }
                catch (UPNPResponseException uPNPResponseException) {}
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

