/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.impls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternetGatewayDevice {
    private static final Log log = LogFactory.getLog(InternetGatewayDevice.class);
    private UPNPRootDevice igd;
    private UPNPMessageFactory msgFactory;

    public InternetGatewayDevice(UPNPRootDevice igd) throws UnsupportedOperationException {
        this(igd, true, true);
    }

    private InternetGatewayDevice(UPNPRootDevice igd, boolean WANIPConnection, boolean WANPPPConnection) throws UnsupportedOperationException {
        this.igd = igd;
        UPNPDevice myIGDWANConnDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        if (myIGDWANConnDevice == null) {
            throw new UnsupportedOperationException("device urn:schemas-upnp-org:device:WANConnectionDevice:1 not supported by IGD device " + igd.getModelName());
        }
        UPNPService wanIPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
        UPNPService wanPPPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANPPPConnection:1");
        if (WANIPConnection && WANPPPConnection && wanIPSrv == null && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 or urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (WANIPConnection && !WANPPPConnection && wanIPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 service");
        }
        if (!WANIPConnection && WANPPPConnection && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (wanIPSrv != null && wanPPPSrv == null) {
            this.msgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
        } else if (wanPPPSrv != null && wanIPSrv == null) {
            this.msgFactory = UPNPMessageFactory.getNewInstance(wanPPPSrv);
        } else {
            if (this.testWANInterface(wanIPSrv)) {
                this.msgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
            } else if (this.testWANInterface(wanPPPSrv)) {
                this.msgFactory = UPNPMessageFactory.getNewInstance(wanPPPSrv);
            }
            if (this.msgFactory == null) {
                log.warn("Unable to detect active WANIPConnection, dfaulting to urn:schemas-upnp-org:service:WANIPConnection:1");
                this.msgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
            }
        }
    }

    private boolean testWANInterface(UPNPService srv) {
        UPNPMessageFactory tmp = UPNPMessageFactory.getNewInstance(srv);
        ActionMessage msg = tmp.getMessage("GetExternalIPAddress");
        String ipToParse = null;
        try {
            ipToParse = msg.service().getOutActionArgumentValue("NewExternalIPAddress");
        }
        catch (UPNPResponseException uPNPResponseException) {
        }
        catch (IOException ex) {
            log.warn("IOException occured during device detection", ex);
        }
        if (ipToParse != null && ipToParse.length() > 0 && !ipToParse.equals("0.0.0.0")) {
            try {
                return InetAddress.getByName(ipToParse) != null;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    public UPNPRootDevice getIGDRootDevice() {
        return this.igd;
    }

    public static InternetGatewayDevice[] getDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, 4, 3, true, true, null);
    }

    public static InternetGatewayDevice[] getDevices(int timeout, int ttl, int mx, NetworkInterface ni) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, ttl, mx, true, true, ni);
    }

    public static InternetGatewayDevice[] getIPDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, 4, 3, true, false, null);
    }

    public static InternetGatewayDevice[] getPPPDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, 4, 3, false, true, null);
    }

    private static InternetGatewayDevice[] lookupDeviceDevices(int timeout, int ttl, int mx, boolean WANIPConnection, boolean WANPPPConnection, NetworkInterface ni) throws IOException {
        UPNPRootDevice[] devices = null;
        InternetGatewayDevice[] rtrVal = null;
        devices = timeout == -1 ? Discovery.discover(1500, ttl, mx, "urn:schemas-upnp-org:device:InternetGatewayDevice:1", ni) : Discovery.discover(timeout, ttl, mx, "urn:schemas-upnp-org:device:InternetGatewayDevice:1", ni);
        if (devices != null) {
            int i;
            HashSet<InternetGatewayDevice> valid = new HashSet<InternetGatewayDevice>();
            for (i = 0; i < devices.length; ++i) {
                try {
                    valid.add(new InternetGatewayDevice(devices[i], WANIPConnection, WANPPPConnection));
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("UnsupportedOperationException during discovery " + ex.getMessage());
                }
            }
            if (valid.size() == 0) {
                return null;
            }
            rtrVal = new InternetGatewayDevice[valid.size()];
            i = 0;
            Iterator itr = valid.iterator();
            while (itr.hasNext()) {
                rtrVal[i++] = (InternetGatewayDevice)itr.next();
            }
        }
        return rtrVal;
    }

    public String getExternalIPAddress() throws UPNPResponseException, IOException {
        ActionMessage msg = this.msgFactory.getMessage("GetExternalIPAddress");
        return msg.service().getOutActionArgumentValue("NewExternalIPAddress");
    }

    public ActionResponse getGenericPortMappingEntry(int newPortMappingIndex) throws IOException, UPNPResponseException {
        ActionMessage msg = this.msgFactory.getMessage("GetGenericPortMappingEntry");
        msg.setInputParameter("NewPortMappingIndex", newPortMappingIndex);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public ActionResponse getSpecificPortMappingEntry(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("GetSpecificPortMappingEntry");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public boolean addPortMapping(String description, String remoteHost, int internalPort, int externalPort, String internalClient, int leaseDuration, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        if (externalPort != 0) {
            this.checkPortRange(externalPort);
        }
        this.checkPortRange(internalPort);
        String string = description = description == null ? "" : description;
        if (leaseDuration < 0) {
            throw new IllegalArgumentException("Invalid leaseDuration (" + leaseDuration + ") value");
        }
        ActionMessage msg = this.msgFactory.getMessage("AddPortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol).setInputParameter("NewInternalPort", internalPort).setInputParameter("NewInternalClient", internalClient).setInputParameter("NewEnabled", true).setInputParameter("NewPortMappingDescription", description).setInputParameter("NewLeaseDuration", leaseDuration);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 718) {
                return false;
            }
            throw ex;
        }
    }

    public boolean deletePortMapping(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("DeletePortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return false;
            }
            throw ex;
        }
    }

    public Integer getNatMappingsCount() throws IOException, UPNPResponseException {
        Integer rtrval;
        block2: {
            rtrval = null;
            StateVariableMessage natTableSize = this.msgFactory.getStateVariableMessage("PortMappingNumberOfEntries");
            try {
                StateVariableResponse resp = natTableSize.service();
                rtrval = new Integer(resp.getStateVariableValue());
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 404) break block2;
                throw ex;
            }
        }
        return rtrval;
    }

    public Integer getNatTableSize() throws IOException, UPNPResponseException {
        int startIndex = -1;
        for (int i = 0; i < 50; ++i) {
            try {
                this.getGenericPortMappingEntry(i);
                startIndex = i;
                break;
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 713 || ex.getDetailErrorCode() == 402) continue;
                throw ex;
            }
        }
        if (startIndex == -1) {
            return null;
        }
        int size = 0;
        try {
            while (true) {
                this.getGenericPortMappingEntry(startIndex++);
                ++size;
            }
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() != 713 && ex.getDetailErrorCode() != 402) {
                throw ex;
            }
            return new Integer(size);
        }
    }

    private void checkPortMappingProtocol(String prot) throws IllegalArgumentException {
        if (prot == null || !prot.equals("TCP") && !prot.equals("UDP")) {
            throw new IllegalArgumentException("PortMappingProtocol must be either TCP or UDP");
        }
    }

    private void checkPortRange(int port) throws IllegalArgumentException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port range must be between 1 and 65535");
        }
    }
}

