/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.viz;

import com.touchgraph.graphlayout.Edge;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.viz.HubNode;
import ibis.smartsockets.viz.SmartNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ClientNode
extends SmartNode {
    private final boolean compact;
    protected Edge edge;
    protected HubNode hub;

    public ClientNode(String id, HubNode hub, boolean compact) {
        this.setRank(1);
        this.compact = compact;
        this.hub = hub;
        this.edge = new Edge(this, hub);
        this.edge.setLength(20);
        this.edge.useArrowHead(false);
    }

    public ClientNode(ClientInfo info, HubNode hub, boolean compact) {
        this.hub = hub;
        this.compact = compact;
        this.setRank(1);
        this.edge = new Edge(this, hub);
        this.edge.useArrowHead(false);
        this.edge.setLength(20);
        if (compact) {
            this.setType(4);
        } else {
            this.setType(2);
        }
        this.update(info, hub);
    }

    public void update(ClientInfo info, HubNode hub) {
        String adr = info.getClientAddress().toString();
        String tmp = info.getProperty("smartsockets.viz");
        String label = this.getElement(tmp, 0, "C");
        String longLabel = this.getElement(tmp, 1, "Client");
        String[] popup = this.getElements(tmp, 2, new String[]{"Client"});
        String color = this.getElement(tmp, 3, null);
        String rank = this.getElement(tmp, 4, null);
        if (this.compact) {
            if (label.length() > 1) {
                label = label.substring(0, 1);
            }
            this.setLabel(label);
        } else {
            this.setLabel(longLabel);
        }
        if (color != null && !color.equalsIgnoreCase("invisible")) {
            this.setPattern(Color.decode(color));
        } else {
            this.setPattern(hub.getPattern());
        }
        if (rank != null) {
            try {
                int r = Integer.parseInt(rank, 10);
                this.setRank(r);
            }
            catch (NumberFormatException r) {
                // empty catch block
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(popup));
        list.add(adr);
        this.setMouseOverText(list.toArray(new String[0]));
        if (!(tmp != null && tmp.equalsIgnoreCase("invisible") || color != null && color.equalsIgnoreCase("invisible"))) {
            this.setVisible(true);
        }
    }

    private String getElement(String s, int num, String def) {
        if (s == null) {
            return def;
        }
        String[] tmp = this.split(s, "^");
        if (tmp.length <= num || tmp[num] == null) {
            return def;
        }
        return tmp[num];
    }

    private String[] split(String s, String seperator) {
        StringTokenizer t = new StringTokenizer(s, seperator);
        String[] result = new String[t.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = t.nextToken();
        }
        return result;
    }

    private String[] getElements(String s, int num, String[] def) {
        String tmp = this.getElement(s, num, null);
        if (tmp == null) {
            return def;
        }
        return this.split(tmp, ",");
    }

    public Edge getEdge() {
        return this.edge;
    }
}

