/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.hubrouted;

import ibis.smartsockets.virtual.modules.hubrouted.HubRoutedVirtualSocket;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class HubRoutedInputStream
extends InputStream {
    private final int MINIMAL_ACK_SIZE;
    private final HubRoutedVirtualSocket parent;
    private final byte[] buffer;
    private int startRead = 0;
    private int startWrite = 0;
    private int available = 0;
    private int pendingACK = 0;
    private boolean closePending = false;
    private boolean closed = false;

    HubRoutedInputStream(HubRoutedVirtualSocket parent, int fragmentation, int bufferSize, int ackSize) {
        this.parent = parent;
        this.buffer = new byte[bufferSize];
        this.MINIMAL_ACK_SIZE = ackSize;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed!");
        }
        int avail = this.waitAvailable();
        if (avail == -1) {
            this.doClose();
            return -1;
        }
        byte result = this.buffer[this.startRead];
        this.startRead = (this.startRead + 1) % this.buffer.length;
        this.decreaseAvailableAndACK(1);
        return result & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        if (this.closed) {
            throw new IOException("Stream closed!");
        }
        int avail = this.waitAvailable();
        if (avail == -1) {
            this.doClose();
            return -1;
        }
        int n = toRead = avail < len ? avail : len;
        if (this.startRead + toRead <= this.buffer.length) {
            System.arraycopy(this.buffer, this.startRead, b, off, toRead);
            this.startRead = (this.startRead + toRead) % this.buffer.length;
        } else {
            int part = this.buffer.length - this.startRead;
            System.arraycopy(this.buffer, this.startRead, b, off, part);
            System.arraycopy(this.buffer, 0, b, off + part, toRead - part);
            this.startRead = toRead - part;
        }
        this.decreaseAvailableAndACK(toRead);
        return toRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseAvailableAndACK(int amount) throws IOException {
        HubRoutedInputStream hubRoutedInputStream = this;
        synchronized (hubRoutedInputStream) {
            this.available -= amount;
        }
        this.pendingACK += amount;
        if (this.pendingACK > this.MINIMAL_ACK_SIZE) {
            this.parent.sendACK(this.pendingACK);
            this.pendingACK = 0;
        }
    }

    private synchronized int waitAvailable() throws IOException {
        if (this.available > 0) {
            return this.available;
        }
        long deadline = 0L;
        long timeleft = this.parent.getSoTimeout();
        if (timeleft > 0L) {
            deadline = System.currentTimeMillis() + timeleft;
        } else {
            timeleft = 0L;
        }
        while (this.available == 0) {
            if (this.closePending || this.closed) {
                return -1;
            }
            try {
                this.wait(timeleft);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (deadline <= 0L || this.available != 0 || (timeleft = deadline - System.currentTimeMillis()) > 0L) continue;
            throw new SocketTimeoutException("Timeout while reading data");
        }
        return this.available;
    }

    @Override
    public synchronized int available() {
        return this.available;
    }

    @Override
    public synchronized void close() {
        this.closePending = true;
        if (this.available == 0) {
            this.notifyAll();
        }
    }

    private synchronized void doClose() {
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }

    protected final synchronized void add(int len, DataInputStream dis) throws IOException {
        int cont;
        if (len > this.buffer.length - this.available) {
            System.err.println("EEK: buffer overflow!! (" + len + " > " + this.buffer.length + " - " + this.available + ")");
            new Exception().printStackTrace(System.err);
        }
        if ((cont = this.buffer.length - this.startWrite) >= len) {
            dis.readFully(this.buffer, this.startWrite, len);
            this.startWrite = (this.startWrite + len) % this.buffer.length;
        } else {
            dis.readFully(this.buffer, this.startWrite, cont);
            dis.readFully(this.buffer, 0, len - cont);
            this.startWrite = len - cont;
        }
        this.available += len;
        if (this.available == len) {
            this.notifyAll();
        }
    }
}

