/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.servicelink;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class ClientInfo {
    private final DirectSocketAddress clientAddress;
    private final long version;
    private final Map<String, String> properties;

    public ClientInfo(String clientAsString) {
        String orig = clientAsString;
        if (!clientAsString.startsWith("Client(")) {
            throw new IllegalArgumentException("String does not contain Client description!");
        }
        try {
            clientAsString = clientAsString.substring(7);
            int index = clientAsString.indexOf(", ");
            if (index == -1) {
                throw new IllegalArgumentException("String does not contain Client description!");
            }
            this.clientAddress = DirectSocketAddress.getByAddress(clientAsString.substring(0, index));
            if ((index = (clientAsString = clientAsString.substring(index + 2)).indexOf(", [")) == -1) {
                index = clientAsString.indexOf(")");
            }
            if (index == -1) {
                throw new IllegalArgumentException("String does not contain Client description!");
            }
            this.version = Long.parseLong(clientAsString.substring(0, index));
            this.properties = new HashMap<String, String>();
            clientAsString = clientAsString.substring(index);
            while (clientAsString.startsWith(", [")) {
                clientAsString = clientAsString.substring(3);
                index = clientAsString.indexOf(",");
                String key = clientAsString.substring(0, index);
                clientAsString = clientAsString.substring(index + 1);
                index = clientAsString.indexOf(93);
                String value = clientAsString.substring(0, index);
                this.properties.put(key, value);
                clientAsString = clientAsString.substring(index + 1);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String does not contain Client description: \"" + orig + "\"", e);
        }
        if (!clientAsString.equals(")")) {
            throw new IllegalArgumentException("String does not contain Client description!");
        }
    }

    public ClientInfo(DirectSocketAddress clientAddress, long version, Map<String, String> properties) {
        this.clientAddress = clientAddress;
        this.version = version;
        this.properties = properties;
    }

    public DirectSocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public VirtualSocketAddress getPropertyAsAddress(String name) throws UnknownHostException {
        return new VirtualSocketAddress(this.getProperty(name));
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Client(");
        result.append(this.clientAddress.toString());
        result.append(", ");
        result.append(this.version);
        result.append(", ");
        for (String key : this.properties.keySet()) {
            String value = this.properties.get(key);
            result.append(", [");
            result.append(key);
            result.append(",");
            result.append(value);
            result.append("]");
        }
        result.append(")");
        return result.toString();
    }
}

