/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.io.rewriter.CodeGenerator;
import ibis.io.rewriter.RewriterConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

class SerializationInfo
implements RewriterConstants {
    static FieldComparator fieldComparator = new FieldComparator();
    static HashMap<String, Long> serialversionids = new HashMap();
    static HashMap<Type, SerializationInfo> primitiveSerialization = new HashMap();
    static SerializationInfo referenceSerialization = new SerializationInfo("writeObject", "readObject", "readFieldObject", (Type)Type.OBJECT, false);
    String write_name;
    String read_name;
    String final_read_name;
    Type tp;
    Type[] param_tp_arr;
    boolean primitive;

    SerializationInfo(String wn, String rn, String frn, Type t, boolean primitive) {
        this.write_name = wn;
        this.read_name = rn;
        this.final_read_name = frn;
        this.tp = t;
        this.param_tp_arr = new Type[]{t};
        this.primitive = primitive;
    }

    static SerializationInfo getSerializationInfo(Type tp) {
        SerializationInfo temp = primitiveSerialization.get(tp);
        return temp == null ? referenceSerialization : temp;
    }

    static boolean directImplementationOf(JavaClass clazz, String name) {
        String[] names = clazz.getInterfaceNames();
        String supername = clazz.getSuperclassName();
        if (supername.equals(name)) {
            return true;
        }
        if (names == null) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    static boolean predecessor(String c1, JavaClass c2) {
        String n = c2.getSuperclassName();
        if (n.equals(c1)) {
            return true;
        }
        if (n.equals("java.lang.Object")) {
            return false;
        }
        return SerializationInfo.predecessor(c1, CodeGenerator.lookupClass(n));
    }

    static boolean isFinal(Type t) {
        if (t instanceof BasicType) {
            return true;
        }
        if (t instanceof ArrayType) {
            return SerializationInfo.isFinal(((ArrayType)t).getBasicType());
        }
        if (t instanceof ObjectType) {
            String name = ((ObjectType)t).getClassName();
            JavaClass c = CodeGenerator.lookupClass(name);
            if (c == null) {
                return false;
            }
            return c.isFinal();
        }
        return false;
    }

    static boolean isIbisSerializable(JavaClass clazz) {
        return SerializationInfo.directImplementationOf(clazz, "ibis.io.Serializable");
    }

    static boolean isExternalizable(JavaClass clazz) {
        try {
            return Repository.implementationOf((JavaClass)clazz, (String)"java.io.Externalizable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean isSerializable(JavaClass clazz) {
        try {
            return Repository.implementationOf((JavaClass)clazz, (String)"java.io.Serializable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean hasSerialPersistentFields(Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().equals("serialPersistentFields") || !f.isFinal() || !f.isStatic() || !f.isPrivate() || !f.getSignature().equals("[Ljava/io/ObjectStreamField;")) continue;
            return true;
        }
        return false;
    }

    static boolean hasFinalFields(Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isFinal()) continue;
            return true;
        }
        return false;
    }

    static boolean hasIbisConstructor(JavaClass cl) {
        Method[] clMethods = cl.getMethods();
        for (int i = 0; i < clMethods.length; ++i) {
            if (!clMethods[i].getName().equals("<init>") || !clMethods[i].getSignature().equals("(Libis/io/IbisSerializationInputStream;)V")) continue;
            return true;
        }
        return false;
    }

    static long computeSUID(JavaClass clazz) {
        if (!SerializationInfo.isSerializable(clazz)) {
            return 0L;
        }
        try {
            int mods;
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(clazz.getClassName());
            int classModifiers = clazz.getModifiers() & 0x611;
            Method[] cMethods = clazz.getMethods();
            if ((classModifiers & 0x200) != 0) {
                classModifiers = cMethods.length > 0 ? (classModifiers |= 0x400) : (classModifiers &= 0xFFFFFBFF);
            }
            dout.writeInt(classModifiers);
            Object[] interfaceNames = clazz.getInterfaceNames();
            Arrays.sort(interfaceNames);
            for (int i2 = 0; i2 < interfaceNames.length; ++i2) {
                dout.writeUTF((String)interfaceNames[i2]);
            }
            Field[] cFields = clazz.getFields();
            Arrays.sort(cFields, fieldComparator);
            for (i = 0; i < cFields.length; ++i) {
                mods = cFields[i].getModifiers();
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(cFields[i].getName());
                dout.writeInt(mods);
                dout.writeUTF(cFields[i].getSignature());
            }
            for (i = 0; i < cMethods.length; ++i) {
                if (!cMethods[i].getName().equals("<clinit>")) continue;
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
                break;
            }
            Arrays.sort(cMethods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    String name2;
                    String name1 = o1.getName();
                    if (name1.equals(name2 = o2.getName())) {
                        String sig1 = o1.getSignature();
                        String sig2 = o2.getSignature();
                        return sig1.compareTo(sig2);
                    }
                    return name1.compareTo(name2);
                }
            });
            for (i = 0; i < cMethods.length; ++i) {
                if (!cMethods[i].getName().equals("<init>") || ((mods = cMethods[i].getModifiers()) & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(cMethods[i].getSignature().replace('/', '.'));
            }
            for (i = 0; i < cMethods.length; ++i) {
                if (cMethods[i].getName().equals("<init>") || cMethods[i].getName().equals("<clinit>") || ((mods = cMethods[i].getModifiers()) & 2) != 0) continue;
                dout.writeUTF(cMethods[i].getName());
                dout.writeInt(mods);
                dout.writeUTF(cMethods[i].getSignature().replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i3 = Math.min(hashBytes.length, 8) - 1; i3 >= 0; --i3) {
                hash = hash << 8 | (long)(hashBytes[i3] & 0xFF);
            }
            return hash;
        }
        catch (Exception ex) {
            System.err.println("Warning: could not get serialVersionUID for class " + clazz.getClassName());
            return 0L;
        }
    }

    static long getSerialVersionUID(String classname, JavaClass clazz) {
        long uid;
        Long ui = serialversionids.get(classname);
        if (ui == null) {
            uid = SerializationInfo.computeSUID(clazz);
            serialversionids.put(classname, new Long(uid));
        } else {
            uid = ui;
        }
        return uid;
    }

    static int findMethod(Method[] methods, String name, String signature) {
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !methods[i].getSignature().equals(signature)) continue;
            return i;
        }
        return -1;
    }

    static boolean hasWriteObject(Method[] methods) {
        return SerializationInfo.findMethod(methods, "writeObject", "(Ljava/io/ObjectOutputStream;)V") != -1;
    }

    static boolean hasReadObject(Method[] methods) {
        return SerializationInfo.findMethod(methods, "readObject", "(Ljava/io/ObjectInputStream;)V") != -1;
    }

    static {
        primitiveSerialization.put((Type)Type.BOOLEAN, new SerializationInfo("writeBoolean", "readBoolean", "readFieldBoolean", (Type)Type.BOOLEAN, true));
        primitiveSerialization.put((Type)Type.BYTE, new SerializationInfo("writeByte", "readByte", "readFieldByte", (Type)Type.BYTE, true));
        primitiveSerialization.put((Type)Type.SHORT, new SerializationInfo("writeShort", "readShort", "readFieldShort", (Type)Type.SHORT, true));
        primitiveSerialization.put((Type)Type.CHAR, new SerializationInfo("writeChar", "readChar", "readFieldChar", (Type)Type.CHAR, true));
        primitiveSerialization.put((Type)Type.INT, new SerializationInfo("writeInt", "readInt", "readFieldInt", (Type)Type.INT, true));
        primitiveSerialization.put((Type)Type.LONG, new SerializationInfo("writeLong", "readLong", "readFieldLong", (Type)Type.LONG, true));
        primitiveSerialization.put((Type)Type.FLOAT, new SerializationInfo("writeFloat", "readFloat", "readFieldFloat", (Type)Type.FLOAT, true));
        primitiveSerialization.put((Type)Type.DOUBLE, new SerializationInfo("writeDouble", "readDouble", "readFieldDouble", (Type)Type.DOUBLE, true));
        primitiveSerialization.put((Type)Type.STRING, new SerializationInfo("writeString", "readString", "readFieldString", (Type)Type.STRING, true));
        primitiveSerialization.put(java_lang_class_type, new SerializationInfo("writeClass", "readClass", "readFieldClass", java_lang_class_type, true));
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            return f1.getName().compareTo(f2.getName());
        }
    }
}

