/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.compile.IbiscComponent;
import ibis.io.rewriter.CodeGenerator;
import ibis.io.rewriter.JMECodeGenerator;
import ibis.io.rewriter.JMESerializationInfo;
import ibis.io.rewriter.RewriterConstants;
import ibis.io.rewriter.SerializationInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class IOGenerator
extends IbiscComponent
implements RewriterConstants {
    boolean local = true;
    boolean file = false;
    boolean force_generated_calls = false;
    boolean silent = true;
    boolean use_jme = false;
    Vector<JavaClass> classes_to_rewrite = new Vector();
    Vector<JavaClass> target_classes = new Vector();
    Vector<JavaClass> classes_to_save = new Vector();
    HashMap<String, JavaClass> arguments = new HashMap();
    boolean fromIbisc = false;

    public IOGenerator() {
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isFromIbisc() {
        return this.fromIbisc;
    }

    protected boolean forceGeneratedCalls() {
        return this.force_generated_calls;
    }

    protected boolean useJME() {
        return this.use_jme;
    }

    private boolean removeTarget(JavaClass clazz) {
        return this.target_classes.remove(clazz);
    }

    private void addTarget(JavaClass clazz) {
        this.target_classes.add(clazz);
    }

    private boolean removeSave(JavaClass clazz) {
        return this.classes_to_save.remove(clazz);
    }

    private void addSave(JavaClass clazz) {
        this.classes_to_save.add(clazz);
    }

    protected void replace(JavaClass clazz, JavaClass newclazz) {
        if (this.removeTarget(clazz)) {
            Repository.removeClass((JavaClass)clazz);
            Repository.addClass((JavaClass)newclazz);
            this.addTarget(newclazz);
        }
        if (this.removeSave(clazz)) {
            this.addSave(newclazz);
        }
    }

    protected void markRewritten(JavaClass clazz, JavaClass instgen) {
        if (this.isFromIbisc()) {
            this.setModified(this.wrapper.getInfo((Object)clazz));
            if (instgen != null) {
                this.addEntry(this.wrapper.getInfo((Object)instgen), clazz.getClassName());
            }
        }
        this.addSave(clazz);
        if (instgen != null) {
            this.addSave(instgen);
        }
    }

    public IOGenerator(boolean verbose, boolean local, boolean file, boolean force_generated_calls, boolean silent, boolean use_jme) {
        this();
        this.verbose = verbose;
        this.local = local;
        this.file = file;
        this.force_generated_calls = force_generated_calls;
        this.silent = silent;
        this.use_jme = use_jme;
    }

    public boolean processArgs(ArrayList<String> args) {
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg.equals("-iogen-force")) {
                this.force_generated_calls = true;
                args.remove(i);
                --i;
            }
            if (!arg.equals("-jme")) continue;
            this.use_jme = true;
            args.remove(i);
            --i;
        }
        return true;
    }

    public String getUsageString() {
        return "[-iogen-force] [-jme]";
    }

    public void process(Iterator<?> classes) {
        JavaClass clazz;
        int i;
        this.fromIbisc = true;
        this.arguments = new HashMap();
        Iterator<?> i2 = classes;
        while (i2.hasNext()) {
            JavaClass cl = (JavaClass)i2.next();
            this.arguments.put(cl.getClassName(), cl);
        }
        for (JavaClass cl : this.arguments.values()) {
            if (this.useJME()) {
                if (!JMESerializationInfo.isJMESerializable(cl) || JMESerializationInfo.isJMERewritten(cl)) continue;
                this.addClass(cl);
                continue;
            }
            if (!SerializationInfo.isSerializable(cl) || SerializationInfo.isIbisSerializable(cl)) continue;
            this.addClass(cl);
        }
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            this.addReferencesToRewrite(clazz);
        }
        this.do_sort_classes(this.classes_to_rewrite);
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            if (this.useJME()) {
                new JMECodeGenerator(this, clazz).generateEmptyMethods();
                continue;
            }
            new CodeGenerator(this, clazz).generateEmptyMethods();
        }
        if (this.verbose) {
            System.out.println("Ibisc: IOGenerator rewriting classes");
        }
        this.do_sort_classes(this.target_classes);
        for (i = 0; i < this.target_classes.size(); ++i) {
            clazz = this.target_classes.get(i);
            if (this.verbose) {
                System.out.println("Target Class: " + clazz.getClassName());
            }
            if (clazz.isInterface()) continue;
            if (!this.silent) {
                System.out.println("  Rewrite class : " + clazz.getClassName());
            }
            if (this.useJME()) {
                new JMECodeGenerator(this, clazz).generateCode();
                continue;
            }
            new CodeGenerator(this, clazz).generateCode();
        }
    }

    public String rewriterImpl() {
        return "BCEL";
    }

    private void addTargetClass(JavaClass clazz) {
        String nm;
        if (this.useJME()) {
            String nm2;
            if (this.verbose) {
                System.out.println("Considering target: " + clazz.getClassName());
            }
            if (!this.target_classes.contains(clazz) && this.arguments.containsKey(nm2 = clazz.getClassName())) {
                this.target_classes.add(clazz);
                if (this.verbose) {
                    System.out.println("Adding jme target class : " + nm2);
                }
            }
        } else if (!this.target_classes.contains(clazz) && !SerializationInfo.isIbisSerializable(clazz) && this.arguments.containsKey(nm = clazz.getClassName())) {
            this.target_classes.add(clazz);
            if (this.verbose) {
                System.out.println("Adding target class : " + nm);
            }
        }
    }

    private void addRewriteClass(Type t, JavaClass clazz) {
        String name;
        JavaClass c;
        if (t instanceof ArrayType) {
            this.addRewriteClass(((ArrayType)t).getBasicType(), clazz);
        } else if (t instanceof ObjectType && (c = CodeGenerator.lookupClass(name = ((ObjectType)t).getClassName())) != null && (!this.local || clazz.getPackageName().equals(c.getPackageName()))) {
            this.addClass(c);
        }
    }

    private void addRewriteClass(JavaClass clazz) {
        if (this.useJME()) {
            if (!this.classes_to_rewrite.contains(clazz) && JMESerializationInfo.isJMESerializable(clazz) && !JMESerializationInfo.isJMERewritten(clazz)) {
                this.classes_to_rewrite.add(clazz);
                if (this.verbose) {
                    System.out.println("Adding jme rewrite class : " + clazz.getClassName());
                }
            }
        } else if (!this.classes_to_rewrite.contains(clazz) && !SerializationInfo.isIbisSerializable(clazz)) {
            this.classes_to_rewrite.add(clazz);
            if (this.verbose) {
                System.out.println("Adding rewrite class : " + clazz.getClassName());
            }
        }
    }

    private void addClass(JavaClass clazz) {
        boolean serializable = false;
        if (!clazz.isClass()) {
            return;
        }
        if (clazz.getClassName().equals("java.lang.Class")) {
            return;
        }
        if (clazz.getClassName().equals("java.lang.String")) {
            return;
        }
        try {
            if (Repository.instanceOf((JavaClass)clazz, (String)"java.lang.Enum")) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.classes_to_rewrite.contains(clazz)) {
            JavaClass[] super_classes;
            try {
                super_classes = Repository.getSuperClasses((JavaClass)clazz);
            }
            catch (ClassNotFoundException e) {
                super_classes = null;
            }
            if (super_classes != null) {
                for (int i = 0; i < super_classes.length; ++i) {
                    if (this.useJME()) {
                        if (!JMESerializationInfo.isJMESerializable(super_classes[i])) continue;
                        serializable = true;
                        if (!JMESerializationInfo.isJMERewritten(super_classes[i])) {
                            if (this.local && !clazz.getPackageName().equals(super_classes[i].getPackageName())) continue;
                            this.addRewriteClass(super_classes[i]);
                            continue;
                        }
                        if (!this.verbose) continue;
                        System.out.println(clazz.getClassName() + " already implements " + "ibis.io.jme.JMESerializable");
                        continue;
                    }
                    if (!SerializationInfo.isSerializable(super_classes[i])) continue;
                    serializable = true;
                    if (!SerializationInfo.isIbisSerializable(super_classes[i])) {
                        if (this.local && !clazz.getPackageName().equals(super_classes[i].getPackageName())) continue;
                        this.addRewriteClass(super_classes[i]);
                        continue;
                    }
                    if (!this.verbose) continue;
                    System.out.println(clazz.getClassName() + " already implements " + "ibis.io.Serializable");
                }
            }
            serializable = this.useJME() ? (serializable |= JMESerializationInfo.isJMESerializable(clazz)) : (serializable |= SerializationInfo.isSerializable(clazz));
        } else {
            serializable = true;
        }
        if (serializable) {
            this.addRewriteClass(clazz);
            this.addTargetClass(clazz);
        }
    }

    void addReferencesToRewrite(JavaClass clazz) {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Type field_type;
            Field field = fields[i];
            if (field.isStatic() || field.isTransient() || (field_type = Type.getType((String)field.getSignature())) instanceof BasicType || field_type == Type.STRING || !SerializationInfo.isFinal(field_type)) continue;
            this.addRewriteClass(field_type, clazz);
        }
    }

    private void do_sort_classes(Vector<JavaClass> t) {
        int l = t.size();
        for (int i = 0; i < l; ++i) {
            JavaClass clazz = t.get(i);
            int sav_index = i;
            for (int j = i + 1; j < l; ++j) {
                JavaClass clazz2 = t.get(j);
                if (!SerializationInfo.predecessor(clazz2.getClassName(), clazz)) continue;
                clazz = clazz2;
                sav_index = j;
            }
            if (sav_index == i) continue;
            t.setElementAt(t.get(i), sav_index);
            t.setElementAt(clazz, i);
        }
    }

    private void scanClass(Vector<String> classnames) {
        JavaClass clazz;
        int i;
        int lngth = classnames.size();
        Object[] names = classnames.toArray();
        Arrays.sort(names);
        for (i = lngth - 1; i >= 0; --i) {
            String nm = (String)names[i];
            this.arguments.put(nm, null);
        }
        for (i = lngth - 1; i >= 0; --i) {
            if (this.verbose) {
                System.out.println("  Loading class : " + (String)names[i]);
            }
            String className = (String)names[i];
            JavaClass clazz2 = null;
            if (!this.file) {
                clazz2 = CodeGenerator.lookupClass(className);
                if (clazz2 == null) {
                    System.err.println("Warning: could not load class " + className + ". Please check your classpath.");
                }
            } else {
                System.err.println("class name = " + className);
                try {
                    ClassParser p = new ClassParser(className.replace('.', File.separatorChar) + ".class");
                    clazz2 = p.parse();
                    if (clazz2 != null) {
                        Repository.removeClass((String)className);
                        Repository.addClass((JavaClass)clazz2);
                    }
                }
                catch (Exception e) {
                    System.err.println("got exception while loading class: " + e);
                    System.exit(1);
                }
            }
            if (clazz2 == null) continue;
            if (SerializationInfo.isSerializable(clazz2)) {
                if (!SerializationInfo.isIbisSerializable(clazz2)) {
                    this.addClass(clazz2);
                    continue;
                }
                if (!this.verbose) continue;
                System.out.println(clazz2.getClassName() + " already implements " + "ibis.io.Serializable");
                continue;
            }
            if (this.verbose) {
                System.out.println(clazz2.getClassName() + " is not serializable");
            }
            Repository.removeClass((JavaClass)clazz2);
        }
        if (this.verbose) {
            System.out.println("Preparing classes");
        }
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            this.addReferencesToRewrite(clazz);
        }
        Repository.clearCache();
        this.do_sort_classes(this.classes_to_rewrite);
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            if (this.useJME()) {
                new JMECodeGenerator(this, clazz).generateEmptyMethods();
                continue;
            }
            new CodeGenerator(this, clazz).generateEmptyMethods();
        }
        if (this.verbose) {
            System.out.println("Rewriting classes");
        }
        this.do_sort_classes(this.target_classes);
        for (i = 0; i < this.target_classes.size(); ++i) {
            clazz = this.target_classes.get(i);
            if (clazz.isInterface()) continue;
            if (!this.silent) {
                System.out.println("  Rewrite class : " + clazz.getClassName());
            }
            if (this.useJME()) {
                new JMECodeGenerator(this, clazz).generateCode();
                continue;
            }
            new CodeGenerator(this, clazz).generateCode();
        }
        if (this.verbose) {
            System.out.println("Saving classes");
        }
        for (i = 0; i < this.classes_to_save.size(); ++i) {
            clazz = this.classes_to_save.get(i);
            String cl = clazz.getClassName();
            String classfile = "";
            try {
                if (this.local) {
                    int index = cl.lastIndexOf(46);
                    classfile = cl.substring(index + 1) + ".class";
                } else {
                    classfile = cl.replace('.', File.separatorChar) + ".class";
                }
                if (this.verbose) {
                    System.out.println("  Saving class : " + classfile);
                }
                clazz.dump(classfile);
                continue;
            }
            catch (IOException e) {
                System.err.println("got exception while writing " + classfile + ": " + e);
                System.exit(1);
            }
        }
    }

    private static void usage() {
        System.out.println("Usage : java IOGenerator [-dir|-local] [-package <package>] [-v] [-jme]<fully qualified classname list | classfiles>");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean local = true;
        boolean file = false;
        boolean force_generated_calls = false;
        boolean silent = false;
        boolean use_jme = false;
        Vector<String> files = new Vector<String>();
        String pack = null;
        if (args.length == 0) {
            IOGenerator.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (!args[i].startsWith("-")) {
                files.add(args[i]);
                continue;
            }
            if (args[i].equals("-dir")) {
                local = false;
                continue;
            }
            if (args[i].equals("-local")) {
                local = true;
                continue;
            }
            if (args[i].equals("-file")) {
                file = true;
                continue;
            }
            if (args[i].equals("-silent")) {
                silent = true;
                continue;
            }
            if (args[i].equals("-force")) {
                force_generated_calls = true;
                continue;
            }
            if (args[i].equals("-jme")) {
                use_jme = true;
                continue;
            }
            if (args[i].equals("-package")) {
                pack = args[i + 1];
                ++i;
                continue;
            }
            IOGenerator.usage();
        }
        Vector<String> newArgs = new Vector<String>();
        for (int i = 0; i < files.size(); ++i) {
            int index;
            String name = (String)files.elementAt(i);
            int colon = name.indexOf(58);
            if (colon != -1) {
                name = name.substring(colon + 1);
            }
            if ((index = name.lastIndexOf(".class")) != -1) {
                name = name.substring(0, index);
                name = name.replace(File.separatorChar, '.');
                if (pack == null) {
                    newArgs.add(name);
                    continue;
                }
                newArgs.add(pack + "." + name);
                continue;
            }
            File f = new File(name);
            name = name.replace(File.separatorChar, '.');
            if (f.isDirectory()) {
                IOGenerator.processDirectory(f, newArgs, name);
                continue;
            }
            if (pack == null) {
                newArgs.add(name);
                continue;
            }
            newArgs.add(pack + "." + name);
        }
        new IOGenerator(verbose, local, file, force_generated_calls, silent, use_jme).scanClass(newArgs);
    }

    private static void processDirectory(File f, Vector<String> args, String name) {
        File[] list = f.listFiles();
        String prefix = "";
        if (!name.equals(".")) {
            prefix = name + ".";
        }
        for (int i = 0; i < list.length; ++i) {
            String fname = list[i].getName();
            if (list[i].isDirectory()) {
                IOGenerator.processDirectory(list[i], args, prefix + fname);
                continue;
            }
            int index = fname.lastIndexOf(".class");
            if (index == -1) continue;
            args.add(prefix + fname.substring(0, index));
        }
    }
}

