/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.AlternativeTypeInfo;
import ibis.io.Constants;
import ibis.io.DataOutputStream;
import ibis.io.DataSerializationOutputStream;
import ibis.io.HandleHash;
import ibis.io.IOProperties;
import ibis.io.IbisHash;
import ibis.io.IbisIllegalAccessException;
import ibis.io.IbisNotSerializableException;
import ibis.io.Replacer;
import ibis.io.Serializable;
import ibis.io.SerializationError;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbisSerializationOutputStream
extends DataSerializationOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(IbisSerializationOutputStream.class);
    private static final boolean DEBUG = IOProperties.DEBUG;
    private static final boolean TIME_IBIS_SERIALIZATION = IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.ibis");
    private static final boolean STATS_OBJECTS = IOProperties.properties.getBooleanProperty("ibis.io.stats.written");
    static Hashtable<Class<?>, Integer> statSendObjects;
    static final int[] statArrayCount;
    static int statObjectHandle;
    static final int[] statArrayHandle;
    static final long[] statArrayLength;
    public Replacer replacer;
    int next_handle;
    private HandleHash references = new HandleHash(2048);
    private boolean resetPending = false;
    private boolean clearPending = false;
    private int next_type;
    private IbisHash types = new IbisHash();
    Object current_object;
    int current_level;
    Object current_putfield;
    private Object[] object_stack;
    private int[] level_stack;
    private Object[] putfield_stack;
    private int max_stack_size = 0;
    private int stack_size = 0;
    private Class<?> lastClass;
    private int lastTypeno;
    private JavaObjectOutputStream objectStream = null;

    public IbisSerializationOutputStream(DataOutputStream out) throws IOException {
        super(out);
        this.types_clear();
        this.next_type = 9;
        this.next_handle = 2;
    }

    protected IbisSerializationOutputStream() throws IOException {
        this.types_clear();
        this.next_type = 9;
        this.next_handle = 2;
    }

    static String primitiveName(int i) {
        switch (i) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "char";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
        }
        return null;
    }

    static int primitiveBytes(int i) {
        switch (i) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return 0;
    }

    private static int arrayClassType(Class<?> arrayClass) {
        if (arrayClass == Constants.classByteArray) {
            return 2;
        }
        if (arrayClass == Constants.classIntArray) {
            return 5;
        }
        if (arrayClass == Constants.classBooleanArray) {
            return 1;
        }
        if (arrayClass == Constants.classDoubleArray) {
            return 8;
        }
        if (arrayClass == Constants.classCharArray) {
            return 3;
        }
        if (arrayClass == Constants.classShortArray) {
            return 4;
        }
        if (arrayClass == Constants.classLongArray) {
            return 6;
        }
        if (arrayClass == Constants.classFloatArray) {
            return 7;
        }
        return -1;
    }

    @Override
    public boolean reInitOnNewConnection() {
        return true;
    }

    @Override
    public void setReplacer(Replacer replacer) throws IOException {
        this.replacer = replacer;
    }

    @Override
    public String serializationImplName() {
        return "ibis";
    }

    @Override
    public void statistics() {
    }

    private void types_clear() {
        this.lastClass = null;
        this.types.clear();
        this.types.put(Constants.classBooleanArray, -2147483647);
        this.types.put(Constants.classByteArray, -2147483646);
        this.types.put(Constants.classCharArray, -2147483645);
        this.types.put(Constants.classShortArray, -2147483644);
        this.types.put(Constants.classIntArray, -2147483643);
        this.types.put(Constants.classLongArray, -2147483642);
        this.types.put(Constants.classFloatArray, -2147483641);
        this.types.put(Constants.classDoubleArray, -2147483640);
        this.next_type = 9;
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    @Override
    public void reset(boolean cleartypes) {
        if (cleartypes || this.next_handle > 2) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("reset: next handle = " + this.next_handle + ".");
            }
            this.references.clear();
            if (cleartypes) {
                this.clearPending = true;
            } else {
                this.resetPending = true;
            }
            this.next_handle = 2;
        }
        if (cleartypes) {
            this.types_clear();
        }
    }

    public void writeClass(Class<?> ref) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (ref == null) {
            this.writeHandle(0);
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return;
        }
        int hashCode = HandleHash.getHashCode(ref);
        int handle = this.references.find(ref, hashCode);
        if (handle == 0) {
            this.assignHandle(ref, hashCode);
            this.writeType(Class.class);
            this.writeUTF(ref.getName());
        } else {
            this.writeHandle(handle);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    void writeHandle(int v) throws IOException {
        if (this.clearPending) {
            this.writeInt(-1);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("wrote a CLEAR");
            }
            this.resetPending = false;
            this.clearPending = false;
        } else if (this.resetPending) {
            this.writeInt(1);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("wrote a RESET");
            }
            this.resetPending = false;
        }
        this.writeInt(v);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote handle " + v);
        }
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classBooleanArray, len, false)) {
            this.writeArrayBoolean(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classByteArray, len, false)) {
            this.writeArrayByte(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(value, Constants.classByteArray, len = value.limit() - value.position(), false)) {
            this.internalWriteByteBuffer(value);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classShortArray, len, false)) {
            this.writeArrayShort(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classCharArray, len, false)) {
            this.writeArrayChar(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classIntArray, len, false)) {
            this.writeArrayInt(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classLongArray, len, false)) {
            this.writeArrayLong(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classFloatArray, len, false)) {
            this.writeArrayFloat(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, Constants.classDoubleArray, len, false)) {
            this.writeArrayDouble(ref, off, len);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(Object[] ref, int off, int len) throws IOException {
        Class<?> clazz;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (this.writeArrayHeader(ref, clazz = ref.getClass(), len, false)) {
            for (int i = off; i < off + len; ++i) {
                this.doWriteObject(ref[i]);
            }
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    private boolean writeTypeHandle(Object ref, Class<?> clazz) throws IOException {
        int handle = this.references.lazyPut(ref, this.next_handle);
        if (handle != this.next_handle) {
            this.writeHandle(handle);
            return true;
        }
        this.writeType(clazz);
        ++this.next_handle;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeTypeHandle: references[" + handle + "] = " + (ref == null ? "null" : ref));
        }
        return false;
    }

    private boolean writeArrayHeader(Object ref, Class<?> clazz, int len, boolean doCycleCheck) throws IOException {
        if (ref == null) {
            this.writeHandle(0);
            return false;
        }
        if (doCycleCheck) {
            if (this.writeTypeHandle(ref, clazz)) {
                return false;
            }
        } else {
            this.writeType(clazz);
        }
        this.writeInt(len);
        IbisSerializationOutputStream.addStatSendArrayHandle(ref, len);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArrayHeader " + clazz.getName() + " length = " + len);
        }
        return true;
    }

    void writeArray(Object ref, Class<?> arrayClass, boolean unshared) throws IOException {
        String s = arrayClass.getName();
        switch (s.charAt(1)) {
            case 'B': {
                byte[] a = (byte[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayByte(a, 0, len);
                break;
            }
            case 'I': {
                int[] a = (int[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayInt(a, 0, len);
                break;
            }
            case 'Z': {
                boolean[] a = (boolean[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayBoolean(a, 0, len);
                break;
            }
            case 'D': {
                double[] a = (double[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayDouble(a, 0, len);
                break;
            }
            case 'C': {
                char[] a = (char[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayChar(a, 0, len);
                break;
            }
            case 'S': {
                short[] a = (short[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayShort(a, 0, len);
                break;
            }
            case 'J': {
                long[] a = (long[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayLong(a, 0, len);
                break;
            }
            case 'F': {
                float[] a = (float[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                this.writeArrayFloat(a, 0, len);
                break;
            }
            default: {
                Object[] a = (Object[])ref;
                int len = a.length;
                if (!this.writeArrayHeader(a, arrayClass, len, !unshared)) break;
                for (int i = 0; i < len; ++i) {
                    this.doWriteObject(a[i]);
                }
            }
        }
    }

    private int newType(Class<?> clazz) {
        int type_number = this.next_type++;
        this.types.put(clazz, type_number |= Integer.MIN_VALUE);
        return type_number;
    }

    void writeType(Class<?> clazz) throws IOException {
        int type_number;
        if (clazz == this.lastClass) {
            type_number = this.lastTypeno;
        } else {
            type_number = this.types.find(clazz);
            this.lastClass = clazz;
            this.lastTypeno = type_number;
        }
        if (type_number != 0) {
            this.writeHandle(type_number);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("wrote type number 0x" + Integer.toHexString(type_number));
            }
            return;
        }
        this.lastTypeno = type_number = this.newType(clazz);
        this.lastClass = clazz;
        this.writeHandle(type_number);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote NEW type number 0x" + Integer.toHexString(type_number) + " type " + clazz.getName());
        }
        this.writeUTF(clazz.getName());
    }

    public int writeKnownObjectHeader(Object ref) throws IOException {
        if (ref == null) {
            this.writeHandle(0);
            return 0;
        }
        int handle = this.references.lazyPut(ref, this.next_handle);
        if (handle == this.next_handle) {
            Class<?> clazz = ref.getClass();
            ++this.next_handle;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeKnownObjectHeader -> writing NEW object, class = " + clazz.getName());
            }
            this.writeType(clazz);
            return 1;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeKnownObjectHeader -> writing OLD HANDLE " + handle);
        }
        this.writeHandle(handle);
        return -1;
    }

    public int writeKnownArrayHeader(Object ref, int typehandle) throws IOException {
        if (ref == null) {
            this.writeHandle(0);
            return 0;
        }
        int handle = this.references.lazyPut(ref, this.next_handle);
        if (handle == this.next_handle) {
            ++this.next_handle;
            this.writeInt(typehandle | Integer.MIN_VALUE);
            return 1;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeKnownObjectHeader -> writing OLD HANDLE " + handle);
        }
        this.writeHandle(handle);
        return -1;
    }

    void alternativeDefaultWriteObject(AlternativeTypeInfo t, Object ref) throws IOException, IllegalAccessException {
        int i;
        int temp = 0;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("alternativeDefaultWriteObject, class = " + t.clazz.getName());
        }
        for (i = 0; i < t.double_count; ++i) {
            this.writeDouble(t.serializable_fields[temp++].getDouble(ref));
        }
        for (i = 0; i < t.long_count; ++i) {
            this.writeLong(t.serializable_fields[temp++].getLong(ref));
        }
        for (i = 0; i < t.float_count; ++i) {
            this.writeFloat(t.serializable_fields[temp++].getFloat(ref));
        }
        for (i = 0; i < t.int_count; ++i) {
            this.writeInt(t.serializable_fields[temp++].getInt(ref));
        }
        for (i = 0; i < t.short_count; ++i) {
            this.writeShort(t.serializable_fields[temp++].getShort(ref));
        }
        for (i = 0; i < t.char_count; ++i) {
            this.writeChar(t.serializable_fields[temp++].getChar(ref));
        }
        for (i = 0; i < t.byte_count; ++i) {
            this.writeByte(t.serializable_fields[temp++].getByte(ref));
        }
        for (i = 0; i < t.boolean_count; ++i) {
            this.writeBoolean(t.serializable_fields[temp++].getBoolean(ref));
        }
        for (i = 0; i < t.reference_count; ++i) {
            this.doWriteObject(t.serializable_fields[temp++].get(ref));
        }
    }

    void alternativeWriteObject(AlternativeTypeInfo t, Object ref) throws IOException, IllegalAccessException {
        if (t.superSerializable) {
            this.alternativeWriteObject(t.alternativeSuperInfo, ref);
        }
        if (t.hasWriteObject) {
            this.current_level = t.level;
            try {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("invoking writeObject() of class " + t.clazz.getName());
                }
                t.invokeWriteObject(ref, this.getJavaObjectOutputStream());
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("done with writeObject() of class " + t.clazz.getName());
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("Caught exception", (Throwable)e);
                }
                if ((cause = e.getTargetException()) instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("now rethrow as IllegalAccessException ...");
                }
                throw new IbisIllegalAccessException("writeObject method", e);
            }
            return;
        }
        this.alternativeDefaultWriteObject(t, ref);
    }

    public void push_current_object(Object ref, int level) {
        if (this.stack_size >= this.max_stack_size) {
            this.max_stack_size = 2 * this.max_stack_size + 10;
            Object[] new_o_stack = new Object[this.max_stack_size];
            int[] new_l_stack = new int[this.max_stack_size];
            Object[] new_p_stack = new Object[this.max_stack_size];
            for (int i = 0; i < this.stack_size; ++i) {
                new_o_stack[i] = this.object_stack[i];
                new_l_stack[i] = this.level_stack[i];
                new_p_stack[i] = this.putfield_stack[i];
            }
            this.object_stack = new_o_stack;
            this.level_stack = new_l_stack;
            this.putfield_stack = new_p_stack;
        }
        this.object_stack[this.stack_size] = this.current_object;
        this.level_stack[this.stack_size] = this.current_level;
        this.putfield_stack[this.stack_size] = this.current_putfield;
        ++this.stack_size;
        this.current_object = ref;
        this.current_level = level;
        this.current_putfield = null;
    }

    public void pop_current_object() {
        --this.stack_size;
        this.current_object = this.object_stack[this.stack_size];
        this.current_level = this.level_stack[this.stack_size];
        this.current_putfield = this.putfield_stack[this.stack_size];
        this.object_stack[this.stack_size] = null;
        this.putfield_stack[this.stack_size] = null;
    }

    public void writeSerializableObject(Object ref, String classname) throws IOException {
        AlternativeTypeInfo t;
        try {
            t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationError("Internal error", e);
        }
        try {
            this.push_current_object(ref, 0);
            this.alternativeWriteObject(t, ref);
            this.pop_current_object();
        }
        catch (IllegalAccessException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
            }
            throw new IbisNotSerializableException("Serializable failed for : " + classname, e);
        }
    }

    @Override
    public void writeString(String ref) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (ref == null) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeString: --> null");
            }
            this.writeHandle(0);
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return;
        }
        int handle = this.references.lazyPut(ref, this.next_handle);
        if (handle == this.next_handle) {
            ++this.next_handle;
            this.writeType(String.class);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeString: " + ref);
            }
            this.writeUTF(ref);
        } else {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeString: duplicate handle " + handle + " string = " + ref);
            }
            this.writeHandle(handle);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    static void addStatSendObject(Object ref) {
        if (STATS_OBJECTS) {
            Class<?> clazz = ref.getClass();
            Integer n = statSendObjects.get(clazz);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            statSendObjects.put(clazz, n);
        }
    }

    private static void addStatSendObjectHandle(Object ref) {
        if (STATS_OBJECTS) {
            ++statObjectHandle;
        }
    }

    @Override
    void addStatSendArray(Object ref, int type, int len) {
        if (STATS_OBJECTS) {
            IbisSerializationOutputStream.addStatSendObject(ref);
            int n = type;
            statArrayCount[n] = statArrayCount[n] + 1;
            int n2 = type;
            statArrayLength[n2] = statArrayLength[n2] + (long)len;
        }
    }

    private static void addStatSendArrayHandle(Object ref, int len) {
        if (STATS_OBJECTS) {
            Class<?> arrayClass = ref.getClass();
            int type = IbisSerializationOutputStream.arrayClassType(arrayClass);
            if (type == -1) {
                ++statObjectHandle;
            } else {
                int n = type;
                statArrayHandle[n] = statArrayHandle[n] + 1;
            }
        }
    }

    @Override
    public void writeObject(Object ref) throws IOException {
        this.doWriteObject(ref);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.replacer = null;
        this.references = null;
        this.types = null;
        this.current_object = null;
        this.current_putfield = null;
        this.object_stack = null;
        this.level_stack = null;
        this.putfield_stack = null;
        this.lastClass = null;
    }

    void assignHandle(Object ref, int hashCode) {
        int handle = this.next_handle++;
        this.references.put(ref, handle, hashCode);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("assignHandle: references[" + handle + "] = " + ref);
        }
    }

    void doWriteObject(Object ref) throws IOException {
        int hashCode;
        int handle;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if (ref == null) {
            this.writeHandle(0);
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return;
        }
        if (this.replacer != null) {
            ref = this.replacer.replace(ref);
        }
        if ((handle = this.references.find(ref, hashCode = HandleHash.getHashCode(ref))) == 0) {
            Class<?> clazz = ref.getClass();
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("start writeObject of class " + clazz.getName() + " handle = " + this.next_handle);
            }
            t.writer.writeObject(this, ref, t, hashCode, false);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("finished writeObject of class " + clazz.getName());
            }
        } else {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeObject: duplicate handle " + handle + " class = " + ref.getClass());
            }
            this.writeHandle(handle);
            IbisSerializationOutputStream.addStatSendObjectHandle(ref);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    public void defaultWriteSerializableObject(Object ref, int depth) throws IOException {
        Class<?> clazz = ref.getClass();
        AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
        while (t.level > depth) {
            t = t.alternativeSuperInfo;
        }
        try {
            this.alternativeDefaultWriteObject(t, ref);
        }
        catch (IllegalAccessException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
            }
            throw new IbisNotSerializableException("illegal access", e);
        }
    }

    public ObjectOutputStream getJavaObjectOutputStream() throws IOException {
        if (this.objectStream == null) {
            this.objectStream = new JavaObjectOutputStream(this);
        }
        return this.objectStream;
    }

    static {
        if (STATS_OBJECTS) {
            Runtime.getRuntime().addShutdownHook(new Thread("IbisSerializationOutputStream ShutdownHook"){

                @Override
                public void run() {
                    System.out.print("Serializable objects sent: ");
                    System.out.println(statSendObjects);
                    System.out.println("Non-array handles sent " + statObjectHandle);
                    for (int i = 1; i < 9; ++i) {
                        if (statArrayCount[i] + statArrayHandle[i] <= 0) continue;
                        System.out.println("       " + IbisSerializationOutputStream.primitiveName(i) + " arrays " + statArrayCount[i] + " total bytes " + statArrayLength[i] * (long)IbisSerializationOutputStream.primitiveBytes(i) + " handles " + statArrayHandle[i]);
                    }
                }
            });
            System.out.println("IbisSerializationOutputStream.STATS_OBJECTS enabled");
            statSendObjects = new Hashtable();
            statArrayCount = new int[9];
            statArrayHandle = new int[9];
            statArrayLength = new long[9];
        } else {
            statSendObjects = null;
            statArrayCount = null;
            statArrayLength = null;
            statArrayHandle = null;
        }
    }

    private class JavaObjectOutputStream
    extends ObjectOutputStream {
        IbisSerializationOutputStream ibisStream;

        JavaObjectOutputStream(IbisSerializationOutputStream s) throws IOException {
            this.ibisStream = s;
        }

        @Override
        public void writeObjectOverride(Object ref) throws IOException {
            this.ibisStream.doWriteObject(ref);
        }

        @Override
        public void defaultWriteObject() throws IOException, NotActiveException {
            if (IbisSerializationOutputStream.this.current_object == null) {
                throw new NotActiveException("defaultWriteObject: no object");
            }
            Object ref = IbisSerializationOutputStream.this.current_object;
            Class<?> clazz = ref.getClass();
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
            if (t.isIbisSerializable) {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("generated_DefaultWriteObject, class = " + clazz.getName() + ", level = " + IbisSerializationOutputStream.this.current_level);
                }
                ((Serializable)ref).generated_DefaultWriteObject(this.ibisStream, IbisSerializationOutputStream.this.current_level);
            } else if (ref instanceof java.io.Serializable) {
                while (t.level > IbisSerializationOutputStream.this.current_level) {
                    t = t.alternativeSuperInfo;
                }
                try {
                    IbisSerializationOutputStream.this.alternativeDefaultWriteObject(t, ref);
                }
                catch (IllegalAccessException e) {
                    if (DEBUG && logger.isDebugEnabled()) {
                        logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
                    }
                    throw new IbisNotSerializableException("illegal access", e);
                }
            } else {
                throw new IbisNotSerializableException("Not Serializable : " + clazz.getName());
            }
        }

        @Override
        public void writeUnshared(Object ref) throws IOException {
            if (ref == null) {
                this.ibisStream.writeHandle(0);
                return;
            }
            Class<?> clazz = ref.getClass();
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("start writeUnshared of class " + clazz.getName() + " handle = " + IbisSerializationOutputStream.this.next_handle);
            }
            t.writer.writeObject(this.ibisStream, ref, t, 0, true);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("finished writeUnshared of class " + clazz.getName() + " handle = " + IbisSerializationOutputStream.this.next_handle);
            }
        }

        @Override
        public void useProtocolVersion(int version) {
        }

        @Override
        protected void writeStreamHeader() {
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            Class<?> cl = desc.forClass();
            if (cl == null) {
                this.ibisStream.writeHandle(0);
                return;
            }
            this.ibisStream.writeClass(cl);
        }

        @Override
        public void writeFields() throws IOException {
            if (IbisSerializationOutputStream.this.current_putfield == null) {
                throw new NotActiveException("no PutField object");
            }
            ((ImplPutField)IbisSerializationOutputStream.this.current_putfield).writeFields();
        }

        @Override
        public ObjectOutputStream.PutField putFields() throws IOException {
            if (IbisSerializationOutputStream.this.current_putfield == null) {
                if (IbisSerializationOutputStream.this.current_object == null) {
                    throw new NotActiveException("not in writeObject");
                }
                Class<?> clazz = IbisSerializationOutputStream.this.current_object.getClass();
                AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
                while (t.level > IbisSerializationOutputStream.this.current_level) {
                    t = t.alternativeSuperInfo;
                }
                IbisSerializationOutputStream.this.current_putfield = new ImplPutField(t);
            }
            return (ImplPutField)IbisSerializationOutputStream.this.current_putfield;
        }

        @Override
        public void writeBytes(String s) throws IOException {
            if (TIME_IBIS_SERIALIZATION) {
                IbisSerializationOutputStream.this.timer.start();
            }
            if (s != null) {
                byte[] bytes = s.getBytes();
                int len = bytes.length;
                this.ibisStream.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.ibisStream.writeByte(bytes[i]);
                }
            }
            if (TIME_IBIS_SERIALIZATION) {
                IbisSerializationOutputStream.this.timer.stop();
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            if (TIME_IBIS_SERIALIZATION) {
                IbisSerializationOutputStream.this.timer.start();
            }
            if (s != null) {
                int len = s.length();
                this.ibisStream.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    this.ibisStream.writeChar(s.charAt(i));
                }
            }
            if (TIME_IBIS_SERIALIZATION) {
                IbisSerializationOutputStream.this.timer.stop();
            }
        }

        @Override
        public void close() throws IOException {
            this.ibisStream.close();
        }

        @Override
        public void reset() throws IOException {
            this.ibisStream.reset();
        }

        @Override
        public void flush() throws IOException {
            this.ibisStream.flush();
        }

        @Override
        protected void drain() throws IOException {
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.ibisStream.writeArray(buf, off, len);
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.ibisStream.writeArray(buf);
        }

        @Override
        public void write(int val) throws IOException {
            this.ibisStream.writeByte((byte)val);
        }

        @Override
        public void writeBoolean(boolean val) throws IOException {
            this.ibisStream.writeBoolean(val);
        }

        @Override
        public void writeByte(int val) throws IOException {
            this.ibisStream.writeByte((byte)val);
        }

        @Override
        public void writeShort(int val) throws IOException {
            this.ibisStream.writeShort((short)val);
        }

        @Override
        public void writeChar(int val) throws IOException {
            this.ibisStream.writeChar((char)val);
        }

        @Override
        public void writeInt(int val) throws IOException {
            this.ibisStream.writeInt(val);
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.ibisStream.writeLong(val);
        }

        @Override
        public void writeFloat(float val) throws IOException {
            this.ibisStream.writeFloat(val);
        }

        @Override
        public void writeDouble(double val) throws IOException {
            this.ibisStream.writeDouble(val);
        }

        @Override
        public void writeUTF(String val) throws IOException {
            this.ibisStream.writeUTF(val);
        }

        private class ImplPutField
        extends ObjectOutputStream.PutField {
            private double[] doubles;
            private long[] longs;
            private int[] ints;
            private float[] floats;
            private short[] shorts;
            private char[] chars;
            private byte[] bytes;
            private boolean[] booleans;
            private Object[] refs;
            private AlternativeTypeInfo t;

            ImplPutField(AlternativeTypeInfo t) {
                this.doubles = new double[t.double_count];
                this.longs = new long[t.long_count];
                this.ints = new int[t.int_count];
                this.shorts = new short[t.short_count];
                this.floats = new float[t.float_count];
                this.chars = new char[t.char_count];
                this.bytes = new byte[t.byte_count];
                this.booleans = new boolean[t.boolean_count];
                this.refs = new Object[t.reference_count];
                this.t = t;
            }

            @Override
            public void put(String name, boolean value) throws IllegalArgumentException {
                this.booleans[this.t.getOffset((String)name, Boolean.TYPE)] = value;
            }

            @Override
            public void put(String name, char value) throws IllegalArgumentException {
                this.chars[this.t.getOffset((String)name, Character.TYPE)] = value;
            }

            @Override
            public void put(String name, byte value) throws IllegalArgumentException {
                this.bytes[this.t.getOffset((String)name, Byte.TYPE)] = value;
            }

            @Override
            public void put(String name, short value) throws IllegalArgumentException {
                this.shorts[this.t.getOffset((String)name, Short.TYPE)] = value;
            }

            @Override
            public void put(String name, int value) throws IllegalArgumentException {
                this.ints[this.t.getOffset((String)name, Integer.TYPE)] = value;
            }

            @Override
            public void put(String name, long value) throws IllegalArgumentException {
                this.longs[this.t.getOffset((String)name, Long.TYPE)] = value;
            }

            @Override
            public void put(String name, float value) throws IllegalArgumentException {
                this.floats[this.t.getOffset((String)name, Float.TYPE)] = value;
            }

            @Override
            public void put(String name, double value) throws IllegalArgumentException {
                this.doubles[this.t.getOffset((String)name, Double.TYPE)] = value;
            }

            @Override
            public void put(String name, Object value) {
                this.refs[this.t.getOffset((String)name, value.getClass())] = value;
            }

            @Override
            public void write(ObjectOutput o) throws IOException {
                int i;
                for (i = 0; i < this.t.double_count; ++i) {
                    o.writeDouble(this.doubles[i]);
                }
                for (i = 0; i < this.t.float_count; ++i) {
                    o.writeFloat(this.floats[i]);
                }
                for (i = 0; i < this.t.long_count; ++i) {
                    o.writeLong(this.longs[i]);
                }
                for (i = 0; i < this.t.int_count; ++i) {
                    o.writeInt(this.ints[i]);
                }
                for (i = 0; i < this.t.short_count; ++i) {
                    o.writeShort(this.shorts[i]);
                }
                for (i = 0; i < this.t.char_count; ++i) {
                    o.writeChar(this.chars[i]);
                }
                for (i = 0; i < this.t.byte_count; ++i) {
                    o.writeByte(this.bytes[i]);
                }
                for (i = 0; i < this.t.boolean_count; ++i) {
                    o.writeBoolean(this.booleans[i]);
                }
                for (i = 0; i < this.t.reference_count; ++i) {
                    o.writeObject(this.refs[i]);
                }
            }

            void writeFields() throws IOException {
                int i;
                for (i = 0; i < this.t.double_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeDouble(this.doubles[i]);
                }
                for (i = 0; i < this.t.float_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeFloat(this.floats[i]);
                }
                for (i = 0; i < this.t.long_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeLong(this.longs[i]);
                }
                for (i = 0; i < this.t.int_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeInt(this.ints[i]);
                }
                for (i = 0; i < this.t.short_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeShort(this.shorts[i]);
                }
                for (i = 0; i < this.t.char_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeChar(this.chars[i]);
                }
                for (i = 0; i < this.t.byte_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeByte(this.bytes[i]);
                }
                for (i = 0; i < this.t.boolean_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeBoolean(this.booleans[i]);
                }
                for (i = 0; i < this.t.reference_count; ++i) {
                    JavaObjectOutputStream.this.ibisStream.writeObject(this.refs[i]);
                }
            }
        }
    }
}

