/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IbisIOException;
import ibis.io.JavaDependantStuff;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class DalvikJavaStuff
extends JavaDependantStuff {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    static Method newInstance = null;
    static Method setFieldBoolean = null;
    static Method setFieldByte = null;
    static Method setFieldShort = null;
    static Method setFieldInt = null;
    static Method setFieldLong = null;
    static Method setFieldChar = null;
    static Method setFieldFloat = null;
    static Method setFieldDouble = null;
    static Method setFieldObject = null;
    static boolean available = false;
    private Class<?> constructorClass = null;

    private static Method getMethod(Class<?> cl, String name, Class<?> ... params) throws NoSuchMethodException {
        Method m = cl.getDeclaredMethod(name, params);
        m.setAccessible(true);
        return m;
    }

    DalvikJavaStuff(Class<?> clazz) {
        super(clazz);
        if (!available) {
            throw new Error("DalvikJavaStuff not available");
        }
        this.constructorClass = clazz;
        while (this.constructorClass != null && Serializable.class.isAssignableFrom(this.constructorClass)) {
            this.constructorClass = this.constructorClass.getSuperclass();
        }
        Constructor<?> constructor = null;
        if (this.constructorClass != null) {
            try {
                constructor = this.constructorClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (constructor != null) {
            int constructorModifiers = constructor.getModifiers();
            if (Modifier.isPrivate(constructorModifiers)) {
                this.constructorClass = null;
            } else if (!(Modifier.isPublic(constructorModifiers) || Modifier.isProtected(constructorModifiers) || this.constructorClass.getPackage().getName().equals(clazz.getPackage().getName()))) {
                this.constructorClass = null;
            }
        }
    }

    @Override
    Object newInstance() {
        if (this.constructorClass == null) {
            return null;
        }
        try {
            return newInstance.invoke(null, this.clazz, this.constructorClass);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    void setFieldBoolean(Object ref, String fieldname, boolean d) throws IOException {
        try {
            setFieldBoolean.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldByte(Object ref, String fieldname, byte d) throws IOException {
        try {
            setFieldByte.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldChar(Object ref, String fieldname, char d) throws IOException {
        try {
            setFieldChar.invoke(null, ref, this.clazz, fieldname, Character.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldClass(Object ref, String fieldname, Class<?> d) throws IOException {
        try {
            setFieldObject.invoke(null, ref, this.clazz, fieldname, "Ljava.lang.Class;", d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldDouble(Object ref, String fieldname, double d) throws IOException {
        try {
            setFieldDouble.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldFloat(Object ref, String fieldname, float d) throws IOException {
        try {
            setFieldFloat.invoke(null, ref, this.clazz, fieldname, Float.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldInt(Object ref, String fieldname, int d) throws IOException {
        try {
            setFieldInt.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldLong(Object ref, String fieldname, long d) throws IOException {
        try {
            setFieldLong.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldObject(Object ref, String fieldname, Object d, String fieldsig) throws IOException {
        try {
            setFieldObject.invoke(null, ref, this.clazz, fieldname, fieldsig, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldShort(Object ref, String fieldname, short d) throws IOException {
        try {
            setFieldShort.invoke(null, ref, this.clazz, fieldname, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldString(Object ref, String fieldname, String d) throws IOException {
        try {
            setFieldObject.invoke(null, ref, this.clazz, fieldname, "Ljava.lang.String;", d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    static {
        try {
            newInstance = DalvikJavaStuff.getMethod(ObjectInputStream.class, "newInstance", Class.class, Class.class);
            setFieldBoolean = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Boolean.TYPE);
            setFieldByte = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Byte.TYPE);
            setFieldShort = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Short.TYPE);
            setFieldInt = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Integer.TYPE);
            setFieldLong = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Long.TYPE);
            setFieldChar = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Character.TYPE);
            setFieldFloat = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Float.TYPE);
            setFieldDouble = DalvikJavaStuff.getMethod(ObjectInputStream.class, "setField", Object.class, Class.class, String.class, Double.TYPE);
            setFieldObject = DalvikJavaStuff.getMethod(ObjectInputStream.class, "objSetField", Object.class, Class.class, String.class, String.class, Object.class);
            available = true;
        }
        catch (Throwable e) {
            logger.info("No Dalvik java stuff: got exception", e);
        }
    }
}

