/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IOProperties;
import ibis.io.SimpleBigConversion;
import ibis.io.SimpleLittleConversion;
import ibis.io.nio.HybridChunkBigConversion;
import ibis.io.nio.HybridChunkLittleConversion;
import ibis.io.nio.NioChunkBigConversion;
import ibis.io.nio.NioChunkLittleConversion;
import ibis.io.nio.NioWrapBigConversion;
import ibis.io.nio.NioWrapLittleConversion;
import ibis.util.TypedProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Conversion {
    public static final Conversion defaultConversion;
    private static final Conversion simpleBig;
    private static final Conversion simpleLittle;
    public static final int BITS_PER_BYTE = 8;
    public static final int BOOLEAN_SIZE = 1;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int BITS_PER_SHORT = 16;
    public static final int CHAR_SIZE = 2;
    public static final int BITS_PER_CHAR = 16;
    public static final int INT_SIZE = 4;
    public static final int BITS_PER_INT = 32;
    public static final int LONG_SIZE = 8;
    public static final int BITS_PER_LONG = 64;
    public static final int FLOAT_SIZE = 4;
    public static final int BITS_PER_FLOAT = 32;
    public static final int DOUBLE_SIZE = 8;
    public static final int BITS_PER_DOUBLE = 64;

    public static final Conversion loadConversion(String className) throws Exception {
        return (Conversion)Class.forName(className).newInstance();
    }

    public static final Conversion loadConversion(boolean bigEndian) {
        TypedProperties properties = IOProperties.properties;
        String conversion = properties.getProperty("ibis.io.conversion");
        if (conversion != null && conversion.equalsIgnoreCase("wrap")) {
            System.err.println("nio/wrap conversion selected");
            try {
                if (bigEndian) {
                    return new NioWrapBigConversion();
                }
                return new NioWrapLittleConversion();
            }
            catch (Exception e) {}
        } else if (conversion != null && conversion.equalsIgnoreCase("chunk")) {
            System.err.println("nio/chunk conversion selected");
            try {
                if (bigEndian) {
                    return new NioChunkBigConversion();
                }
                return new NioChunkLittleConversion();
            }
            catch (Exception e) {}
        } else if (conversion == null || conversion.equalsIgnoreCase("hybrid")) {
            if (conversion != null) {
                System.err.println("hybrid conversion selected");
            }
            try {
                if (bigEndian) {
                    return new HybridChunkBigConversion();
                }
                return new HybridChunkLittleConversion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.err.println("falling back to simple conversion");
        if (bigEndian) {
            return simpleBig;
        }
        return simpleLittle;
    }

    public abstract boolean bigEndian();

    public abstract byte boolean2byte(boolean var1);

    public abstract boolean byte2boolean(byte var1);

    public abstract void char2byte(char var1, byte[] var2, int var3);

    public abstract char byte2char(byte[] var1, int var2);

    public abstract void short2byte(short var1, byte[] var2, int var3);

    public abstract short byte2short(byte[] var1, int var2);

    public abstract void int2byte(int var1, byte[] var2, int var3);

    public abstract int byte2int(byte[] var1, int var2);

    public abstract void long2byte(long var1, byte[] var3, int var4);

    public abstract long byte2long(byte[] var1, int var2);

    public abstract void float2byte(float var1, byte[] var2, int var3);

    public abstract float byte2float(byte[] var1, int var2);

    public abstract void double2byte(double var1, byte[] var3, int var4);

    public abstract double byte2double(byte[] var1, int var2);

    public abstract void boolean2byte(boolean[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2boolean(byte[] var1, int var2, boolean[] var3, int var4, int var5);

    public abstract void char2byte(char[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2char(byte[] var1, int var2, char[] var3, int var4, int var5);

    public abstract void short2byte(short[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2short(byte[] var1, int var2, short[] var3, int var4, int var5);

    public abstract void int2byte(int[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2int(byte[] var1, int var2, int[] var3, int var4, int var5);

    public abstract void long2byte(long[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2long(byte[] var1, int var2, long[] var3, int var4, int var5);

    public abstract void float2byte(float[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2float(byte[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void double2byte(double[] var1, int var2, int var3, byte[] var4, int var5);

    public abstract void byte2double(byte[] var1, int var2, double[] var3, int var4, int var5);

    public static final byte[] object2byte(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        oos = null;
        return bos.toByteArray();
    }

    public static final Object byte2object(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static int align(int a, int d) {
        return a + d - 1 & ~(d - 1);
    }

    static {
        simpleBig = new SimpleBigConversion();
        simpleLittle = new SimpleLittleConversion();
        defaultConversion = simpleBig;
    }
}

