/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.Conversion;
import ibis.io.DataInputStream;
import ibis.io.IOProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedArrayInputStream
extends DataInputStream {
    private static final boolean DEBUG = IOProperties.DEBUG;
    private static final Logger logger = LoggerFactory.getLogger(BufferedArrayInputStream.class);
    private final int BUF_SIZE;
    private InputStream in;
    private byte[] buffer;
    private int index;
    private int buffered_bytes;
    private long bytes = 0L;
    private Conversion conversion;

    public BufferedArrayInputStream(InputStream in, int bufSize) {
        this.in = in;
        this.BUF_SIZE = bufSize;
        this.buffer = new byte[this.BUF_SIZE];
        this.conversion = Conversion.loadConversion(false);
    }

    public BufferedArrayInputStream(InputStream in) {
        this(in, IOProperties.BUFFER_SIZE);
    }

    @Override
    public long bytesRead() {
        return this.bytes - (long)this.buffered_bytes;
    }

    @Override
    public void resetBytesRead() {
        this.bytes = this.buffered_bytes;
    }

    private static final int min(int a, int b) {
        return a > b ? b : a;
    }

    @Override
    public final int read() throws IOException {
        try {
            byte b = this.readByte();
            return b & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    private final void fillBuffer(int len) throws IOException {
        if (this.buffered_bytes >= len) {
            return;
        }
        if (this.buffered_bytes == 0) {
            this.index = 0;
        } else if (this.index + this.buffered_bytes > this.BUF_SIZE - len) {
            System.arraycopy(this.buffer, this.index, this.buffer, 0, this.buffered_bytes);
            this.index = 0;
        }
        while (this.buffered_bytes < len) {
            int n = this.in.read(this.buffer, this.index + this.buffered_bytes, this.BUF_SIZE - (this.index + this.buffered_bytes));
            if (n < 0) {
                throw new EOFException("EOF encountered");
            }
            this.bytes += (long)n;
            this.buffered_bytes += n;
        }
    }

    @Override
    public final int available() throws IOException {
        return this.buffered_bytes + this.in.available();
    }

    @Override
    public void readArray(boolean[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 1;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 1;
            this.conversion.byte2boolean(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 1;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2boolean(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(byte[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(byte[" + off + " ... " + (off + len) + "])");
        }
        if (this.buffered_bytes >= len) {
            System.arraycopy(this.buffer, this.index, a, off, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            int n;
            if (this.buffered_bytes != 0) {
                System.arraycopy(this.buffer, this.index, a, off, this.buffered_bytes);
            }
            int rd = this.buffered_bytes;
            this.index = 0;
            do {
                if ((n = this.in.read(a, off + rd, len - rd)) < 0) {
                    throw new EOFException("EOF encountered");
                }
                this.bytes += (long)n;
            } while ((rd += n) < len);
            this.buffered_bytes = 0;
        }
    }

    @Override
    public void readArray(short[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(char[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 2;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 2;
            this.conversion.byte2short(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 2;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2short(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(char[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(char[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 2;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 2;
            this.conversion.byte2char(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 2;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2char(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(int[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(int[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 4;
            this.conversion.byte2int(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 4;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2int(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(long[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(long[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 8;
            this.conversion.byte2long(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 8;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2long(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(float[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(float[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 4;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 4;
            this.conversion.byte2float(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 4;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2float(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public void readArray(double[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArray(double[" + off + " ... " + (off + len) + "])");
        }
        int to_convert = len * 8;
        while (this.buffered_bytes < to_convert) {
            if (this.buffered_bytes == 0) {
                this.index = 0;
                this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
                continue;
            }
            int useable = this.buffered_bytes / 8;
            this.conversion.byte2double(this.buffer, this.index, a, off, useable);
            len -= useable;
            off += useable;
            int converted = useable * 8;
            this.index += converted;
            this.buffered_bytes -= converted;
            to_convert -= converted;
            for (int i = 0; i < this.buffered_bytes; ++i) {
                this.buffer[i] = this.buffer[this.index + i];
            }
            this.index = 0;
            this.fillBuffer(BufferedArrayInputStream.min(this.BUF_SIZE, to_convert));
        }
        this.conversion.byte2double(this.buffer, this.index, a, off, len);
        this.buffered_bytes -= to_convert;
        this.index += to_convert;
    }

    @Override
    public byte readByte() throws IOException {
        this.fillBuffer(1);
        --this.buffered_bytes;
        return this.buffer[this.index++];
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.fillBuffer(1);
        --this.buffered_bytes;
        return this.conversion.byte2boolean(this.buffer[this.index++]);
    }

    @Override
    public char readChar() throws IOException {
        this.fillBuffer(2);
        char v = this.conversion.byte2char(this.buffer, this.index);
        this.index += 2;
        this.buffered_bytes -= 2;
        return v;
    }

    @Override
    public short readShort() throws IOException {
        this.fillBuffer(2);
        short v = this.conversion.byte2short(this.buffer, this.index);
        this.index += 2;
        this.buffered_bytes -= 2;
        return v;
    }

    @Override
    public int readInt() throws IOException {
        this.fillBuffer(4);
        int v = this.conversion.byte2int(this.buffer, this.index);
        this.index += 4;
        this.buffered_bytes -= 4;
        return v;
    }

    @Override
    public long readLong() throws IOException {
        this.fillBuffer(8);
        long v = this.conversion.byte2long(this.buffer, this.index);
        this.index += 8;
        this.buffered_bytes -= 8;
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        this.fillBuffer(4);
        float v = this.conversion.byte2float(this.buffer, this.index);
        this.index += 4;
        this.buffered_bytes -= 4;
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        this.fillBuffer(8);
        double v = this.conversion.byte2double(this.buffer, this.index);
        this.index += 8;
        this.buffered_bytes -= 8;
        return v;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] a, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read(byte[" + off + " ... " + (off + len) + "])");
        }
        if (this.buffered_bytes >= len) {
            System.arraycopy(this.buffer, this.index, a, off, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            if (this.buffered_bytes != 0) {
                System.arraycopy(this.buffer, this.index, a, off, this.buffered_bytes);
            }
            int rd = this.buffered_bytes;
            this.index = 0;
            do {
                int n;
                if ((n = this.in.read(a, off + rd, len - rd)) < 0) {
                    len = rd;
                    continue;
                }
                rd += n;
                this.bytes += (long)n;
            } while (rd < len);
            this.buffered_bytes = 0;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int bufferSize() {
        return this.BUF_SIZE;
    }

    @Override
    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        int len = value.limit() - value.position();
        if (this.buffered_bytes >= len) {
            value.put(this.buffer, this.index, len);
            this.index += len;
            this.buffered_bytes -= len;
        } else {
            if (this.buffered_bytes != 0) {
                value.put(this.buffer, this.index, this.buffered_bytes);
                len -= this.buffered_bytes;
                this.buffered_bytes = 0;
            }
            this.index = 0;
            if (value.hasArray()) {
                this.in.read(value.array(), value.arrayOffset(), len);
                value.position(value.limit());
                this.bytes += (long)len;
            } else {
                int toread;
                do {
                    toread = Math.min(len, this.BUF_SIZE);
                    this.fillBuffer(toread);
                    toread = len < this.buffered_bytes ? len : this.buffered_bytes;
                    value.put(this.buffer, this.index, toread);
                    this.index += toread;
                    this.buffered_bytes -= toread;
                } while ((len -= toread) > 0);
            }
        }
    }
}

