/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ClassLister {
    private JarFile[] jarFiles;
    private ClassLoader ld = null;
    private static HashMap<String, ClassLister> listers = new HashMap();
    private static ClassLister classPathLister = null;

    private ClassLister(String dirList) {
        if (dirList != null) {
            this.readJarFiles(dirList);
        } else {
            this.readJarFiles();
        }
        URL[] urls = new URL[this.jarFiles.length];
        for (int i = 0; i < this.jarFiles.length; ++i) {
            try {
                File f = new File(this.jarFiles[i].getName());
                urls[i] = f.toURI().toURL();
                continue;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        this.ld = new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    public static synchronized ClassLister getClassLister(String dirList) {
        if (dirList == null) {
            if (classPathLister == null) {
                classPathLister = new ClassLister(null);
            }
            return classPathLister;
        }
        ClassLister lister = listers.get(dirList);
        if (lister == null) {
            lister = new ClassLister(dirList);
            listers.put(dirList, lister);
        }
        return lister;
    }

    protected void readJarFiles() {
        ArrayList<JarFile> jarList = new ArrayList<JarFile>();
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String jar = st.nextToken();
                File f = new File(jar);
                try {
                    JarFile jarFile = new JarFile(f, true);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null) continue;
                    manifest.getMainAttributes();
                    jarList.add(jarFile);
                }
                catch (IOException e) {}
            }
        }
        this.jarFiles = jarList.toArray(new JarFile[0]);
    }

    private void addJarFiles(String dir, ArrayList<JarFile> jarList) {
        File f = new File(dir);
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            try {
                JarFile jarFile = new JarFile(files[i], true);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) continue;
                manifest.getMainAttributes();
                jarList.add(jarFile);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected void readJarFiles(String dirList) {
        ArrayList<JarFile> jarList = new ArrayList<JarFile>();
        StringTokenizer st = new StringTokenizer(dirList, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String dir = st.nextToken();
            this.addJarFiles(dir, jarList);
        }
        this.jarFiles = jarList.toArray(new JarFile[0]);
    }

    public List<Class<?>> getClassList(String attribName) {
        ArrayList list = new ArrayList();
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < this.jarFiles.length; ++i) {
            Attributes ab;
            String names;
            Manifest mf = null;
            try {
                mf = this.jarFiles[i].getManifest();
            }
            catch (IOException e) {
                throw new Error("Could not get Manifest from " + this.jarFiles[i].getName(), e);
            }
            if (mf == null || (names = (ab = mf.getMainAttributes()).getValue(attribName)) == null) continue;
            StringTokenizer st = new StringTokenizer(names, ", ");
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                if (classNames.contains(className)) continue;
                try {
                    Class<?> cl = Class.forName(className, false, this.ld);
                    list.add(cl);
                    classNames.add(className);
                }
                catch (Exception e) {
                    throw new Error("Could not load class " + className + ". Something wrong with jar " + this.jarFiles[i].getName() + "?", e);
                }
            }
        }
        return list;
    }

    public List<Class<?>> getClassList(String attribName, Class<?> clazz) {
        List<Class<?>> list = this.getClassList(attribName);
        for (Class<?> cl : list) {
            if (clazz.isAssignableFrom(cl)) continue;
            throw new Error("Class " + cl.getName() + " cannot be assigned to class " + clazz.getName());
        }
        return list;
    }
}

