/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.DataInputStream;
import ibis.io.SerializationFactory;
import ibis.io.SerializationInput;
import ibis.ipl.impl.ReadMessage;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.SendPortIdentifier;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivePortConnectionInfo {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.ReceivePortConnectionInfo");
    public final SendPortIdentifier origin;
    public SerializationInput in;
    public final ReceivePort port;
    public ReadMessage message;
    public DataInputStream dataIn;
    protected boolean closed = false;
    private long cnt = 0L;

    public ReceivePortConnectionInfo(SendPortIdentifier origin, ReceivePort port, DataInputStream dataIn) throws IOException {
        this.origin = origin;
        this.port = port;
        this.dataIn = dataIn;
        port.addInfo(origin, this);
    }

    public long bytesRead() {
        long rd = this.dataIn.bytesRead();
        if (rd != 0L) {
            this.dataIn.resetBytesRead();
            this.port.addDataIn(rd);
            this.cnt += rd;
        }
        return this.cnt;
    }

    public void newStream() throws IOException {
        this.bytesRead();
        if (this.in != null) {
            this.in.close();
        }
        this.in = SerializationFactory.createSerializationInput((String)this.port.serialization, (DataInputStream)this.dataIn);
        this.message = this.port.createReadMessage(this.in, this);
    }

    public void close(Throwable e) {
        try {
            this.in.close();
        }
        catch (Throwable z) {
            // empty catch block
        }
        try {
            this.dataIn.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closed = true;
        this.in = null;
        if (logger.isDebugEnabled()) {
            logger.debug(this.port.name + ": connection with " + this.origin + " closing", e);
        }
        this.port.lostConnection(this.origin, e);
    }

    protected void upcallCalledFinish() {
        this.message = this.port.createReadMessage(this.in, this);
        if (logger.isDebugEnabled()) {
            logger.debug(this.port.name + ": new connection handler for " + this.origin + ", finish called from upcall");
        }
    }

    public String connectionType() {
        return "unknown";
    }
}

