/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.SerializationInput;
import ibis.ipl.ConnectionClosedException;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.Manageable;
import ibis.ipl.impl.ReceivePortConnectionInfo;
import ibis.ipl.impl.ReceivePortIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReceivePort
extends Manageable
implements ibis.ipl.ReceivePort {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.ReceivePort");
    public static final byte ACCEPTED = 0;
    public static final byte DENIED = 1;
    public static final byte DISABLED = 2;
    public static final byte ALREADY_CONNECTED = 3;
    public static final byte TYPE_MISMATCH = 4;
    public static final byte NOT_PRESENT = 5;
    public static final byte NO_MANY_TO_X = 6;
    static final Set<Thread> threadsInUpcallSet = Collections.synchronizedSet(new HashSet());
    public final PortType type;
    public final String name;
    private boolean connectionsEnabled = false;
    private boolean connectionDowncalls = false;
    public final ReceivePortIdentifier ident;
    private ArrayList<ibis.ipl.impl.SendPortIdentifier> lostConnections = new ArrayList();
    private ArrayList<ibis.ipl.impl.SendPortIdentifier> newConnections = new ArrayList();
    protected MessageUpcall upcall;
    protected ReceivePortConnectUpcall connectUpcall;
    protected HashMap<ibis.ipl.impl.SendPortIdentifier, ReceivePortConnectionInfo> connections = new HashMap();
    protected boolean allowUpcalls = false;
    protected Ibis ibis;
    protected final boolean numbered;
    protected final String serialization;
    protected boolean closed = false;
    protected ibis.ipl.impl.ReadMessage message = null;
    protected boolean delivered = false;
    protected final Properties properties;
    private long nMessages = 0L;
    private long messageBytes = 0L;
    private long bytes = 0L;
    private long nConnections = 0L;
    private long nLostConnections = 0L;
    private long nClosedConnections = 0L;
    private int outstanding;

    protected ReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connectUpcall, Properties properties) throws IOException {
        this.ibis = ibis;
        this.type = type;
        this.name = name;
        this.ident = ibis.createReceivePortIdentifier(name, ibis.ident);
        this.upcall = upcall;
        this.connectUpcall = connectUpcall;
        this.connectionDowncalls = type.hasCapability("connection.downcalls");
        this.numbered = type.hasCapability("communication.numbered");
        this.properties = ibis.properties();
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                this.properties.setProperty(key, value);
            }
        }
        this.serialization = type.hasCapability("serialization.data") ? "data" : (type.hasCapability("serialization.object.sun") ? "sun" : (type.hasCapability("serialization.object.ibis") ? "ibis" : (type.hasCapability("serialization.object") ? "object" : "byte")));
        ibis.register(this);
        if (logger.isDebugEnabled()) {
            logger.debug(ibis.ident + ": ReceivePort '" + name + "' created");
        }
        this.addValidKey("Messages");
        this.addValidKey("MessageBytes");
        this.addValidKey("Bytes");
        this.addValidKey("Connections");
        this.addValidKey("LostConnections");
        this.addValidKey("ClosedConnections");
    }

    protected ibis.ipl.impl.ReadMessage createReadMessage(SerializationInput in, ReceivePortConnectionInfo info) {
        return new ibis.ipl.impl.ReadMessage(in, info);
    }

    public synchronized void enableMessageUpcalls() {
        this.allowUpcalls = true;
        this.notifyAll();
    }

    public synchronized Map<IbisIdentifier, Set<String>> getConnectionTypes() {
        HashMap<IbisIdentifier, Set<String>> result = new HashMap<IbisIdentifier, Set<String>>();
        for (ibis.ipl.impl.SendPortIdentifier port : this.connections.keySet()) {
            ReceivePortConnectionInfo i = this.connections.get(port);
            if (i == null) continue;
            IbisIdentifier id = port.ibis;
            Set<String> s = result.get(id);
            if (s == null) {
                s = new HashSet<String>();
            }
            s.add(i.connectionType());
            result.put(id, s);
        }
        return result;
    }

    public static String getString(int result) {
        switch (result) {
            case 0: {
                return "ACCEPTED";
            }
            case 1: {
                return "DENIED";
            }
            case 6: {
                return "NO_MANYTOONE";
            }
            case 2: {
                return "DISABLED";
            }
            case 3: {
                return "ALREADY_CONNECTED";
            }
            case 4: {
                return "TYPE_MISMATCH";
            }
            case 5: {
                return "NOT_PRESENT";
            }
        }
        return "UNKNOWN";
    }

    public synchronized void disableMessageUpcalls() {
        this.allowUpcalls = false;
    }

    public synchronized SendPortIdentifier[] connectedTo() {
        return this.connections.keySet().toArray(new SendPortIdentifier[0]);
    }

    public PortType getPortType() {
        return this.type;
    }

    public synchronized SendPortIdentifier[] lostConnections() {
        if (!this.connectionDowncalls) {
            throw new IbisConfigurationException("ReceivePort.lostConnections() called but connectiondowncalls not configured");
        }
        SendPortIdentifier[] result = this.lostConnections.toArray(new SendPortIdentifier[0]);
        this.lostConnections.clear();
        return result;
    }

    public synchronized SendPortIdentifier[] newConnections() {
        if (!this.connectionDowncalls) {
            throw new IbisConfigurationException("ReceivePort.newConnections() called but connectiondowncalls not configured");
        }
        SendPortIdentifier[] result = this.newConnections.toArray(new SendPortIdentifier[0]);
        this.newConnections.clear();
        return result;
    }

    public String name() {
        return this.name;
    }

    public ibis.ipl.ReceivePortIdentifier identifier() {
        return this.ident;
    }

    public synchronized void enableConnections() {
        this.connectionsEnabled = true;
    }

    public synchronized void disableConnections() {
        this.connectionsEnabled = false;
    }

    public ibis.ipl.impl.ReadMessage receive() throws IOException {
        return this.receive(0L);
    }

    public ibis.ipl.impl.ReadMessage receive(long timeout) throws IOException {
        if (this.upcall != null) {
            throw new IbisConfigurationException("Configured Receiveport for upcalls, downcall not allowed");
        }
        if (timeout < 0L) {
            throw new IOException("timeout must be a non-negative number");
        }
        if (timeout > 0L && !this.type.hasCapability("receive.timeout")) {
            throw new IbisConfigurationException("This port is not configured for receive() with timeout");
        }
        return this.getMessage(timeout);
    }

    public final void close() throws IOException {
        this.close(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Receiveport " + this.name + ": closing");
        }
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            if (this.closed) {
                throw new IOException("Port already closed");
            }
            this.connectionsEnabled = false;
            this.closed = true;
            this.notifyAll();
        }
        this.closePort(timeout);
        this.ibis.deRegister(this);
    }

    public synchronized byte connectionAllowed(ibis.ipl.impl.SendPortIdentifier id, PortType sp) {
        int retval = 0;
        if (this.isConnectedTo(id)) {
            retval = 3;
        } else if (!sp.equals((Object)this.type)) {
            retval = 4;
        } else if (!this.connectionsEnabled) {
            retval = 2;
        } else if (!(this.outstanding == 0 && this.connections.size() == 0 || this.type.hasCapability("connection.manytoone") || this.type.hasCapability("connection.manytomany"))) {
            retval = 6;
        } else if (this.connectUpcall != null) {
            retval = 1;
            try {
                if (this.connectUpcall.gotConnection((ibis.ipl.ReceivePort)this, (SendPortIdentifier)id)) {
                    retval = 0;
                }
            }
            catch (Throwable e) {
                logger.error("Unexpected exception in gotConnection(), this Java instance will be terminated", e);
                System.exit(1);
            }
        }
        if (retval == 0 && this.connectionDowncalls) {
            this.newConnections.add(id);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Connection attempt from " + id + ": " + ReceivePort.getString(retval));
        }
        if (retval == 0) {
            ++this.outstanding;
        }
        return (byte)retval;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReceivePort) {
            ReceivePort other = (ReceivePort)obj;
            return this.name.equals(other.name);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return s.equals(this.name);
        }
        return false;
    }

    public synchronized boolean isConnectedTo(ibis.ipl.impl.SendPortIdentifier id) {
        return this.getInfo(id) != null;
    }

    public ibis.ipl.impl.ReadMessage poll() throws IOException {
        if (!this.type.hasCapability("receive.poll")) {
            throw new IbisConfigurationException("Receiveport not configured for polls");
        }
        return this.doPoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostConnection(ibis.ipl.impl.SendPortIdentifier id, Throwable e) {
        if (this.connectionDowncalls) {
            ReceivePort receivePort = this;
            synchronized (receivePort) {
                this.lostConnections.add(id);
            }
        }
        if (this.connectUpcall != null) {
            try {
                this.connectUpcall.lostConnection((ibis.ipl.ReceivePort)this, (SendPortIdentifier)id, e);
            }
            catch (Throwable e2) {
                logger.error("Unexpected exception in lostConnection(), this Java instance will be terminated", e2);
                System.exit(1);
            }
        }
        if (e != null) {
            ++this.nLostConnections;
        } else {
            ++this.nClosedConnections;
        }
        this.removeInfo(id);
    }

    public synchronized ReceivePortConnectionInfo getInfo(ibis.ipl.impl.SendPortIdentifier id) {
        return this.connections.get(id);
    }

    public synchronized void addInfo(ibis.ipl.impl.SendPortIdentifier id, ReceivePortConnectionInfo info) {
        ++this.nConnections;
        this.connections.put(id, info);
        --this.outstanding;
        this.notifyAll();
    }

    public synchronized ReceivePortConnectionInfo removeInfo(ibis.ipl.impl.SendPortIdentifier id) {
        ReceivePortConnectionInfo info = this.connections.remove(id);
        if (this.connections.size() == 0) {
            this.notifyAll();
        }
        return info;
    }

    public synchronized ReceivePortConnectionInfo[] connections() {
        return this.connections.values().toArray(new ReceivePortConnectionInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ibis.ipl.impl.ReadMessage getMessage(long timeout) throws IOException {
        long deadLine = System.currentTimeMillis() + timeout;
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            while ((this.message == null || this.delivered) && !this.closed) {
                try {
                    if (timeout > 0L) {
                        long time = System.currentTimeMillis();
                        if (time >= deadLine) {
                            throw new ReceiveTimedOutException("timeout expired in receive()");
                        }
                        time = deadLine - time;
                        this.wait(time);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.closed) continue;
                throw new ConnectionClosedException("receive() on closed port");
            }
            this.delivered = true;
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpcall(ibis.ipl.impl.ReadMessage msg) {
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            while (!this.allowUpcalls) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        msg.setInUpcall(true);
        try {
            threadsInUpcallSet.add(Thread.currentThread());
            this.upcall.upcall((ReadMessage)msg);
        }
        catch (IOException e) {
            if (!msg.isFinished()) {
                msg.finish(e);
                return;
            }
            logger.error("Got unexpected exception in upcall, continuing ...", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got exception from upcall", (Throwable)e);
            }
            if (!msg.isFinished()) {
                IOException ioex = new IOException("Got ClassNotFoundException: " + e.getMessage());
                ioex.initCause(e);
                msg.finish(ioex);
            }
            return;
        }
        catch (Throwable e) {
            logger.error("Got unexpected throwable in upcall(), this Java instance will be terminated", e);
            System.exit(1);
        }
        finally {
            msg.setInUpcall(false);
        }
        if (!msg.isFinished()) {
            try {
                msg.finish();
            }
            catch (IOException e) {
                msg.finish(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(ibis.ipl.impl.ReadMessage msg) {
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            while (this.message != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.message = msg;
            this.delivered = false;
            this.notifyAll();
        }
        if (this.upcall != null) {
            this.doUpcall(this.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMessage(ibis.ipl.impl.ReadMessage r, long cnt) {
        SendPortIdentifier[] ports;
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            ports = this.connectedTo();
            ++this.nMessages;
            this.messageBytes += cnt;
            this.message = null;
            threadsInUpcallSet.remove(Thread.currentThread());
            this.notifyAll();
        }
        this.ibis.addReceivedPerIbis(cnt, ports);
    }

    public synchronized void finishMessage(ibis.ipl.impl.ReadMessage r, IOException e) {
        r.getInfo().close(e);
        this.message = null;
        threadsInUpcallSet.remove(Thread.currentThread());
        this.notifyAll();
    }

    public synchronized void closePort(long timeout) {
        if (timeout == 0L) {
            while (this.connections.size() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        } else {
            long endTime = System.currentTimeMillis() + timeout;
            while (this.connections.size() > 0 && timeout > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeout = endTime - System.currentTimeMillis();
            }
            ReceivePortConnectionInfo[] conns = this.connections();
            for (int i = 0; i < conns.length; ++i) {
                conns[i].close(new IOException("receiver forcibly closed connection"));
            }
            this.nClosedConnections += (long)conns.length;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.name + ":done receiveport.close");
        }
    }

    protected synchronized void killConnectionsWith(ibis.ipl.IbisIdentifier id) {
        ibis.ipl.impl.SendPortIdentifier[] keys;
        for (ibis.ipl.impl.SendPortIdentifier s : keys = this.connections.keySet().toArray(new ibis.ipl.impl.SendPortIdentifier[this.connections.size()])) {
            if (!s.ibisIdentifier().equals(id)) continue;
            this.connections.get(s).close((Throwable)new ConnectionClosedException("Connection origin died or left"));
            this.removeInfo(s);
        }
    }

    @Override
    protected synchronized void updateProperties() {
        this.setProperty("Bytes", "" + this.bytes);
        this.setProperty("ClosedConnections", "" + this.nClosedConnections);
        this.setProperty("Connections", "" + this.nConnections);
        this.setProperty("Messages", "" + this.nMessages);
        this.setProperty("MessageBytes", "" + this.messageBytes);
        this.setProperty("LostConnections", "" + this.nLostConnections);
    }

    @Override
    protected void doProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.doProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void doProperty(String key, String value) {
        if (key.equals("Bytes")) {
            this.bytes = Long.parseLong(value);
        } else if (key.equals("ClosedConnections")) {
            this.nClosedConnections = Long.parseLong(value);
        } else if (key.equals("nConnections")) {
            this.nConnections = Long.parseLong(value);
        } else if (key.equals("Messages")) {
            this.nMessages = Long.parseLong(value);
        } else if (key.equals("MessageBytes")) {
            this.messageBytes = Long.parseLong(value);
        } else if (key.equals("LostConnections")) {
            this.nLostConnections = Long.parseLong(value);
        }
    }

    void addDataIn(long cnt) {
        this.bytes += cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ibis.ipl.impl.ReadMessage doPoll() throws IOException {
        Thread.yield();
        if (this.upcall != null) {
            return null;
        }
        ReceivePort receivePort = this;
        synchronized (receivePort) {
            if (this.message == null || this.delivered) {
                return null;
            }
            if (this.message != null) {
                this.delivered = true;
            }
            return this.message;
        }
    }

    synchronized long getMessageCount() {
        return this.nMessages;
    }

    synchronized long getBytesReceived() {
        return this.bytes;
    }

    synchronized long getBytesRead() {
        return this.messageBytes;
    }
}

