# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.instructions_dto import InstructionsDTO  # noqa: F401,E501
from xtrf_python_api.models.language_combination_dto import LanguageCombinationDTO  # noqa: F401,E501
from xtrf_python_api.models.people_dto import PeopleDTO  # noqa: F401,E501
from xtrf_python_api.models.project_dates_dto import ProjectDatesDTO  # noqa: F401,E501
from xtrf_python_api.models.task_file_dto import TaskFileDTO  # noqa: F401,E501


class TaskCreateDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'client_task_po_number': 'str',
        'language_combination': 'LanguageCombinationDTO',
        'dates': 'ProjectDatesDTO',
        'people': 'PeopleDTO',
        'instructions': 'InstructionsDTO',
        'specialization_id': 'int',
        'workflow_id': 'int',
        'files': 'list[TaskFileDTO]'
    }

    attribute_map = {
        'name': 'name',
        'client_task_po_number': 'clientTaskPONumber',
        'language_combination': 'languageCombination',
        'dates': 'dates',
        'people': 'people',
        'instructions': 'instructions',
        'specialization_id': 'specializationId',
        'workflow_id': 'workflowId',
        'files': 'files'
    }

    def __init__(self, name=None, client_task_po_number=None, language_combination=None, dates=None, people=None, instructions=None, specialization_id=None, workflow_id=None, files=None):  # noqa: E501
        """TaskCreateDTO - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._client_task_po_number = None
        self._language_combination = None
        self._dates = None
        self._people = None
        self._instructions = None
        self._specialization_id = None
        self._workflow_id = None
        self._files = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if client_task_po_number is not None:
            self.client_task_po_number = client_task_po_number
        if language_combination is not None:
            self.language_combination = language_combination
        if dates is not None:
            self.dates = dates
        if people is not None:
            self.people = people
        if instructions is not None:
            self.instructions = instructions
        if specialization_id is not None:
            self.specialization_id = specialization_id
        if workflow_id is not None:
            self.workflow_id = workflow_id
        if files is not None:
            self.files = files

    @property
    def name(self):
        """Gets the name of this TaskCreateDTO.  # noqa: E501

        name  # noqa: E501

        :return: The name of this TaskCreateDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TaskCreateDTO.

        name  # noqa: E501

        :param name: The name of this TaskCreateDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def client_task_po_number(self):
        """Gets the client_task_po_number of this TaskCreateDTO.  # noqa: E501

        client task PO number  # noqa: E501

        :return: The client_task_po_number of this TaskCreateDTO.  # noqa: E501
        :rtype: str
        """
        return self._client_task_po_number

    @client_task_po_number.setter
    def client_task_po_number(self, client_task_po_number):
        """Sets the client_task_po_number of this TaskCreateDTO.

        client task PO number  # noqa: E501

        :param client_task_po_number: The client_task_po_number of this TaskCreateDTO.  # noqa: E501
        :type: str
        """

        self._client_task_po_number = client_task_po_number

    @property
    def language_combination(self):
        """Gets the language_combination of this TaskCreateDTO.  # noqa: E501


        :return: The language_combination of this TaskCreateDTO.  # noqa: E501
        :rtype: LanguageCombinationDTO
        """
        return self._language_combination

    @language_combination.setter
    def language_combination(self, language_combination):
        """Sets the language_combination of this TaskCreateDTO.


        :param language_combination: The language_combination of this TaskCreateDTO.  # noqa: E501
        :type: LanguageCombinationDTO
        """

        self._language_combination = language_combination

    @property
    def dates(self):
        """Gets the dates of this TaskCreateDTO.  # noqa: E501


        :return: The dates of this TaskCreateDTO.  # noqa: E501
        :rtype: ProjectDatesDTO
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this TaskCreateDTO.


        :param dates: The dates of this TaskCreateDTO.  # noqa: E501
        :type: ProjectDatesDTO
        """

        self._dates = dates

    @property
    def people(self):
        """Gets the people of this TaskCreateDTO.  # noqa: E501


        :return: The people of this TaskCreateDTO.  # noqa: E501
        :rtype: PeopleDTO
        """
        return self._people

    @people.setter
    def people(self, people):
        """Sets the people of this TaskCreateDTO.


        :param people: The people of this TaskCreateDTO.  # noqa: E501
        :type: PeopleDTO
        """

        self._people = people

    @property
    def instructions(self):
        """Gets the instructions of this TaskCreateDTO.  # noqa: E501


        :return: The instructions of this TaskCreateDTO.  # noqa: E501
        :rtype: InstructionsDTO
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """Sets the instructions of this TaskCreateDTO.


        :param instructions: The instructions of this TaskCreateDTO.  # noqa: E501
        :type: InstructionsDTO
        """

        self._instructions = instructions

    @property
    def specialization_id(self):
        """Gets the specialization_id of this TaskCreateDTO.  # noqa: E501

        specialization  # noqa: E501

        :return: The specialization_id of this TaskCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._specialization_id

    @specialization_id.setter
    def specialization_id(self, specialization_id):
        """Sets the specialization_id of this TaskCreateDTO.

        specialization  # noqa: E501

        :param specialization_id: The specialization_id of this TaskCreateDTO.  # noqa: E501
        :type: int
        """

        self._specialization_id = specialization_id

    @property
    def workflow_id(self):
        """Gets the workflow_id of this TaskCreateDTO.  # noqa: E501

        workflow  # noqa: E501

        :return: The workflow_id of this TaskCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._workflow_id

    @workflow_id.setter
    def workflow_id(self, workflow_id):
        """Sets the workflow_id of this TaskCreateDTO.

        workflow  # noqa: E501

        :param workflow_id: The workflow_id of this TaskCreateDTO.  # noqa: E501
        :type: int
        """

        self._workflow_id = workflow_id

    @property
    def files(self):
        """Gets the files of this TaskCreateDTO.  # noqa: E501

        files  # noqa: E501

        :return: The files of this TaskCreateDTO.  # noqa: E501
        :rtype: list[TaskFileDTO]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this TaskCreateDTO.

        files  # noqa: E501

        :param files: The files of this TaskCreateDTO.  # noqa: E501
        :type: list[TaskFileDTO]
        """

        self._files = files

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskCreateDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskCreateDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
