# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.documents_dto import DocumentsDTO  # noqa: F401,E501
from xtrf_python_api.models.people_dto import PeopleDTO  # noqa: F401,E501
from xtrf_python_api.models.project_languages_dto import ProjectLanguagesDTO  # noqa: F401,E501
from xtrf_python_api.models.volume_dto import VolumeDTO  # noqa: F401,E501


class QuoteDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'quote_id': 'str',
        'is_classic_quote': 'bool',
        'quote_id_number': 'str',
        'name': 'str',
        'status': 'str',
        'category_ids': 'list[int]',
        'budget_code': 'str',
        'client_id': 'int',
        'service_id': 'int',
        'origin': 'str',
        'client_deadline': 'int',
        'client_reference_number': 'str',
        'client_notes': 'str',
        'internal_notes': 'str',
        'volume': 'VolumeDTO',
        'languages': 'ProjectLanguagesDTO',
        'documents': 'DocumentsDTO',
        'people': 'PeopleDTO',
        'instructions_for_all_jobs': 'str',
        'created_on': 'int',
        'quote_expiry': 'int',
        'expected_delivery_date': 'int',
        'business_days': 'int'
    }

    attribute_map = {
        'id': 'id',
        'quote_id': 'quoteId',
        'is_classic_quote': 'isClassicQuote',
        'quote_id_number': 'quoteIdNumber',
        'name': 'name',
        'status': 'status',
        'category_ids': 'categoryIds',
        'budget_code': 'budgetCode',
        'client_id': 'clientId',
        'service_id': 'serviceId',
        'origin': 'origin',
        'client_deadline': 'clientDeadline',
        'client_reference_number': 'clientReferenceNumber',
        'client_notes': 'clientNotes',
        'internal_notes': 'internalNotes',
        'volume': 'volume',
        'languages': 'languages',
        'documents': 'documents',
        'people': 'people',
        'instructions_for_all_jobs': 'instructionsForAllJobs',
        'created_on': 'createdOn',
        'quote_expiry': 'quoteExpiry',
        'expected_delivery_date': 'expectedDeliveryDate',
        'business_days': 'businessDays'
    }

    def __init__(self, id=None, quote_id=None, is_classic_quote=None, quote_id_number=None, name=None, status=None, category_ids=None, budget_code=None, client_id=None, service_id=None, origin=None, client_deadline=None, client_reference_number=None, client_notes=None, internal_notes=None, volume=None, languages=None, documents=None, people=None, instructions_for_all_jobs=None, created_on=None, quote_expiry=None, expected_delivery_date=None, business_days=None):  # noqa: E501
        """QuoteDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._quote_id = None
        self._is_classic_quote = None
        self._quote_id_number = None
        self._name = None
        self._status = None
        self._category_ids = None
        self._budget_code = None
        self._client_id = None
        self._service_id = None
        self._origin = None
        self._client_deadline = None
        self._client_reference_number = None
        self._client_notes = None
        self._internal_notes = None
        self._volume = None
        self._languages = None
        self._documents = None
        self._people = None
        self._instructions_for_all_jobs = None
        self._created_on = None
        self._quote_expiry = None
        self._expected_delivery_date = None
        self._business_days = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if quote_id is not None:
            self.quote_id = quote_id
        if is_classic_quote is not None:
            self.is_classic_quote = is_classic_quote
        if quote_id_number is not None:
            self.quote_id_number = quote_id_number
        if name is not None:
            self.name = name
        if status is not None:
            self.status = status
        if category_ids is not None:
            self.category_ids = category_ids
        if budget_code is not None:
            self.budget_code = budget_code
        if client_id is not None:
            self.client_id = client_id
        if service_id is not None:
            self.service_id = service_id
        if origin is not None:
            self.origin = origin
        if client_deadline is not None:
            self.client_deadline = client_deadline
        if client_reference_number is not None:
            self.client_reference_number = client_reference_number
        if client_notes is not None:
            self.client_notes = client_notes
        if internal_notes is not None:
            self.internal_notes = internal_notes
        if volume is not None:
            self.volume = volume
        if languages is not None:
            self.languages = languages
        if documents is not None:
            self.documents = documents
        if people is not None:
            self.people = people
        if instructions_for_all_jobs is not None:
            self.instructions_for_all_jobs = instructions_for_all_jobs
        if created_on is not None:
            self.created_on = created_on
        if quote_expiry is not None:
            self.quote_expiry = quote_expiry
        if expected_delivery_date is not None:
            self.expected_delivery_date = expected_delivery_date
        if business_days is not None:
            self.business_days = business_days

    @property
    def id(self):
        """Gets the id of this QuoteDTO.  # noqa: E501


        :return: The id of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this QuoteDTO.


        :param id: The id of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def quote_id(self):
        """Gets the quote_id of this QuoteDTO.  # noqa: E501


        :return: The quote_id of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this QuoteDTO.


        :param quote_id: The quote_id of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._quote_id = quote_id

    @property
    def is_classic_quote(self):
        """Gets the is_classic_quote of this QuoteDTO.  # noqa: E501


        :return: The is_classic_quote of this QuoteDTO.  # noqa: E501
        :rtype: bool
        """
        return self._is_classic_quote

    @is_classic_quote.setter
    def is_classic_quote(self, is_classic_quote):
        """Sets the is_classic_quote of this QuoteDTO.


        :param is_classic_quote: The is_classic_quote of this QuoteDTO.  # noqa: E501
        :type: bool
        """

        self._is_classic_quote = is_classic_quote

    @property
    def quote_id_number(self):
        """Gets the quote_id_number of this QuoteDTO.  # noqa: E501


        :return: The quote_id_number of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._quote_id_number

    @quote_id_number.setter
    def quote_id_number(self, quote_id_number):
        """Sets the quote_id_number of this QuoteDTO.


        :param quote_id_number: The quote_id_number of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._quote_id_number = quote_id_number

    @property
    def name(self):
        """Gets the name of this QuoteDTO.  # noqa: E501


        :return: The name of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QuoteDTO.


        :param name: The name of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def status(self):
        """Gets the status of this QuoteDTO.  # noqa: E501


        :return: The status of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this QuoteDTO.


        :param status: The status of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def category_ids(self):
        """Gets the category_ids of this QuoteDTO.  # noqa: E501


        :return: The category_ids of this QuoteDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._category_ids

    @category_ids.setter
    def category_ids(self, category_ids):
        """Sets the category_ids of this QuoteDTO.


        :param category_ids: The category_ids of this QuoteDTO.  # noqa: E501
        :type: list[int]
        """

        self._category_ids = category_ids

    @property
    def budget_code(self):
        """Gets the budget_code of this QuoteDTO.  # noqa: E501


        :return: The budget_code of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._budget_code

    @budget_code.setter
    def budget_code(self, budget_code):
        """Sets the budget_code of this QuoteDTO.


        :param budget_code: The budget_code of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._budget_code = budget_code

    @property
    def client_id(self):
        """Gets the client_id of this QuoteDTO.  # noqa: E501


        :return: The client_id of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this QuoteDTO.


        :param client_id: The client_id of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._client_id = client_id

    @property
    def service_id(self):
        """Gets the service_id of this QuoteDTO.  # noqa: E501


        :return: The service_id of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """Sets the service_id of this QuoteDTO.


        :param service_id: The service_id of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._service_id = service_id

    @property
    def origin(self):
        """Gets the origin of this QuoteDTO.  # noqa: E501


        :return: The origin of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._origin

    @origin.setter
    def origin(self, origin):
        """Sets the origin of this QuoteDTO.


        :param origin: The origin of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._origin = origin

    @property
    def client_deadline(self):
        """Gets the client_deadline of this QuoteDTO.  # noqa: E501


        :return: The client_deadline of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._client_deadline

    @client_deadline.setter
    def client_deadline(self, client_deadline):
        """Sets the client_deadline of this QuoteDTO.


        :param client_deadline: The client_deadline of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._client_deadline = client_deadline

    @property
    def client_reference_number(self):
        """Gets the client_reference_number of this QuoteDTO.  # noqa: E501


        :return: The client_reference_number of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._client_reference_number

    @client_reference_number.setter
    def client_reference_number(self, client_reference_number):
        """Sets the client_reference_number of this QuoteDTO.


        :param client_reference_number: The client_reference_number of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._client_reference_number = client_reference_number

    @property
    def client_notes(self):
        """Gets the client_notes of this QuoteDTO.  # noqa: E501


        :return: The client_notes of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._client_notes

    @client_notes.setter
    def client_notes(self, client_notes):
        """Sets the client_notes of this QuoteDTO.


        :param client_notes: The client_notes of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._client_notes = client_notes

    @property
    def internal_notes(self):
        """Gets the internal_notes of this QuoteDTO.  # noqa: E501


        :return: The internal_notes of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._internal_notes

    @internal_notes.setter
    def internal_notes(self, internal_notes):
        """Sets the internal_notes of this QuoteDTO.


        :param internal_notes: The internal_notes of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._internal_notes = internal_notes

    @property
    def volume(self):
        """Gets the volume of this QuoteDTO.  # noqa: E501


        :return: The volume of this QuoteDTO.  # noqa: E501
        :rtype: VolumeDTO
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this QuoteDTO.


        :param volume: The volume of this QuoteDTO.  # noqa: E501
        :type: VolumeDTO
        """

        self._volume = volume

    @property
    def languages(self):
        """Gets the languages of this QuoteDTO.  # noqa: E501


        :return: The languages of this QuoteDTO.  # noqa: E501
        :rtype: ProjectLanguagesDTO
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """Sets the languages of this QuoteDTO.


        :param languages: The languages of this QuoteDTO.  # noqa: E501
        :type: ProjectLanguagesDTO
        """

        self._languages = languages

    @property
    def documents(self):
        """Gets the documents of this QuoteDTO.  # noqa: E501


        :return: The documents of this QuoteDTO.  # noqa: E501
        :rtype: DocumentsDTO
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """Sets the documents of this QuoteDTO.


        :param documents: The documents of this QuoteDTO.  # noqa: E501
        :type: DocumentsDTO
        """

        self._documents = documents

    @property
    def people(self):
        """Gets the people of this QuoteDTO.  # noqa: E501


        :return: The people of this QuoteDTO.  # noqa: E501
        :rtype: PeopleDTO
        """
        return self._people

    @people.setter
    def people(self, people):
        """Sets the people of this QuoteDTO.


        :param people: The people of this QuoteDTO.  # noqa: E501
        :type: PeopleDTO
        """

        self._people = people

    @property
    def instructions_for_all_jobs(self):
        """Gets the instructions_for_all_jobs of this QuoteDTO.  # noqa: E501


        :return: The instructions_for_all_jobs of this QuoteDTO.  # noqa: E501
        :rtype: str
        """
        return self._instructions_for_all_jobs

    @instructions_for_all_jobs.setter
    def instructions_for_all_jobs(self, instructions_for_all_jobs):
        """Sets the instructions_for_all_jobs of this QuoteDTO.


        :param instructions_for_all_jobs: The instructions_for_all_jobs of this QuoteDTO.  # noqa: E501
        :type: str
        """

        self._instructions_for_all_jobs = instructions_for_all_jobs

    @property
    def created_on(self):
        """Gets the created_on of this QuoteDTO.  # noqa: E501


        :return: The created_on of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this QuoteDTO.


        :param created_on: The created_on of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def quote_expiry(self):
        """Gets the quote_expiry of this QuoteDTO.  # noqa: E501


        :return: The quote_expiry of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._quote_expiry

    @quote_expiry.setter
    def quote_expiry(self, quote_expiry):
        """Sets the quote_expiry of this QuoteDTO.


        :param quote_expiry: The quote_expiry of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._quote_expiry = quote_expiry

    @property
    def expected_delivery_date(self):
        """Gets the expected_delivery_date of this QuoteDTO.  # noqa: E501


        :return: The expected_delivery_date of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._expected_delivery_date

    @expected_delivery_date.setter
    def expected_delivery_date(self, expected_delivery_date):
        """Sets the expected_delivery_date of this QuoteDTO.


        :param expected_delivery_date: The expected_delivery_date of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._expected_delivery_date = expected_delivery_date

    @property
    def business_days(self):
        """Gets the business_days of this QuoteDTO.  # noqa: E501


        :return: The business_days of this QuoteDTO.  # noqa: E501
        :rtype: int
        """
        return self._business_days

    @business_days.setter
    def business_days(self, business_days):
        """Sets the business_days of this QuoteDTO.


        :param business_days: The business_days of this QuoteDTO.  # noqa: E501
        :type: int
        """

        self._business_days = business_days

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QuoteDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
