# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.big_decimal import BigDecimal  # noqa: F401,E501
from xtrf_python_api.models.charge_language_combination_dto import ChargeLanguageCombinationDTO  # noqa: F401,E501


class PayableDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'job_type_id': 'int',
        'language_combination': 'ChargeLanguageCombinationDTO',
        'language_combination_id_number': 'str',
        'rate_origin': 'str',
        'currency_id': 'int',
        'total': 'BigDecimal',
        'invoice_id': 'str',
        'type': 'str',
        'calculation_unit_id': 'int',
        'ignore_minimum_charge': 'bool',
        'minimum_charge': 'BigDecimal',
        'description': 'str',
        'rate': 'BigDecimal',
        'quantity': 'BigDecimal',
        'job_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'job_type_id': 'jobTypeId',
        'language_combination': 'languageCombination',
        'language_combination_id_number': 'languageCombinationIdNumber',
        'rate_origin': 'rateOrigin',
        'currency_id': 'currencyId',
        'total': 'total',
        'invoice_id': 'invoiceId',
        'type': 'type',
        'calculation_unit_id': 'calculationUnitId',
        'ignore_minimum_charge': 'ignoreMinimumCharge',
        'minimum_charge': 'minimumCharge',
        'description': 'description',
        'rate': 'rate',
        'quantity': 'quantity',
        'job_id': 'jobId'
    }

    def __init__(self, id=None, job_type_id=None, language_combination=None, language_combination_id_number=None, rate_origin=None, currency_id=None, total=None, invoice_id=None, type=None, calculation_unit_id=None, ignore_minimum_charge=None, minimum_charge=None, description=None, rate=None, quantity=None, job_id=None):  # noqa: E501
        """PayableDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._job_type_id = None
        self._language_combination = None
        self._language_combination_id_number = None
        self._rate_origin = None
        self._currency_id = None
        self._total = None
        self._invoice_id = None
        self._type = None
        self._calculation_unit_id = None
        self._ignore_minimum_charge = None
        self._minimum_charge = None
        self._description = None
        self._rate = None
        self._quantity = None
        self._job_id = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if job_type_id is not None:
            self.job_type_id = job_type_id
        if language_combination is not None:
            self.language_combination = language_combination
        if language_combination_id_number is not None:
            self.language_combination_id_number = language_combination_id_number
        if rate_origin is not None:
            self.rate_origin = rate_origin
        if currency_id is not None:
            self.currency_id = currency_id
        if total is not None:
            self.total = total
        if invoice_id is not None:
            self.invoice_id = invoice_id
        if type is not None:
            self.type = type
        if calculation_unit_id is not None:
            self.calculation_unit_id = calculation_unit_id
        if ignore_minimum_charge is not None:
            self.ignore_minimum_charge = ignore_minimum_charge
        if minimum_charge is not None:
            self.minimum_charge = minimum_charge
        if description is not None:
            self.description = description
        if rate is not None:
            self.rate = rate
        if quantity is not None:
            self.quantity = quantity
        if job_id is not None:
            self.job_id = job_id

    @property
    def id(self):
        """Gets the id of this PayableDTO.  # noqa: E501


        :return: The id of this PayableDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PayableDTO.


        :param id: The id of this PayableDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def job_type_id(self):
        """Gets the job_type_id of this PayableDTO.  # noqa: E501


        :return: The job_type_id of this PayableDTO.  # noqa: E501
        :rtype: int
        """
        return self._job_type_id

    @job_type_id.setter
    def job_type_id(self, job_type_id):
        """Sets the job_type_id of this PayableDTO.


        :param job_type_id: The job_type_id of this PayableDTO.  # noqa: E501
        :type: int
        """

        self._job_type_id = job_type_id

    @property
    def language_combination(self):
        """Gets the language_combination of this PayableDTO.  # noqa: E501


        :return: The language_combination of this PayableDTO.  # noqa: E501
        :rtype: ChargeLanguageCombinationDTO
        """
        return self._language_combination

    @language_combination.setter
    def language_combination(self, language_combination):
        """Sets the language_combination of this PayableDTO.


        :param language_combination: The language_combination of this PayableDTO.  # noqa: E501
        :type: ChargeLanguageCombinationDTO
        """

        self._language_combination = language_combination

    @property
    def language_combination_id_number(self):
        """Gets the language_combination_id_number of this PayableDTO.  # noqa: E501


        :return: The language_combination_id_number of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._language_combination_id_number

    @language_combination_id_number.setter
    def language_combination_id_number(self, language_combination_id_number):
        """Sets the language_combination_id_number of this PayableDTO.


        :param language_combination_id_number: The language_combination_id_number of this PayableDTO.  # noqa: E501
        :type: str
        """

        self._language_combination_id_number = language_combination_id_number

    @property
    def rate_origin(self):
        """Gets the rate_origin of this PayableDTO.  # noqa: E501


        :return: The rate_origin of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._rate_origin

    @rate_origin.setter
    def rate_origin(self, rate_origin):
        """Sets the rate_origin of this PayableDTO.


        :param rate_origin: The rate_origin of this PayableDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["PRICE_PROFILE", "PRICE_LIST", "FILLED_MANUALLY", "AUTOCALCULATED"]  # noqa: E501
        if rate_origin not in allowed_values:
            raise ValueError(
                "Invalid value for `rate_origin` ({0}), must be one of {1}"  # noqa: E501
                .format(rate_origin, allowed_values)
            )

        self._rate_origin = rate_origin

    @property
    def currency_id(self):
        """Gets the currency_id of this PayableDTO.  # noqa: E501


        :return: The currency_id of this PayableDTO.  # noqa: E501
        :rtype: int
        """
        return self._currency_id

    @currency_id.setter
    def currency_id(self, currency_id):
        """Sets the currency_id of this PayableDTO.


        :param currency_id: The currency_id of this PayableDTO.  # noqa: E501
        :type: int
        """

        self._currency_id = currency_id

    @property
    def total(self):
        """Gets the total of this PayableDTO.  # noqa: E501


        :return: The total of this PayableDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this PayableDTO.


        :param total: The total of this PayableDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._total = total

    @property
    def invoice_id(self):
        """Gets the invoice_id of this PayableDTO.  # noqa: E501


        :return: The invoice_id of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._invoice_id

    @invoice_id.setter
    def invoice_id(self, invoice_id):
        """Sets the invoice_id of this PayableDTO.


        :param invoice_id: The invoice_id of this PayableDTO.  # noqa: E501
        :type: str
        """

        self._invoice_id = invoice_id

    @property
    def type(self):
        """Gets the type of this PayableDTO.  # noqa: E501


        :return: The type of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this PayableDTO.


        :param type: The type of this PayableDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["SIMPLE", "CAT"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def calculation_unit_id(self):
        """Gets the calculation_unit_id of this PayableDTO.  # noqa: E501


        :return: The calculation_unit_id of this PayableDTO.  # noqa: E501
        :rtype: int
        """
        return self._calculation_unit_id

    @calculation_unit_id.setter
    def calculation_unit_id(self, calculation_unit_id):
        """Sets the calculation_unit_id of this PayableDTO.


        :param calculation_unit_id: The calculation_unit_id of this PayableDTO.  # noqa: E501
        :type: int
        """

        self._calculation_unit_id = calculation_unit_id

    @property
    def ignore_minimum_charge(self):
        """Gets the ignore_minimum_charge of this PayableDTO.  # noqa: E501


        :return: The ignore_minimum_charge of this PayableDTO.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_minimum_charge

    @ignore_minimum_charge.setter
    def ignore_minimum_charge(self, ignore_minimum_charge):
        """Sets the ignore_minimum_charge of this PayableDTO.


        :param ignore_minimum_charge: The ignore_minimum_charge of this PayableDTO.  # noqa: E501
        :type: bool
        """

        self._ignore_minimum_charge = ignore_minimum_charge

    @property
    def minimum_charge(self):
        """Gets the minimum_charge of this PayableDTO.  # noqa: E501


        :return: The minimum_charge of this PayableDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._minimum_charge

    @minimum_charge.setter
    def minimum_charge(self, minimum_charge):
        """Sets the minimum_charge of this PayableDTO.


        :param minimum_charge: The minimum_charge of this PayableDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._minimum_charge = minimum_charge

    @property
    def description(self):
        """Gets the description of this PayableDTO.  # noqa: E501


        :return: The description of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PayableDTO.


        :param description: The description of this PayableDTO.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def rate(self):
        """Gets the rate of this PayableDTO.  # noqa: E501


        :return: The rate of this PayableDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """Sets the rate of this PayableDTO.


        :param rate: The rate of this PayableDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._rate = rate

    @property
    def quantity(self):
        """Gets the quantity of this PayableDTO.  # noqa: E501


        :return: The quantity of this PayableDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this PayableDTO.


        :param quantity: The quantity of this PayableDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._quantity = quantity

    @property
    def job_id(self):
        """Gets the job_id of this PayableDTO.  # noqa: E501


        :return: The job_id of this PayableDTO.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this PayableDTO.


        :param job_id: The job_id of this PayableDTO.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PayableDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PayableDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
