# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.job_communication_dto import JobCommunicationDto  # noqa: F401,E501
from xtrf_python_api.models.job_dates_dto import JobDatesDto  # noqa: F401,E501
from xtrf_python_api.models.job_documents_dto import JobDocumentsDto  # noqa: F401,E501
from xtrf_python_api.models.job_files_dto import JobFilesDto  # noqa: F401,E501
from xtrf_python_api.models.job_language_combination_dto import JobLanguageCombinationDto  # noqa: F401,E501
from xtrf_python_api.models.step_type_dto import StepTypeDto  # noqa: F401,E501


class JobDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'id_number': 'str',
        'name': 'str',
        'status': 'str',
        'step_number': 'int',
        'vendor_id': 'int',
        'vendor_price_profile_id': 'int',
        'step_type': 'StepTypeDto',
        'languages': 'list[JobLanguageCombinationDto]',
        'dates': 'JobDatesDto',
        'files': 'JobFilesDto',
        'communication': 'JobCommunicationDto',
        'documents': 'JobDocumentsDto'
    }

    attribute_map = {
        'id': 'id',
        'id_number': 'idNumber',
        'name': 'name',
        'status': 'status',
        'step_number': 'stepNumber',
        'vendor_id': 'vendorId',
        'vendor_price_profile_id': 'vendorPriceProfileId',
        'step_type': 'stepType',
        'languages': 'languages',
        'dates': 'dates',
        'files': 'files',
        'communication': 'communication',
        'documents': 'documents'
    }

    def __init__(self, id=None, id_number=None, name=None, status=None, step_number=None, vendor_id=None, vendor_price_profile_id=None, step_type=None, languages=None, dates=None, files=None, communication=None, documents=None):  # noqa: E501
        """JobDto - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._id_number = None
        self._name = None
        self._status = None
        self._step_number = None
        self._vendor_id = None
        self._vendor_price_profile_id = None
        self._step_type = None
        self._languages = None
        self._dates = None
        self._files = None
        self._communication = None
        self._documents = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if id_number is not None:
            self.id_number = id_number
        if name is not None:
            self.name = name
        if status is not None:
            self.status = status
        if step_number is not None:
            self.step_number = step_number
        if vendor_id is not None:
            self.vendor_id = vendor_id
        if vendor_price_profile_id is not None:
            self.vendor_price_profile_id = vendor_price_profile_id
        if step_type is not None:
            self.step_type = step_type
        if languages is not None:
            self.languages = languages
        if dates is not None:
            self.dates = dates
        if files is not None:
            self.files = files
        if communication is not None:
            self.communication = communication
        if documents is not None:
            self.documents = documents

    @property
    def id(self):
        """Gets the id of this JobDto.  # noqa: E501


        :return: The id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobDto.


        :param id: The id of this JobDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def id_number(self):
        """Gets the id_number of this JobDto.  # noqa: E501


        :return: The id_number of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._id_number

    @id_number.setter
    def id_number(self, id_number):
        """Sets the id_number of this JobDto.


        :param id_number: The id_number of this JobDto.  # noqa: E501
        :type: str
        """

        self._id_number = id_number

    @property
    def name(self):
        """Gets the name of this JobDto.  # noqa: E501


        :return: The name of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JobDto.


        :param name: The name of this JobDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def status(self):
        """Gets the status of this JobDto.  # noqa: E501


        :return: The status of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this JobDto.


        :param status: The status of this JobDto.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def step_number(self):
        """Gets the step_number of this JobDto.  # noqa: E501


        :return: The step_number of this JobDto.  # noqa: E501
        :rtype: int
        """
        return self._step_number

    @step_number.setter
    def step_number(self, step_number):
        """Sets the step_number of this JobDto.


        :param step_number: The step_number of this JobDto.  # noqa: E501
        :type: int
        """

        self._step_number = step_number

    @property
    def vendor_id(self):
        """Gets the vendor_id of this JobDto.  # noqa: E501


        :return: The vendor_id of this JobDto.  # noqa: E501
        :rtype: int
        """
        return self._vendor_id

    @vendor_id.setter
    def vendor_id(self, vendor_id):
        """Sets the vendor_id of this JobDto.


        :param vendor_id: The vendor_id of this JobDto.  # noqa: E501
        :type: int
        """

        self._vendor_id = vendor_id

    @property
    def vendor_price_profile_id(self):
        """Gets the vendor_price_profile_id of this JobDto.  # noqa: E501


        :return: The vendor_price_profile_id of this JobDto.  # noqa: E501
        :rtype: int
        """
        return self._vendor_price_profile_id

    @vendor_price_profile_id.setter
    def vendor_price_profile_id(self, vendor_price_profile_id):
        """Sets the vendor_price_profile_id of this JobDto.


        :param vendor_price_profile_id: The vendor_price_profile_id of this JobDto.  # noqa: E501
        :type: int
        """

        self._vendor_price_profile_id = vendor_price_profile_id

    @property
    def step_type(self):
        """Gets the step_type of this JobDto.  # noqa: E501


        :return: The step_type of this JobDto.  # noqa: E501
        :rtype: StepTypeDto
        """
        return self._step_type

    @step_type.setter
    def step_type(self, step_type):
        """Sets the step_type of this JobDto.


        :param step_type: The step_type of this JobDto.  # noqa: E501
        :type: StepTypeDto
        """

        self._step_type = step_type

    @property
    def languages(self):
        """Gets the languages of this JobDto.  # noqa: E501


        :return: The languages of this JobDto.  # noqa: E501
        :rtype: list[JobLanguageCombinationDto]
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """Sets the languages of this JobDto.


        :param languages: The languages of this JobDto.  # noqa: E501
        :type: list[JobLanguageCombinationDto]
        """

        self._languages = languages

    @property
    def dates(self):
        """Gets the dates of this JobDto.  # noqa: E501


        :return: The dates of this JobDto.  # noqa: E501
        :rtype: JobDatesDto
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this JobDto.


        :param dates: The dates of this JobDto.  # noqa: E501
        :type: JobDatesDto
        """

        self._dates = dates

    @property
    def files(self):
        """Gets the files of this JobDto.  # noqa: E501


        :return: The files of this JobDto.  # noqa: E501
        :rtype: JobFilesDto
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this JobDto.


        :param files: The files of this JobDto.  # noqa: E501
        :type: JobFilesDto
        """

        self._files = files

    @property
    def communication(self):
        """Gets the communication of this JobDto.  # noqa: E501


        :return: The communication of this JobDto.  # noqa: E501
        :rtype: JobCommunicationDto
        """
        return self._communication

    @communication.setter
    def communication(self, communication):
        """Sets the communication of this JobDto.


        :param communication: The communication of this JobDto.  # noqa: E501
        :type: JobCommunicationDto
        """

        self._communication = communication

    @property
    def documents(self):
        """Gets the documents of this JobDto.  # noqa: E501


        :return: The documents of this JobDto.  # noqa: E501
        :rtype: JobDocumentsDto
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """Sets the documents of this JobDto.


        :param documents: The documents of this JobDto.  # noqa: E501
        :type: JobDocumentsDto
        """

        self._documents = documents

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JobDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
