# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ImportResultDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'current_system_version': 'str',
        'target_system_version': 'str',
        'invalid_reports_names': 'list[str]',
        'imported_reports_names': 'list[str]'
    }

    attribute_map = {
        'current_system_version': 'currentSystemVersion',
        'target_system_version': 'targetSystemVersion',
        'invalid_reports_names': 'invalidReportsNames',
        'imported_reports_names': 'importedReportsNames'
    }

    def __init__(self, current_system_version=None, target_system_version=None, invalid_reports_names=None, imported_reports_names=None):  # noqa: E501
        """ImportResultDTO - a model defined in Swagger"""  # noqa: E501
        self._current_system_version = None
        self._target_system_version = None
        self._invalid_reports_names = None
        self._imported_reports_names = None
        self.discriminator = None
        if current_system_version is not None:
            self.current_system_version = current_system_version
        if target_system_version is not None:
            self.target_system_version = target_system_version
        if invalid_reports_names is not None:
            self.invalid_reports_names = invalid_reports_names
        if imported_reports_names is not None:
            self.imported_reports_names = imported_reports_names

    @property
    def current_system_version(self):
        """Gets the current_system_version of this ImportResultDTO.  # noqa: E501


        :return: The current_system_version of this ImportResultDTO.  # noqa: E501
        :rtype: str
        """
        return self._current_system_version

    @current_system_version.setter
    def current_system_version(self, current_system_version):
        """Sets the current_system_version of this ImportResultDTO.


        :param current_system_version: The current_system_version of this ImportResultDTO.  # noqa: E501
        :type: str
        """

        self._current_system_version = current_system_version

    @property
    def target_system_version(self):
        """Gets the target_system_version of this ImportResultDTO.  # noqa: E501


        :return: The target_system_version of this ImportResultDTO.  # noqa: E501
        :rtype: str
        """
        return self._target_system_version

    @target_system_version.setter
    def target_system_version(self, target_system_version):
        """Sets the target_system_version of this ImportResultDTO.


        :param target_system_version: The target_system_version of this ImportResultDTO.  # noqa: E501
        :type: str
        """

        self._target_system_version = target_system_version

    @property
    def invalid_reports_names(self):
        """Gets the invalid_reports_names of this ImportResultDTO.  # noqa: E501


        :return: The invalid_reports_names of this ImportResultDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._invalid_reports_names

    @invalid_reports_names.setter
    def invalid_reports_names(self, invalid_reports_names):
        """Sets the invalid_reports_names of this ImportResultDTO.


        :param invalid_reports_names: The invalid_reports_names of this ImportResultDTO.  # noqa: E501
        :type: list[str]
        """

        self._invalid_reports_names = invalid_reports_names

    @property
    def imported_reports_names(self):
        """Gets the imported_reports_names of this ImportResultDTO.  # noqa: E501


        :return: The imported_reports_names of this ImportResultDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._imported_reports_names

    @imported_reports_names.setter
    def imported_reports_names(self, imported_reports_names):
        """Sets the imported_reports_names of this ImportResultDTO.


        :param imported_reports_names: The imported_reports_names of this ImportResultDTO.  # noqa: E501
        :type: list[str]
        """

        self._imported_reports_names = imported_reports_names

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImportResultDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImportResultDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
