# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.custom_field_dto import CustomFieldDTO  # noqa: F401,E501
from xtrf_python_api.models.person_contact_dto import PersonContactDTO  # noqa: F401,E501


class CustomerPersonDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'last_name': 'str',
        'contact': 'PersonContactDTO',
        'position_id': 'int',
        'gender': 'str',
        'active': 'bool',
        'mother_tongues_ids': 'list[int]',
        'custom_fields': 'list[CustomFieldDTO]',
        'customer_id': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'last_name': 'lastName',
        'contact': 'contact',
        'position_id': 'positionId',
        'gender': 'gender',
        'active': 'active',
        'mother_tongues_ids': 'motherTonguesIds',
        'custom_fields': 'customFields',
        'customer_id': 'customerId'
    }

    def __init__(self, id=None, name=None, last_name=None, contact=None, position_id=None, gender=None, active=None, mother_tongues_ids=None, custom_fields=None, customer_id=None):  # noqa: E501
        """CustomerPersonDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._last_name = None
        self._contact = None
        self._position_id = None
        self._gender = None
        self._active = None
        self._mother_tongues_ids = None
        self._custom_fields = None
        self._customer_id = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if last_name is not None:
            self.last_name = last_name
        if contact is not None:
            self.contact = contact
        if position_id is not None:
            self.position_id = position_id
        if gender is not None:
            self.gender = gender
        if active is not None:
            self.active = active
        if mother_tongues_ids is not None:
            self.mother_tongues_ids = mother_tongues_ids
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if customer_id is not None:
            self.customer_id = customer_id

    @property
    def id(self):
        """Gets the id of this CustomerPersonDTO.  # noqa: E501


        :return: The id of this CustomerPersonDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CustomerPersonDTO.


        :param id: The id of this CustomerPersonDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this CustomerPersonDTO.  # noqa: E501


        :return: The name of this CustomerPersonDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CustomerPersonDTO.


        :param name: The name of this CustomerPersonDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def last_name(self):
        """Gets the last_name of this CustomerPersonDTO.  # noqa: E501


        :return: The last_name of this CustomerPersonDTO.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this CustomerPersonDTO.


        :param last_name: The last_name of this CustomerPersonDTO.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def contact(self):
        """Gets the contact of this CustomerPersonDTO.  # noqa: E501


        :return: The contact of this CustomerPersonDTO.  # noqa: E501
        :rtype: PersonContactDTO
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this CustomerPersonDTO.


        :param contact: The contact of this CustomerPersonDTO.  # noqa: E501
        :type: PersonContactDTO
        """

        self._contact = contact

    @property
    def position_id(self):
        """Gets the position_id of this CustomerPersonDTO.  # noqa: E501


        :return: The position_id of this CustomerPersonDTO.  # noqa: E501
        :rtype: int
        """
        return self._position_id

    @position_id.setter
    def position_id(self, position_id):
        """Sets the position_id of this CustomerPersonDTO.


        :param position_id: The position_id of this CustomerPersonDTO.  # noqa: E501
        :type: int
        """

        self._position_id = position_id

    @property
    def gender(self):
        """Gets the gender of this CustomerPersonDTO.  # noqa: E501


        :return: The gender of this CustomerPersonDTO.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this CustomerPersonDTO.


        :param gender: The gender of this CustomerPersonDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["FEMALE", "MALE"]  # noqa: E501
        if gender not in allowed_values:
            raise ValueError(
                "Invalid value for `gender` ({0}), must be one of {1}"  # noqa: E501
                .format(gender, allowed_values)
            )

        self._gender = gender

    @property
    def active(self):
        """Gets the active of this CustomerPersonDTO.  # noqa: E501


        :return: The active of this CustomerPersonDTO.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this CustomerPersonDTO.


        :param active: The active of this CustomerPersonDTO.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def mother_tongues_ids(self):
        """Gets the mother_tongues_ids of this CustomerPersonDTO.  # noqa: E501


        :return: The mother_tongues_ids of this CustomerPersonDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._mother_tongues_ids

    @mother_tongues_ids.setter
    def mother_tongues_ids(self, mother_tongues_ids):
        """Sets the mother_tongues_ids of this CustomerPersonDTO.


        :param mother_tongues_ids: The mother_tongues_ids of this CustomerPersonDTO.  # noqa: E501
        :type: list[int]
        """

        self._mother_tongues_ids = mother_tongues_ids

    @property
    def custom_fields(self):
        """Gets the custom_fields of this CustomerPersonDTO.  # noqa: E501


        :return: The custom_fields of this CustomerPersonDTO.  # noqa: E501
        :rtype: list[CustomFieldDTO]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this CustomerPersonDTO.


        :param custom_fields: The custom_fields of this CustomerPersonDTO.  # noqa: E501
        :type: list[CustomFieldDTO]
        """

        self._custom_fields = custom_fields

    @property
    def customer_id(self):
        """Gets the customer_id of this CustomerPersonDTO.  # noqa: E501


        :return: The customer_id of this CustomerPersonDTO.  # noqa: E501
        :rtype: int
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """Sets the customer_id of this CustomerPersonDTO.


        :param customer_id: The customer_id of this CustomerPersonDTO.  # noqa: E501
        :type: int
        """

        self._customer_id = customer_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CustomerPersonDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomerPersonDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
