# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from xtrf_python_api.models.big_decimal import BigDecimal  # noqa: F401,E501
from xtrf_python_api.models.customer_details_dto import CustomerDetailsDTO  # noqa: F401,E501
from xtrf_python_api.models.customer_invoice_dates_dto import CustomerInvoiceDatesDTO  # noqa: F401,E501
from xtrf_python_api.models.payment_terms_dto import PaymentTermsDTO  # noqa: F401,E501
from xtrf_python_api.models.task_dto import TaskDTO  # noqa: F401,E501


class CustomerInvoiceDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'total_gross': 'BigDecimal',
        'total_netto': 'BigDecimal',
        'currency_id': 'int',
        'status': 'str',
        'invoice_number': 'str',
        'type': 'str',
        'tasks_value': 'BigDecimal',
        'vat_calculation_rule': 'str',
        'total_in_words': 'str',
        'payment_method_id': 'int',
        'payment_terms': 'PaymentTermsDTO',
        'customer_id': 'int',
        'dates': 'CustomerInvoiceDatesDTO',
        'tasks': 'list[TaskDTO]',
        'customer_details': 'CustomerDetailsDTO'
    }

    attribute_map = {
        'id': 'id',
        'total_gross': 'totalGross',
        'total_netto': 'totalNetto',
        'currency_id': 'currencyId',
        'status': 'status',
        'invoice_number': 'invoiceNumber',
        'type': 'type',
        'tasks_value': 'tasksValue',
        'vat_calculation_rule': 'vatCalculationRule',
        'total_in_words': 'totalInWords',
        'payment_method_id': 'paymentMethodId',
        'payment_terms': 'paymentTerms',
        'customer_id': 'customerId',
        'dates': 'dates',
        'tasks': 'tasks',
        'customer_details': 'customerDetails'
    }

    def __init__(self, id=None, total_gross=None, total_netto=None, currency_id=None, status=None, invoice_number=None, type=None, tasks_value=None, vat_calculation_rule=None, total_in_words=None, payment_method_id=None, payment_terms=None, customer_id=None, dates=None, tasks=None, customer_details=None):  # noqa: E501
        """CustomerInvoiceDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._total_gross = None
        self._total_netto = None
        self._currency_id = None
        self._status = None
        self._invoice_number = None
        self._type = None
        self._tasks_value = None
        self._vat_calculation_rule = None
        self._total_in_words = None
        self._payment_method_id = None
        self._payment_terms = None
        self._customer_id = None
        self._dates = None
        self._tasks = None
        self._customer_details = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if total_gross is not None:
            self.total_gross = total_gross
        if total_netto is not None:
            self.total_netto = total_netto
        if currency_id is not None:
            self.currency_id = currency_id
        if status is not None:
            self.status = status
        if invoice_number is not None:
            self.invoice_number = invoice_number
        if type is not None:
            self.type = type
        if tasks_value is not None:
            self.tasks_value = tasks_value
        if vat_calculation_rule is not None:
            self.vat_calculation_rule = vat_calculation_rule
        if total_in_words is not None:
            self.total_in_words = total_in_words
        if payment_method_id is not None:
            self.payment_method_id = payment_method_id
        if payment_terms is not None:
            self.payment_terms = payment_terms
        if customer_id is not None:
            self.customer_id = customer_id
        if dates is not None:
            self.dates = dates
        if tasks is not None:
            self.tasks = tasks
        if customer_details is not None:
            self.customer_details = customer_details

    @property
    def id(self):
        """Gets the id of this CustomerInvoiceDTO.  # noqa: E501


        :return: The id of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CustomerInvoiceDTO.


        :param id: The id of this CustomerInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def total_gross(self):
        """Gets the total_gross of this CustomerInvoiceDTO.  # noqa: E501


        :return: The total_gross of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._total_gross

    @total_gross.setter
    def total_gross(self, total_gross):
        """Sets the total_gross of this CustomerInvoiceDTO.


        :param total_gross: The total_gross of this CustomerInvoiceDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._total_gross = total_gross

    @property
    def total_netto(self):
        """Gets the total_netto of this CustomerInvoiceDTO.  # noqa: E501


        :return: The total_netto of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._total_netto

    @total_netto.setter
    def total_netto(self, total_netto):
        """Sets the total_netto of this CustomerInvoiceDTO.


        :param total_netto: The total_netto of this CustomerInvoiceDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._total_netto = total_netto

    @property
    def currency_id(self):
        """Gets the currency_id of this CustomerInvoiceDTO.  # noqa: E501


        :return: The currency_id of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._currency_id

    @currency_id.setter
    def currency_id(self, currency_id):
        """Sets the currency_id of this CustomerInvoiceDTO.


        :param currency_id: The currency_id of this CustomerInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._currency_id = currency_id

    @property
    def status(self):
        """Gets the status of this CustomerInvoiceDTO.  # noqa: E501


        :return: The status of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CustomerInvoiceDTO.


        :param status: The status of this CustomerInvoiceDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["NOT_READY", "READY", "SENT"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def invoice_number(self):
        """Gets the invoice_number of this CustomerInvoiceDTO.  # noqa: E501


        :return: The invoice_number of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """Sets the invoice_number of this CustomerInvoiceDTO.


        :param invoice_number: The invoice_number of this CustomerInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._invoice_number = invoice_number

    @property
    def type(self):
        """Gets the type of this CustomerInvoiceDTO.  # noqa: E501


        :return: The type of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CustomerInvoiceDTO.


        :param type: The type of this CustomerInvoiceDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["FINAL", "DRAFT"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def tasks_value(self):
        """Gets the tasks_value of this CustomerInvoiceDTO.  # noqa: E501


        :return: The tasks_value of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: BigDecimal
        """
        return self._tasks_value

    @tasks_value.setter
    def tasks_value(self, tasks_value):
        """Sets the tasks_value of this CustomerInvoiceDTO.


        :param tasks_value: The tasks_value of this CustomerInvoiceDTO.  # noqa: E501
        :type: BigDecimal
        """

        self._tasks_value = tasks_value

    @property
    def vat_calculation_rule(self):
        """Gets the vat_calculation_rule of this CustomerInvoiceDTO.  # noqa: E501


        :return: The vat_calculation_rule of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._vat_calculation_rule

    @vat_calculation_rule.setter
    def vat_calculation_rule(self, vat_calculation_rule):
        """Sets the vat_calculation_rule of this CustomerInvoiceDTO.


        :param vat_calculation_rule: The vat_calculation_rule of this CustomerInvoiceDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["SUM_ITEMS", "BY_NET_TOTAL"]  # noqa: E501
        if vat_calculation_rule not in allowed_values:
            raise ValueError(
                "Invalid value for `vat_calculation_rule` ({0}), must be one of {1}"  # noqa: E501
                .format(vat_calculation_rule, allowed_values)
            )

        self._vat_calculation_rule = vat_calculation_rule

    @property
    def total_in_words(self):
        """Gets the total_in_words of this CustomerInvoiceDTO.  # noqa: E501


        :return: The total_in_words of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._total_in_words

    @total_in_words.setter
    def total_in_words(self, total_in_words):
        """Sets the total_in_words of this CustomerInvoiceDTO.


        :param total_in_words: The total_in_words of this CustomerInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._total_in_words = total_in_words

    @property
    def payment_method_id(self):
        """Gets the payment_method_id of this CustomerInvoiceDTO.  # noqa: E501


        :return: The payment_method_id of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._payment_method_id

    @payment_method_id.setter
    def payment_method_id(self, payment_method_id):
        """Sets the payment_method_id of this CustomerInvoiceDTO.


        :param payment_method_id: The payment_method_id of this CustomerInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._payment_method_id = payment_method_id

    @property
    def payment_terms(self):
        """Gets the payment_terms of this CustomerInvoiceDTO.  # noqa: E501


        :return: The payment_terms of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: PaymentTermsDTO
        """
        return self._payment_terms

    @payment_terms.setter
    def payment_terms(self, payment_terms):
        """Sets the payment_terms of this CustomerInvoiceDTO.


        :param payment_terms: The payment_terms of this CustomerInvoiceDTO.  # noqa: E501
        :type: PaymentTermsDTO
        """

        self._payment_terms = payment_terms

    @property
    def customer_id(self):
        """Gets the customer_id of this CustomerInvoiceDTO.  # noqa: E501


        :return: The customer_id of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """Sets the customer_id of this CustomerInvoiceDTO.


        :param customer_id: The customer_id of this CustomerInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._customer_id = customer_id

    @property
    def dates(self):
        """Gets the dates of this CustomerInvoiceDTO.  # noqa: E501


        :return: The dates of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: CustomerInvoiceDatesDTO
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this CustomerInvoiceDTO.


        :param dates: The dates of this CustomerInvoiceDTO.  # noqa: E501
        :type: CustomerInvoiceDatesDTO
        """

        self._dates = dates

    @property
    def tasks(self):
        """Gets the tasks of this CustomerInvoiceDTO.  # noqa: E501


        :return: The tasks of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: list[TaskDTO]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this CustomerInvoiceDTO.


        :param tasks: The tasks of this CustomerInvoiceDTO.  # noqa: E501
        :type: list[TaskDTO]
        """

        self._tasks = tasks

    @property
    def customer_details(self):
        """Gets the customer_details of this CustomerInvoiceDTO.  # noqa: E501


        :return: The customer_details of this CustomerInvoiceDTO.  # noqa: E501
        :rtype: CustomerDetailsDTO
        """
        return self._customer_details

    @customer_details.setter
    def customer_details(self, customer_details):
        """Sets the customer_details of this CustomerInvoiceDTO.


        :param customer_details: The customer_details of this CustomerInvoiceDTO.  # noqa: E501
        :type: CustomerDetailsDTO
        """

        self._customer_details = customer_details

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CustomerInvoiceDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomerInvoiceDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
