# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ActiveSubscriptionDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url': 'str',
        'event': 'str',
        'filter': 'str',
        'embed': 'str',
        'subscription_id': 'str'
    }

    attribute_map = {
        'url': 'url',
        'event': 'event',
        'filter': 'filter',
        'embed': 'embed',
        'subscription_id': 'subscriptionId'
    }

    def __init__(self, url=None, event=None, filter=None, embed=None, subscription_id=None):  # noqa: E501
        """ActiveSubscriptionDTO - a model defined in Swagger"""  # noqa: E501
        self._url = None
        self._event = None
        self._filter = None
        self._embed = None
        self._subscription_id = None
        self.discriminator = None
        if url is not None:
            self.url = url
        if event is not None:
            self.event = event
        if filter is not None:
            self.filter = filter
        if embed is not None:
            self.embed = embed
        if subscription_id is not None:
            self.subscription_id = subscription_id

    @property
    def url(self):
        """Gets the url of this ActiveSubscriptionDTO.  # noqa: E501

        url that will be invoked by XTRF on event  # noqa: E501

        :return: The url of this ActiveSubscriptionDTO.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ActiveSubscriptionDTO.

        url that will be invoked by XTRF on event  # noqa: E501

        :param url: The url of this ActiveSubscriptionDTO.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def event(self):
        """Gets the event of this ActiveSubscriptionDTO.  # noqa: E501

        event to which you want to subscribe  # noqa: E501

        :return: The event of this ActiveSubscriptionDTO.  # noqa: E501
        :rtype: str
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this ActiveSubscriptionDTO.

        event to which you want to subscribe  # noqa: E501

        :param event: The event of this ActiveSubscriptionDTO.  # noqa: E501
        :type: str
        """

        self._event = event

    @property
    def filter(self):
        """Gets the filter of this ActiveSubscriptionDTO.  # noqa: E501

        filter expression in the form 'attribute=value'  # noqa: E501

        :return: The filter of this ActiveSubscriptionDTO.  # noqa: E501
        :rtype: str
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this ActiveSubscriptionDTO.

        filter expression in the form 'attribute=value'  # noqa: E501

        :param filter: The filter of this ActiveSubscriptionDTO.  # noqa: E501
        :type: str
        """

        self._filter = filter

    @property
    def embed(self):
        """Gets the embed of this ActiveSubscriptionDTO.  # noqa: E501

        additional fields which should be embedded in the event  # noqa: E501

        :return: The embed of this ActiveSubscriptionDTO.  # noqa: E501
        :rtype: str
        """
        return self._embed

    @embed.setter
    def embed(self, embed):
        """Sets the embed of this ActiveSubscriptionDTO.

        additional fields which should be embedded in the event  # noqa: E501

        :param embed: The embed of this ActiveSubscriptionDTO.  # noqa: E501
        :type: str
        """

        self._embed = embed

    @property
    def subscription_id(self):
        """Gets the subscription_id of this ActiveSubscriptionDTO.  # noqa: E501

        subscription identifier  # noqa: E501

        :return: The subscription_id of this ActiveSubscriptionDTO.  # noqa: E501
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this ActiveSubscriptionDTO.

        subscription identifier  # noqa: E501

        :param subscription_id: The subscription_id of this ActiveSubscriptionDTO.  # noqa: E501
        :type: str
        """

        self._subscription_id = subscription_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ActiveSubscriptionDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActiveSubscriptionDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
